/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngine;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineImpl;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.store.ServiceStore;
import org.apache.ranger.plugin.util.ServicePolicies;

class RangerPolicyEngineCache {
    private static final Log LOG = LogFactory.getLog(RangerPolicyEngineCache.class);
    private final Map<String, RangerPolicyEngine> policyEngineCache = new HashMap<String, RangerPolicyEngine>();

    RangerPolicyEngineCache() {
    }

    final synchronized RangerPolicyEngine getPolicyEngine(String serviceName, ServiceStore svcStore, RangerPolicyEngineOptions options) {
        RangerPolicyEngine ret = null;
        if (serviceName != null) {
            long policyVersion;
            ret = this.policyEngineCache.get(serviceName);
            long l = policyVersion = ret != null ? ret.getPolicyVersion() : -1L;
            if (svcStore != null) {
                try {
                    ServicePolicies policies = svcStore.getServicePoliciesIfUpdated(serviceName, policyVersion);
                    if (policies != null) {
                        if (ret == null) {
                            ret = this.addPolicyEngine(policies, options);
                        } else if (policies.getPolicyVersion() != null && !policies.getPolicyVersion().equals(policyVersion)) {
                            ret = this.addPolicyEngine(policies, options);
                        }
                    }
                }
                catch (Exception excp) {
                    LOG.error("getPolicyEngine(" + serviceName + "): failed to get latest policies from service-store", excp);
                }
            }
        }
        return ret;
    }

    private RangerPolicyEngine addPolicyEngine(ServicePolicies policies, RangerPolicyEngineOptions options) {
        RangerPolicyEngineImpl ret = new RangerPolicyEngineImpl("ranger-admin", policies, options);
        this.policyEngineCache.put(policies.getServiceName(), ret);
        return ret;
    }
}

