/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.plugin.contextenricher.RangerContextEnricher;
import org.apache.ranger.plugin.contextenricher.RangerTagForEval;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.PolicyEvaluatorForTag;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.policyengine.RangerMutableResource;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngine;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyengine.RangerPolicyRepository;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyengine.RangerResourceAccessInfo;
import org.apache.ranger.plugin.policyengine.RangerTagAccessRequest;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.ServicePolicies;

public class RangerPolicyEngineImpl
implements RangerPolicyEngine {
    private static final Log LOG = LogFactory.getLog(RangerPolicyEngineImpl.class);
    private static final Log PERF_POLICYENGINE_INIT_LOG = RangerPerfTracer.getPerfLogger("policyengine.init");
    private static final Log PERF_POLICYENGINE_REQUEST_LOG = RangerPerfTracer.getPerfLogger("policyengine.request");
    private static final Log PERF_POLICYENGINE_AUDIT_LOG = RangerPerfTracer.getPerfLogger("policyengine.audit");
    private static final Log PERF_CONTEXTENRICHER_REQUEST_LOG = RangerPerfTracer.getPerfLogger("contextenricher.request");
    private static final Log PERF_POLICYENGINE_REBALANCE_LOG = RangerPerfTracer.getPerfLogger("policyengine.rebalance");
    private static final Log PERF_POLICYENGINE_USAGE_LOG = RangerPerfTracer.getPerfLogger("policyengine.usage");
    private static final Log PERF_POLICYENGINE_GET_ACLS_LOG = RangerPerfTracer.getPerfLogger("policyengine.getResourceACLs");
    private static final int MAX_POLICIES_FOR_CACHE_TYPE_EVALUATOR = 100;
    private final RangerPolicyRepository policyRepository;
    private final RangerPolicyRepository tagPolicyRepository;
    private List<RangerContextEnricher> allContextEnrichers;
    private final Map<Long, RangerPolicyEvaluator> policyEvaluatorsMap;
    private boolean useForwardedIPAddress;
    private String[] trustedProxyAddresses;

    public RangerPolicyEngineImpl(String appId, ServicePolicies servicePolicies, RangerPolicyEngineOptions options) {
        List<RangerContextEnricher> tmpList;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyEngineImpl(" + appId + ", " + servicePolicies + ", " + options + ")");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "RangerPolicyEngine.init(appId=" + appId + ",hashCode=" + Integer.toHexString(System.identityHashCode(this)) + ")");
            long freeMemory = Runtime.getRuntime().freeMemory();
            long totalMemory = Runtime.getRuntime().totalMemory();
            PERF_POLICYENGINE_INIT_LOG.debug("In-Use memory: " + (totalMemory - freeMemory) + ", Free memory:" + freeMemory);
        }
        if (options == null) {
            options = new RangerPolicyEngineOptions();
        }
        if (StringUtils.isBlank(options.evaluatorType) || StringUtils.equalsIgnoreCase(options.evaluatorType, "auto")) {
            String serviceType = servicePolicies.getServiceDef().getName();
            String propertyName = "ranger.plugin." + serviceType + ".policyengine.evaluator.auto.maximum.policycount.for.cache.type";
            int thresholdForUsingOptimizedEvaluator = RangerConfiguration.getInstance().getInt(propertyName, 100);
            int servicePoliciesCount = servicePolicies.getPolicies().size() + (servicePolicies.getTagPolicies() != null ? servicePolicies.getTagPolicies().getPolicies().size() : 0);
            options.evaluatorType = servicePoliciesCount > thresholdForUsingOptimizedEvaluator ? "optimized" : "cached";
        } else {
            options.evaluatorType = StringUtils.equalsIgnoreCase(options.evaluatorType, "cached") ? "cached" : "optimized";
        }
        this.policyRepository = new RangerPolicyRepository(appId, servicePolicies, options);
        ServicePolicies.TagPolicies tagPolicies = servicePolicies.getTagPolicies();
        if (!(options.disableTagPolicyEvaluation || tagPolicies == null || StringUtils.isEmpty(tagPolicies.getServiceName()) || tagPolicies.getServiceDef() == null || CollectionUtils.isEmpty(tagPolicies.getPolicies()))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("RangerPolicyEngineImpl : Building tag-policy-repository for tag-service " + tagPolicies.getServiceName());
            }
            this.tagPolicyRepository = new RangerPolicyRepository(appId, tagPolicies, options, servicePolicies.getServiceDef(), servicePolicies.getServiceName());
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("RangerPolicyEngineImpl : No tag-policy-repository for service " + servicePolicies.getServiceName());
            }
            this.tagPolicyRepository = null;
        }
        List<RangerContextEnricher> tagContextEnrichers = this.tagPolicyRepository == null ? null : this.tagPolicyRepository.getContextEnrichers();
        List<RangerContextEnricher> resourceContextEnrichers = this.policyRepository.getContextEnrichers();
        if (CollectionUtils.isEmpty(tagContextEnrichers)) {
            tmpList = resourceContextEnrichers;
        } else if (CollectionUtils.isEmpty(resourceContextEnrichers)) {
            tmpList = tagContextEnrichers;
        } else {
            tmpList = new ArrayList<RangerContextEnricher>(tagContextEnrichers);
            tmpList.addAll(resourceContextEnrichers);
        }
        this.allContextEnrichers = tmpList;
        this.policyEvaluatorsMap = this.createPolicyEvaluatorsMap();
        RangerPerfTracer.log(perf);
        if (PERF_POLICYENGINE_INIT_LOG.isDebugEnabled()) {
            long freeMemory = Runtime.getRuntime().freeMemory();
            long totalMemory = Runtime.getRuntime().totalMemory();
            PERF_POLICYENGINE_INIT_LOG.debug("In-Use memory: " + (totalMemory - freeMemory) + ", Free memory:" + freeMemory);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyEngineImpl()");
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.cleanup();
        }
        finally {
            super.finalize();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RangerPolicyEngineImpl={");
        sb.append("serviceName={").append(this.getServiceName()).append("} ");
        sb.append(this.policyRepository);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void setUseForwardedIPAddress(boolean useForwardedIPAddress) {
        this.useForwardedIPAddress = useForwardedIPAddress;
    }

    @Override
    public void setTrustedProxyAddresses(String[] trustedProxyAddresses) {
        this.trustedProxyAddresses = trustedProxyAddresses;
    }

    @Override
    public boolean getUseForwardedIPAddress() {
        return this.useForwardedIPAddress;
    }

    @Override
    public String[] getTrustedProxyAddresses() {
        return this.trustedProxyAddresses;
    }

    @Override
    public RangerServiceDef getServiceDef() {
        return this.policyRepository.getServiceDef();
    }

    @Override
    public long getPolicyVersion() {
        return this.policyRepository.getPolicyVersion();
    }

    @Override
    public void preProcess(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyEngineImpl.preProcess(" + request + ")");
        }
        this.setResourceServiceDef(request);
        if (request instanceof RangerAccessRequestImpl) {
            ((RangerAccessRequestImpl)request).extractAndSetClientIPAddress(this.useForwardedIPAddress, this.trustedProxyAddresses);
        }
        RangerAccessRequestUtil.setCurrentUserInContext(request.getContext(), request.getUser());
        List<RangerContextEnricher> enrichers = this.allContextEnrichers;
        if (!CollectionUtils.isEmpty(enrichers)) {
            for (RangerContextEnricher enricher : enrichers) {
                RangerPerfTracer perf = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_CONTEXTENRICHER_REQUEST_LOG)) {
                    perf = RangerPerfTracer.getPerfTracer(PERF_CONTEXTENRICHER_REQUEST_LOG, "RangerContextEnricher.enrich(requestHashCode=" + Integer.toHexString(System.identityHashCode(request)) + ", enricherName=" + enricher.getName() + ")");
                }
                enricher.enrich(request);
                RangerPerfTracer.log(perf);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyEngineImpl.preProcess(" + request + ")");
        }
    }

    @Override
    public void preProcess(Collection<RangerAccessRequest> requests) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyEngineImpl.preProcess(" + requests + ")");
        }
        if (CollectionUtils.isNotEmpty(requests)) {
            for (RangerAccessRequest request : requests) {
                this.preProcess(request);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyEngineImpl.preProcess(" + requests + ")");
        }
    }

    @Override
    public RangerAccessResult evaluatePolicies(RangerAccessRequest request, int policyType, RangerAccessResultProcessor resultProcessor) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyEngineImpl.evaluatePolicies(" + request + ", policyType=" + policyType + ")");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_REQUEST_LOG)) {
            String requestHashCode = Integer.toHexString(System.identityHashCode(request)) + "_" + Integer.toString(policyType);
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_REQUEST_LOG, "RangerPolicyEngine.evaluatePolicies(requestHashCode=" + requestHashCode + ")");
            LOG.info("RangerPolicyEngineImpl.evaluatePolicies(" + requestHashCode + ", " + request + ")");
        }
        RangerAccessResult ret = this.evaluatePoliciesNoAudit(request, policyType);
        this.updatePolicyUsageCounts(request, ret);
        if (resultProcessor != null) {
            RangerPerfTracer perfAuditTracer = null;
            if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_AUDIT_LOG)) {
                String requestHashCode = Integer.toHexString(System.identityHashCode(request)) + "_" + Integer.toString(policyType);
                perfAuditTracer = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_AUDIT_LOG, "RangerPolicyEngine.processAudit(requestHashCode=" + requestHashCode + ")");
            }
            resultProcessor.processResult(ret);
            RangerPerfTracer.log(perfAuditTracer);
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyEngineImpl.evaluatePolicies(" + request + ", policyType=" + policyType + "): " + ret);
        }
        return ret;
    }

    @Override
    public Collection<RangerAccessResult> evaluatePolicies(Collection<RangerAccessRequest> requests, int policyType, RangerAccessResultProcessor resultProcessor) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyEngineImpl.evaluatePolicies(" + requests + ", policyType=" + policyType + ")");
        }
        ArrayList<RangerAccessResult> ret = new ArrayList<RangerAccessResult>();
        if (requests != null) {
            for (RangerAccessRequest request : requests) {
                RangerAccessResult result2 = this.evaluatePoliciesNoAudit(request, policyType);
                ret.add(result2);
            }
        }
        if (resultProcessor != null) {
            resultProcessor.processResults(ret);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyEngineImpl.evaluatePolicies(" + requests + ", policyType=" + policyType + "): " + ret);
        }
        return ret;
    }

    @Override
    public RangerResourceACLs getResourceACLs(RangerAccessRequest request) {
        List<RangerPolicyEvaluator> allEvaluators;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyEngineImpl.getResourceACLs(request=" + request + ")");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_GET_ACLS_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_GET_ACLS_LOG, "RangerPolicyEngine.getResourceACLs(requestHashCode=" + request.getResource().getAsString() + ")");
        }
        RangerResourceACLs ret = new RangerResourceACLs();
        Set<RangerTagForEval> tags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext());
        List<PolicyEvaluatorForTag> tagPolicyEvaluators = this.tagPolicyRepository == null ? null : this.tagPolicyRepository.getLikelyMatchPolicyEvaluators(tags, 0, null);
        List<RangerPolicyEvaluator> resourcePolicyEvaluators = this.policyRepository.getLikelyMatchPolicyEvaluators(request.getResource(), 0);
        HashMap<Long, RangerPolicyResourceMatcher.MatchType> tagMatchTypeMap = null;
        HashSet<Long> policyIdForTemporalTags = null;
        if (CollectionUtils.isNotEmpty(tagPolicyEvaluators)) {
            allEvaluators = new ArrayList<RangerPolicyEvaluator>();
            tagMatchTypeMap = new HashMap<Long, RangerPolicyResourceMatcher.MatchType>();
            for (PolicyEvaluatorForTag tagEvaluator : tagPolicyEvaluators) {
                RangerPolicyEvaluator evaluator = tagEvaluator.getEvaluator();
                RangerTagForEval tag = tagEvaluator.getTag();
                allEvaluators.add(evaluator);
                tagMatchTypeMap.put(evaluator.getId(), tag.getMatchType());
                if (!CollectionUtils.isNotEmpty(tag.getValidityPeriods())) continue;
                if (policyIdForTemporalTags == null) {
                    policyIdForTemporalTags = new HashSet<Long>();
                }
                policyIdForTemporalTags.add(evaluator.getId());
            }
            allEvaluators.addAll(resourcePolicyEvaluators);
            allEvaluators.sort(RangerPolicyEvaluator.EVAL_ORDER_COMPARATOR);
        } else {
            allEvaluators = resourcePolicyEvaluators;
        }
        if (CollectionUtils.isNotEmpty(allEvaluators)) {
            Integer policyPriority = null;
            for (RangerPolicyEvaluator evaluator : allEvaluators) {
                Integer accessResult;
                RangerPolicyEvaluator.PolicyACLSummary aclSummary;
                boolean isMatched;
                RangerPolicyResourceMatcher.MatchType matchType;
                if (policyPriority == null) {
                    policyPriority = evaluator.getPolicyPriority();
                }
                if (policyPriority.intValue() != evaluator.getPolicyPriority()) {
                    ret.finalizeAcls();
                    policyPriority = evaluator.getPolicyPriority();
                }
                RangerPolicyResourceMatcher.MatchType matchType2 = matchType = tagMatchTypeMap != null ? (RangerPolicyResourceMatcher.MatchType)((Object)tagMatchTypeMap.get(evaluator.getId())) : null;
                if (matchType == null) {
                    matchType = evaluator.getPolicyResourceMatcher().getMatchType(request.getResource(), request.getContext());
                }
                if (request.getResourceMatchingScope() == RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS) {
                    isMatched = matchType != RangerPolicyResourceMatcher.MatchType.NONE;
                } else {
                    boolean bl = isMatched = matchType == RangerPolicyResourceMatcher.MatchType.SELF || matchType == RangerPolicyResourceMatcher.MatchType.ANCESTOR;
                }
                if (!isMatched || (aclSummary = evaluator.getPolicyACLSummary()) == null) continue;
                boolean isConditional = policyIdForTemporalTags != null && policyIdForTemporalTags.contains(evaluator.getId()) || evaluator.getValidityScheduleEvaluatorsCount() != 0;
                for (Map.Entry<String, Map<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult>> userAccessInfo : aclSummary.getUsersAccessInfo().entrySet()) {
                    String userName = userAccessInfo.getKey();
                    for (Map.Entry<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult> accessInfo : userAccessInfo.getValue().entrySet()) {
                        if (isConditional) {
                            accessResult = RangerPolicyEvaluator.ACCESS_CONDITIONAL;
                        } else {
                            accessResult = accessInfo.getValue().getResult();
                            if (accessResult.equals(RangerPolicyEvaluator.ACCESS_UNDETERMINED)) {
                                accessResult = RangerPolicyEvaluator.ACCESS_DENIED;
                            }
                        }
                        ret.setUserAccessInfo(userName, accessInfo.getKey(), accessResult);
                    }
                }
                for (Map.Entry<String, Map<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult>> groupAccessInfo : aclSummary.getGroupsAccessInfo().entrySet()) {
                    String groupName = groupAccessInfo.getKey();
                    for (Map.Entry<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult> accessInfo : groupAccessInfo.getValue().entrySet()) {
                        if (isConditional) {
                            accessResult = RangerPolicyEvaluator.ACCESS_CONDITIONAL;
                        } else {
                            accessResult = accessInfo.getValue().getResult();
                            if (accessResult.equals(RangerPolicyEvaluator.ACCESS_UNDETERMINED)) {
                                accessResult = RangerPolicyEvaluator.ACCESS_DENIED;
                            }
                        }
                        ret.setGroupAccessInfo(groupName, accessInfo.getKey(), accessResult);
                    }
                }
            }
            ret.finalizeAcls();
        }
        RangerPerfTracer.logAlways(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyEngineImpl.getResourceACLs(request=" + request + ") : ret=" + ret);
        }
        return ret;
    }

    @Override
    public boolean preCleanup() {
        boolean ret = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyEngineImpl.preCleanup()");
        }
        if (CollectionUtils.isNotEmpty(this.allContextEnrichers)) {
            for (RangerContextEnricher contextEnricher : this.allContextEnrichers) {
                boolean readyForCleanup = contextEnricher.preCleanup();
                if (readyForCleanup) continue;
                LOG.warn("contextEnricher.preCleanup() failed for contextEnricher=" + contextEnricher.getName());
                ret = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyEngineImpl.preCleanup() : result=" + ret);
        }
        return ret;
    }

    @Override
    public void cleanup() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyEngineImpl.cleanup()");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "RangerPolicyEngine.cleanUp(hashCode=" + Integer.toHexString(System.identityHashCode(this)) + ")");
        }
        this.preCleanup();
        if (CollectionUtils.isNotEmpty(this.allContextEnrichers)) {
            for (RangerContextEnricher contextEnricher : this.allContextEnrichers) {
                contextEnricher.cleanup();
            }
        }
        this.allContextEnrichers = null;
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyEngineImpl.cleanup()");
        }
    }

    @Override
    public void reorderPolicyEvaluators() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> reorderEvaluators()");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_REBALANCE_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_REBALANCE_LOG, "RangerPolicyEngine.reorderEvaluators()");
        }
        if (MapUtils.isNotEmpty(this.policyEvaluatorsMap)) {
            for (Map.Entry<Long, RangerPolicyEvaluator> entry2 : this.policyEvaluatorsMap.entrySet()) {
                entry2.getValue().setUsageCountImmutable();
            }
        }
        if (this.tagPolicyRepository != null) {
            this.tagPolicyRepository.reorderPolicyEvaluators();
        }
        if (this.policyRepository != null) {
            this.policyRepository.reorderPolicyEvaluators();
        }
        if (MapUtils.isNotEmpty(this.policyEvaluatorsMap)) {
            for (Map.Entry<Long, RangerPolicyEvaluator> entry2 : this.policyEvaluatorsMap.entrySet()) {
                entry2.getValue().resetUsageCount();
            }
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== reorderEvaluators()");
        }
    }

    @Override
    public boolean isAccessAllowed(RangerAccessResource resource, String user, Set<String> userGroups, String accessType) {
        RangerPolicyEvaluator evaluator;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyEngineImpl.isAccessAllowed(" + resource + ", " + user + ", " + userGroups + ", " + accessType + ")");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_REQUEST_LOG, "RangerPolicyEngine.isAccessAllowed(user=" + user + ",accessType=" + accessType + "resource=" + resource.getAsString() + ")");
        }
        boolean ret = false;
        Iterator<RangerPolicyEvaluator> iterator2 = this.policyRepository.getLikelyMatchPolicyEvaluators(resource, 0).iterator();
        while (iterator2.hasNext() && !(ret = (evaluator = iterator2.next()).isAccessAllowed(resource, user, userGroups, accessType))) {
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyEngineImpl.isAccessAllowed(" + resource + ", " + user + ", " + userGroups + ", " + accessType + "): " + ret);
        }
        return ret;
    }

    @Override
    public boolean isAccessAllowed(RangerPolicy policy, String user, Set<String> userGroups, String accessType) {
        RangerPolicyEvaluator evaluator;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyEngineImpl.isAccessAllowed(" + policy.getId() + ", " + user + ", " + userGroups + ", " + accessType + ")");
        }
        boolean ret = false;
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_REQUEST_LOG, "RangerPolicyEngine.isAccessAllowed(user=" + user + "," + userGroups + ",accessType=" + accessType + ")");
        }
        Iterator<RangerPolicyEvaluator> iterator2 = this.policyRepository.getPolicyEvaluators().iterator();
        while (iterator2.hasNext() && !(ret = (evaluator = iterator2.next()).isAccessAllowed(policy, user, userGroups, accessType))) {
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyEngineImpl.isAccessAllowed(" + policy.getId() + ", " + user + ", " + userGroups + ", " + accessType + "): " + ret);
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getExactMatchPolicies(RangerAccessResource resource, Map<String, Object> evalContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyEngineImpl.getExactMatchPolicies(" + resource + ", " + evalContext + ")");
        }
        ArrayList<RangerPolicy> ret = null;
        for (RangerPolicyEvaluator evaluator : this.policyRepository.getPolicyEvaluators()) {
            if (!evaluator.isCompleteMatch(resource, evalContext)) continue;
            if (ret == null) {
                ret = new ArrayList<RangerPolicy>();
            }
            ret.add(evaluator.getPolicy());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyEngineImpl.getExactMatchPolicies(" + resource + ", " + evalContext + "): " + ret);
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getExactMatchPolicies(Map<String, RangerPolicy.RangerPolicyResource> resources, Map<String, Object> evalContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyEngineImpl.getExactMatchPolicies(" + resources + ", " + evalContext + ")");
        }
        ArrayList<RangerPolicy> ret = null;
        for (RangerPolicyEvaluator evaluator : this.policyRepository.getPolicyEvaluators()) {
            if (!evaluator.isCompleteMatch(resources, evalContext)) continue;
            if (ret == null) {
                ret = new ArrayList<RangerPolicy>();
            }
            ret.add(evaluator.getPolicy());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyEngineImpl.getExactMatchPolicies(" + resources + ", " + evalContext + "): " + ret);
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getMatchingPolicies(RangerAccessResource resource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyEngineImpl.getMatchingPolicies(" + resource + ")");
        }
        RangerAccessRequestImpl request = new RangerAccessRequestImpl(resource, "_any", null, null);
        this.preProcess(request);
        List<RangerPolicy> ret = this.getMatchingPolicies(request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyEngineImpl.getMatchingPolicies(" + resource + ") : " + ret.size());
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getMatchingPolicies(RangerAccessRequest request) {
        Set<RangerTagForEval> tags;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyEngineImpl.getMatchingPolicies(" + request + ")");
        }
        ArrayList<RangerPolicy> ret = new ArrayList<RangerPolicy>();
        if (this.hasTagPolicies() && CollectionUtils.isNotEmpty(tags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext()))) {
            for (RangerTagForEval tag : tags) {
                RangerTagAccessRequest tagEvalRequest = new RangerTagAccessRequest(tag, this.tagPolicyRepository.getServiceDef(), request);
                RangerAccessResource tagResource = tagEvalRequest.getResource();
                List<RangerPolicyEvaluator> likelyEvaluators = this.tagPolicyRepository.getLikelyMatchPolicyEvaluators(tagResource);
                for (RangerPolicyEvaluator evaluator : likelyEvaluators) {
                    RangerPolicyResourceMatcher matcher = evaluator.getPolicyResourceMatcher();
                    if (matcher == null || !(request.isAccessTypeAny() ? matcher.isMatch(tagResource, RangerPolicyResourceMatcher.MatchScope.ANY, null) : matcher.isMatch(tagResource, null))) continue;
                    ret.add(evaluator.getPolicy());
                }
            }
        }
        if (this.hasResourcePolicies()) {
            List<RangerPolicyEvaluator> likelyEvaluators = this.policyRepository.getLikelyMatchPolicyEvaluators(request.getResource());
            for (RangerPolicyEvaluator evaluator : likelyEvaluators) {
                RangerPolicyResourceMatcher matcher = evaluator.getPolicyResourceMatcher();
                if (matcher == null || !(request.isAccessTypeAny() ? matcher.isMatch(request.getResource(), RangerPolicyResourceMatcher.MatchScope.ANY, null) : matcher.isMatch(request.getResource(), null))) continue;
                ret.add(evaluator.getPolicy());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyEngineImpl.getMatchingPolicies(" + request + ") : " + ret.size());
        }
        return ret;
    }

    @Override
    public RangerResourceAccessInfo getResourceAccessInfo(RangerAccessRequest request) {
        List<RangerPolicyEvaluator> resPolicyEvaluators;
        Set<RangerTagForEval> tags;
        List<RangerPolicyEvaluator> tagPolicyEvaluators;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyEngineImpl.getResourceAccessInfo(" + request + ")");
        }
        RangerResourceAccessInfo ret = new RangerResourceAccessInfo(request);
        List<RangerPolicyEvaluator> list = tagPolicyEvaluators = this.tagPolicyRepository == null ? null : this.tagPolicyRepository.getPolicyEvaluators();
        if (CollectionUtils.isNotEmpty(tagPolicyEvaluators) && CollectionUtils.isNotEmpty(tags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext()))) {
            for (RangerTagForEval tag : tags) {
                RangerTagAccessRequest tagEvalRequest = new RangerTagAccessRequest(tag, this.tagPolicyRepository.getServiceDef(), request);
                List<RangerPolicyEvaluator> evaluators = this.tagPolicyRepository.getLikelyMatchPolicyEvaluators(tagEvalRequest.getResource(), 0);
                for (RangerPolicyEvaluator evaluator : evaluators) {
                    evaluator.getResourceAccessInfo(tagEvalRequest, ret);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(resPolicyEvaluators = this.policyRepository.getLikelyMatchPolicyEvaluators(request.getResource(), 0))) {
            for (RangerPolicyEvaluator evaluator : resPolicyEvaluators) {
                evaluator.getResourceAccessInfo(request, ret);
            }
        }
        ret.getAllowedUsers().removeAll(ret.getDeniedUsers());
        ret.getAllowedGroups().removeAll(ret.getDeniedGroups());
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyEngineImpl.getResourceAccessInfo(" + request + "): " + ret);
        }
        return ret;
    }

    @Override
    public boolean isAccessAllowed(Map<String, RangerPolicy.RangerPolicyResource> resources, String user, Set<String> userGroups, String accessType) {
        RangerPolicyEvaluator evaluator;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyEngineImpl.isAccessAllowed(" + resources + ", " + user + ", " + userGroups + ", " + accessType + ")");
        }
        boolean ret = false;
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_REQUEST_LOG, "RangerPolicyEngine.isAccessAllowed(user=" + user + "," + userGroups + ",accessType=" + accessType + ")");
        }
        Iterator<RangerPolicyEvaluator> iterator2 = this.policyRepository.getPolicyEvaluators().iterator();
        while (iterator2.hasNext() && !(ret = (evaluator = iterator2.next()).isAccessAllowed(resources, user, userGroups, accessType))) {
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyEngineImpl.isAccessAllowed(" + resources + ", " + user + ", " + userGroups + ", " + accessType + "): " + ret);
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getAllowedPolicies(String user, Set<String> userGroups, String accessType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyEngineImpl.getAllowedPolicies(" + user + ", " + userGroups + ", " + accessType + ")");
        }
        ArrayList<RangerPolicy> ret = new ArrayList<RangerPolicy>();
        for (RangerPolicyEvaluator evaluator : this.policyRepository.getPolicyEvaluators()) {
            RangerPolicy policy = evaluator.getPolicy();
            boolean isAccessAllowed = this.isAccessAllowed(policy.getResources(), user, userGroups, accessType);
            if (!isAccessAllowed) continue;
            ret.add(policy);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyEngineImpl.getAllowedPolicies(" + user + ", " + userGroups + ", " + accessType + "): policyCount=" + ret.size());
        }
        return ret;
    }

    private RangerAccessResult evaluatePoliciesNoAudit(RangerAccessRequest request, int policyType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyEngineImpl.evaluatePoliciesNoAudit(" + request + ", policyType =" + policyType + ")");
        }
        RangerAccessResult ret = this.createAccessResult(request, policyType);
        Date accessTime = request.getAccessTime();
        if (ret != null && request != null) {
            this.evaluateTagPolicies(request, policyType, ret);
            if (LOG.isDebugEnabled() && ret.getIsAccessDetermined() && ret.getIsAuditedDetermined()) {
                if (!ret.getIsAllowed()) {
                    LOG.debug("RangerPolicyEngineImpl.evaluatePoliciesNoAudit() - audit determined and access denied by a tag policy. Higher priority resource policies will be evaluated to check for allow, request=" + request + ", result=" + ret);
                } else {
                    LOG.debug("RangerPolicyEngineImpl.evaluatePoliciesNoAudit() - audit determined and access allowed by a tag policy. Same or higher priority resource policies will be evaluated to check for deny, request=" + request + ", result=" + ret);
                }
            }
            boolean isAllowedByTags = ret.getIsAccessDetermined() && ret.getIsAllowed();
            boolean isDeniedByTags = ret.getIsAccessDetermined() && !ret.getIsAllowed();
            boolean evaluateResourcePolicies = this.hasResourcePolicies();
            if (evaluateResourcePolicies) {
                boolean findAuditByResource = !ret.getIsAuditedDetermined();
                boolean foundInCache = findAuditByResource && this.policyRepository.setAuditEnabledFromCache(request, ret);
                ret.setIsAccessDetermined(false);
                List<RangerPolicyEvaluator> evaluators = this.policyRepository.getLikelyMatchPolicyEvaluators(request.getResource(), policyType);
                for (RangerPolicyEvaluator evaluator : evaluators) {
                    if (!evaluator.isApplicable(accessTime)) continue;
                    if (isDeniedByTags) {
                        if (ret.getPolicyPriority() >= evaluator.getPolicyPriority()) {
                            ret.setIsAccessDetermined(true);
                        }
                    } else if (isAllowedByTags && ret.getPolicyPriority() > evaluator.getPolicyPriority()) {
                        ret.setIsAccessDetermined(true);
                    }
                    ret.incrementEvaluatedPoliciesCount();
                    evaluator.evaluate(request, ret);
                    if (ret.getIsAllowed() && !evaluator.hasDeny()) {
                        ret.setIsAccessDetermined(true);
                    }
                    if (!ret.getIsAuditedDetermined() || !ret.getIsAccessDetermined()) continue;
                    break;
                }
                if (!ret.getIsAccessDetermined()) {
                    if (isDeniedByTags) {
                        ret.setIsAllowed(false);
                    } else if (isAllowedByTags) {
                        ret.setIsAllowed(true);
                    }
                }
                if (ret.getIsAllowed()) {
                    ret.setIsAccessDetermined(true);
                }
                if (findAuditByResource && !foundInCache) {
                    this.policyRepository.storeAuditEnabledInCache(request, ret);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyEngineImpl.evaluatePoliciesNoAudit(" + request + ", policyType =" + policyType + "): " + ret);
        }
        return ret;
    }

    private void evaluateTagPolicies(RangerAccessRequest request, int policyType, RangerAccessResult result2) {
        List<PolicyEvaluatorForTag> policyEvaluators;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyEngineImpl.evaluateTagPolicies(" + request + ", policyType =" + policyType + ", " + result2 + ")");
        }
        Date accessTime = request.getAccessTime();
        Set<RangerTagForEval> tags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext());
        List<PolicyEvaluatorForTag> list = policyEvaluators = this.tagPolicyRepository == null ? null : this.tagPolicyRepository.getLikelyMatchPolicyEvaluators(tags, policyType, accessTime);
        if (CollectionUtils.isNotEmpty(policyEvaluators)) {
            for (PolicyEvaluatorForTag policyEvaluator : policyEvaluators) {
                RangerPolicyEvaluator evaluator = policyEvaluator.getEvaluator();
                RangerTagForEval tag = policyEvaluator.getTag();
                RangerTagAccessRequest tagEvalRequest = new RangerTagAccessRequest(tag, this.tagPolicyRepository.getServiceDef(), request);
                RangerAccessResult tagEvalResult = this.createAccessResult(tagEvalRequest, policyType);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RangerPolicyEngineImpl.evaluateTagPolicies: Evaluating policies for tag (" + tag.getType() + ")");
                }
                tagEvalResult.setAccessResultFrom(result2);
                tagEvalResult.setAuditResultFrom(result2);
                result2.incrementEvaluatedPoliciesCount();
                evaluator.evaluate(tagEvalRequest, tagEvalResult);
                if (tagEvalResult.getIsAllowed() && !evaluator.hasDeny()) {
                    tagEvalResult.setIsAccessDetermined(true);
                }
                if (tagEvalResult.getIsAudited()) {
                    result2.setAuditResultFrom(tagEvalResult);
                }
                if (!result2.getIsAccessDetermined()) {
                    if (tagEvalResult.getIsAccessDetermined()) {
                        result2.setAccessResultFrom(tagEvalResult);
                    } else if (!result2.getIsAllowed() && tagEvalResult.getIsAllowed()) {
                        result2.setAccessResultFrom(tagEvalResult);
                    }
                }
                if (!result2.getIsAuditedDetermined() || !result2.getIsAccessDetermined()) continue;
                break;
            }
        }
        if (result2.getIsAllowed()) {
            result2.setIsAccessDetermined(true);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyEngineImpl.evaluateTagPolicies(" + request + ", policyType =" + policyType + ", " + result2 + ")");
        }
    }

    private String getServiceName() {
        return this.policyRepository.getServiceName();
    }

    private RangerPolicyEvaluator getPolicyEvaluator(Long id) {
        return this.policyEvaluatorsMap.get(id);
    }

    private RangerAccessResult createAccessResult(RangerAccessRequest request, int policyType) {
        RangerAccessResult ret = new RangerAccessResult(policyType, this.getServiceName(), this.policyRepository.getServiceDef(), request);
        switch (this.policyRepository.getAuditModeEnum()) {
            case AUDIT_ALL: {
                ret.setIsAudited(true);
                break;
            }
            case AUDIT_NONE: {
                ret.setIsAudited(false);
                break;
            }
            default: {
                if (!CollectionUtils.isEmpty(this.policyRepository.getPolicies()) || this.tagPolicyRepository != null) break;
                ret.setIsAudited(true);
            }
        }
        return ret;
    }

    private void setResourceServiceDef(RangerAccessRequest request) {
        RangerAccessResource resource = request.getResource();
        if (resource.getServiceDef() == null) {
            if (resource instanceof RangerMutableResource) {
                RangerMutableResource mutable = (RangerMutableResource)resource;
                mutable.setServiceDef(this.getServiceDef());
            } else {
                LOG.debug("RangerPolicyEngineImpl.setResourceServiceDef(): Cannot set ServiceDef in RangerMutableResource.");
            }
        }
    }

    private boolean hasTagPolicies() {
        return this.tagPolicyRepository != null && CollectionUtils.isNotEmpty(this.tagPolicyRepository.getPolicies());
    }

    private boolean hasResourcePolicies() {
        return this.policyRepository != null && CollectionUtils.isNotEmpty(this.policyRepository.getPolicies());
    }

    private Map<Long, RangerPolicyEvaluator> createPolicyEvaluatorsMap() {
        HashMap<Long, RangerPolicyEvaluator> tmpPolicyEvaluatorMap = new HashMap<Long, RangerPolicyEvaluator>();
        if (this.tagPolicyRepository != null) {
            for (RangerPolicyEvaluator evaluator : this.tagPolicyRepository.getPolicyEvaluators()) {
                tmpPolicyEvaluatorMap.put(evaluator.getPolicy().getId(), evaluator);
            }
            for (RangerPolicyEvaluator evaluator : this.tagPolicyRepository.getDataMaskPolicyEvaluators()) {
                tmpPolicyEvaluatorMap.put(evaluator.getPolicy().getId(), evaluator);
            }
            for (RangerPolicyEvaluator evaluator : this.tagPolicyRepository.getRowFilterPolicyEvaluators()) {
                tmpPolicyEvaluatorMap.put(evaluator.getPolicy().getId(), evaluator);
            }
        }
        for (RangerPolicyEvaluator evaluator : this.policyRepository.getPolicyEvaluators()) {
            tmpPolicyEvaluatorMap.put(evaluator.getPolicy().getId(), evaluator);
        }
        for (RangerPolicyEvaluator evaluator : this.policyRepository.getDataMaskPolicyEvaluators()) {
            tmpPolicyEvaluatorMap.put(evaluator.getPolicy().getId(), evaluator);
        }
        for (RangerPolicyEvaluator evaluator : this.policyRepository.getRowFilterPolicyEvaluators()) {
            tmpPolicyEvaluatorMap.put(evaluator.getPolicy().getId(), evaluator);
        }
        return Collections.unmodifiableMap(tmpPolicyEvaluatorMap);
    }

    private void updatePolicyUsageCounts(RangerAccessRequest accessRequest, RangerAccessResult accessResult) {
        RangerPolicyEvaluator accessPolicy;
        boolean auditCountUpdated = false;
        if (accessResult.getIsAccessDetermined() && (accessPolicy = this.getPolicyEvaluator(accessResult.getPolicyId())) != null) {
            if (accessPolicy.getPolicy().getIsAuditEnabled().booleanValue()) {
                this.updateUsageCount(accessPolicy, 2);
                accessResult.setAuditPolicyId(accessResult.getPolicyId());
                auditCountUpdated = true;
            } else {
                this.updateUsageCount(accessPolicy, 1);
            }
        }
        if (!auditCountUpdated && accessResult.getIsAuditedDetermined()) {
            long auditPolicyId = accessResult.getAuditPolicyId();
            RangerPolicyEvaluator auditPolicy = auditPolicyId == -1L ? null : this.getPolicyEvaluator(auditPolicyId);
            this.updateUsageCount(auditPolicy, 1);
        }
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_USAGE_LOG)) {
            RangerAccessRequestImpl rangerAccessRequest = (RangerAccessRequestImpl)accessRequest;
            RangerPerfTracer perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_USAGE_LOG, "RangerPolicyEngine.usage(accessingUser=" + rangerAccessRequest.getUser() + ",accessedResource=" + rangerAccessRequest.getResource().getAsString() + ",accessType=" + rangerAccessRequest.getAccessType() + ",evaluatedPoliciesCount=" + accessResult.getEvaluatedPoliciesCount() + ")");
            RangerPerfTracer.logAlways(perf);
        }
    }

    private void updateUsageCount(RangerPolicyEvaluator evaluator, int number) {
        if (evaluator != null) {
            evaluator.incrementUsageCount(number);
        }
    }
}

