/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyevaluator;

import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.util.ServiceDefUtil;

public abstract class RangerAbstractPolicyEvaluator
implements RangerPolicyEvaluator {
    private static final Log LOG = LogFactory.getLog(RangerAbstractPolicyEvaluator.class);
    private RangerPolicy policy;
    private RangerServiceDef serviceDef;
    private Integer leafResourceLevel;
    private int evalOrder;
    protected long usageCount;
    protected boolean usageCountMutable = true;

    @Override
    public void init(RangerPolicy policy, RangerServiceDef serviceDef, RangerPolicyEngineOptions options) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAbstractPolicyEvaluator.init(" + policy + ", " + serviceDef + ")");
        }
        this.policy = policy;
        this.serviceDef = serviceDef;
        this.leafResourceLevel = ServiceDefUtil.getLeafResourceLevel(serviceDef, this.getPolicyResource());
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAbstractPolicyEvaluator.init(" + policy + ", " + serviceDef + ")");
        }
    }

    @Override
    public long getId() {
        return this.policy != null ? this.policy.getId() : -1L;
    }

    @Override
    public Map<String, RangerPolicy.RangerPolicyResource> getPolicyResource() {
        return this.policy != null ? this.policy.getResources() : null;
    }

    @Override
    public RangerPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public int getPolicyPriority() {
        return this.policy != null && this.policy.getPolicyPriority() != null ? this.policy.getPolicyPriority() : 0;
    }

    @Override
    public RangerServiceDef getServiceDef() {
        return this.serviceDef;
    }

    @Override
    public Integer getLeafResourceLevel() {
        return this.leafResourceLevel;
    }

    @Override
    public boolean hasAllow() {
        return this.policy != null && CollectionUtils.isNotEmpty(this.policy.getPolicyItems());
    }

    protected boolean hasMatchablePolicyItem(RangerAccessRequest request) {
        return this.hasAllow() || this.hasDeny();
    }

    @Override
    public boolean hasDeny() {
        return this.policy != null && CollectionUtils.isNotEmpty(this.policy.getDenyPolicyItems());
    }

    @Override
    public long getUsageCount() {
        return this.usageCount;
    }

    @Override
    public int getEvalOrder() {
        return this.evalOrder;
    }

    @Override
    public boolean isAuditEnabled() {
        return this.policy != null && this.policy.getIsAuditEnabled() != false;
    }

    public void setEvalOrder(int evalOrder) {
        this.evalOrder = evalOrder;
    }

    @Override
    public void incrementUsageCount(int number) {
        if (this.usageCountMutable) {
            this.usageCount += (long)number;
        }
    }

    @Override
    public void setUsageCountImmutable() {
        this.usageCountMutable = false;
    }

    @Override
    public void resetUsageCount() {
        this.usageCount = 0L;
        this.usageCountMutable = true;
    }

    @Override
    public RangerPolicyEvaluator.PolicyACLSummary getPolicyACLSummary() {
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerAbstractPolicyEvaluator={");
        sb.append("policy={").append(this.policy).append("} ");
        sb.append("serviceDef={").append(this.serviceDef).append("} ");
        sb.append("}");
        return sb;
    }
}

