/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.resourcematcher.RangerAbstractResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.ResourceMatcher;

public class RangerDefaultResourceMatcher
extends RangerAbstractResourceMatcher {
    private static final Log LOG = LogFactory.getLog(RangerDefaultResourceMatcher.class);

    @Override
    public boolean isMatch(Object resource, Map<String, Object> evalContext) {
        ResourceMatcher resourceMatcher;
        Iterator<ResourceMatcher> iterator2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultResourceMatcher.isMatch(" + resource + ", " + evalContext + ")");
        }
        boolean ret = false;
        boolean allValuesRequested = this.isAllValuesRequested(resource);
        if (allValuesRequested || this.isMatchAny) {
            ret = this.isMatchAny;
        } else if (resource instanceof String) {
            String strValue = (String)resource;
            iterator2 = this.resourceMatchers.getResourceMatchers().iterator();
            while (iterator2.hasNext() && !(ret = (resourceMatcher = iterator2.next()).isMatch(strValue, evalContext))) {
            }
        } else if (resource instanceof Collection) {
            Collection collValue = (Collection)resource;
            iterator2 = this.resourceMatchers.getResourceMatchers().iterator();
            while (iterator2.hasNext() && !(ret = (resourceMatcher = iterator2.next()).isMatchAny(collValue, evalContext))) {
            }
        }
        ret = this.applyExcludes(allValuesRequested, ret);
        if (!ret && LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (String policyValue : this.policyValues) {
                sb.append(policyValue);
                sb.append(" ");
            }
            sb.append("]");
            LOG.debug("RangerDefaultResourceMatcher.isMatch returns FALSE, (resource=" + resource + ", policyValues=" + sb.toString() + ")");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultResourceMatcher.isMatch(" + resource + ", " + evalContext + "): " + ret);
        }
        return ret;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerDefaultResourceMatcher={");
        super.toString(sb);
        sb.append("}");
        return sb;
    }
}

