/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store;

import java.util.List;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.plugin.model.RangerTag;
import org.apache.ranger.plugin.model.RangerTagDef;
import org.apache.ranger.plugin.model.RangerTagResourceMap;
import org.apache.ranger.plugin.store.AbstractPredicateUtil;
import org.apache.ranger.plugin.util.SearchFilter;

public class TagPredicateUtil
extends AbstractPredicateUtil {
    @Override
    public void addPredicates(SearchFilter filter2, List<Predicate> predicates) {
        super.addPredicates(filter2, predicates);
        this.addPredicateForTagDefId(filter2.getParam("tagDefId"), predicates);
        this.addPredicateForTagDefGuid(filter2.getParam("tagDefGuid"), predicates);
        this.addPredicateForTagId(filter2.getParam("tagId"), predicates);
        this.addPredicateForTagGuid(filter2.getParam("tagGuid"), predicates);
        this.addPredicateForTagType(filter2.getParam("tagType"), predicates);
        this.addPredicateForResourceId(filter2.getParam("resourceId"), predicates);
        this.addPredicateForResourceGuid(filter2.getParam("resourceGuid"), predicates);
        this.addPredicateForServiceResourceServiceName(filter2.getParam("resourceServiceName"), predicates);
        this.addPredicateForResourceSignature(filter2.getParam("resourceSignature"), predicates);
        this.addPredicateForTagResourceMapId(filter2.getParam("tagResourceMapId"), predicates);
    }

    private Predicate addPredicateForTagDefId(final String id, List<Predicate> predicates) {
        if (StringUtils.isEmpty(id)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                boolean ret = false;
                if (object == null) {
                    return ret;
                }
                if (object instanceof RangerTagDef) {
                    RangerTagDef tagDef = (RangerTagDef)object;
                    ret = StringUtils.equals(id, tagDef.getId().toString());
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForTagDefGuid(final String guid, List<Predicate> predicates) {
        if (StringUtils.isEmpty(guid)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                boolean ret = false;
                if (object == null) {
                    return ret;
                }
                if (object instanceof RangerTagDef) {
                    RangerTagDef tagDef = (RangerTagDef)object;
                    ret = StringUtils.equals(guid, tagDef.getGuid());
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForTagId(final String id, List<Predicate> predicates) {
        if (StringUtils.isEmpty(id)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                boolean ret = false;
                if (object == null) {
                    return ret;
                }
                if (object instanceof RangerTag) {
                    RangerTag tag = (RangerTag)object;
                    ret = StringUtils.equals(id, tag.getId().toString());
                } else if (object instanceof RangerTagResourceMap) {
                    RangerTagResourceMap tagResourceMap = (RangerTagResourceMap)object;
                    ret = StringUtils.equals(id, tagResourceMap.getTagId().toString());
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForTagGuid(final String guid, List<Predicate> predicates) {
        if (StringUtils.isEmpty(guid)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                boolean ret = false;
                if (object == null) {
                    return ret;
                }
                if (object instanceof RangerTag) {
                    RangerTag tag = (RangerTag)object;
                    ret = StringUtils.equals(guid, tag.getGuid());
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForTagType(final String type, List<Predicate> predicates) {
        if (StringUtils.isEmpty(type)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                boolean ret = false;
                if (object == null) {
                    return ret;
                }
                if (object instanceof RangerTagDef) {
                    RangerTagDef tagDef = (RangerTagDef)object;
                    ret = StringUtils.equals(type, tagDef.getName());
                } else if (object instanceof RangerTag) {
                    RangerTag tag = (RangerTag)object;
                    ret = StringUtils.equals(type, tag.getType());
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForResourceId(final String id, List<Predicate> predicates) {
        if (StringUtils.isEmpty(id)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                boolean ret = false;
                if (object == null) {
                    return ret;
                }
                if (object instanceof RangerServiceResource) {
                    RangerServiceResource resource = (RangerServiceResource)object;
                    ret = StringUtils.equals(id, resource.getId().toString());
                } else if (object instanceof RangerTagResourceMap) {
                    RangerTagResourceMap tagResourceMap = (RangerTagResourceMap)object;
                    ret = StringUtils.equals(id, tagResourceMap.getId().toString());
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForResourceGuid(final String id, List<Predicate> predicates) {
        if (StringUtils.isEmpty(id)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                boolean ret = false;
                if (object == null) {
                    return ret;
                }
                if (object instanceof RangerServiceResource) {
                    RangerServiceResource resource = (RangerServiceResource)object;
                    ret = StringUtils.equals(id, resource.getGuid());
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForServiceResourceServiceName(final String serviceName, List<Predicate> predicates) {
        if (serviceName == null || StringUtils.isEmpty(serviceName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                boolean ret = false;
                if (object == null) {
                    return ret;
                }
                if (object instanceof RangerServiceResource) {
                    RangerServiceResource resource = (RangerServiceResource)object;
                    ret = StringUtils.equals(resource.getServiceName(), serviceName);
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForResourceSignature(final String signature, List<Predicate> predicates) {
        if (StringUtils.isEmpty(signature)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                boolean ret = false;
                if (object == null) {
                    return ret;
                }
                if (object instanceof RangerServiceResource) {
                    RangerServiceResource resource = (RangerServiceResource)object;
                    ret = StringUtils.equals(signature, resource.getResourceSignature());
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForTagResourceMapId(final String id, List<Predicate> predicates) {
        if (StringUtils.isEmpty(id)) {
            return null;
        }
        Predicate ret = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                boolean ret = false;
                if (object == null) {
                    return ret;
                }
                if (object instanceof RangerTagResourceMap) {
                    RangerTagResourceMap tagResourceMap = (RangerTagResourceMap)object;
                    ret = StringUtils.equals(id, tagResourceMap.getId().toString());
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }
}

