/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import com.sun.jersey.core.util.Base64;
import java.io.IOException;
import java.security.Key;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordUtils.class);
    private final String CRYPT_ALGO;
    private String password;
    private final char[] ENCRYPT_KEY;
    private final byte[] SALT;
    private final int ITERATION_COUNT;
    private final char[] encryptKey;
    private final byte[] salt;
    private static final String LEN_SEPARATOR_STR = ":";
    public static final String DEFAULT_CRYPT_ALGO = "PBEWithMD5AndDES";
    public static final String DEFAULT_ENCRYPT_KEY = "tzL1AKl5uc4NKYaoQ4P3WLGIBFPXWPWdu1fRm9004jtQiV";
    public static final String DEFAULT_SALT = "f77aLYLo";
    public static final int DEFAULT_ITERATION_COUNT = 17;

    public static String encryptPassword(String aPassword) throws IOException {
        return new PasswordUtils(aPassword).encrypt();
    }

    private String encrypt() throws IOException {
        String ret = null;
        String strToEncrypt = null;
        strToEncrypt = this.password == null ? "" : this.password.length() + LEN_SEPARATOR_STR + this.password;
        try {
            Cipher engine = Cipher.getInstance(this.CRYPT_ALGO);
            PBEKeySpec keySpec = new PBEKeySpec(this.encryptKey);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(this.CRYPT_ALGO);
            SecretKey key = skf.generateSecret(keySpec);
            engine.init(1, (Key)key, new PBEParameterSpec(this.salt, this.ITERATION_COUNT));
            byte[] encryptedStr = engine.doFinal(strToEncrypt.getBytes());
            ret = new String(Base64.encode(encryptedStr));
        }
        catch (Throwable t) {
            LOG.error("Unable to encrypt password due to error", t);
            throw new IOException("Unable to encrypt password due to error", t);
        }
        return ret;
    }

    PasswordUtils(String aPassword) {
        Map<String, String> env;
        String encryptKeyStr;
        String[] crypt_algo_array = null;
        int count2 = 0;
        if (aPassword != null && aPassword.contains(",")) {
            count2 = StringUtils.countMatches(aPassword, ",");
            crypt_algo_array = aPassword.split(",");
        }
        if (crypt_algo_array != null && crypt_algo_array.length > 4) {
            this.CRYPT_ALGO = crypt_algo_array[0];
            this.ENCRYPT_KEY = crypt_algo_array[1].toCharArray();
            this.SALT = crypt_algo_array[2].getBytes();
            this.ITERATION_COUNT = Integer.parseInt(crypt_algo_array[3]);
            this.password = crypt_algo_array[4];
            if (count2 > 4) {
                for (int i = 5; i <= count2; ++i) {
                    this.password = this.password + "," + crypt_algo_array[i];
                }
            }
        } else {
            this.CRYPT_ALGO = DEFAULT_CRYPT_ALGO;
            this.ENCRYPT_KEY = DEFAULT_ENCRYPT_KEY.toCharArray();
            this.SALT = DEFAULT_SALT.getBytes();
            this.ITERATION_COUNT = 17;
            this.password = aPassword;
        }
        this.encryptKey = (encryptKeyStr = (env = System.getenv()).get("ENCRYPT_KEY")) == null ? this.ENCRYPT_KEY : encryptKeyStr.toCharArray();
        String saltStr = env.get("ENCRYPT_SALT");
        this.salt = saltStr == null ? this.SALT : saltStr.getBytes();
    }

    public static String decryptPassword(String aPassword) throws IOException {
        return new PasswordUtils(aPassword).decrypt();
    }

    private String decrypt() throws IOException {
        String ret = null;
        try {
            byte[] decodedPassword = Base64.decode(this.password);
            Cipher engine = Cipher.getInstance(this.CRYPT_ALGO);
            PBEKeySpec keySpec = new PBEKeySpec(this.encryptKey);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(this.CRYPT_ALGO);
            SecretKey key = skf.generateSecret(keySpec);
            engine.init(2, (Key)key, new PBEParameterSpec(this.salt, this.ITERATION_COUNT));
            String decrypted = new String(engine.doFinal(decodedPassword));
            int foundAt = decrypted.indexOf(LEN_SEPARATOR_STR);
            ret = foundAt > -1 ? (decrypted.length() > foundAt ? decrypted.substring(foundAt + 1) : "") : null;
        }
        catch (Throwable t) {
            LOG.error("Unable to decrypt password due to error", t);
            throw new IOException("Unable to decrypt password due to error", t);
        }
        return ret;
    }

    public static String getDecryptPassword(String password) {
        String decryptedPwd = null;
        try {
            decryptedPwd = PasswordUtils.decryptPassword(password);
        }
        catch (Exception ex) {
            LOG.warn("Password decryption failed, trying original password string.");
            decryptedPwd = null;
        }
        finally {
            if (decryptedPwd == null) {
                decryptedPwd = password;
            }
        }
        return decryptedPwd;
    }
}

