/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceEvaluator;
import org.apache.ranger.plugin.resourcematcher.RangerAbstractResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.RangerResourceMatcher;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerResourceTrie;

public class RangerResourceTrie<T extends RangerPolicyResourceEvaluator> {
    private static final Log LOG = LogFactory.getLog(RangerResourceTrie.class);
    private static final Log PERF_TRIE_INIT_LOG = RangerPerfTracer.getPerfLogger("resourcetrie.init");
    private static final Log PERF_TRIE_OP_LOG = RangerPerfTracer.getPerfLogger("resourcetrie.op");
    private static final String DEFAULT_WILDCARD_CHARS = "*?";
    private static final String TRIE_BUILDER_THREAD_COUNT = "ranger.policyengine.trie.builder.thread.count";
    private final String resourceName;
    private final boolean optIgnoreCase;
    private final boolean optWildcard;
    private final String wildcardChars;
    private final TrieNode<T> root;
    private final Comparator<T> comparator;
    private final boolean isOptimizedForRetrieval;

    public RangerResourceTrie(RangerServiceDef.RangerResourceDef resourceDef, List<T> evaluators) {
        this(resourceDef, evaluators, null, true);
    }

    public RangerResourceTrie(RangerServiceDef.RangerResourceDef resourceDef, List<T> evaluators, Comparator<T> comparator, boolean isOptimizedForRetrieval) {
        int builderThreadCount;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerResourceTrie(" + resourceDef.getName() + ", evaluatorCount=" + evaluators.size() + ", isOptimizedForRetrieval=" + isOptimizedForRetrieval + ")");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_INIT_LOG, "RangerResourceTrie.init(name=" + resourceDef.getName() + ")");
        }
        if ((builderThreadCount = RangerConfiguration.getInstance().getInt(TRIE_BUILDER_THREAD_COUNT, 1)) < 1) {
            builderThreadCount = 1;
        }
        LOG.info("builderThreadCount is set to [" + builderThreadCount + "]");
        PERF_TRIE_INIT_LOG.info("builderThreadCount is set to [" + builderThreadCount + "]");
        Map<String, String> matcherOptions = resourceDef.getMatcherOptions();
        boolean optReplaceTokens = RangerAbstractResourceMatcher.getOptionReplaceTokens(matcherOptions);
        String tokenReplaceSpecialChars = "";
        if (optReplaceTokens) {
            char delimiterStart = RangerAbstractResourceMatcher.getOptionDelimiterStart(matcherOptions);
            char delimiterEnd = RangerAbstractResourceMatcher.getOptionDelimiterEnd(matcherOptions);
            char delimiterEscape = RangerAbstractResourceMatcher.getOptionDelimiterEscape(matcherOptions);
            tokenReplaceSpecialChars = tokenReplaceSpecialChars + delimiterStart;
            tokenReplaceSpecialChars = tokenReplaceSpecialChars + delimiterEnd;
            tokenReplaceSpecialChars = tokenReplaceSpecialChars + delimiterEscape;
        }
        this.resourceName = resourceDef.getName();
        this.optIgnoreCase = RangerAbstractResourceMatcher.getOptionIgnoreCase(matcherOptions);
        this.optWildcard = RangerAbstractResourceMatcher.getOptionWildCard(matcherOptions);
        this.wildcardChars = this.optWildcard ? DEFAULT_WILDCARD_CHARS + tokenReplaceSpecialChars : "" + tokenReplaceSpecialChars;
        this.comparator = comparator;
        this.isOptimizedForRetrieval = isOptimizedForRetrieval;
        TrieNode<T> tmpRoot = this.buildTrie(resourceDef, evaluators, comparator, builderThreadCount);
        this.root = builderThreadCount > 1 && tmpRoot == null ? this.buildTrie(resourceDef, evaluators, comparator, 1) : tmpRoot;
        RangerPerfTracer.logAlways(perf);
        if (PERF_TRIE_INIT_LOG.isDebugEnabled()) {
            PERF_TRIE_INIT_LOG.debug(this.toString());
        }
        if (PERF_TRIE_INIT_LOG.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            this.root.toString("", sb);
            PERF_TRIE_INIT_LOG.trace("Trie Dump:\n{" + sb.toString() + "}");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerResourceTrie(" + resourceDef.getName() + ", evaluatorCount=" + evaluators.size() + ", isOptimizedForRetrieval=" + isOptimizedForRetrieval + "): " + this.toString());
        }
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public List<T> getEvaluatorsForResource(Object resource) {
        if (resource instanceof String) {
            return this.getEvaluatorsForResource((String)resource);
        }
        if (resource instanceof Collection) {
            if (CollectionUtils.isEmpty((Collection)resource)) {
                return this.getEvaluatorsForResource("");
            }
            Collection resources = (Collection)resource;
            return this.getEvaluatorsForResources(resources);
        }
        return null;
    }

    private TrieNode<T> buildTrie(RangerServiceDef.RangerResourceDef resourceDef, List<T> evaluators, Comparator<T> comparator, int builderThreadCount) {
        HashMap<Character, Integer> builderThreadMap;
        ArrayList<ResourceTrieBuilderThread> builderThreads;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> buildTrie(" + resourceDef.getName() + ", evaluatorCount=" + evaluators.size() + ", isMultiThreaded=" + (builderThreadCount > 1) + ")");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_INIT_LOG, "RangerResourceTrie.init(resourceDef=" + resourceDef.getName() + ")");
        }
        TrieNode<RangerPolicyResourceEvaluator> ret = new TrieNode<RangerPolicyResourceEvaluator>(null);
        boolean isMultiThreaded = builderThreadCount > 1;
        int lastUsedThreadIndex = 0;
        if (isMultiThreaded) {
            builderThreads = new ArrayList<ResourceTrieBuilderThread>();
            for (int i = 0; i < builderThreadCount; ++i) {
                ResourceTrieBuilderThread t = new ResourceTrieBuilderThread(this.isOptimizedForRetrieval);
                t.setDaemon(true);
                builderThreads.add(t);
                t.start();
            }
            builderThreadMap = new HashMap<Character, Integer>();
        } else {
            builderThreads = null;
            builderThreadMap = null;
        }
        for (RangerPolicyResourceEvaluator evaluator : evaluators) {
            RangerPolicy.RangerPolicyResource policyResource;
            Map<String, RangerPolicy.RangerPolicyResource> policyResources = evaluator.getPolicyResource();
            RangerPolicy.RangerPolicyResource rangerPolicyResource = policyResource = policyResources != null ? policyResources.get(this.resourceName) : null;
            if (policyResource == null) {
                if (evaluator.getLeafResourceLevel() == null || resourceDef.getLevel() == null || evaluator.getLeafResourceLevel() >= resourceDef.getLevel()) continue;
                ret.addWildcardEvaluator(evaluator);
                continue;
            }
            if (policyResource.getIsExcludes().booleanValue()) {
                ret.addWildcardEvaluator(evaluator);
                continue;
            }
            RangerResourceMatcher resourceMatcher = evaluator.getResourceMatcher(this.resourceName);
            if (resourceMatcher != null && resourceMatcher.isMatchAny()) {
                ret.addWildcardEvaluator(evaluator);
                continue;
            }
            if (!CollectionUtils.isNotEmpty(policyResource.getValues())) continue;
            for (String resource : policyResource.getValues()) {
                if (!isMultiThreaded) {
                    this.insert(ret, resource, policyResource.getIsRecursive(), evaluator);
                    continue;
                }
                try {
                    lastUsedThreadIndex = this.insert(ret, resource, policyResource.getIsRecursive(), evaluator, builderThreadMap, builderThreads, lastUsedThreadIndex);
                }
                catch (InterruptedException ex) {
                    LOG.error("Failed to dispatch " + resource + " to " + builderThreads.get(lastUsedThreadIndex));
                    LOG.error("Failing and retrying with one thread");
                    ret = null;
                    break;
                }
            }
            if (ret != null) continue;
            break;
        }
        if (ret != null) {
            if (isMultiThreaded) {
                ret.setup(null, comparator);
                for (ResourceTrieBuilderThread t : builderThreads) {
                    t.setParentWildcardEvaluators(((TrieNode)ret).wildcardEvaluators);
                    try {
                        t.add("", false, null);
                        t.join();
                        ret.getChildren().putAll(t.getSubtrees());
                    }
                    catch (InterruptedException ex) {
                        LOG.error("BuilderThread " + t + " was interrupted:", ex);
                        LOG.error("Failing and retrying with one thread");
                        ret = null;
                        break;
                    }
                }
            } else if (this.isOptimizedForRetrieval) {
                RangerPerfTracer postSetupPerf = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_INIT_LOG)) {
                    postSetupPerf = RangerPerfTracer.getPerfTracer(PERF_TRIE_INIT_LOG, "RangerResourceTrie.init(name=" + resourceDef.getName() + "-postSetup)");
                }
                ret.postSetup(null, comparator);
                RangerPerfTracer.logAlways(postSetupPerf);
            } else {
                ret.setup(null, comparator);
            }
        }
        if (isMultiThreaded) {
            this.cleanUpThreads(builderThreads);
        }
        RangerPerfTracer.logAlways(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== buildTrie(" + resourceDef.getName() + ", evaluatorCount=" + evaluators.size() + ", isMultiThreaded=" + isMultiThreaded + ") :" + ret);
        }
        return ret;
    }

    private void cleanUpThreads(List<ResourceTrieBuilderThread> builderThreads) {
        if (CollectionUtils.isNotEmpty(builderThreads)) {
            for (ResourceTrieBuilderThread t : builderThreads) {
                try {
                    if (!t.isAlive()) continue;
                    t.interrupt();
                    t.join();
                }
                catch (InterruptedException ex) {
                    LOG.error("Could not terminate thread " + t);
                }
            }
        }
    }

    private TrieData getTrieData() {
        TrieData ret = new TrieData();
        this.root.populateTrieData(ret);
        ret.maxDepth = this.getMaxDepth();
        return ret;
    }

    private int getMaxDepth() {
        return this.root.getMaxDepth();
    }

    private Character getLookupChar(char ch) {
        return Character.valueOf(this.optIgnoreCase ? Character.toLowerCase(ch) : ch);
    }

    private Character getLookupChar(String str, int index) {
        return this.getLookupChar(str.charAt(index));
    }

    private int insert(TrieNode<T> currentRoot, String resource, boolean isRecursive, T evaluator, Map<Character, Integer> builderThreadMap, List<ResourceTrieBuilderThread> builderThreads, int lastUsedThreadIndex) throws InterruptedException {
        int ret = lastUsedThreadIndex;
        String prefix = this.getNonWildcardPrefix(resource);
        if (StringUtils.isNotEmpty(prefix)) {
            char c = this.getLookupChar(prefix.charAt(0)).charValue();
            Integer index = builderThreadMap.get(Character.valueOf(c));
            if (index == null) {
                index = (lastUsedThreadIndex + 1) % builderThreads.size();
                ret = index;
                builderThreadMap.put(Character.valueOf(c), index);
            }
            builderThreads.get(index).add(resource, isRecursive, evaluator);
        } else {
            currentRoot.addWildcardEvaluator(evaluator);
        }
        return ret;
    }

    private void insert(TrieNode<T> currentRoot, String resource, boolean isRecursive, T evaluator) {
        boolean isWildcard;
        TrieNode<T> curr = currentRoot;
        String prefix = this.getNonWildcardPrefix(resource);
        boolean bl = isWildcard = prefix.length() != resource.length();
        if (StringUtils.isNotEmpty(prefix)) {
            curr = curr.getOrCreateChild(prefix);
        }
        if (isWildcard || isRecursive) {
            curr.addWildcardEvaluator(evaluator);
        } else {
            curr.addEvaluator(evaluator);
        }
    }

    private String getNonWildcardPrefix(String str) {
        int minIndex = str.length();
        for (int i = 0; i < this.wildcardChars.length(); ++i) {
            int index = str.indexOf(this.wildcardChars.charAt(i));
            if (index == -1 || index >= minIndex) continue;
            minIndex = index;
        }
        return str.substring(0, minIndex);
    }

    private List<T> getEvaluatorsForResource(String resource) {
        int i;
        String childStr;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerResourceTrie.getEvaluatorsForResource(" + resource + ")");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_OP_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_OP_LOG, "RangerResourceTrie.getEvaluatorsForResource(resource=" + resource + ")");
        }
        TrieNode<T> curr = this.root;
        TrieNode<T> parent = null;
        int len = resource.length();
        for (i = 0; i < len; i += childStr.length()) {
            TrieNode<T> child;
            if (!this.isOptimizedForRetrieval) {
                curr.setupIfNeeded(parent, this.comparator);
            }
            if ((child = curr.getChild(this.getLookupChar(resource, i))) == null || !resource.regionMatches(this.optIgnoreCase, i, childStr = child.getStr(), 0, childStr.length())) break;
            parent = curr;
            curr = child;
        }
        if (!this.isOptimizedForRetrieval) {
            curr.setupIfNeeded(parent, this.comparator);
        }
        List<T> ret = i == len ? curr.getEvaluators() : curr.getWildcardEvaluators();
        RangerPerfTracer.logAlways(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerResourceTrie.getEvaluatorsForResource(" + resource + "): evaluatorCount=" + (ret == null ? 0 : ret.size()));
        }
        return ret;
    }

    private List<T> getEvaluatorsForResources(Collection<String> resources) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerResourceTrie.getEvaluatorsForResources(" + resources + ")");
        }
        List<Object> ret = null;
        HashMap<Long, RangerPolicyResourceEvaluator> evaluatorsMap = null;
        for (String resource : resources) {
            List<T> resourceEvaluators = this.getEvaluatorsForResource(resource);
            if (CollectionUtils.isEmpty(resourceEvaluators)) continue;
            if (evaluatorsMap == null) {
                if (ret == null) {
                    ret = resourceEvaluators;
                } else if (ret != resourceEvaluators) {
                    evaluatorsMap = new HashMap<Long, RangerPolicyResourceEvaluator>();
                    for (RangerPolicyResourceEvaluator rangerPolicyResourceEvaluator : ret) {
                        evaluatorsMap.put(rangerPolicyResourceEvaluator.getId(), rangerPolicyResourceEvaluator);
                    }
                    ret = null;
                }
            }
            if (evaluatorsMap == null) continue;
            for (RangerPolicyResourceEvaluator rangerPolicyResourceEvaluator : resourceEvaluators) {
                evaluatorsMap.put(rangerPolicyResourceEvaluator.getId(), rangerPolicyResourceEvaluator);
            }
        }
        if (ret == null && evaluatorsMap != null) {
            ret = new ArrayList(evaluatorsMap.values());
            if (this.comparator != null) {
                ret.sort(this.comparator);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerResourceTrie.getEvaluatorsForResources(" + resources + "): evaluatorCount=" + (ret == null ? 0 : ret.size()));
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        TrieData trieData = this.getTrieData();
        sb.append("resourceName=").append(this.resourceName);
        sb.append("; optIgnoreCase=").append(this.optIgnoreCase);
        sb.append("; optWildcard=").append(this.optWildcard);
        sb.append("; wildcardChars=").append(this.wildcardChars);
        sb.append("; nodeCount=").append(trieData.nodeCount);
        sb.append("; leafNodeCount=").append(trieData.leafNodeCount);
        sb.append("; singleChildNodeCount=").append(trieData.singleChildNodeCount);
        sb.append("; maxDepth=").append(trieData.maxDepth);
        sb.append("; evaluatorListCount=").append(trieData.evaluatorListCount);
        sb.append("; wildcardEvaluatorListCount=").append(trieData.wildcardEvaluatorListCount);
        sb.append("; evaluatorListRefCount=").append(trieData.evaluatorListRefCount);
        sb.append("; wildcardEvaluatorListRefCount=").append(trieData.wildcardEvaluatorListRefCount);
        return sb.toString();
    }

    class TrieNode<U extends RangerPolicyResourceEvaluator> {
        private String str;
        private final Map<Character, TrieNode<U>> children = new HashMap<Character, TrieNode<U>>();
        private List<U> evaluators;
        private List<U> wildcardEvaluators;
        private boolean isSharingParentWildcardEvaluators;
        private volatile boolean isSetup = false;

        TrieNode(String str) {
            this.str = str;
        }

        String getStr() {
            return this.str;
        }

        void setStr(String str) {
            this.str = str;
        }

        Map<Character, TrieNode<U>> getChildren() {
            return this.children;
        }

        List<U> getEvaluators() {
            return this.evaluators;
        }

        List<U> getWildcardEvaluators() {
            return this.wildcardEvaluators;
        }

        TrieNode<U> getChild(Character ch) {
            return this.children == null ? null : this.children.get(ch);
        }

        void populateTrieData(TrieData trieData) {
            ++trieData.nodeCount;
            if (this.wildcardEvaluators != null) {
                if (this.isSharingParentWildcardEvaluators) {
                    ++trieData.wildcardEvaluatorListRefCount;
                } else {
                    ++trieData.wildcardEvaluatorListCount;
                }
            }
            if (this.evaluators != null) {
                if (this.evaluators == this.wildcardEvaluators) {
                    ++trieData.evaluatorListRefCount;
                } else {
                    ++trieData.evaluatorListCount;
                }
            }
            if (this.children != null && !this.children.isEmpty()) {
                if (this.children.size() == 1) {
                    ++trieData.singleChildNodeCount;
                }
                for (Map.Entry<Character, TrieNode<U>> entry2 : this.children.entrySet()) {
                    TrieNode<U> child = entry2.getValue();
                    child.populateTrieData(trieData);
                }
            } else {
                ++trieData.leafNodeCount;
            }
        }

        int getMaxDepth() {
            int ret = 0;
            if (this.children != null) {
                for (Map.Entry<Character, TrieNode<U>> entry2 : this.children.entrySet()) {
                    TrieNode<U> child = entry2.getValue();
                    int maxChildDepth = child.getMaxDepth();
                    if (maxChildDepth <= ret) continue;
                    ret = maxChildDepth;
                }
            }
            return ret + 1;
        }

        TrieNode<U> getOrCreateChild(String str) {
            int len = str.length();
            TrieNode<U> child = this.children.get(RangerResourceTrie.this.getLookupChar(str, 0));
            if (child == null) {
                child = new TrieNode<U>(str);
                this.addChild(child);
            } else {
                boolean isExactMatch;
                String childStr = child.getStr();
                int childStrLen = childStr.length();
                boolean bl = isExactMatch = RangerResourceTrie.this.optIgnoreCase ? StringUtils.equalsIgnoreCase(childStr, str) : StringUtils.equals(childStr, str);
                if (!isExactMatch) {
                    int index;
                    int numOfCharactersToMatch = childStrLen < len ? childStrLen : len;
                    for (index = 1; index < numOfCharactersToMatch && RangerResourceTrie.this.getLookupChar(childStr, index) == RangerResourceTrie.this.getLookupChar(str, index); ++index) {
                    }
                    if (index == numOfCharactersToMatch) {
                        if (childStrLen > len) {
                            TrieNode<U> newChild = new TrieNode<U>(str);
                            this.addChild(newChild);
                            child.setStr(childStr.substring(index));
                            super.addChild(child);
                            child = newChild;
                        } else {
                            child = child.getOrCreateChild(str.substring(index));
                        }
                    } else {
                        String matchedPart = str.substring(0, index);
                        TrieNode<U> newChild = new TrieNode<U>(matchedPart);
                        this.addChild(newChild);
                        child.setStr(childStr.substring(index));
                        super.addChild(child);
                        child = newChild.getOrCreateChild(str.substring(index));
                    }
                }
            }
            return child;
        }

        private void addChild(TrieNode<U> child) {
            this.children.put(RangerResourceTrie.this.getLookupChar(child.getStr(), 0), child);
        }

        void addEvaluator(U evaluator) {
            if (this.evaluators == null) {
                this.evaluators = new ArrayList<U>();
            }
            if (!this.evaluators.contains(evaluator)) {
                this.evaluators.add(evaluator);
            }
        }

        void addWildcardEvaluator(U evaluator) {
            if (this.wildcardEvaluators == null) {
                this.wildcardEvaluators = new ArrayList<U>();
            }
            if (!this.wildcardEvaluators.contains(evaluator)) {
                this.wildcardEvaluators.add(evaluator);
            }
        }

        void postSetup(List<U> parentWildcardEvaluators, Comparator<U> comparator) {
            this.setup(parentWildcardEvaluators, comparator);
            if (this.children != null) {
                for (Map.Entry<Character, TrieNode<U>> entry2 : this.children.entrySet()) {
                    TrieNode<U> child = entry2.getValue();
                    child.postSetup(this.wildcardEvaluators, comparator);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setupIfNeeded(TrieNode<U> parent, Comparator<U> comparator) {
            boolean setupNeeded;
            if (parent == null) {
                return;
            }
            boolean bl = setupNeeded = !this.isSetup;
            if (setupNeeded) {
                TrieNode trieNode = this;
                synchronized (trieNode) {
                    boolean bl2 = setupNeeded = !this.isSetup;
                    if (setupNeeded) {
                        this.setup(parent.getWildcardEvaluators(), comparator);
                        this.isSetup = true;
                    }
                }
            }
        }

        void setup(List<U> parentWildcardEvaluators, Comparator<U> comparator) {
            if (parentWildcardEvaluators != null) {
                if (CollectionUtils.isEmpty(this.wildcardEvaluators)) {
                    this.wildcardEvaluators = parentWildcardEvaluators;
                } else {
                    for (RangerPolicyResourceEvaluator evaluator : parentWildcardEvaluators) {
                        this.addWildcardEvaluator(evaluator);
                    }
                }
            }
            boolean bl = this.isSharingParentWildcardEvaluators = this.wildcardEvaluators == parentWildcardEvaluators;
            if (this.wildcardEvaluators != null) {
                if (CollectionUtils.isEmpty(this.evaluators)) {
                    this.evaluators = this.wildcardEvaluators;
                } else {
                    for (RangerPolicyResourceEvaluator evaluator : this.wildcardEvaluators) {
                        this.addEvaluator(evaluator);
                    }
                }
            }
            if (comparator != null) {
                if (!this.isSharingParentWildcardEvaluators && CollectionUtils.isNotEmpty(this.wildcardEvaluators)) {
                    this.wildcardEvaluators.sort(comparator);
                }
                if (this.evaluators != this.wildcardEvaluators && CollectionUtils.isNotEmpty(this.evaluators)) {
                    this.evaluators.sort(comparator);
                }
            }
        }

        public void toString(String prefix, StringBuilder sb) {
            String nodeValue = prefix;
            if (this.str != null) {
                nodeValue = nodeValue + this.str;
            }
            sb.append("nodeValue=").append(nodeValue);
            sb.append("; childCount=").append(this.children == null ? 0 : this.children.size());
            sb.append("; evaluators=[ ");
            if (this.evaluators != null) {
                for (RangerPolicyResourceEvaluator rangerPolicyResourceEvaluator : this.evaluators) {
                    sb.append(rangerPolicyResourceEvaluator.getId()).append(" ");
                }
            }
            sb.append("]");
            sb.append("; wildcardEvaluators=[ ");
            if (this.wildcardEvaluators != null) {
                for (RangerPolicyResourceEvaluator rangerPolicyResourceEvaluator : this.wildcardEvaluators) {
                    sb.append(rangerPolicyResourceEvaluator.getId()).append(" ");
                }
            }
            sb.append("]\n");
            if (this.children != null) {
                for (Map.Entry entry2 : this.children.entrySet()) {
                    TrieNode child = (TrieNode)entry2.getValue();
                    child.toString(nodeValue, sb);
                }
            }
        }

        public void clear() {
            if (this.children != null) {
                this.children.clear();
            }
            this.evaluators = null;
            this.wildcardEvaluators = null;
        }
    }

    class TrieData {
        int nodeCount;
        int leafNodeCount;
        int singleChildNodeCount;
        int maxDepth;
        int evaluatorListCount;
        int wildcardEvaluatorListCount;
        int evaluatorListRefCount;
        int wildcardEvaluatorListRefCount;

        TrieData() {
        }
    }

    class ResourceTrieBuilderThread
    extends Thread {
        private final TrieNode<T> thisRoot;
        private final BlockingQueue<org.apache.ranger.plugin.util.RangerResourceTrie$ResourceTrieBuilderThread.WorkItem> workQueue;
        private final boolean isOptimizedForRetrieval;
        private List<T> parentWildcardEvaluators;

        ResourceTrieBuilderThread(boolean isOptimizedForRetrieval) {
            this.thisRoot = new TrieNode(null);
            this.workQueue = new LinkedBlockingQueue<org.apache.ranger.plugin.util.RangerResourceTrie$ResourceTrieBuilderThread.WorkItem>();
            this.isOptimizedForRetrieval = isOptimizedForRetrieval;
        }

        void add(String resourceName, boolean isRecursive, T evaluator) throws InterruptedException {
            this.workQueue.put((org.apache.ranger.plugin.util.RangerResourceTrie$ResourceTrieBuilderThread.WorkItem)new WorkItem(this, resourceName, isRecursive, evaluator));
        }

        void setParentWildcardEvaluators(List<T> parentWildcardEvaluators) {
            this.parentWildcardEvaluators = parentWildcardEvaluators;
        }

        Map<Character, TrieNode<T>> getSubtrees() {
            return this.thisRoot.getChildren();
        }

        @Override
        public void run() {
            block8: {
                WorkItem workItem;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Running " + this);
                }
                while (true) {
                    try {
                        workItem = (WorkItem)this.workQueue.take();
                    }
                    catch (InterruptedException exception) {
                        LOG.error("Thread=" + this + " is interrupted", exception);
                        break block8;
                    }
                    if (workItem.evaluator == null) break;
                    RangerResourceTrie.this.insert(this.thisRoot, workItem.resourceName, workItem.isRecursive, workItem.evaluator);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received termination signal. " + workItem);
                }
            }
            if (!this.isInterrupted() && this.isOptimizedForRetrieval) {
                RangerPerfTracer postSetupPerf = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_INIT_LOG)) {
                    postSetupPerf = RangerPerfTracer.getPerfTracer(PERF_TRIE_INIT_LOG, "RangerResourceTrie.init(thread=" + this.getName() + "-postSetup)");
                }
                this.thisRoot.postSetup(this.parentWildcardEvaluators, RangerResourceTrie.this.comparator);
                RangerPerfTracer.logAlways(postSetupPerf);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Exiting " + this);
            }
        }

        static class WorkItem {
            final String resourceName;
            final boolean isRecursive;
            final T evaluator;
            final /* synthetic */ ResourceTrieBuilderThread this$1;

            WorkItem(String resourceName, boolean isRecursive, T evaluator) {
                this.this$1 = this$1;
                this.resourceName = resourceName;
                this.isRecursive = isRecursive;
                this.evaluator = evaluator;
            }

            public String toString() {
                return "resourceName=" + this.resourceName + "isRecursive=" + this.isRecursive + "evaluator=" + (this.evaluator != null ? Long.valueOf(this.evaluator.getId()) : null);
            }
        }
    }
}

