/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;

public class ServiceDefUtil {
    public static boolean getOption_enableDenyAndExceptionsInPolicies(RangerServiceDef serviceDef) {
        boolean ret = false;
        if (serviceDef != null) {
            boolean enableDenyAndExceptionsInPoliciesHiddenOption = RangerConfiguration.getInstance().getBoolean("ranger.servicedef.enableDenyAndExceptionsInPolicies", true);
            boolean defaultValue = enableDenyAndExceptionsInPoliciesHiddenOption || StringUtils.equalsIgnoreCase(serviceDef.getName(), "tag");
            ret = ServiceDefUtil.getBooleanValue(serviceDef.getOptions(), "enableDenyAndExceptionsInPolicies", defaultValue);
        }
        return ret;
    }

    public static RangerServiceDef.RangerDataMaskTypeDef getDataMaskType(RangerServiceDef serviceDef, String typeName) {
        List<RangerServiceDef.RangerDataMaskTypeDef> maskTypes;
        RangerServiceDef.RangerDataMaskTypeDef ret = null;
        if (serviceDef != null && serviceDef.getDataMaskDef() != null && CollectionUtils.isNotEmpty(maskTypes = serviceDef.getDataMaskDef().getMaskTypes())) {
            for (RangerServiceDef.RangerDataMaskTypeDef maskType : maskTypes) {
                if (!StringUtils.equals(maskType.getName(), typeName)) continue;
                ret = maskType;
                break;
            }
        }
        return ret;
    }

    public static RangerServiceDef normalize(RangerServiceDef serviceDef) {
        ServiceDefUtil.normalizeDataMaskDef(serviceDef);
        ServiceDefUtil.normalizeRowFilterDef(serviceDef);
        return serviceDef;
    }

    public static RangerServiceDef.RangerResourceDef getResourceDef(RangerServiceDef serviceDef, String resource) {
        RangerServiceDef.RangerResourceDef ret = null;
        if (serviceDef != null && resource != null && CollectionUtils.isNotEmpty(serviceDef.getResources())) {
            for (RangerServiceDef.RangerResourceDef resourceDef : serviceDef.getResources()) {
                if (!StringUtils.equalsIgnoreCase(resourceDef.getName(), resource)) continue;
                ret = resourceDef;
                break;
            }
        }
        return ret;
    }

    public static Integer getLeafResourceLevel(RangerServiceDef serviceDef, Map<String, RangerPolicy.RangerPolicyResource> policyResource) {
        Integer ret = null;
        RangerServiceDef.RangerResourceDef resourceDef = ServiceDefUtil.getLeafResourceDef(serviceDef, policyResource);
        if (resourceDef != null) {
            ret = resourceDef.getLevel();
        }
        return ret;
    }

    public static RangerServiceDef.RangerResourceDef getLeafResourceDef(RangerServiceDef serviceDef, Map<String, RangerPolicy.RangerPolicyResource> policyResource) {
        RangerServiceDef.RangerResourceDef ret = null;
        if (serviceDef != null && policyResource != null) {
            for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry2 : policyResource.entrySet()) {
                String resource;
                RangerServiceDef.RangerResourceDef resourceDef;
                if (ServiceDefUtil.isEmpty(entry2.getValue()) || (resourceDef = ServiceDefUtil.getResourceDef(serviceDef, resource = entry2.getKey())) == null || resourceDef.getLevel() == null) continue;
                if (ret == null) {
                    ret = resourceDef;
                    continue;
                }
                if (ret.getLevel() >= resourceDef.getLevel()) continue;
                ret = resourceDef;
            }
        }
        return ret;
    }

    public static boolean isEmpty(RangerPolicy.RangerPolicyResource policyResource) {
        List<String> resourceValues;
        boolean ret = true;
        if (policyResource != null && CollectionUtils.isNotEmpty(resourceValues = policyResource.getValues())) {
            for (String resourceValue : resourceValues) {
                if (!StringUtils.isNotBlank(resourceValue)) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    public static String getOption(Map<String, String> options, String name, String defaultValue) {
        String ret;
        String string2 = ret = options != null && name != null ? options.get(name) : null;
        if (ret == null) {
            ret = defaultValue;
        }
        return ret;
    }

    public static boolean getBooleanOption(Map<String, String> options, String name, boolean defaultValue) {
        String val = ServiceDefUtil.getOption(options, name, null);
        return val == null ? defaultValue : Boolean.parseBoolean(val);
    }

    public static char getCharOption(Map<String, String> options, String name, char defaultValue) {
        String val = ServiceDefUtil.getOption(options, name, null);
        return StringUtils.isEmpty(val) ? defaultValue : val.charAt(0);
    }

    private static void normalizeDataMaskDef(RangerServiceDef serviceDef) {
        if (serviceDef != null && serviceDef.getDataMaskDef() != null) {
            Serializable processedDef;
            ArrayList<RangerServiceDef.RangerResourceDef> processedDefs;
            List<RangerServiceDef.RangerResourceDef> dataMaskResources = serviceDef.getDataMaskDef().getResources();
            List<RangerServiceDef.RangerAccessTypeDef> dataMaskAccessTypes = serviceDef.getDataMaskDef().getAccessTypes();
            if (CollectionUtils.isNotEmpty(dataMaskResources)) {
                List<RangerServiceDef.RangerResourceDef> resources = serviceDef.getResources();
                processedDefs = new ArrayList<RangerServiceDef.RangerResourceDef>(dataMaskResources.size());
                Iterator<Serializable> iterator2 = dataMaskResources.iterator();
                while (iterator2.hasNext()) {
                    RangerServiceDef.RangerResourceDef dataMaskResource;
                    processedDef = dataMaskResource = (RangerServiceDef.RangerResourceDef)iterator2.next();
                    for (RangerServiceDef.RangerResourceDef resourceDef : resources) {
                        if (!StringUtils.equals(resourceDef.getName(), dataMaskResource.getName())) continue;
                        processedDef = ServiceDefUtil.mergeResourceDef(resourceDef, dataMaskResource);
                        break;
                    }
                    processedDefs.add((RangerServiceDef.RangerResourceDef)processedDef);
                }
                serviceDef.getDataMaskDef().setResources(processedDefs);
            }
            if (CollectionUtils.isNotEmpty(dataMaskAccessTypes)) {
                List<RangerServiceDef.RangerAccessTypeDef> accessTypes = serviceDef.getAccessTypes();
                processedDefs = new ArrayList(accessTypes.size());
                for (RangerServiceDef.RangerAccessTypeDef dataMaskAccessType : dataMaskAccessTypes) {
                    processedDef = dataMaskAccessType;
                    for (RangerServiceDef.RangerAccessTypeDef accessType : accessTypes) {
                        if (!StringUtils.equals(accessType.getName(), dataMaskAccessType.getName())) continue;
                        processedDef = ServiceDefUtil.mergeAccessTypeDef(accessType, dataMaskAccessType);
                        break;
                    }
                    processedDefs.add((RangerServiceDef.RangerResourceDef)processedDef);
                }
                serviceDef.getDataMaskDef().setAccessTypes(processedDefs);
            }
        }
    }

    private static void normalizeRowFilterDef(RangerServiceDef serviceDef) {
        if (serviceDef != null && serviceDef.getRowFilterDef() != null) {
            Serializable processedDef;
            ArrayList<RangerServiceDef.RangerResourceDef> processedDefs;
            List<RangerServiceDef.RangerResourceDef> rowFilterResources = serviceDef.getRowFilterDef().getResources();
            List<RangerServiceDef.RangerAccessTypeDef> rowFilterAccessTypes = serviceDef.getRowFilterDef().getAccessTypes();
            if (CollectionUtils.isNotEmpty(rowFilterResources)) {
                List<RangerServiceDef.RangerResourceDef> resources = serviceDef.getResources();
                processedDefs = new ArrayList<RangerServiceDef.RangerResourceDef>(rowFilterResources.size());
                Iterator<Serializable> iterator2 = rowFilterResources.iterator();
                while (iterator2.hasNext()) {
                    RangerServiceDef.RangerResourceDef rowFilterResource;
                    processedDef = rowFilterResource = (RangerServiceDef.RangerResourceDef)iterator2.next();
                    for (RangerServiceDef.RangerResourceDef resourceDef : resources) {
                        if (!StringUtils.equals(resourceDef.getName(), rowFilterResource.getName())) continue;
                        processedDef = ServiceDefUtil.mergeResourceDef(resourceDef, rowFilterResource);
                        break;
                    }
                    processedDefs.add((RangerServiceDef.RangerResourceDef)processedDef);
                }
                serviceDef.getRowFilterDef().setResources(processedDefs);
            }
            if (CollectionUtils.isNotEmpty(rowFilterAccessTypes)) {
                List<RangerServiceDef.RangerAccessTypeDef> accessTypes = serviceDef.getAccessTypes();
                processedDefs = new ArrayList(accessTypes.size());
                for (RangerServiceDef.RangerAccessTypeDef rowFilterAccessType : rowFilterAccessTypes) {
                    processedDef = rowFilterAccessType;
                    for (RangerServiceDef.RangerAccessTypeDef accessType : accessTypes) {
                        if (!StringUtils.equals(accessType.getName(), rowFilterAccessType.getName())) continue;
                        processedDef = ServiceDefUtil.mergeAccessTypeDef(accessType, rowFilterAccessType);
                        break;
                    }
                    processedDefs.add((RangerServiceDef.RangerResourceDef)processedDef);
                }
                serviceDef.getRowFilterDef().setAccessTypes(processedDefs);
            }
        }
    }

    private static RangerServiceDef.RangerResourceDef mergeResourceDef(RangerServiceDef.RangerResourceDef base, RangerServiceDef.RangerResourceDef delta) {
        RangerServiceDef.RangerResourceDef ret = new RangerServiceDef.RangerResourceDef(base);
        if (delta.getRecursiveSupported() != null) {
            ret.setRecursiveSupported(delta.getRecursiveSupported());
        }
        if (delta.getExcludesSupported() != null) {
            ret.setExcludesSupported(delta.getExcludesSupported());
        }
        if (StringUtils.isNotEmpty(delta.getMatcher())) {
            ret.setMatcher(delta.getMatcher());
        }
        if (MapUtils.isNotEmpty(delta.getMatcherOptions())) {
            if (ret.getMatcherOptions() == null) {
                ret.setMatcherOptions(new HashMap<String, String>());
            }
            for (Map.Entry<String, String> e : delta.getMatcherOptions().entrySet()) {
                ret.getMatcherOptions().put(e.getKey(), e.getValue());
            }
        }
        if (StringUtils.isNotEmpty(delta.getValidationRegEx())) {
            ret.setValidationRegEx(delta.getValidationRegEx());
        }
        if (StringUtils.isNotEmpty(delta.getValidationMessage())) {
            ret.setValidationMessage(delta.getValidationMessage());
        }
        if (StringUtils.isNotEmpty(delta.getUiHint())) {
            ret.setUiHint(delta.getUiHint());
        }
        if (StringUtils.isNotEmpty(delta.getLabel())) {
            ret.setLabel(delta.getLabel());
        }
        if (StringUtils.isNotEmpty(delta.getDescription())) {
            ret.setDescription(delta.getDescription());
        }
        if (StringUtils.isNotEmpty(delta.getRbKeyLabel())) {
            ret.setRbKeyLabel(delta.getRbKeyLabel());
        }
        if (StringUtils.isNotEmpty(delta.getRbKeyDescription())) {
            ret.setRbKeyDescription(delta.getRbKeyDescription());
        }
        if (StringUtils.isNotEmpty(delta.getRbKeyValidationMessage())) {
            ret.setRbKeyValidationMessage(delta.getRbKeyValidationMessage());
        }
        if (CollectionUtils.isNotEmpty(delta.getAccessTypeRestrictions())) {
            ret.setAccessTypeRestrictions(delta.getAccessTypeRestrictions());
        }
        if (delta.getIsValidLeaf() != null) {
            ret.setIsValidLeaf(delta.getIsValidLeaf());
        }
        return ret;
    }

    private static RangerServiceDef.RangerAccessTypeDef mergeAccessTypeDef(RangerServiceDef.RangerAccessTypeDef base, RangerServiceDef.RangerAccessTypeDef delta) {
        RangerServiceDef.RangerAccessTypeDef ret = new RangerServiceDef.RangerAccessTypeDef(base);
        if (StringUtils.isNotEmpty(delta.getLabel())) {
            ret.setLabel(delta.getLabel());
        }
        if (StringUtils.isNotEmpty(delta.getRbKeyLabel())) {
            ret.setRbKeyLabel(delta.getRbKeyLabel());
        }
        return ret;
    }

    private static boolean getBooleanValue(Map<String, String> map2, String elementName, boolean defaultValue) {
        String elementValue;
        boolean ret = defaultValue;
        if (MapUtils.isNotEmpty(map2) && map2.containsKey(elementName) && StringUtils.isNotEmpty(elementValue = map2.get(elementName))) {
            ret = Boolean.valueOf(elementValue.toString());
        }
        return ret;
    }
}

