/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.stream.JSONTupleStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class SolrStream
extends TupleStream {
    private static final long serialVersionUID = 1L;
    private String baseUrl;
    private Map params;
    private int numWorkers;
    private int workerID;
    private boolean trace;
    private Map<String, String> fieldMappings;
    private transient JSONTupleStream jsonTupleStream;
    private transient HttpSolrClient client;
    private transient SolrClientCache cache;

    public SolrStream(String baseUrl, Map params) {
        this.baseUrl = baseUrl;
        this.params = params;
    }

    public void setFieldMappings(Map<String, String> fieldMappings) {
        this.fieldMappings = fieldMappings;
    }

    @Override
    public List<TupleStream> children() {
        return new ArrayList<TupleStream>();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.numWorkers = context.numWorkers;
        this.workerID = context.workerID;
        this.cache = context.getSolrClientCache();
    }

    @Override
    public void open() throws IOException {
        this.client = this.cache == null ? new HttpSolrClient(this.baseUrl) : this.cache.getHttpSolrClient(this.baseUrl);
        try {
            this.jsonTupleStream = JSONTupleStream.create(this.client, this.loadParams(this.params));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    private SolrParams loadParams(Map params) throws IOException {
        ModifiableSolrParams solrParams = new ModifiableSolrParams();
        if (params.containsKey("partitionKeys")) {
            if (!params.get("partitionKeys").equals("none")) {
                String partitionFilter = this.getPartitionFilter();
                solrParams.add("fq", partitionFilter);
            }
        } else if (this.numWorkers > 1) {
            throw new IOException("When numWorkers > 1 partitionKeys must be set. Set partitionKeys=none to send the entire stream to each worker.");
        }
        for (Map.Entry entry2 : params.entrySet()) {
            solrParams.add((String)entry2.getKey(), entry2.getValue().toString());
        }
        return solrParams;
    }

    private String getPartitionFilter() {
        StringBuilder buf = new StringBuilder("{!hash workers=");
        buf.append(this.numWorkers);
        buf.append(" worker=");
        buf.append(this.workerID);
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void close() throws IOException {
        this.jsonTupleStream.close();
        if (this.cache == null) {
            this.client.close();
        }
    }

    @Override
    public Tuple read() throws IOException {
        Map fields = this.jsonTupleStream.next();
        if (this.trace) {
            fields.put((String)"_CORE_", (Object)this.baseUrl);
        }
        if (fields == null) {
            HashMap<String, Boolean> m3 = new HashMap<String, Boolean>();
            m3.put("EOF", true);
            return new Tuple(m3);
        }
        if (this.fieldMappings != null) {
            fields = this.mapFields(fields, this.fieldMappings);
        }
        return new Tuple(fields);
    }

    private Map mapFields(Map fields, Map<String, String> mappings) {
        for (Map.Entry<String, String> entry2 : mappings.entrySet()) {
            String mapFrom = entry2.getKey();
            String mapTo2 = entry2.getValue();
            Object o = fields.get(mapFrom);
            fields.remove(mapFrom);
            fields.put(mapTo2, o);
        }
        return fields;
    }
}

