/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream.expr;

import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParser;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;

public class StreamExpressionNamedParameter
implements StreamExpressionParameter {
    private String name;
    private StreamExpressionParameter parameter;

    public StreamExpressionNamedParameter(String name) {
        this.name = name;
    }

    public StreamExpressionNamedParameter(String name, String parameter) {
        this.name = name;
        this.setParameter(parameter);
    }

    public StreamExpressionNamedParameter(String name, StreamExpressionParameter parameter) {
        this.name = name;
        this.setParameter(parameter);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (null == name || 0 == name.length()) {
            throw new IllegalArgumentException("Null or empty name is not allowed is not allowed.");
        }
        this.name = name;
    }

    public StreamExpressionParameter getParameter() {
        return this.parameter;
    }

    public void setParameter(StreamExpressionParameter parameter) {
        this.parameter = parameter;
    }

    public StreamExpressionNamedParameter withParameter(StreamExpressionParameter parameter) {
        this.setParameter(parameter);
        return this;
    }

    public void setParameter(String parameter) {
        this.parameter = new StreamExpressionValue(parameter);
    }

    public StreamExpressionNamedParameter withParameter(String parameter) {
        this.setParameter(parameter);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("=");
        boolean requiresQuote = false;
        if (this.parameter instanceof StreamExpressionValue) {
            String value2 = ((StreamExpressionValue)this.parameter).getValue();
            boolean bl = requiresQuote = !StreamExpressionParser.wordToken(value2);
        }
        if (requiresQuote) {
            sb.append("\"");
        }
        sb.append(this.parameter.toString());
        if (requiresQuote) {
            sb.append("\"");
        }
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other.getClass() != StreamExpressionNamedParameter.class) {
            return false;
        }
        StreamExpressionNamedParameter check2 = (StreamExpressionNamedParameter)other;
        if (null == this.name && null != check2.name) {
            return false;
        }
        if (null != this.name && null == check2.name) {
            return false;
        }
        if (null != this.name && null != check2.name && !this.name.equals(check2.name)) {
            return false;
        }
        return this.parameter.equals(check2.parameter);
    }
}

