/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.XML;

public class UpdateRequest
extends AbstractUpdateRequest {
    public static final String REPFACT = "rf";
    public static final String MIN_REPFACT = "min_rf";
    public static final String VER = "ver";
    public static final String ROUTE = "_route_";
    public static final String OVERWRITE = "ow";
    public static final String COMMIT_WITHIN = "cw";
    private Map<SolrInputDocument, Map<String, Object>> documents = null;
    private Iterator<SolrInputDocument> docIterator = null;
    private Map<String, Map<String, Object>> deleteById = null;
    private List<String> deleteQuery = null;
    private boolean isLastDocInBatch = false;

    public UpdateRequest() {
        super(SolrRequest.METHOD.POST, "/update");
    }

    public UpdateRequest(String url) {
        super(SolrRequest.METHOD.POST, url);
    }

    public void clear() {
        if (this.documents != null) {
            this.documents.clear();
        }
        if (this.deleteById != null) {
            this.deleteById.clear();
        }
        if (this.deleteQuery != null) {
            this.deleteQuery.clear();
        }
    }

    public UpdateRequest add(SolrInputDocument doc) {
        Objects.requireNonNull(doc, "Cannot add a null SolrInputDocument");
        if (this.documents == null) {
            this.documents = new LinkedHashMap<SolrInputDocument, Map<String, Object>>();
        }
        this.documents.put(doc, null);
        return this;
    }

    public UpdateRequest add(SolrInputDocument doc, Boolean overwrite) {
        return this.add(doc, null, overwrite);
    }

    public UpdateRequest add(SolrInputDocument doc, Integer commitWithin) {
        return this.add(doc, commitWithin, null);
    }

    public UpdateRequest add(SolrInputDocument doc, Integer commitWithin, Boolean overwrite) {
        Objects.requireNonNull(doc, "Cannot add a null SolrInputDocument");
        if (this.documents == null) {
            this.documents = new LinkedHashMap<SolrInputDocument, Map<String, Object>>();
        }
        HashMap<String, Constable> params = new HashMap<String, Constable>(2);
        if (commitWithin != null) {
            params.put(COMMIT_WITHIN, commitWithin);
        }
        if (overwrite != null) {
            params.put(OVERWRITE, overwrite);
        }
        this.documents.put(doc, params);
        return this;
    }

    public UpdateRequest add(Collection<SolrInputDocument> docs) {
        if (this.documents == null) {
            this.documents = new LinkedHashMap<SolrInputDocument, Map<String, Object>>();
        }
        for (SolrInputDocument doc : docs) {
            Objects.requireNonNull(doc, "Cannot add a null SolrInputDocument");
            this.documents.put(doc, null);
        }
        return this;
    }

    public UpdateRequest deleteById(String id) {
        if (this.deleteById == null) {
            this.deleteById = new LinkedHashMap<String, Map<String, Object>>();
        }
        this.deleteById.put(id, null);
        return this;
    }

    public UpdateRequest deleteById(String id, String route) {
        return this.deleteById(id, route, null);
    }

    public UpdateRequest deleteById(String id, String route, Long version) {
        HashMap<String, Object> params;
        if (this.deleteById == null) {
            this.deleteById = new LinkedHashMap<String, Map<String, Object>>();
        }
        HashMap<String, Object> hashMap = params = route == null && version == null ? null : new HashMap<String, Object>(1);
        if (version != null) {
            params.put(VER, version);
        }
        if (route != null) {
            params.put(ROUTE, route);
        }
        this.deleteById.put(id, params);
        return this;
    }

    public UpdateRequest deleteById(List<String> ids) {
        if (this.deleteById == null) {
            this.deleteById = new LinkedHashMap<String, Map<String, Object>>();
        }
        for (String id : ids) {
            this.deleteById.put(id, null);
        }
        return this;
    }

    public UpdateRequest deleteById(String id, Long version) {
        return this.deleteById(id, null, version);
    }

    public UpdateRequest deleteByQuery(String q) {
        if (this.deleteQuery == null) {
            this.deleteQuery = new ArrayList<String>();
        }
        this.deleteQuery.add(q);
        return this;
    }

    public Map<String, LBHttpSolrClient.Req> getRoutes(DocRouter router, DocCollection col, Map<String, List<String>> urlMap, ModifiableSolrParams params, String idField) {
        UpdateRequest urequest;
        LBHttpSolrClient.Req request;
        String leaderUrl;
        List<String> urls;
        if (!(this.documents != null && this.documents.size() != 0 || this.deleteById != null && this.deleteById.size() != 0)) {
            return null;
        }
        HashMap<String, LBHttpSolrClient.Req> routes = new HashMap<String, LBHttpSolrClient.Req>();
        if (this.documents != null) {
            Set<Map.Entry<SolrInputDocument, Map<String, Object>>> entries = this.documents.entrySet();
            Iterator<Map.Entry<SolrInputDocument, Map<String, Object>>> iterator2 = entries.iterator();
            while (iterator2.hasNext()) {
                Map.Entry<SolrInputDocument, Map<String, Object>> entry2 = iterator2.next();
                SolrInputDocument doc = entry2.getKey();
                Object id = doc.getFieldValue(idField);
                if (id == null) {
                    return null;
                }
                Slice slice2 = router.getTargetSlice(id.toString(), doc, null, null, col);
                if (slice2 == null) {
                    return null;
                }
                urls = urlMap.get(slice2.getName());
                leaderUrl = urls.get(0);
                request = (LBHttpSolrClient.Req)routes.get(leaderUrl);
                if (request == null) {
                    UpdateRequest updateRequest = new UpdateRequest();
                    updateRequest.setMethod(this.getMethod());
                    updateRequest.setCommitWithin(this.getCommitWithin());
                    updateRequest.setParams(params);
                    updateRequest.setPath(this.getPath());
                    updateRequest.setBasicAuthCredentials(this.getBasicAuthUser(), this.getBasicAuthPassword());
                    request = new LBHttpSolrClient.Req(updateRequest, urls);
                    routes.put(leaderUrl, request);
                }
                urequest = (UpdateRequest)request.getRequest();
                Map<String, Object> value2 = entry2.getValue();
                Boolean ow = null;
                if (value2 != null) {
                    ow = (Boolean)value2.get(OVERWRITE);
                }
                if (ow != null) {
                    urequest.add(doc, ow);
                    continue;
                }
                urequest.add(doc);
            }
        }
        if (this.deleteById != null) {
            for (Map.Entry entry2 : this.deleteById.entrySet()) {
                Slice slice2;
                String deleteId = (String)entry2.getKey();
                Map map2 = (Map)entry2.getValue();
                Long version = null;
                if (map2 != null) {
                    version = (Long)map2.get(VER);
                }
                if ((slice2 = router.getTargetSlice(deleteId, null, null, null, col)) == null) {
                    return null;
                }
                urls = urlMap.get(slice2.getName());
                leaderUrl = urls.get(0);
                request = (LBHttpSolrClient.Req)routes.get(leaderUrl);
                if (request != null) {
                    urequest = (UpdateRequest)request.getRequest();
                    urequest.deleteById(deleteId, version);
                    continue;
                }
                urequest = new UpdateRequest();
                urequest.setParams(params);
                urequest.deleteById(deleteId, version);
                urequest.setCommitWithin(this.getCommitWithin());
                request = new LBHttpSolrClient.Req(urequest, urls);
                routes.put(leaderUrl, request);
            }
        }
        return routes;
    }

    public void setDocIterator(Iterator<SolrInputDocument> docIterator) {
        this.docIterator = docIterator;
    }

    public void setDeleteQuery(List<String> deleteQuery) {
        this.deleteQuery = deleteQuery;
    }

    @Override
    public Collection<ContentStream> getContentStreams() throws IOException {
        return ClientUtils.toContentStreams(this.getXML(), "application/xml; charset=UTF-8");
    }

    public String getXML() throws IOException {
        StringWriter writer = new StringWriter();
        this.writeXML(writer);
        writer.flush();
        String xml = writer.toString();
        return xml.length() > 0 ? xml : null;
    }

    private List<Map<SolrInputDocument, Map<String, Object>>> getDocLists(Map<SolrInputDocument, Map<String, Object>> documents) {
        ArrayList<Map<SolrInputDocument, Map<String, Object>>> docLists = new ArrayList<Map<SolrInputDocument, Map<String, Object>>>();
        LinkedHashMap<SolrInputDocument, Map<String, Object>> docList = null;
        if (this.documents != null) {
            Boolean lastOverwrite = true;
            Integer lastCommitWithin = -1;
            Set<Map.Entry<SolrInputDocument, Map<String, Object>>> entries = this.documents.entrySet();
            for (Map.Entry<SolrInputDocument, Map<String, Object>> entry2 : entries) {
                Map<String, Object> map2 = entry2.getValue();
                Boolean overwrite = null;
                Integer commitWithin = null;
                if (map2 != null) {
                    overwrite = (Boolean)entry2.getValue().get(OVERWRITE);
                    commitWithin = (Integer)entry2.getValue().get(COMMIT_WITHIN);
                }
                if (overwrite != lastOverwrite || commitWithin != lastCommitWithin || docLists.size() == 0) {
                    docList = new LinkedHashMap();
                    docLists.add(docList);
                }
                docList.put(entry2.getKey(), entry2.getValue());
                lastCommitWithin = commitWithin;
                lastOverwrite = overwrite;
            }
        }
        if (this.docIterator != null) {
            docList = new LinkedHashMap<SolrInputDocument, Map<String, Object>>();
            docLists.add(docList);
            while (this.docIterator.hasNext()) {
                SolrInputDocument doc = this.docIterator.next();
                if (doc == null) continue;
                docList.put(doc, null);
            }
        }
        return docLists;
    }

    public void writeXML(Writer writer) throws IOException {
        boolean deleteQ;
        List<Map<SolrInputDocument, Map<String, Object>>> getDocLists = this.getDocLists(this.documents);
        for (Map<SolrInputDocument, Map<String, Object>> docs : getDocLists) {
            if (docs == null || docs.size() <= 0) continue;
            Map.Entry<SolrInputDocument, Map<String, Object>> firstDoc = docs.entrySet().iterator().next();
            Map<String, Object> map2 = firstDoc.getValue();
            Integer cw = null;
            Boolean ow = null;
            if (map2 != null) {
                cw = (Integer)firstDoc.getValue().get(COMMIT_WITHIN);
                ow = (Boolean)firstDoc.getValue().get(OVERWRITE);
            }
            if (ow == null) {
                ow = true;
            }
            int commitWithin = cw != null && cw != -1 ? cw : this.commitWithin;
            boolean overwrite = ow;
            if (commitWithin > -1 || !overwrite) {
                writer.write("<add commitWithin=\"" + commitWithin + "\" " + "overwrite=\"" + overwrite + "\">");
            } else {
                writer.write("<add>");
            }
            Set<Map.Entry<SolrInputDocument, Map<String, Object>>> entries = docs.entrySet();
            for (Map.Entry<SolrInputDocument, Map<String, Object>> entry2 : entries) {
                ClientUtils.writeXML(entry2.getKey(), writer);
            }
            writer.write("</add>");
        }
        boolean deleteI = this.deleteById != null && this.deleteById.size() > 0;
        boolean bl = deleteQ = this.deleteQuery != null && this.deleteQuery.size() > 0;
        if (deleteI || deleteQ) {
            if (this.commitWithin > 0) {
                writer.append("<delete commitWithin=\"" + this.commitWithin + "\">");
            } else {
                writer.append("<delete>");
            }
            if (deleteI) {
                for (Map.Entry entry2 : this.deleteById.entrySet()) {
                    writer.append("<id");
                    Map map3 = (Map)entry2.getValue();
                    if (map3 != null) {
                        Long version = (Long)map3.get(VER);
                        String route = (String)map3.get(ROUTE);
                        if (version != null) {
                            writer.append(" version=\"" + version + "\"");
                        }
                        if (route != null) {
                            writer.append(" _route_=\"" + route + "\"");
                        }
                    }
                    writer.append(">");
                    XML.escapeCharData((String)entry2.getKey(), writer);
                    writer.append("</id>");
                }
            }
            if (deleteQ) {
                for (String string2 : this.deleteQuery) {
                    writer.append("<query>");
                    XML.escapeCharData(string2, writer);
                    writer.append("</query>");
                }
            }
            writer.append("</delete>");
        }
    }

    public List<SolrInputDocument> getDocuments() {
        if (this.documents == null) {
            return null;
        }
        ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>(this.documents.size());
        docs.addAll(this.documents.keySet());
        return docs;
    }

    public Map<SolrInputDocument, Map<String, Object>> getDocumentsMap() {
        return this.documents;
    }

    public Iterator<SolrInputDocument> getDocIterator() {
        return this.docIterator;
    }

    public List<String> getDeleteById() {
        if (this.deleteById == null) {
            return null;
        }
        ArrayList<String> deletes = new ArrayList<String>(this.deleteById.keySet());
        return deletes;
    }

    public Map<String, Map<String, Object>> getDeleteByIdMap() {
        return this.deleteById;
    }

    public List<String> getDeleteQuery() {
        return this.deleteQuery;
    }

    public boolean isLastDocInBatch() {
        return this.isLastDocInBatch;
    }

    public void lastDocInBatch() {
        this.isLastDocInBatch = true;
    }
}

