/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.response;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.util.NamedList;

public class FieldStatsInfo
implements Serializable {
    final String name;
    Object min;
    Object max;
    Object sum;
    Long count;
    Long countDistinct;
    Collection<Object> distinctValues;
    Long missing;
    Object mean = null;
    Double sumOfSquares = null;
    Double stddev = null;
    Long cardinality = null;
    Map<String, List<FieldStatsInfo>> facets;
    Map<Double, Double> percentiles;

    public FieldStatsInfo(NamedList<Object> nl, String fname) {
        this.name = fname;
        for (Map.Entry<String, Object> entry2 : nl) {
            NamedList fields;
            if ("min".equals(entry2.getKey())) {
                this.min = entry2.getValue();
                continue;
            }
            if ("max".equals(entry2.getKey())) {
                this.max = entry2.getValue();
                continue;
            }
            if ("sum".equals(entry2.getKey())) {
                this.sum = entry2.getValue();
                continue;
            }
            if ("count".equals(entry2.getKey())) {
                this.count = (Long)entry2.getValue();
                continue;
            }
            if ("countDistinct".equals(entry2.getKey())) {
                this.countDistinct = (Long)entry2.getValue();
                continue;
            }
            if ("distinctValues".equals(entry2.getKey())) {
                this.distinctValues = (Collection)entry2.getValue();
                continue;
            }
            if ("missing".equals(entry2.getKey())) {
                this.missing = (Long)entry2.getValue();
                continue;
            }
            if ("mean".equals(entry2.getKey())) {
                this.mean = entry2.getValue();
                continue;
            }
            if ("sumOfSquares".equals(entry2.getKey())) {
                this.sumOfSquares = (Double)entry2.getValue();
                continue;
            }
            if ("stddev".equals(entry2.getKey())) {
                this.stddev = (Double)entry2.getValue();
                continue;
            }
            if ("facets".equals(entry2.getKey())) {
                fields = (NamedList)entry2.getValue();
                this.facets = new HashMap<String, List<FieldStatsInfo>>();
                for (Map.Entry ev : fields) {
                    ArrayList<FieldStatsInfo> vals = new ArrayList<FieldStatsInfo>();
                    this.facets.put(ev.getKey(), vals);
                    NamedList vnl = (NamedList)ev.getValue();
                    for (int i = 0; i < vnl.size(); ++i) {
                        String n = vnl.getName(i);
                        vals.add(new FieldStatsInfo((NamedList)vnl.getVal(i), n));
                    }
                }
                continue;
            }
            if ("percentiles".equals(entry2.getKey())) {
                fields = (NamedList)entry2.getValue();
                this.percentiles = new LinkedHashMap<Double, Double>();
                for (Map.Entry ev : fields) {
                    this.percentiles.put(Double.parseDouble(ev.getKey()), (Double)ev.getValue());
                }
                continue;
            }
            if ("cardinality".equals(entry2.getKey())) {
                this.cardinality = (Long)entry2.getValue();
                continue;
            }
            throw new RuntimeException("unknown key: " + entry2.getKey() + " [" + entry2.getValue() + "]");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append(": {");
        if (this.min != null) {
            sb.append(" min:").append(this.min);
        }
        if (this.max != null) {
            sb.append(" max:").append(this.max);
        }
        if (this.sum != null) {
            sb.append(" sum:").append(this.sum);
        }
        if (this.count != null) {
            sb.append(" count:").append(this.count);
        }
        if (this.countDistinct != null) {
            sb.append(" countDistinct:").append(this.countDistinct);
        }
        if (this.distinctValues != null) {
            sb.append(" distinctValues:").append(this.distinctValues);
        }
        if (this.missing != null) {
            sb.append(" missing:").append(this.missing);
        }
        if (this.mean != null) {
            sb.append(" mean:").append(this.mean);
        }
        if (this.stddev != null) {
            sb.append(" stddev:").append(this.stddev);
        }
        if (this.percentiles != null) {
            sb.append(" percentiles:").append(this.percentiles);
        }
        if (this.cardinality != null) {
            sb.append(" cardinality:").append(this.cardinality);
        }
        sb.append(" }");
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public Object getMin() {
        return this.min;
    }

    public Object getMax() {
        return this.max;
    }

    public Object getSum() {
        return this.sum;
    }

    public Long getCount() {
        return this.count;
    }

    public Long getCountDistinct() {
        return this.countDistinct;
    }

    public Collection<Object> getDistinctValues() {
        return this.distinctValues;
    }

    public Long getMissing() {
        return this.missing;
    }

    public Object getMean() {
        return this.mean;
    }

    public Double getStddev() {
        return this.stddev;
    }

    public Double getSumOfSquares() {
        return this.sumOfSquares;
    }

    public Map<String, List<FieldStatsInfo>> getFacets() {
        return this.facets;
    }

    public Map<Double, Double> getPercentiles() {
        return this.percentiles;
    }

    public Long getCardinality() {
        return this.cardinality;
    }
}

