/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.response;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.response.FieldStatsInfo;
import org.apache.solr.client.solrj.response.RangeFacet;

public class PivotField
implements Serializable {
    final String _field;
    final Object _value;
    final int _count;
    final List<PivotField> _pivot;
    final Map<String, FieldStatsInfo> _statsInfo;
    final Map<String, Integer> _querycounts;
    final List<RangeFacet> _ranges;

    @Deprecated
    public PivotField(String f, Object v, int count2, List<PivotField> pivot) {
        this(f, v, count2, pivot, null, null, null);
    }

    public PivotField(String f, Object v, int count2, List<PivotField> pivot, Map<String, FieldStatsInfo> statsInfo, Map<String, Integer> queryCounts, List<RangeFacet> ranges) {
        this._field = f;
        this._value = v;
        this._count = count2;
        this._pivot = pivot;
        this._statsInfo = statsInfo;
        this._querycounts = queryCounts;
        this._ranges = ranges;
    }

    public String getField() {
        return this._field;
    }

    public Object getValue() {
        return this._value;
    }

    public int getCount() {
        return this._count;
    }

    public List<PivotField> getPivot() {
        return this._pivot;
    }

    public Map<String, FieldStatsInfo> getFieldStatsInfo() {
        return this._statsInfo;
    }

    public Map<String, Integer> getFacetQuery() {
        return this._querycounts;
    }

    public List<RangeFacet> getFacetRanges() {
        return this._ranges;
    }

    public String toString() {
        return this._field + ":" + this._value + " [" + this._count + "] " + this._pivot;
    }

    public void write(PrintStream out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print("  ");
        }
        out.print(this._field + "=" + this._value + " (" + this._count + ")");
        if (null != this._statsInfo) {
            out.print("->stats:[");
            for (FieldStatsInfo fieldStatsInfo : this._statsInfo.values()) {
                out.print(fieldStatsInfo.toString());
                out.print(",");
            }
            out.print("]");
        }
        out.println();
        if (this._querycounts != null) {
            out.println(this._querycounts.toString());
        }
        if (this._ranges != null) {
            out.println(this._ranges.toString());
        }
        if (this._pivot != null) {
            for (PivotField p : this._pivot) {
                p.write(out, indent + 1);
            }
        }
    }
}

