/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.cloud.DefaultZkCredentialsProvider;
import org.apache.solr.common.cloud.ZkCredentialsProvider;

public class VMParamsSingleSetCredentialsDigestZkCredentialsProvider
extends DefaultZkCredentialsProvider {
    public static final String DEFAULT_DIGEST_USERNAME_VM_PARAM_NAME = "zkDigestUsername";
    public static final String DEFAULT_DIGEST_PASSWORD_VM_PARAM_NAME = "zkDigestPassword";
    final String zkDigestUsernameVMParamName;
    final String zkDigestPasswordVMParamName;

    public VMParamsSingleSetCredentialsDigestZkCredentialsProvider() {
        this(DEFAULT_DIGEST_USERNAME_VM_PARAM_NAME, DEFAULT_DIGEST_PASSWORD_VM_PARAM_NAME);
    }

    public VMParamsSingleSetCredentialsDigestZkCredentialsProvider(String zkDigestUsernameVMParamName, String zkDigestPasswordVMParamName) {
        this.zkDigestUsernameVMParamName = zkDigestUsernameVMParamName;
        this.zkDigestPasswordVMParamName = zkDigestPasswordVMParamName;
    }

    @Override
    protected Collection<ZkCredentialsProvider.ZkCredentials> createCredentials() {
        ArrayList<ZkCredentialsProvider.ZkCredentials> result2 = new ArrayList<ZkCredentialsProvider.ZkCredentials>();
        String digestUsername = System.getProperty(this.zkDigestUsernameVMParamName);
        String digestPassword = System.getProperty(this.zkDigestPasswordVMParamName);
        if (!StringUtils.isEmpty(digestUsername) && !StringUtils.isEmpty(digestPassword)) {
            try {
                result2.add(new ZkCredentialsProvider.ZkCredentials("digest", (digestUsername + ":" + digestPassword).getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return result2;
    }
}

