/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.params;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.AppendedSolrParams;
import org.apache.solr.common.params.DefaultSolrParams;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;

public abstract class SolrParams
implements Serializable {
    public abstract String get(String var1);

    public abstract String[] getParams(String var1);

    public abstract Iterator<String> getParameterNamesIterator();

    public String get(String param2, String def) {
        String val = this.get(param2);
        return val == null ? def : val;
    }

    public RequiredSolrParams required() {
        return new RequiredSolrParams(this);
    }

    protected String fpname(String field2, String param2) {
        return "f." + field2 + '.' + param2;
    }

    public String getFieldParam(String field2, String param2) {
        String val = this.get(this.fpname(field2, param2));
        return val != null ? val : this.get(param2);
    }

    public String getFieldParam(String field2, String param2, String def) {
        String val = this.get(this.fpname(field2, param2));
        return val != null ? val : this.get(param2, def);
    }

    public String[] getFieldParams(String field2, String param2) {
        String[] val = this.getParams(this.fpname(field2, param2));
        return val != null ? val : this.getParams(param2);
    }

    public Boolean getBool(String param2) {
        String val = this.get(param2);
        return val == null ? null : Boolean.valueOf(StrUtils.parseBool(val));
    }

    public boolean getBool(String param2, boolean def) {
        String val = this.get(param2);
        return val == null ? def : StrUtils.parseBool(val);
    }

    public Boolean getFieldBool(String field2, String param2) {
        String val = this.getFieldParam(field2, param2);
        return val == null ? null : Boolean.valueOf(StrUtils.parseBool(val));
    }

    public boolean getFieldBool(String field2, String param2, boolean def) {
        String val = this.getFieldParam(field2, param2);
        return val == null ? def : StrUtils.parseBool(val);
    }

    public Integer getInt(String param2) {
        String val = this.get(param2);
        try {
            return val == null ? null : Integer.valueOf(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public Long getLong(String param2, Long def) {
        String val = this.get(param2);
        try {
            return val == null ? def : Long.parseLong(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public int getInt(String param2, int def) {
        String val = this.get(param2);
        try {
            return val == null ? def : Integer.parseInt(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public Long getLong(String param2) {
        String val = this.get(param2);
        try {
            return val == null ? null : Long.valueOf(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public long getLong(String param2, long def) {
        String val = this.get(param2);
        try {
            return val == null ? def : Long.parseLong(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public Integer getFieldInt(String field2, String param2) {
        String val = this.getFieldParam(field2, param2);
        try {
            return val == null ? null : Integer.valueOf(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public int getFieldInt(String field2, String param2, int def) {
        String val = this.getFieldParam(field2, param2);
        try {
            return val == null ? def : Integer.parseInt(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public Float getFloat(String param2) {
        String val = this.get(param2);
        try {
            return val == null ? null : Float.valueOf(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public float getFloat(String param2, float def) {
        String val = this.get(param2);
        try {
            return val == null ? def : Float.parseFloat(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public Double getDouble(String param2) {
        String val = this.get(param2);
        try {
            return val == null ? null : Double.valueOf(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public double getDouble(String param2, double def) {
        String val = this.get(param2);
        try {
            return val == null ? def : Double.parseDouble(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public Float getFieldFloat(String field2, String param2) {
        String val = this.getFieldParam(field2, param2);
        try {
            return val == null ? null : Float.valueOf(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public float getFieldFloat(String field2, String param2, float def) {
        String val = this.getFieldParam(field2, param2);
        try {
            return val == null ? def : Float.parseFloat(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public Double getFieldDouble(String field2, String param2) {
        String val = this.getFieldParam(field2, param2);
        try {
            return val == null ? null : Double.valueOf(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public double getFieldDouble(String field2, String param2, double def) {
        String val = this.getFieldParam(field2, param2);
        try {
            return val == null ? def : Double.parseDouble(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public static SolrParams wrapDefaults(SolrParams params, SolrParams defaults) {
        if (params == null) {
            return defaults;
        }
        if (defaults == null) {
            return params;
        }
        return new DefaultSolrParams(params, defaults);
    }

    public static SolrParams wrapAppended(SolrParams params, SolrParams defaults) {
        if (params == null) {
            return defaults;
        }
        if (defaults == null) {
            return params;
        }
        return AppendedSolrParams.wrapAppended(params, defaults);
    }

    public static Map<String, String> toMap(NamedList params) {
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (int i = 0; i < params.size(); ++i) {
            map2.put(params.getName(i), params.getVal(i).toString());
        }
        return map2;
    }

    public static Map<String, String[]> toMultiMap(NamedList params) {
        HashMap<String, String[]> map2 = new HashMap<String, String[]>();
        for (int i = 0; i < params.size(); ++i) {
            String name = params.getName(i);
            Object val = params.getVal(i);
            if (val instanceof String[]) {
                MultiMapSolrParams.addParam(name, (String[])val, map2);
                continue;
            }
            if (val instanceof List) {
                List l = (List)val;
                String[] s2 = new String[l.size()];
                for (int j = 0; j < l.size(); ++j) {
                    s2[j] = l.get(j) == null ? null : String.valueOf(l.get(j));
                }
                MultiMapSolrParams.addParam(name, s2, map2);
                continue;
            }
            MultiMapSolrParams.addParam(name, val.toString(), map2);
        }
        return map2;
    }

    public static SolrParams toSolrParams(NamedList params) {
        return new MultiMapSolrParams(SolrParams.toMultiMap(params));
    }

    public SolrParams toFilteredSolrParams(List<String> names) {
        NamedList<String> nl = new NamedList<String>();
        Iterator<String> it = this.getParameterNamesIterator();
        while (it.hasNext()) {
            String[] values;
            String name = it.next();
            if (!names.contains(name)) continue;
            for (String value2 : values = this.getParams(name)) {
                nl.add(name, value2);
            }
        }
        return SolrParams.toSolrParams(nl);
    }

    public NamedList<Object> toNamedList() {
        SimpleOrderedMap<Object> result2 = new SimpleOrderedMap<Object>();
        Iterator<String> it = this.getParameterNamesIterator();
        while (it.hasNext()) {
            String name = it.next();
            String[] values = this.getParams(name);
            if (values.length == 1) {
                result2.add(name, values[0]);
                continue;
            }
            result2.add(name, values);
        }
        return result2;
    }

    public Map<String, Object> getAll(Map<String, Object> sink, String ... params) {
        if (sink == null) {
            sink = new LinkedHashMap<String, Object>();
        }
        for (String param2 : params) {
            String[] v = this.getParams(param2);
            if (v == null || v.length <= 0) continue;
            if (v.length == 1) {
                sink.put(param2, v[0]);
                continue;
            }
            sink.put(param2, v);
        }
        return sink;
    }

    public String toQueryString() {
        try {
            String charset = StandardCharsets.UTF_8.name();
            StringBuilder sb = new StringBuilder(128);
            boolean first = true;
            Iterator<String> it = this.getParameterNamesIterator();
            while (it.hasNext()) {
                String name = it.next();
                String nameEnc = URLEncoder.encode(name, charset);
                for (String val : this.getParams(name)) {
                    sb.append(first ? (char)'?' : '&').append(nameEnc).append('=').append(URLEncoder.encode(val, charset));
                    first = false;
                }
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        try {
            boolean first = true;
            Iterator<String> it = this.getParameterNamesIterator();
            while (it.hasNext()) {
                String name = it.next();
                for (String val : this.getParams(name)) {
                    if (!first) {
                        sb.append('&');
                    }
                    first = false;
                    StrUtils.partialURLEncodeVal(sb, name);
                    sb.append('=');
                    StrUtils.partialURLEncodeVal(sb, val);
                }
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

