/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

public class Hash {
    public static int lookup3(int[] k, int offset2, int length, int initval) {
        int c;
        int b = c = -559038737 + (length << 2) + initval;
        int a = c;
        int i = offset2;
        while (length > 3) {
            a += k[i];
            a -= (c += k[i + 2]);
            a ^= c << 4 | c >>> -4;
            b -= a;
            b ^= a << 6 | a >>> -6;
            a += (c += (b += k[i + 1]));
            c -= b;
            c ^= b << 8 | b >>> -8;
            b += a;
            a -= c;
            a ^= c << 16 | c >>> -16;
            c += b;
            b -= a;
            b ^= a << 19 | a >>> -19;
            a += c;
            c -= b;
            c ^= b << 4 | b >>> -4;
            b += a;
            length -= 3;
            i += 3;
        }
        switch (length) {
            case 3: {
                c += k[i + 2];
            }
            case 2: {
                b += k[i + 1];
            }
            case 1: {
                a += k[i + 0];
                c ^= b;
                a ^= (c -= b << 14 | b >>> -14);
                b ^= (a -= c << 11 | c >>> -11);
                c ^= (b -= a << 25 | a >>> -25);
                a ^= (c -= b << 16 | b >>> -16);
                b ^= (a -= c << 4 | c >>> -4);
                c ^= (b -= a << 14 | a >>> -14);
                c -= b << 24 | b >>> -24;
            }
        }
        return c;
    }

    public static int lookup3ycs(int[] k, int offset2, int length, int initval) {
        return Hash.lookup3(k, offset2, length, initval - (length << 2));
    }

    public static int lookup3ycs(CharSequence s2, int start, int end, int initval) {
        int c;
        int b = c = -559038737 + initval;
        int a = c;
        int i = start;
        boolean mixed = true;
        while (i < end) {
            int ch;
            mixed = false;
            a += Character.isHighSurrogate((char)(ch = s2.charAt(i++))) && i < end ? Character.toCodePoint((char)ch, s2.charAt(i++)) : ch;
            if (i >= end) break;
            b += Character.isHighSurrogate((char)(ch = (int)s2.charAt(i++))) && i < end ? Character.toCodePoint((char)ch, s2.charAt(i++)) : ch;
            if (i >= end) break;
            c += Character.isHighSurrogate((char)(ch = (int)s2.charAt(i++))) && i < end ? Character.toCodePoint((char)ch, s2.charAt(i++)) : ch;
            if (i >= end) break;
            a -= c;
            a ^= c << 4 | c >>> -4;
            c += b;
            b -= a;
            b ^= a << 6 | a >>> -6;
            a += c;
            c -= b;
            c ^= b << 8 | b >>> -8;
            b += a;
            a -= c;
            a ^= c << 16 | c >>> -16;
            c += b;
            b -= a;
            b ^= a << 19 | a >>> -19;
            a += c;
            c -= b;
            c ^= b << 4 | b >>> -4;
            b += a;
            mixed = true;
        }
        if (!mixed) {
            c ^= b;
            a ^= (c -= b << 14 | b >>> -14);
            b ^= (a -= c << 11 | c >>> -11);
            c ^= (b -= a << 25 | a >>> -25);
            a ^= (c -= b << 16 | b >>> -16);
            b ^= (a -= c << 4 | c >>> -4);
            c ^= (b -= a << 14 | a >>> -14);
            c -= b << 24 | b >>> -24;
        }
        return c;
    }

    public static long lookup3ycs64(CharSequence s2, int start, int end, long initval) {
        int c;
        int b = c = -559038737 + (int)initval;
        int a = c;
        c += (int)(initval >>> 32);
        int i = start;
        boolean mixed = true;
        while (i < end) {
            int ch;
            mixed = false;
            a += Character.isHighSurrogate((char)(ch = s2.charAt(i++))) && i < end ? Character.toCodePoint((char)ch, s2.charAt(i++)) : ch;
            if (i >= end) break;
            b += Character.isHighSurrogate((char)(ch = (int)s2.charAt(i++))) && i < end ? Character.toCodePoint((char)ch, s2.charAt(i++)) : ch;
            if (i >= end) break;
            c += Character.isHighSurrogate((char)(ch = (int)s2.charAt(i++))) && i < end ? Character.toCodePoint((char)ch, s2.charAt(i++)) : ch;
            if (i >= end) break;
            a -= c;
            a ^= c << 4 | c >>> -4;
            c += b;
            b -= a;
            b ^= a << 6 | a >>> -6;
            a += c;
            c -= b;
            c ^= b << 8 | b >>> -8;
            b += a;
            a -= c;
            a ^= c << 16 | c >>> -16;
            c += b;
            b -= a;
            b ^= a << 19 | a >>> -19;
            a += c;
            c -= b;
            c ^= b << 4 | b >>> -4;
            b += a;
            mixed = true;
        }
        if (!mixed) {
            c ^= b;
            a ^= (c -= b << 14 | b >>> -14);
            b ^= (a -= c << 11 | c >>> -11);
            c ^= (b -= a << 25 | a >>> -25);
            a ^= (c -= b << 16 | b >>> -16);
            b ^= (a -= c << 4 | c >>> -4);
            c ^= (b -= a << 14 | a >>> -14);
            c -= b << 24 | b >>> -24;
        }
        return (long)c + ((long)b << 32);
    }

    public static int murmurhash3_x86_32(byte[] data, int offset2, int len, int seed) {
        int c1 = -862048943;
        int c2 = 461845907;
        int h1 = seed;
        int roundedEnd = offset2 + (len & 0xFFFFFFFC);
        for (int i = offset2; i < roundedEnd; i += 4) {
            int k1 = data[i] & 0xFF | (data[i + 1] & 0xFF) << 8 | (data[i + 2] & 0xFF) << 16 | data[i + 3] << 24;
            k1 *= -862048943;
            k1 = k1 << 15 | k1 >>> 17;
            h1 ^= (k1 *= 461845907);
            h1 = h1 << 13 | h1 >>> 19;
            h1 = h1 * 5 + -430675100;
        }
        int k1 = 0;
        switch (len & 3) {
            case 3: {
                k1 = (data[roundedEnd + 2] & 0xFF) << 16;
            }
            case 2: {
                k1 |= (data[roundedEnd + 1] & 0xFF) << 8;
            }
            case 1: {
                k1 |= data[roundedEnd] & 0xFF;
                k1 *= -862048943;
                k1 = k1 << 15 | k1 >>> 17;
                h1 ^= (k1 *= 461845907);
            }
        }
        h1 ^= len;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }

    public static int murmurhash3_x86_32(CharSequence data, int offset2, int len, int seed) {
        int c1 = -862048943;
        int c2 = 461845907;
        int h1 = seed;
        int pos = offset2;
        int end = offset2 + len;
        int k1 = 0;
        int k2 = 0;
        int shift = 0;
        int bits2 = 0;
        int nBytes = 0;
        while (pos < end) {
            int code;
            if ((code = data.charAt(pos++)) < 128) {
                k2 = code;
                bits2 = 8;
            } else if (code < 2048) {
                k2 = 0xC0 | code >> 6 | (0x80 | code & 0x3F) << 8;
                bits2 = 16;
            } else if (code < 55296 || code > 57343 || pos >= end) {
                k2 = 0xE0 | code >> 12 | (0x80 | code >> 6 & 0x3F) << 8 | (0x80 | code & 0x3F) << 16;
                bits2 = 24;
            } else {
                int utf32 = data.charAt(pos++);
                utf32 = (code - 55232 << 10) + (utf32 & 0x3FF);
                k2 = 0xFF & (0xF0 | utf32 >> 18) | (0x80 | utf32 >> 12 & 0x3F) << 8 | (0x80 | utf32 >> 6 & 0x3F) << 16 | (0x80 | utf32 & 0x3F) << 24;
                bits2 = 32;
            }
            k1 |= k2 << shift;
            if ((shift += bits2) < 32) continue;
            k1 *= -862048943;
            k1 = k1 << 15 | k1 >>> 17;
            h1 ^= (k1 *= 461845907);
            h1 = h1 << 13 | h1 >>> 19;
            h1 = h1 * 5 + -430675100;
            k1 = (shift -= 32) != 0 ? k2 >>> bits2 - shift : 0;
            nBytes += 4;
        }
        if (shift > 0) {
            nBytes += shift >> 3;
            k1 *= -862048943;
            k1 = k1 << 15 | k1 >>> 17;
            h1 ^= (k1 *= 461845907);
        }
        h1 ^= nBytes;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }

    public static final int fmix32(int h2) {
        h2 ^= h2 >>> 16;
        h2 *= -2048144789;
        h2 ^= h2 >>> 13;
        h2 *= -1028477387;
        h2 ^= h2 >>> 16;
        return h2;
    }

    public static final long fmix64(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    public static final long getLongLittleEndian(byte[] buf, int offset2) {
        return (long)buf[offset2 + 7] << 56 | ((long)buf[offset2 + 6] & 0xFFL) << 48 | ((long)buf[offset2 + 5] & 0xFFL) << 40 | ((long)buf[offset2 + 4] & 0xFFL) << 32 | ((long)buf[offset2 + 3] & 0xFFL) << 24 | ((long)buf[offset2 + 2] & 0xFFL) << 16 | ((long)buf[offset2 + 1] & 0xFFL) << 8 | (long)buf[offset2] & 0xFFL;
    }

    public static void murmurhash3_x64_128(byte[] key, int offset2, int len, int seed, LongPair out) {
        long h1 = (long)seed & 0xFFFFFFFFL;
        long h2 = (long)seed & 0xFFFFFFFFL;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        int roundedEnd = offset2 + (len & 0xFFFFFFF0);
        for (int i = offset2; i < roundedEnd; i += 16) {
            long k1 = Hash.getLongLittleEndian(key, i);
            long k2 = Hash.getLongLittleEndian(key, i + 8);
            k1 *= -8663945395140668459L;
            k1 = Long.rotateLeft(k1, 31);
            h1 ^= (k1 *= 5545529020109919103L);
            h1 = Long.rotateLeft(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            k2 *= 5545529020109919103L;
            k2 = Long.rotateLeft(k2, 33);
            h2 ^= (k2 *= -8663945395140668459L);
            h2 = Long.rotateLeft(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        long k1 = 0L;
        long k2 = 0L;
        switch (len & 0xF) {
            case 15: {
                k2 = ((long)key[roundedEnd + 14] & 0xFFL) << 48;
            }
            case 14: {
                k2 |= ((long)key[roundedEnd + 13] & 0xFFL) << 40;
            }
            case 13: {
                k2 |= ((long)key[roundedEnd + 12] & 0xFFL) << 32;
            }
            case 12: {
                k2 |= ((long)key[roundedEnd + 11] & 0xFFL) << 24;
            }
            case 11: {
                k2 |= ((long)key[roundedEnd + 10] & 0xFFL) << 16;
            }
            case 10: {
                k2 |= ((long)key[roundedEnd + 9] & 0xFFL) << 8;
            }
            case 9: {
                k2 |= (long)key[roundedEnd + 8] & 0xFFL;
                k2 *= 5545529020109919103L;
                k2 = Long.rotateLeft(k2, 33);
                h2 ^= (k2 *= -8663945395140668459L);
            }
            case 8: {
                k1 = (long)key[roundedEnd + 7] << 56;
            }
            case 7: {
                k1 |= ((long)key[roundedEnd + 6] & 0xFFL) << 48;
            }
            case 6: {
                k1 |= ((long)key[roundedEnd + 5] & 0xFFL) << 40;
            }
            case 5: {
                k1 |= ((long)key[roundedEnd + 4] & 0xFFL) << 32;
            }
            case 4: {
                k1 |= ((long)key[roundedEnd + 3] & 0xFFL) << 24;
            }
            case 3: {
                k1 |= ((long)key[roundedEnd + 2] & 0xFFL) << 16;
            }
            case 2: {
                k1 |= ((long)key[roundedEnd + 1] & 0xFFL) << 8;
            }
            case 1: {
                k1 |= (long)key[roundedEnd] & 0xFFL;
                k1 *= -8663945395140668459L;
                k1 = Long.rotateLeft(k1, 31);
                h1 ^= (k1 *= 5545529020109919103L);
            }
        }
        h1 ^= (long)len;
        h1 += (h2 ^= (long)len);
        h2 += h1;
        h1 = Hash.fmix64(h1);
        h2 = Hash.fmix64(h2);
        h1 += h2;
        out.val1 = h1;
        out.val2 = h2 += h1;
    }

    public static final class LongPair {
        public long val1;
        public long val2;
    }
}

