/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.interactions;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.EISMappedRecord;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public abstract class EISInteraction
extends DatasourceCall {
    protected InteractionSpec interactionSpec;
    protected String functionName = "";
    protected String inputRecordName = "";
    protected Map properties;
    protected AbstractRecord inputRow;
    protected Vector arguments;
    protected Vector outputArgumentNames;
    protected Vector outputArguments;
    protected String outputResultPath = "";

    public void addOutputArgument(String parameterAndArgumentFieldName) {
        this.addOutputArgument(parameterAndArgumentFieldName, parameterAndArgumentFieldName);
    }

    public void addOutputArgument(String parameterName, String argumentFieldName) {
        this.getOutputArgumentNames().addElement(parameterName);
        this.getOutputArguments().addElement(new DatabaseField(argumentFieldName));
    }

    public Vector getArguments() {
        if (this.arguments == null) {
            this.arguments = new Vector();
        }
        return this.arguments;
    }

    public void setArguments(Vector arguments) {
        this.arguments = arguments;
    }

    public boolean hasArguments() {
        return this.arguments != null && !this.arguments.isEmpty();
    }

    @Override
    public boolean isEISInteraction() {
        return true;
    }

    public String getOutputResultPath() {
        return this.outputResultPath;
    }

    public void setOutputResultPath(String outputResultPath) {
        this.outputResultPath = outputResultPath;
    }

    public Vector getOutputArgumentNames() {
        if (this.outputArgumentNames == null) {
            this.outputArgumentNames = new Vector();
        }
        return this.outputArgumentNames;
    }

    public Vector getOutputArguments() {
        if (this.outputArguments == null) {
            this.outputArguments = new Vector();
        }
        return this.outputArguments;
    }

    public void setOutputArguments(Vector outputArguments) {
        this.outputArguments = outputArguments;
    }

    public void setOutputArgumentNames(Vector outputArgumentNames) {
        this.outputArgumentNames = outputArgumentNames;
    }

    public boolean hasOutputArguments() {
        return this.outputArguments != null && !this.outputArguments.isEmpty();
    }

    @Override
    public void prepare(AbstractSession session) {
        if (this.getInputRecordName().length() == 0) {
            if (this.getQuery() != null && this.getQuery().getDescriptor() instanceof EISDescriptor) {
                EISDescriptor descriptor = (EISDescriptor)this.getQuery().getDescriptor();
                this.setInputRecordName(descriptor.getDataTypeName());
            } else {
                this.setInputRecordName("input");
            }
        }
        super.prepare(session);
    }

    public Object createRecordElement(String elementName, Object value2, EISAccessor accessor) {
        try {
            MappedRecord element = value2;
            if (element instanceof List) {
                List values = (List)element;
                MappedRecord elements = new Vector(values.size());
                int index = 0;
                while (index < values.size()) {
                    elements.add(this.createRecordElement(elementName, values.get(index), accessor));
                    ++index;
                }
                element = elements;
            } else if (value2 instanceof AbstractRecord) {
                AbstractRecord valuesRow = (AbstractRecord)value2;
                String recordName = elementName;
                if (valuesRow.size() > 0) {
                    recordName = valuesRow.getFields().get(0).getTableName();
                }
                MappedRecord record2 = accessor.getRecordFactory().createMappedRecord(recordName);
                for (DatabaseField field2 : valuesRow.getFields()) {
                    Object elementValue = this.createRecordElement(field2.getName(), valuesRow.get(field2), accessor);
                    accessor.getEISPlatform().setValueInRecord(field2.getName(), elementValue, record2, accessor);
                }
                element = record2;
            }
            return element;
        }
        catch (ResourceException exception) {
            throw EISException.resourceException(exception, accessor, null);
        }
    }

    public InteractionSpec getInteractionSpec() {
        return this.interactionSpec;
    }

    public void setInteractionSpec(InteractionSpec interactionSpec) {
        this.interactionSpec = interactionSpec;
    }

    @Override
    public String getLogString(Accessor accessor) {
        StringWriter writer = new StringWriter();
        writer.write("Executing ");
        writer.write(this.toString());
        writer.write(Helper.cr());
        writer.write("\tspec => ");
        writer.write(String.valueOf(this.getInteractionSpec()));
        writer.write(Helper.cr());
        writer.write("\tproperties => ");
        writer.write(String.valueOf(this.getProperties()));
        writer.write(Helper.cr());
        writer.write("\tinput => [");
        if (!this.getParameters().isEmpty()) {
            Iterator iterator2 = this.getParameters().iterator();
            while (iterator2.hasNext()) {
                Object parameter = iterator2.next();
                writer.write(String.valueOf(parameter));
                if (iterator2.hasNext()) {
                    writer.write(", ");
                    continue;
                }
                writer.write("]");
            }
        } else {
            writer.write(String.valueOf(this.getInputRow()));
            writer.write("]");
        }
        return writer.toString();
    }

    @Override
    public void translate(AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
        if (modifyRow != null) {
            this.setInputRow(modifyRow);
        }
        if (this.hasArguments()) {
            ArrayList<Object> parametersValues = new ArrayList<Object>(this.getArguments().size());
            int index = 0;
            while (index < this.getArguments().size()) {
                Object argument = this.getArguments().elementAt(index);
                if (argument != null && argument instanceof DatabaseField) {
                    DatabaseField field2 = (DatabaseField)argument;
                    Object value2 = translationRow.get(field2);
                    if (value2 == null && modifyRow != null) {
                        value2 = modifyRow.get(field2);
                    }
                    parametersValues.add(value2);
                } else {
                    parametersValues.add(argument);
                }
                ++index;
            }
            this.setParameters(parametersValues);
        }
    }

    public abstract Record createInputRecord(EISAccessor var1);

    public abstract AbstractRecord buildRow(Record var1, EISAccessor var2);

    public Vector buildRows(Record record2, EISAccessor accessor) {
        Vector<AbstractRecord> rows = null;
        if (record2 instanceof IndexedRecord) {
            IndexedRecord indexedRecord = (IndexedRecord)record2;
            rows = new Vector(indexedRecord.size());
            int index = 0;
            while (index < indexedRecord.size()) {
                Object element = indexedRecord.get(index);
                if (!(element instanceof Record)) {
                    rows.add(this.buildRow(record2, accessor));
                    return rows;
                }
                rows.addElement(this.buildRow((Record)element, accessor));
                ++index;
            }
        } else if (record2 instanceof MappedRecord) {
            MappedRecord mappedRecord = (MappedRecord)record2;
            if (this.getOutputResultPath().length() > 0) {
                Object element = mappedRecord.get((Object)this.getOutputResultPath());
                if (element instanceof IndexedRecord) {
                    return this.buildRows((Record)((IndexedRecord)element), accessor);
                }
                if (element instanceof MappedRecord) {
                    mappedRecord = (MappedRecord)element;
                } else if (element instanceof List) {
                    List elements = (List)element;
                    rows = new Vector(elements.size());
                    int index = 0;
                    while (index < elements.size()) {
                        Object elementValue = elements.get(index);
                        if (elementValue instanceof Record) {
                            rows.addElement(this.buildRow((Record)elementValue, accessor));
                        } else {
                            rows.add((AbstractRecord)elementValue);
                        }
                        ++index;
                    }
                    return rows;
                }
            }
            rows = new Vector(1);
            EISMappedRecord row = new EISMappedRecord((Map)mappedRecord, accessor);
            rows.add(row);
        } else {
            rows = new Vector<AbstractRecord>(1);
        }
        return rows;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getInputRecordName() {
        return this.inputRecordName;
    }

    public void setInputRecordName(String recordName) {
        this.inputRecordName = recordName;
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap(5);
        }
        return this.properties;
    }

    public Object getProperty(String name) {
        Object value2 = this.getProperties().get(name);
        if (value2 == null && this.getQuery() != null && this.getQuery().getDescriptor() != null) {
            value2 = this.getQuery().getDescriptor().getProperty(name);
        }
        return value2;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public void setProperty(String name, Object value2) {
        this.getProperties().put(name, value2);
    }

    public AbstractRecord getInputRow() {
        return this.inputRow;
    }

    public void setInputRow(AbstractRecord inputRow) {
        this.inputRow = inputRow;
    }

    public String toString() {
        return String.valueOf(Helper.getShortClassName(this.getClass())) + "(" + this.getFunctionName() + ")";
    }
}

