/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.interactions;

import java.io.StringWriter;
import java.util.Iterator;
import org.eclipse.persistence.eis.interactions.MappedInteraction;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.QueryStringCall;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class QueryStringInteraction
extends MappedInteraction
implements QueryStringCall {
    protected String queryString;

    public QueryStringInteraction() {
        this.queryString = "";
    }

    public QueryStringInteraction(String queryString) {
        this.queryString = queryString;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    @Override
    public void translate(AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
        this.translateQueryString(translationRow, modifyRow, session);
    }

    @Override
    public void prepare(AbstractSession session) {
        if (this.isPrepared()) {
            return;
        }
        this.translateCustomQuery();
        this.setIsPrepared(true);
    }

    @Override
    public String getLogString(Accessor accessor) {
        StringWriter writer = new StringWriter();
        writer.write("Executing ");
        writer.write(this.toString());
        writer.write(Helper.cr());
        writer.write("\tspec => ");
        writer.write(String.valueOf(this.getInteractionSpec()));
        writer.write(Helper.cr());
        writer.write("\tquery => ");
        writer.write(this.getQueryString());
        writer.write(Helper.cr());
        writer.write("\tparameters => [");
        if (this.hasParameters()) {
            Iterator iterator2 = this.getParameters().iterator();
            while (iterator2.hasNext()) {
                Object parameter = iterator2.next();
                writer.write(String.valueOf(parameter));
                if (!iterator2.hasNext()) continue;
                writer.write(", ");
            }
        }
        writer.write("]");
        return writer.toString();
    }

    @Override
    public boolean isQueryStringCall() {
        return true;
    }
}

