/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.indirection;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.MapChangeEvent;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.Helper;

public class IndirectMap
extends Hashtable
implements CollectionChangeTracker,
IndirectCollection {
    protected volatile Hashtable delegate;
    protected ValueHolderInterface valueHolder;
    private transient PropertyChangeListener changeListener;
    private transient String attributeName;
    protected int initialCapacity = 11;
    protected float loadFactor = 0.75f;

    public IndirectMap() {
        this(11);
    }

    public IndirectMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IndirectMap(int initialCapacity, float loadFactor) {
        super(0);
        this.initialize(initialCapacity, loadFactor);
    }

    public IndirectMap(Map m3) {
        super(0);
        this.initialize(m3);
    }

    protected Hashtable buildDelegate() {
        Hashtable value2 = (Hashtable)this.getValueHolder().getValue();
        if (value2 == null) {
            value2 = new Hashtable(this.initialCapacity, this.loadFactor);
        }
        return value2;
    }

    @Override
    public synchronized void clear() {
        if (this.hasTrackedPropertyChangeListener()) {
            Iterator objects = this.keySet().iterator();
            while (objects.hasNext()) {
                Object o = objects.next();
                objects.remove();
                this.raiseRemoveChangeEvent(o, this.get(o));
            }
        } else {
            this.getDelegate().clear();
        }
    }

    @Override
    public void clearDeferredChanges() {
    }

    @Override
    public synchronized Object clone() {
        IndirectMap result2 = (IndirectMap)super.clone();
        result2.delegate = (Hashtable)this.getDelegate().clone();
        result2.valueHolder = new ValueHolder(result2.delegate);
        result2.attributeName = null;
        result2.changeListener = null;
        return result2;
    }

    @Override
    public synchronized boolean contains(Object value2) {
        return this.getDelegate().contains(value2);
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.getDelegate().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.getDelegate().containsValue(value2);
    }

    @Override
    public synchronized Enumeration elements() {
        return this.getDelegate().elements();
    }

    @Override
    public Set entrySet() {
        return new Set(){
            Set delegateSet;
            {
                this.delegateSet = IndirectMap.this.getDelegate().entrySet();
            }

            @Override
            public int size() {
                return this.delegateSet.size();
            }

            @Override
            public boolean isEmpty() {
                return this.delegateSet.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return this.delegateSet.contains(o);
            }

            @Override
            public Iterator iterator() {
                return new Iterator(){
                    Iterator delegateIterator;
                    Object currentObject;
                    {
                        this.delegateIterator = delegateSet.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    public Object next() {
                        this.currentObject = this.delegateIterator.next();
                        return this.currentObject;
                    }

                    @Override
                    public void remove() {
                        IndirectMap.this.raiseRemoveChangeEvent(((Map.Entry)this.currentObject).getKey(), ((Map.Entry)this.currentObject).getValue());
                        this.delegateIterator.remove();
                    }
                };
            }

            @Override
            public Object[] toArray() {
                return this.delegateSet.toArray();
            }

            @Override
            public Object[] toArray(Object[] a) {
                return this.delegateSet.toArray(a);
            }

            @Override
            public boolean add(Object o) {
                return this.delegateSet.add(o);
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                return IndirectMap.this.remove(((Map.Entry)o).getKey()) != null;
            }

            @Override
            public boolean containsAll(Collection c) {
                return this.delegateSet.containsAll(c);
            }

            @Override
            public boolean addAll(Collection c) {
                return this.delegateSet.addAll(c);
            }

            @Override
            public boolean retainAll(Collection c) {
                boolean result2 = false;
                Iterator objects = this.delegateSet.iterator();
                while (objects.hasNext()) {
                    Map.Entry object = (Map.Entry)objects.next();
                    if (c.contains(object)) continue;
                    objects.remove();
                    IndirectMap.this.raiseRemoveChangeEvent(object.getKey(), object.getValue());
                    result2 = true;
                }
                return result2;
            }

            @Override
            public boolean removeAll(Collection c) {
                boolean result2 = false;
                for (Object object : c) {
                    Object removed;
                    if (!(object instanceof Map.Entry) || (removed = IndirectMap.this.remove(((Map.Entry)object).getKey())) == null) continue;
                    result2 = true;
                }
                return result2;
            }

            @Override
            public void clear() {
                IndirectMap.this.clear();
            }

            @Override
            public boolean equals(Object o) {
                return this.delegateSet.equals(o);
            }

            @Override
            public int hashCode() {
                return this.delegateSet.hashCode();
            }
        };
    }

    @Override
    public synchronized boolean equals(Object o) {
        return this.getDelegate().equals(o);
    }

    @Override
    public synchronized Object get(Object key) {
        return this.getDelegate().get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getDelegate() {
        if (this.delegate == null) {
            IndirectMap indirectMap = this;
            synchronized (indirectMap) {
                if (this.delegate == null) {
                    this.delegate = this.buildDelegate();
                }
            }
        }
        return this.delegate;
    }

    @Override
    public Object getDelegateObject() {
        return this.getDelegate();
    }

    @Override
    public String getTrackedAttributeName() {
        return this.attributeName;
    }

    @Override
    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this.changeListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValueHolderInterface getValueHolder() {
        if (this.valueHolder == null) {
            IndirectMap indirectMap = this;
            synchronized (indirectMap) {
                if (this.valueHolder == null) {
                    this.valueHolder = new ValueHolder(new Hashtable(this.initialCapacity, this.loadFactor));
                }
            }
        }
        return this.valueHolder;
    }

    @Override
    public synchronized int hashCode() {
        return this.getDelegate().hashCode();
    }

    public boolean hasTrackedPropertyChangeListener() {
        return this.changeListener != null;
    }

    protected void initialize(int initialCapacity, float loadFactor) {
        this.delegate = null;
        this.loadFactor = loadFactor;
        this.initialCapacity = initialCapacity;
        this.valueHolder = null;
    }

    protected void initialize(Map m3) {
        this.delegate = null;
        Hashtable temp = new Hashtable(m3);
        this.valueHolder = new ValueHolder(temp);
    }

    @Override
    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    @Override
    public boolean isInstantiated() {
        return this.getValueHolder().isInstantiated();
    }

    @Override
    public synchronized Enumeration keys() {
        return this.getDelegate().keys();
    }

    @Override
    public Set keySet() {
        return new Set(){
            Set delegateSet;
            {
                this.delegateSet = IndirectMap.this.getDelegate().keySet();
            }

            @Override
            public int size() {
                return this.delegateSet.size();
            }

            @Override
            public boolean isEmpty() {
                return this.delegateSet.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return this.delegateSet.contains(o);
            }

            @Override
            public Iterator iterator() {
                return new Iterator(){
                    Iterator delegateIterator;
                    Object currentObject;
                    {
                        this.delegateIterator = delegateSet.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    public Object next() {
                        this.currentObject = this.delegateIterator.next();
                        return this.currentObject;
                    }

                    @Override
                    public void remove() {
                        IndirectMap.this.raiseRemoveChangeEvent(this.currentObject, IndirectMap.this.getDelegate().get(this.currentObject));
                        this.delegateIterator.remove();
                    }
                };
            }

            @Override
            public Object[] toArray() {
                return this.delegateSet.toArray();
            }

            @Override
            public Object[] toArray(Object[] a) {
                return this.delegateSet.toArray(a);
            }

            @Override
            public boolean add(Object o) {
                return this.delegateSet.add(o);
            }

            @Override
            public boolean remove(Object o) {
                return IndirectMap.this.remove(o) != null;
            }

            @Override
            public boolean containsAll(Collection c) {
                return this.delegateSet.containsAll(c);
            }

            @Override
            public boolean addAll(Collection c) {
                return this.delegateSet.addAll(c);
            }

            @Override
            public boolean retainAll(Collection c) {
                boolean result2 = false;
                Iterator objects = this.delegateSet.iterator();
                while (objects.hasNext()) {
                    Object object = objects.next();
                    if (c.contains(object)) continue;
                    objects.remove();
                    IndirectMap.this.raiseRemoveChangeEvent(object, IndirectMap.this.getDelegate().get(object));
                    result2 = true;
                }
                return result2;
            }

            @Override
            public boolean removeAll(Collection c) {
                boolean result2 = false;
                Iterator cs = c.iterator();
                while (cs.hasNext()) {
                    if (IndirectMap.this.remove(cs.next()) == null) continue;
                    result2 = true;
                }
                return result2;
            }

            @Override
            public void clear() {
                IndirectMap.this.clear();
            }

            @Override
            public boolean equals(Object o) {
                return this.delegateSet.equals(o);
            }

            @Override
            public int hashCode() {
                return this.delegateSet.hashCode();
            }
        };
    }

    @Override
    public synchronized Object put(Object key, Object value2) {
        Object oldValue = this.getDelegate().put(key, value2);
        if (oldValue != null) {
            this.raiseRemoveChangeEvent(key, oldValue);
        }
        this.raiseAddChangeEvent(key, value2);
        return oldValue;
    }

    @Override
    public synchronized void putAll(Map t) {
        if (this.hasTrackedPropertyChangeListener()) {
            for (Object key : t.keySet()) {
                this.put(key, t.get(key));
            }
        } else {
            this.getDelegate().putAll(t);
        }
    }

    @Override
    protected void rehash() {
        throw new InternalError("unsupported");
    }

    protected void raiseAddChangeEvent(Object key, Object value2) {
        if (this.hasTrackedPropertyChangeListener()) {
            this._persistence_getPropertyChangeListener().propertyChange(new MapChangeEvent((Object)this, this.getTrackedAttributeName(), (Object)this, key, value2, CollectionChangeEvent.ADD, true));
        }
    }

    protected void raiseRemoveChangeEvent(Object key, Object value2) {
        if (this.hasTrackedPropertyChangeListener()) {
            this._persistence_getPropertyChangeListener().propertyChange(new MapChangeEvent((Object)this, this.getTrackedAttributeName(), (Object)this, key, value2, CollectionChangeEvent.REMOVE, true));
        }
    }

    @Override
    public synchronized Object remove(Object key) {
        Object value2 = this.getDelegate().remove(key);
        if (value2 != null) {
            this.raiseRemoveChangeEvent(key, value2);
        }
        return value2;
    }

    @Override
    public void setTrackedAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    @Override
    public void _persistence_setPropertyChangeListener(PropertyChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public void setValueHolder(ValueHolderInterface valueHolder) {
        this.delegate = null;
        this.valueHolder = valueHolder;
    }

    @Override
    public int size() {
        return this.getDelegate().size();
    }

    @Override
    public void setUseLazyInstantiation(boolean useLazyInstantiation) {
    }

    @Override
    public Collection getRemovedElements() {
        return null;
    }

    @Override
    public Collection getAddedElements() {
        return null;
    }

    @Override
    public boolean hasDeferredChanges() {
        return false;
    }

    @Override
    public String toString() {
        if (this.isInstantiated()) {
            return "{" + this.getDelegate().toString() + "}";
        }
        return "{" + Helper.getShortClassName(this.getClass()) + ": not instantiated}";
    }

    @Override
    public Collection values() {
        return new Collection(){
            protected Collection delegateCollection;
            {
                this.delegateCollection = IndirectMap.this.getDelegate().values();
            }

            @Override
            public int size() {
                return this.delegateCollection.size();
            }

            @Override
            public boolean isEmpty() {
                return this.delegateCollection.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return this.delegateCollection.contains(o);
            }

            @Override
            public Iterator iterator() {
                return new Iterator(){
                    Iterator delegateIterator;
                    Object currentObject;
                    {
                        this.delegateIterator = delegateCollection.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    public Object next() {
                        this.currentObject = this.delegateIterator.next();
                        return this.currentObject;
                    }

                    @Override
                    public void remove() {
                        for (Map.Entry entry2 : IndirectMap.this.getDelegate().entrySet()) {
                            if (!entry2.getValue().equals(this.currentObject)) continue;
                            IndirectMap.this.raiseRemoveChangeEvent(entry2.getKey(), entry2.getValue());
                        }
                        this.delegateIterator.remove();
                    }
                };
            }

            @Override
            public Object[] toArray() {
                return this.delegateCollection.toArray();
            }

            public Object[] toArray(Object[] a) {
                return this.delegateCollection.toArray(a);
            }

            public boolean add(Object o) {
                return this.delegateCollection.add(o);
            }

            @Override
            public boolean remove(Object o) {
                Iterator iterator2 = IndirectMap.this.getDelegate().entrySet().iterator();
                if (iterator2.hasNext()) {
                    Map.Entry entry2 = iterator2.next();
                    if (entry2.getValue().equals(o)) {
                        IndirectMap.this.raiseRemoveChangeEvent(entry2.getKey(), entry2.getValue());
                    }
                    return true;
                }
                return false;
            }

            public boolean containsAll(Collection c) {
                return this.delegateCollection.containsAll(c);
            }

            public boolean addAll(Collection c) {
                return this.delegateCollection.addAll(c);
            }

            public boolean removeAll(Collection c) {
                boolean result2 = false;
                Iterator iterator2 = c.iterator();
                while (iterator2.hasNext()) {
                    if (!this.remove(iterator2.next())) continue;
                    result2 = true;
                }
                return result2;
            }

            public boolean retainAll(Collection c) {
                boolean result2 = false;
                Iterator iterator2 = IndirectMap.this.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry2 = (Map.Entry)iterator2.next();
                    if (c.contains(entry2.getValue())) continue;
                    iterator2.remove();
                    result2 = true;
                }
                return result2;
            }

            @Override
            public void clear() {
                IndirectMap.this.clear();
            }

            @Override
            public boolean equals(Object o) {
                return this.delegateCollection.equals(o);
            }

            @Override
            public int hashCode() {
                return this.delegateCollection.hashCode();
            }
        };
    }
}

