/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.io.Serializable;
import java.util.Arrays;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;

public class CacheId
implements Serializable,
Comparable<CacheId> {
    public static final CacheId EMPTY = new CacheId(new Object[0]);
    protected Object[] primaryKey;
    protected int hash;
    protected boolean hasArray;

    public CacheId() {
    }

    public CacheId(Object[] primaryKey) {
        this.primaryKey = primaryKey;
        this.hash = this.computeHash(primaryKey);
    }

    public Object[] getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(Object[] primaryKey) {
        this.primaryKey = primaryKey;
        this.hash = this.computeHash(primaryKey);
    }

    public void add(Object value2) {
        Object[] array = new Object[this.primaryKey.length + 1];
        System.arraycopy(this.primaryKey, 0, array, 0, this.primaryKey.length);
        array[this.primaryKey.length] = value2;
        this.setPrimaryKey(array);
    }

    public void set(int index, Object value2) {
        this.primaryKey[index] = value2;
        this.setPrimaryKey(this.primaryKey);
    }

    protected int computeHash(Object[] primaryKey) {
        int result2 = 1;
        Object[] objectArray = primaryKey;
        int n = primaryKey.length;
        int n2 = 0;
        while (n2 < n) {
            Object value2 = objectArray[n2];
            if (value2 != null) {
                if (value2.getClass().isArray()) {
                    result2 = this.computeArrayHashCode(result2, value2);
                    this.hasArray = true;
                } else {
                    result2 = 31 * result2 + value2.hashCode();
                }
            } else {
                result2 *= 31;
            }
            ++n2;
        }
        return result2;
    }

    private int computeArrayHashCode(int result2, Object obj) {
        if (obj.getClass() == ClassConstants.APBYTE) {
            byte[] byArray = (byte[])obj;
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte element = byArray[n2];
                result2 = 31 * result2 + element;
                ++n2;
            }
        } else if (obj.getClass() == ClassConstants.APCHAR) {
            char[] cArray = (char[])obj;
            int n = cArray.length;
            int n3 = 0;
            while (n3 < n) {
                char element = cArray[n3];
                result2 = 31 * result2 + element;
                ++n3;
            }
        } else {
            Object[] objectArray = (Object[])obj;
            int n = objectArray.length;
            int n4 = 0;
            while (n4 < n) {
                Object element = objectArray[n4];
                result2 = 31 * result2 + (element == null ? 0 : element.hashCode());
                ++n4;
            }
        }
        return result2;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        try {
            return this.equals((CacheId)object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean equals(CacheId id) {
        if (this == id) {
            return true;
        }
        if (this.hash != id.hash) {
            return false;
        }
        if (this.hasArray != id.hasArray) {
            return false;
        }
        int size2 = this.primaryKey.length;
        Object[] otherKey = id.primaryKey;
        if (size2 == otherKey.length) {
            int index = 0;
            while (index < size2) {
                Object value2 = this.primaryKey[index];
                Object otherValue = otherKey[index];
                if (value2 == null) {
                    if (otherValue != null) {
                        return false;
                    }
                } else {
                    if (otherValue == null) {
                        return false;
                    }
                    if (this.hasArray) {
                        Class<?> valueClass = value2.getClass();
                        if (valueClass.isArray()) {
                            Class<?> otherClass = otherValue.getClass();
                            if (valueClass == ClassConstants.APBYTE && otherClass == ClassConstants.APBYTE ? !Helper.compareByteArrays((byte[])value2, (byte[])otherValue) : (valueClass == ClassConstants.APCHAR && otherClass == ClassConstants.APCHAR ? !Helper.compareCharArrays((char[])value2, (char[])otherValue) : !Helper.compareArrays((Object[])value2, (Object[])otherValue))) {
                                return false;
                            }
                        } else if (!value2.equals(otherValue)) {
                            return false;
                        }
                    } else if (!value2.equals(otherValue)) {
                        return false;
                    }
                }
                ++index;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(CacheId id) {
        if (this == id) {
            return 0;
        }
        int size2 = this.primaryKey.length;
        Object[] otherKey = id.primaryKey;
        if (size2 == otherKey.length) {
            int index = 0;
            while (index < size2) {
                Object value2 = this.primaryKey[index];
                Object otherValue = otherKey[index];
                if (value2 == null) {
                    if (otherValue != null) {
                        return -1;
                    }
                } else {
                    if (otherValue == null) {
                        return 1;
                    }
                    try {
                        int compareTo = ((Comparable)value2).compareTo(otherValue);
                        if (compareTo != 0) {
                            return compareTo;
                        }
                    }
                    catch (Exception exception) {
                        return 0;
                    }
                }
                ++index;
            }
            return 0;
        }
        if (size2 > otherKey.length) {
            return 1;
        }
        return -1;
    }

    public boolean hasArray() {
        return this.hasArray;
    }

    public String toString() {
        return "[" + Arrays.asList(this.primaryKey) + ": " + this.hash + "]";
    }
}

