/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetClassLoaderForClass;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;

public class ProxyIndirectionHandler
implements InvocationHandler,
Serializable {
    private ValueHolderInterface valueHolder;

    public ProxyIndirectionHandler() {
    }

    private ProxyIndirectionHandler(ValueHolderInterface valueHolder) {
        this.valueHolder = valueHolder;
    }

    @Override
    public Object invoke(Object proxy, Method m3, Object[] args) throws Throwable {
        Object result2 = null;
        try {
            if (m3.getName().equals("toString")) {
                if (this.valueHolder.isInstantiated()) {
                    if (this.valueHolder.getValue() == null) {
                        result2 = "null";
                    } else if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        String toString2 = (String)AccessController.doPrivileged(new PrivilegedMethodInvoker(m3, this.valueHolder.getValue(), args));
                        result2 = "{ " + toString2 + " }";
                    } else {
                        String toString3 = (String)PrivilegedAccessHelper.invokeMethod(m3, this.valueHolder.getValue(), args);
                        result2 = "{ " + toString3 + " }";
                    }
                } else {
                    result2 = "{ IndirectProxy: not instantiated }";
                }
            } else if (m3.getName().equals("equals") && this.valueHolder.getValue() == null && args[0] == null) {
                result2 = Boolean.TRUE;
            } else {
                Object value2 = this.valueHolder.getValue();
                if (value2 == null) {
                    throw ValidationException.nullUnderlyingValueHolderValue(m3.getName());
                }
                result2 = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedMethodInvoker(m3, value2, args)) : PrivilegedAccessHelper.invokeMethod(m3, value2, args);
            }
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw QueryException.unexpectedInvocation(e.getMessage());
        }
        return result2;
    }

    public static Object newProxyInstance(Class anInterface, Class[] interfaces, ValueHolderInterface valueHolder) {
        ClassLoader classLoader = null;
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedGetClassLoaderForClass(anInterface));
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getCause();
            }
        } else {
            classLoader = PrivilegedAccessHelper.getClassLoaderForClass(anInterface);
        }
        return Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new ProxyIndirectionHandler(valueHolder));
    }

    public ValueHolderInterface getValueHolder() {
        return this.valueHolder;
    }

    public void setValueHolder(ValueHolderInterface value2) {
        this.valueHolder = value2;
    }
}

