/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.persistence.internal.jpa.jpql.AbstractRangeDeclaration;
import org.eclipse.persistence.internal.jpa.jpql.CollectionDeclaration;
import org.eclipse.persistence.internal.jpa.jpql.Declaration;
import org.eclipse.persistence.internal.jpa.jpql.DerivedDeclaration;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.internal.jpa.jpql.JoinDeclaration;
import org.eclipse.persistence.internal.jpa.jpql.RangeDeclaration;
import org.eclipse.persistence.internal.jpa.jpql.SubqueryDeclaration;
import org.eclipse.persistence.internal.jpa.jpql.TableDeclaration;
import org.eclipse.persistence.jpa.jpql.JPQLQueryDeclaration;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.jpql.parser.TableVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.jpql.parser.UpdateStatement;

final class DeclarationResolver {
    private Declaration baseDeclaration;
    private List<Declaration> declarations;
    private DeclarationResolver parent;
    private boolean populated;
    private JPQLQueryContext queryContext;
    private Collection<IdentificationVariable> resultVariables;

    DeclarationResolver(JPQLQueryContext queryContext, DeclarationResolver parent) {
        this.initialize(queryContext, parent);
    }

    void addRangeVariableDeclaration(String entityName, String variableName) {
        this.populated = true;
        this.resultVariables = Collections.emptySet();
        RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration(entityName, variableName);
        RangeDeclaration declaration = new RangeDeclaration(this.queryContext);
        declaration.rootPath = entityName;
        declaration.baseExpression = rangeVariableDeclaration;
        declaration.identificationVariable = (IdentificationVariable)rangeVariableDeclaration.getIdentificationVariable();
        this.declarations.add(declaration);
        if (this.baseDeclaration == null) {
            this.baseDeclaration = declaration;
            declaration.getQueryExpression();
        }
    }

    void convertUnqualifiedDeclaration(RangeDeclaration declaration, String outerVariableName) {
        QualifyRangeDeclarationVisitor visitor = new QualifyRangeDeclarationVisitor();
        visitor.declaration = declaration;
        visitor.outerVariableName = outerVariableName;
        visitor.queryContext = this.queryContext.getCurrentContext();
        declaration.declarationExpression.accept(visitor);
        int index = this.declarations.indexOf(declaration);
        this.declarations.set(index, visitor.declaration);
        if (this.baseDeclaration == declaration) {
            this.baseDeclaration = visitor.declaration;
        }
    }

    Declaration getDeclaration(String variableName) {
        for (Declaration declaration : this.declarations) {
            if (!declaration.getVariableName().equalsIgnoreCase(variableName)) continue;
            return declaration;
        }
        return null;
    }

    List<Declaration> getDeclarations() {
        return this.declarations;
    }

    Declaration getFirstDeclaration() {
        return this.baseDeclaration;
    }

    Collection<Join> getJoinFetches(String variableName) {
        RangeDeclaration rangeDeclaration;
        Declaration declaration = this.getDeclaration(variableName);
        if (declaration != null && declaration.getType() == JPQLQueryDeclaration.Type.RANGE && (rangeDeclaration = (RangeDeclaration)declaration).hasJoins()) {
            return rangeDeclaration.getJoinFetches();
        }
        return null;
    }

    DeclarationResolver getParent() {
        return this.parent;
    }

    Collection<IdentificationVariable> getResultVariables() {
        if (this.parent != null) {
            return this.parent.getResultVariables();
        }
        if (this.resultVariables == null) {
            ResultVariableVisitor visitor = new ResultVariableVisitor();
            this.queryContext.getJPQLExpression().accept(visitor);
            this.resultVariables = visitor.resultVariables;
        }
        return this.resultVariables;
    }

    private void initialize(JPQLQueryContext queryContext, DeclarationResolver parent) {
        this.parent = parent;
        this.queryContext = queryContext;
        this.declarations = new LinkedList<Declaration>();
    }

    boolean isCollectionIdentificationVariable(String variableName) {
        boolean result2 = this.isCollectionIdentificationVariableImp(variableName);
        if (!result2 && this.parent != null) {
            result2 = this.parent.isCollectionIdentificationVariableImp(variableName);
        }
        return result2;
    }

    boolean isCollectionIdentificationVariableImp(String variableName) {
        block4: for (Declaration declaration : this.declarations) {
            switch (declaration.getType()) {
                case COLLECTION: {
                    return declaration.getVariableName().equalsIgnoreCase(variableName);
                }
                case DERIVED: 
                case RANGE: {
                    AbstractRangeDeclaration rangeDeclaration = (AbstractRangeDeclaration)declaration;
                    for (Join join : rangeDeclaration.getJoins()) {
                        String joinVariableName = this.queryContext.literal(join.getIdentificationVariable(), LiteralType.IDENTIFICATION_VARIABLE);
                        if (!joinVariableName.equalsIgnoreCase(variableName)) continue;
                        Declaration joinDeclaration = this.queryContext.getDeclaration(joinVariableName);
                        return joinDeclaration.getMapping().isCollectionMapping();
                    }
                    continue block4;
                }
            }
        }
        return false;
    }

    boolean isRangeIdentificationVariable(String variableName) {
        boolean result2 = this.isRangeIdentificationVariableImp(variableName);
        if (!result2 && this.parent != null) {
            result2 = this.parent.isRangeIdentificationVariableImp(variableName);
        }
        return result2;
    }

    private boolean isRangeIdentificationVariableImp(String variableName) {
        Declaration declaration = this.getDeclaration(variableName);
        return declaration != null && declaration.getType().isRange();
    }

    boolean isResultVariable(String variableName) {
        if (this.parent != null) {
            return this.parent.isResultVariable(variableName);
        }
        for (IdentificationVariable resultVariable : this.getResultVariables()) {
            if (!resultVariable.getText().equalsIgnoreCase(variableName)) continue;
            return true;
        }
        return false;
    }

    void populate(Expression expression) {
        if (!this.populated) {
            this.populated = true;
            this.populateImp(expression);
        }
    }

    private void populateImp(Expression expression) {
        DeclarationVisitor visitor = new DeclarationVisitor();
        visitor.queryContext = this.queryContext;
        visitor.declarations = this.declarations;
        expression.accept(visitor);
        this.baseDeclaration = visitor.baseDeclaration;
    }

    private static class DeclarationVisitor
    extends AbstractEclipseLinkExpressionVisitor {
        private Declaration baseDeclaration;
        private boolean buildingDeclaration;
        private Declaration currentDeclaration;
        List<Declaration> declarations;
        JPQLQueryContext queryContext;

        private DeclarationVisitor() {
        }

        @Override
        public void visit(AbstractSchemaName expression) {
            String rootPath = expression.getText();
            if (rootPath.indexOf(46) == -1) {
                this.currentDeclaration = new RangeDeclaration(this.queryContext);
            } else {
                Class<?> type = this.queryContext.getType(rootPath);
                if (type != null) {
                    RangeDeclaration declaration = new RangeDeclaration(this.queryContext);
                    declaration.type = type;
                    this.currentDeclaration = declaration;
                } else {
                    this.currentDeclaration = new DerivedDeclaration(this.queryContext);
                }
            }
            this.currentDeclaration.rootPath = rootPath;
        }

        @Override
        public void visit(CollectionExpression expression) {
            expression.acceptChildren(this);
        }

        @Override
        public void visit(CollectionMemberDeclaration expression) {
            CollectionDeclaration declaration = new CollectionDeclaration(this.queryContext);
            declaration.baseExpression = expression.getCollectionValuedPathExpression();
            declaration.rootPath = declaration.baseExpression.toActualText();
            declaration.declarationExpression = expression;
            this.declarations.add(declaration);
            if (!expression.isDerived()) {
                IdentificationVariable identificationVariable;
                declaration.identificationVariable = identificationVariable = (IdentificationVariable)expression.getIdentificationVariable();
            }
            if (this.baseDeclaration == null) {
                this.baseDeclaration = declaration;
            }
        }

        @Override
        public void visit(CollectionValuedPathExpression expression) {
            String rootPath = expression.toParsedText();
            Class<?> type = this.queryContext.getType(rootPath);
            if (type != null) {
                RangeDeclaration declaration = new RangeDeclaration(this.queryContext);
                declaration.type = type;
                this.currentDeclaration = declaration;
            } else {
                this.currentDeclaration = new DerivedDeclaration(this.queryContext);
            }
            this.currentDeclaration.rootPath = rootPath;
        }

        @Override
        public void visit(DeleteClause expression) {
            try {
                expression.getRangeVariableDeclaration().accept(this);
            }
            finally {
                this.currentDeclaration = null;
            }
        }

        @Override
        public void visit(DeleteStatement expression) {
            expression.getDeleteClause().accept(this);
        }

        @Override
        public void visit(FromClause expression) {
            expression.getDeclaration().accept(this);
        }

        @Override
        public void visit(IdentificationVariableDeclaration expression) {
            try {
                expression.getRangeVariableDeclaration().accept(this);
                this.currentDeclaration.declarationExpression = expression;
                expression.getJoins().accept(this);
            }
            finally {
                this.currentDeclaration = null;
            }
        }

        @Override
        public void visit(Join expression) {
            ((AbstractRangeDeclaration)this.currentDeclaration).addJoin(expression);
            if (!expression.hasFetch() || expression.hasIdentificationVariable()) {
                IdentificationVariable identificationVariable = (IdentificationVariable)expression.getIdentificationVariable();
                JoinDeclaration declaration = new JoinDeclaration(this.queryContext);
                declaration.baseExpression = expression;
                declaration.identificationVariable = identificationVariable;
                this.declarations.add(declaration);
            }
        }

        @Override
        public void visit(JPQLExpression expression) {
            expression.getQueryStatement().accept(this);
        }

        @Override
        public void visit(RangeVariableDeclaration expression) {
            this.buildingDeclaration = true;
            expression.getRootObject().accept(this);
            this.buildingDeclaration = false;
            this.currentDeclaration.identificationVariable = (IdentificationVariable)expression.getIdentificationVariable();
            this.currentDeclaration.baseExpression = expression;
            this.declarations.add(this.currentDeclaration);
            if (this.baseDeclaration == null) {
                this.baseDeclaration = this.currentDeclaration;
            }
        }

        @Override
        public void visit(SelectStatement expression) {
            expression.getFromClause().accept(this);
        }

        @Override
        public void visit(SimpleFromClause expression) {
            expression.getDeclaration().accept(this);
        }

        @Override
        public void visit(SimpleSelectClause expression) {
            expression.getSelectExpression().accept(this);
        }

        @Override
        public void visit(SimpleSelectStatement expression) {
            if (this.buildingDeclaration) {
                this.currentDeclaration = new SubqueryDeclaration(this.queryContext);
                this.currentDeclaration.rootPath = "";
            } else {
                expression.getFromClause().accept(this);
            }
        }

        @Override
        public void visit(SubExpression expression) {
            expression.getExpression().accept(this);
        }

        @Override
        public void visit(TableVariableDeclaration expression) {
            TableDeclaration declaration = new TableDeclaration(this.queryContext);
            declaration.declarationExpression = expression;
            declaration.baseExpression = expression.getTableExpression();
            declaration.rootPath = declaration.baseExpression.toParsedText();
            declaration.identificationVariable = (IdentificationVariable)expression.getIdentificationVariable();
            this.declarations.add(declaration);
        }

        @Override
        public void visit(UpdateClause expression) {
            try {
                expression.getRangeVariableDeclaration().accept(this);
            }
            finally {
                this.currentDeclaration = null;
            }
        }

        @Override
        public void visit(UpdateStatement expression) {
            expression.getUpdateClause().accept(this);
        }
    }

    private static class QualifyRangeDeclarationVisitor
    extends AbstractEclipseLinkExpressionVisitor {
        AbstractRangeDeclaration declaration;
        String outerVariableName;
        JPQLQueryContext queryContext;

        private QualifyRangeDeclarationVisitor() {
        }

        @Override
        public void visit(CollectionValuedPathExpression expression) {
            StringBuilder rootPath = new StringBuilder();
            rootPath.append(this.outerVariableName);
            rootPath.append(".");
            rootPath.append(expression.toParsedText());
            this.declaration.rootPath = rootPath.toString();
        }

        @Override
        public void visit(IdentificationVariableDeclaration expression) {
            expression.getRangeVariableDeclaration().accept(this);
            this.declaration.declarationExpression = expression;
        }

        @Override
        public void visit(RangeVariableDeclaration expression) {
            DerivedDeclaration derivedDeclaration = new DerivedDeclaration(this.queryContext);
            derivedDeclaration.joins = this.declaration.joins;
            derivedDeclaration.rootPath = this.declaration.rootPath;
            derivedDeclaration.baseExpression = this.declaration.baseExpression;
            derivedDeclaration.identificationVariable = this.declaration.identificationVariable;
            this.declaration = derivedDeclaration;
            expression.setVirtualIdentificationVariable(this.outerVariableName, this.declaration.rootPath);
            expression.getRootObject().accept(this);
        }
    }

    private static class ResultVariableVisitor
    extends AbstractEclipseLinkExpressionVisitor {
        Set<IdentificationVariable> resultVariables = new HashSet<IdentificationVariable>();

        @Override
        public void visit(CollectionExpression expression) {
            expression.acceptChildren(this);
        }

        @Override
        public void visit(JPQLExpression expression) {
            expression.getQueryStatement().accept(this);
        }

        @Override
        public void visit(ResultVariable expression) {
            IdentificationVariable identificationVariable = (IdentificationVariable)expression.getResultVariable();
            this.resultVariables.add(identificationVariable);
        }

        @Override
        public void visit(SelectClause expression) {
            expression.getSelectExpression().accept(this);
        }

        @Override
        public void visit(SelectStatement expression) {
            expression.getSelectClause().accept(this);
        }
    }
}

