/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFactory;
import org.eclipse.persistence.internal.jpa.metadata.queries.ComplexTypeMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.platform.database.jdbc.JDBCTypes;
import org.eclipse.persistence.platform.database.oracle.plsql.OraclePLSQLTypes;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLrecord;

public abstract class ORMetadata {
    private MetadataAnnotation m_annotation;
    private MetadataAccessibleObject m_accessibleObject;
    private Object m_location;
    protected MetadataProject m_project;
    private XMLEntityMappings m_entityMappings;
    private String m_xmlElement;
    protected static Map<String, Class> primitiveClasses = null;
    protected static Map<String, String> boxedTypes = null;

    protected ORMetadata() {
    }

    public ORMetadata(String xmlElement) {
        this.m_xmlElement = xmlElement;
    }

    public abstract boolean equals(Object var1);

    protected ORMetadata(MetadataAccessibleObject accessibleObject, MetadataProject project, Object location) {
        this.m_location = location;
        this.m_accessibleObject = accessibleObject;
        this.m_project = project;
    }

    public ORMetadata(MetadataAnnotation annotation, MetadataAccessor accessor) {
        this(accessor.getAccessibleObject(), accessor.getProject(), accessor.getLocation());
        this.m_annotation = annotation;
    }

    public ORMetadata(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject, MetadataProject project) {
        this(accessibleObject, project, accessibleObject);
        this.m_annotation = annotation;
    }

    public ORMetadata(ORMetadata orm) {
        this.m_location = orm.getLocation();
        this.m_accessibleObject = orm.getAccessibleObject();
        this.m_project = orm.getProject();
        this.m_annotation = orm.getAnnotation();
    }

    protected MetadataAccessibleObject getAccessibleObject() {
        return this.m_accessibleObject;
    }

    public String getAccessibleObjectName() {
        return this.m_accessibleObject.getName();
    }

    public MetadataAnnotation getAnnotation() {
        return this.m_annotation;
    }

    protected String getBoxedType(String type) {
        if (boxedTypes == null) {
            boxedTypes = new HashMap<String, String>();
            boxedTypes.put("void", Void.class.getName());
            boxedTypes.put("boolean", Boolean.class.getName());
            boxedTypes.put("byte", Byte.class.getName());
            boxedTypes.put("char", Character.class.getName());
            boxedTypes.put("double", Double.class.getName());
            boxedTypes.put("float", Float.class.getName());
            boxedTypes.put("int", Integer.class.getName());
            boxedTypes.put("long", Long.class.getName());
            boxedTypes.put("short", Short.class.getName());
            boxedTypes.put("byte[]", new Byte[0].getClass().getName());
            boxedTypes.put("char[]", new Character[0].getClass().getName());
            boxedTypes.put("boolean[]", new Boolean[0].getClass().getName());
            boxedTypes.put("double[]", new Double[0].getClass().getName());
            boxedTypes.put("float[]", new Float[0].getClass().getName());
            boxedTypes.put("int[]", new Integer[0].getClass().getName());
            boxedTypes.put("long[]", new Long[0].getClass().getName());
            boxedTypes.put("short[]", new Short[0].getClass().getName());
        }
        return boxedTypes.containsKey(type) ? boxedTypes.get(type) : type;
    }

    public ClassLoader getLoader() {
        return this.getMetadataFactory().getLoader();
    }

    protected DatabaseType getDatabaseTypeEnum(String type) {
        if (type == null) {
            return JDBCTypes.VARCHAR_TYPE;
        }
        try {
            return JDBCTypes.valueOf(type);
        }
        catch (Exception exception) {
            try {
                return OraclePLSQLTypes.valueOf(type);
            }
            catch (Exception exception2) {
                ComplexTypeMetadata typeMetadata = this.getProject().getComplexTypeMetadata(type);
                if (typeMetadata != null) {
                    return typeMetadata.process();
                }
                PLSQLrecord record2 = new PLSQLrecord();
                record2.setTypeName(type);
                return record2;
            }
        }
    }

    public XMLEntityMappings getEntityMappings() {
        return this.m_entityMappings;
    }

    protected String getFullyQualifiedClassName(String className) {
        Class primitiveClass = this.getPrimitiveClassForName(className);
        if (primitiveClass == null) {
            if (this.loadedFromXML()) {
                return this.getEntityMappings().getPackageQualifiedClassName(className);
            }
            return className;
        }
        return primitiveClass.getName();
    }

    protected String getIdentifier() {
        return "";
    }

    protected Class getJavaClass(MetadataClass metadataClass) {
        String className = metadataClass.getName();
        Class primitiveClass = this.getPrimitiveClassForName(className);
        if (primitiveClass == null) {
            String convertedClassName = className;
            int index = className.indexOf(91);
            if (index > 0 && className.charAt(index + 1) == ']') {
                convertedClassName = "[L" + className.substring(0, index) + ";";
            }
            convertedClassName = this.getFullyQualifiedClassName(convertedClassName);
            return MetadataHelper.getClassForName(convertedClassName, this.getLoader());
        }
        return primitiveClass;
    }

    public String getJavaClassName(MetadataClass metadataClass) {
        String className = metadataClass.getName();
        Class primitiveClass = this.getPrimitiveClassForName(className);
        if (primitiveClass == null) {
            String convertedClassName = className;
            int index = className.indexOf(91);
            if (index > 0 && className.charAt(index + 1) == ']') {
                convertedClassName = "[L" + className.substring(0, index) + ";";
            }
            return this.getFullyQualifiedClassName(convertedClassName);
        }
        return primitiveClass.getName();
    }

    public Object getLocation() {
        return this.m_location;
    }

    public MetadataLogger getLogger() {
        return this.m_project.getLogger();
    }

    public MetadataClass getMetadataClass(Class javaClass) {
        if (javaClass == null) {
            return null;
        }
        return this.getMetadataClass(javaClass.getName());
    }

    public MetadataClass getMetadataClass(String className) {
        return this.getMetadataClass(className, true);
    }

    public MetadataClass getMetadataClass(String className, boolean isLazy) {
        return this.getMetadataFactory().getMetadataClass(this.getFullyQualifiedClassName(className), isLazy);
    }

    public MetadataFactory getMetadataFactory() {
        if (this.getAccessibleObject() != null) {
            return this.getAccessibleObject().getMetadataFactory();
        }
        return this.getEntityMappings().getMetadataFactory();
    }

    protected String getName(String name, String defaultName, String context) {
        return MetadataHelper.getName(name, defaultName, context, this.getLogger(), this.getAccessibleObjectName());
    }

    protected Class getPrimitiveClassForName(String className) {
        if (primitiveClasses == null) {
            primitiveClasses = new HashMap<String, Class>();
            primitiveClasses.put("", Void.TYPE);
            primitiveClasses.put("void", Void.TYPE);
            primitiveClasses.put("Boolean", Boolean.class);
            primitiveClasses.put("Byte", Byte.class);
            primitiveClasses.put("Character", Character.class);
            primitiveClasses.put("Double", Double.class);
            primitiveClasses.put("Float", Float.class);
            primitiveClasses.put("Integer", Integer.class);
            primitiveClasses.put("Long", Long.class);
            primitiveClasses.put("Number", Number.class);
            primitiveClasses.put("Short", Short.class);
            primitiveClasses.put("String", String.class);
            primitiveClasses.put("boolean", Boolean.TYPE);
            primitiveClasses.put("byte", Byte.TYPE);
            primitiveClasses.put("char", Character.TYPE);
            primitiveClasses.put("double", Double.TYPE);
            primitiveClasses.put("float", Float.TYPE);
            primitiveClasses.put("int", Integer.TYPE);
            primitiveClasses.put("long", Long.TYPE);
            primitiveClasses.put("short", Short.TYPE);
            primitiveClasses.put("byte[]", new byte[0].getClass());
            primitiveClasses.put("char[]", new char[0].getClass());
            primitiveClasses.put("boolean[]", new boolean[0].getClass());
            primitiveClasses.put("double[]", new double[0].getClass());
            primitiveClasses.put("float[]", new float[0].getClass());
            primitiveClasses.put("int[]", new int[0].getClass());
            primitiveClasses.put("long[]", new long[0].getClass());
            primitiveClasses.put("short[]", new short[0].getClass());
        }
        return className == null ? Void.TYPE : primitiveClasses.get(className);
    }

    public MetadataProject getProject() {
        return this.m_project;
    }

    protected String getText() {
        return null;
    }

    protected String getXMLElement() {
        return this.m_xmlElement;
    }

    protected boolean hasIdentifier() {
        return !this.getIdentifier().equals("");
    }

    protected boolean hasText() {
        return this.getText() != null && !this.getText().equals("");
    }

    protected MetadataClass initXMLClassName(String className) {
        return this.getMetadataClass(className);
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        this.m_project = entityMappings.getProject();
        this.m_accessibleObject = accessibleObject;
        this.setEntityMappings(entityMappings);
    }

    protected void initXMLObject(ORMetadata metadata, MetadataAccessibleObject accessibleObject) {
        if (metadata != null) {
            metadata.initXMLObject(accessibleObject, this.m_entityMappings);
        }
    }

    protected void initXMLObjects(List metadatas, MetadataAccessibleObject accessibleObject) {
        if (metadatas != null) {
            for (ORMetadata metadata : metadatas) {
                metadata.initXMLObject(accessibleObject, this.m_entityMappings);
            }
        }
    }

    protected String initXMLTextObject(List metadatas) {
        ORMetadata metadata;
        if (metadatas != null && metadatas.size() == 1 && (metadata = (ORMetadata)metadatas.get(0)).hasText()) {
            String text = metadata.getText();
            metadatas = null;
            return text;
        }
        return null;
    }

    public boolean loadedFromAnnotation() {
        return this.m_annotation != null || !this.loadedFromXML();
    }

    public boolean loadedFromEclipseLinkXML() {
        if (this.loadedFromXML()) {
            return this.m_entityMappings.isEclipseLinkORMFile();
        }
        return false;
    }

    public boolean loadedFromXML() {
        return this.m_entityMappings != null;
    }

    protected void merge(ORMetadata metadata) {
    }

    protected List mergeORObjectLists(List list1, List list2) {
        boolean found;
        ArrayList<ORMetadata> newList = new ArrayList<ORMetadata>();
        for (ORMetadata obj1 : list1) {
            found = false;
            for (ORMetadata obj2 : list2) {
                if (!obj2.getIdentifier().equals(obj1.getIdentifier())) continue;
                if (obj2.shouldOverride(obj1)) {
                    newList.add(obj2);
                } else {
                    newList.add(obj1);
                }
                found = true;
                break;
            }
            if (found) continue;
            newList.add(obj1);
        }
        for (ORMetadata obj2 : list2) {
            found = false;
            for (ORMetadata obj1 : list1) {
                if (!obj2.getIdentifier().equals(obj1.getIdentifier())) continue;
                found = true;
                break;
            }
            if (found) continue;
            newList.add(obj2);
        }
        return newList;
    }

    protected ORMetadata mergeORObjects(ORMetadata obj1, ORMetadata obj2) {
        if (obj2 != null) {
            if (obj1 != null) {
                if (obj2.shouldOverride(obj1)) {
                    return obj2;
                }
            } else {
                return obj2;
            }
        }
        return obj1;
    }

    protected Object mergeSimpleObjects(Object obj1, Object obj2, ORMetadata otherMetadata, String xmlElement) {
        if (obj1 == null && obj2 == null) {
            return null;
        }
        SimpleORMetadata object1 = obj1 == null ? null : new SimpleORMetadata(obj1, this.getAccessibleObject(), this.getEntityMappings(), xmlElement);
        SimpleORMetadata object2 = obj2 == null ? null : new SimpleORMetadata(obj2, otherMetadata.getAccessibleObject(), otherMetadata.getEntityMappings(), xmlElement);
        return ((SimpleORMetadata)this.mergeORObjects(object1, object2)).getValue();
    }

    protected EntityAccessor reloadEntity(EntityAccessor entity, MetadataDescriptor descriptor) {
        if (entity.loadedFromAnnotation()) {
            EntityAccessor entityAccessor = new EntityAccessor(entity.getAnnotation(), entity.getJavaClass(), entity.getProject());
            descriptor.setDefaultAccess(entity.getDescriptor().getDefaultAccess());
            entityAccessor.setDescriptor(descriptor);
            return entityAccessor;
        }
        return entity.getEntityMappings().reloadEntity(entity, descriptor);
    }

    protected MappedSuperclassAccessor reloadMappedSuperclass(MappedSuperclassAccessor mappedSuperclass, MetadataDescriptor descriptor) {
        if (mappedSuperclass.loadedFromAnnotation()) {
            MappedSuperclassAccessor mappedSuperclassAccessor = new MappedSuperclassAccessor(mappedSuperclass.getAnnotation(), mappedSuperclass.getJavaClass(), descriptor);
            return mappedSuperclassAccessor;
        }
        return mappedSuperclass.getEntityMappings().reloadMappedSuperclass(mappedSuperclass, descriptor);
    }

    public void setAccessibleObject(MetadataAccessibleObject accessibleObject) {
        this.m_accessibleObject = accessibleObject;
    }

    public void setEntityMappings(XMLEntityMappings entityMappings) {
        this.m_entityMappings = entityMappings;
        this.m_location = entityMappings.getMappingFileOrURL();
    }

    protected void setFieldName(DatabaseField field2, String name) {
        field2.setName(name, Helper.getDefaultStartDatabaseDelimiter(), Helper.getDefaultEndDatabaseDelimiter());
        if (this.m_project.useDelimitedIdentifier()) {
            field2.setUseDelimiters(true);
        } else if (this.m_project.getShouldForceFieldNamesToUpperCase() && !field2.shouldUseDelimiters()) {
            field2.useUpperCaseForComparisons(true);
        }
    }

    protected void setFieldName(DatabaseField field2, String defaultName, String context) {
        this.setFieldName(field2, this.getName(field2.getName(), defaultName, context));
    }

    public void setProject(MetadataProject project) {
        this.m_project = project;
    }

    public boolean shouldOverride(ORMetadata existing) {
        MetadataLogger logger = this.getAccessibleObject().getLogger();
        if (existing == null) {
            return true;
        }
        if (!existing.equals(this)) {
            if (this.loadedFromXML() && existing.loadedFromAnnotation()) {
                if (this.hasIdentifier()) {
                    logger.logConfigMessage("metadata_warning_override_named_annotation_with_xml", existing.getAnnotation(), this.getIdentifier(), existing.getLocation(), this.getLocation());
                } else {
                    logger.logConfigMessage("metadata_warning_override_annotation_with_xml", existing.getAnnotation(), existing.getLocation(), this.getLocation());
                }
                return true;
            }
            if (this.loadedFromAnnotation() && existing.loadedFromXML()) {
                if (this.hasIdentifier()) {
                    logger.logConfigMessage("metadata_warning_override_named_annotation_with_xml", this.m_annotation, this.getIdentifier(), this.getLocation(), existing.getLocation());
                } else {
                    logger.logConfigMessage("metadata_warning_override_annotation_with_xml", this.m_annotation, this.getLocation(), existing.getLocation());
                }
            } else {
                if (this.loadedFromEclipseLinkXML() && !existing.loadedFromEclipseLinkXML()) {
                    if (this.hasIdentifier()) {
                        logger.logConfigMessage("metadata_warning_override_named_xml_with_eclipselink_xml", existing.getXMLElement(), this.getIdentifier(), existing.getLocation(), this.getLocation());
                    } else {
                        logger.logConfigMessage("metadata_warning_override_xml_with_eclipselink_xml", existing.getXMLElement(), existing.getLocation(), this.getLocation());
                    }
                    return true;
                }
                if (!this.loadedFromEclipseLinkXML() && existing.loadedFromEclipseLinkXML()) {
                    if (this.hasIdentifier()) {
                        logger.logConfigMessage("metadata_warning_override_named_xml_with_eclipselink_xml", existing.getXMLElement(), this.getIdentifier(), this.getLocation(), existing.getLocation());
                    } else {
                        logger.logConfigMessage("metadata_warning_override_xml_with_eclipselink_xml", existing.getXMLElement(), this.getLocation(), existing.getLocation());
                    }
                } else {
                    if (this.loadedFromAnnotation()) {
                        if (this.hasIdentifier()) {
                            throw ValidationException.conflictingNamedAnnotations(this.getIdentifier(), this.m_annotation, this.getLocation(), existing.getAnnotation(), existing.getLocation());
                        }
                        throw ValidationException.conflictingAnnotations(this.m_annotation, this.getLocation(), existing.getAnnotation(), existing.getLocation());
                    }
                    if (existing.getLocation().equals(this.getLocation()) && existing.getEntityMappings().loadedForCanonicalModel()) {
                        return true;
                    }
                    if (this.hasIdentifier()) {
                        throw ValidationException.conflictingNamedXMLElements(this.getIdentifier(), this.m_xmlElement, this.getLocation(), existing.getLocation());
                    }
                    throw ValidationException.conflictingXMLElements(this.m_xmlElement, this.getAccessibleObject(), this.getLocation(), existing.getLocation());
                }
            }
        }
        return false;
    }

    protected boolean valuesMatch(List<Object> list1, List<Object> list2) {
        if (list1.size() == list2.size()) {
            for (Object obj1 : list1) {
                if (list2.contains(obj1)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean valuesMatch(Object value1, Object value2) {
        if (value1 == null && value2 != null || value2 == null && value1 != null) {
            return false;
        }
        if (value1 == null && value2 == null) {
            return true;
        }
        return value1.equals(value2);
    }

    private class SimpleORMetadata
    extends ORMetadata {
        private Object m_value;

        public SimpleORMetadata(Object value2, MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings, String xmlElement) {
            super(xmlElement);
            this.setAccessibleObject(accessibleObject);
            this.setEntityMappings(entityMappings);
            this.m_value = value2;
        }

        @Override
        public boolean equals(Object objectToCompare) {
            if (objectToCompare instanceof SimpleORMetadata) {
                return this.valuesMatch(this.getValue(), ((SimpleORMetadata)objectToCompare).getValue());
            }
            return false;
        }

        public Object getValue() {
            return this.m_value;
        }
    }
}

