/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.MetadataColumn;

public class DiscriminatorColumnMetadata
extends MetadataColumn {
    public static final String NAME_DEFAULT = "DTYPE";
    private Integer m_length;
    private String m_discriminatorType;

    public DiscriminatorColumnMetadata() {
        super("<discriminator-column>");
    }

    public DiscriminatorColumnMetadata(MetadataAccessor accessor) {
        super(accessor);
    }

    public DiscriminatorColumnMetadata(MetadataAnnotation discriminatorColumn, MetadataAccessor accessor) {
        super(discriminatorColumn, accessor);
        if (discriminatorColumn != null) {
            this.m_length = discriminatorColumn.getAttributeInteger("length");
            this.m_discriminatorType = discriminatorColumn.getAttributeString("discriminatorType");
        }
    }

    protected DiscriminatorColumnMetadata(String xmlElement) {
        super(xmlElement);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof DiscriminatorColumnMetadata) {
            DiscriminatorColumnMetadata discriminatorColumn = (DiscriminatorColumnMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_length, discriminatorColumn.getLength())) {
                return false;
            }
            return this.valuesMatch(this.m_discriminatorType, discriminatorColumn.getDiscriminatorType());
        }
        return false;
    }

    public String getDiscriminatorType() {
        return this.m_discriminatorType;
    }

    @Override
    public DatabaseField getDatabaseField() {
        DatabaseField field2 = super.getDatabaseField();
        field2.setLength(MetadataHelper.getValue(this.m_length, 31));
        if (this.m_discriminatorType == null || this.m_discriminatorType.equals("STRING")) {
            field2.setType(String.class);
        } else if (this.m_discriminatorType.equals("CHAR")) {
            field2.setType(Character.class);
        } else {
            field2.setType(Integer.class);
        }
        return field2;
    }

    public Integer getLength() {
        return this.m_length;
    }

    public DatabaseField process(MetadataDescriptor descriptor, String loggingCtx) {
        DatabaseField field2 = this.getDatabaseField();
        this.setFieldName(field2, NAME_DEFAULT, loggingCtx);
        field2.setTable(descriptor.getPrimaryTable());
        return field2;
    }

    public void setDiscriminatorType(String descriminatorType) {
        this.m_discriminatorType = descriminatorType;
    }

    public void setLength(Integer length) {
        this.m_length = length;
    }
}

