/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.partitioning;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.descriptors.partitioning.RangePartition;
import org.eclipse.persistence.descriptors.partitioning.RangePartitioningPolicy;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.FieldPartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.RangePartitionMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public class RangePartitioningMetadata
extends FieldPartitioningMetadata {
    protected List<RangePartitionMetadata> partitions;

    public RangePartitioningMetadata() {
        super("<range-partitioning>");
    }

    public RangePartitioningMetadata(MetadataAnnotation annotation, MetadataAccessor accessor) {
        super(annotation, accessor);
        this.partitions = new ArrayList<RangePartitionMetadata>();
        Object[] objectArray = annotation.getAttributeArray("partitions");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object partitionAnnotation = objectArray[n2];
            this.partitions.add(new RangePartitionMetadata((MetadataAnnotation)partitionAnnotation, accessor));
            ++n2;
        }
    }

    @Override
    public PartitioningPolicy buildPolicy() {
        RangePartitioningPolicy policy = new RangePartitioningPolicy();
        super.buildPolicy(policy);
        for (RangePartitionMetadata partition2 : this.getPartitions()) {
            policy.addPartition(new RangePartition(partition2.getConnectionPool(), this.getPartitionValueType().getName(), partition2.getStartValue(), partition2.getEndValue()));
        }
        return policy;
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof RangePartitioningMetadata) {
            RangePartitioningMetadata policy = (RangePartitioningMetadata)objectToCompare;
            return this.valuesMatch(this.partitions, policy.getPartitions());
        }
        return false;
    }

    public List<RangePartitionMetadata> getPartitions() {
        return this.partitions;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.partitions, accessibleObject);
    }

    public void setPartitions(List<RangePartitionMetadata> partitions) {
        this.partitions = partitions;
    }
}

