/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import org.eclipse.persistence.internal.helper.ComplexDatabaseType;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.queries.ComplexTypeMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLRecordMetadata;

public abstract class PLSQLComplexTypeMetadata
extends ComplexTypeMetadata {
    private String compatibleType;
    private String javaType;

    public PLSQLComplexTypeMetadata(String element) {
        super(element);
    }

    public PLSQLComplexTypeMetadata(MetadataAnnotation record2, MetadataAccessor accessor) {
        super(record2, accessor);
        this.compatibleType = record2.getAttributeString("compatibleType");
        this.javaType = record2.getAttributeString("javaType");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof PLSQLRecordMetadata) {
            PLSQLRecordMetadata parameter = (PLSQLRecordMetadata)objectToCompare;
            if (!this.valuesMatch(this.name, parameter.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.compatibleType, parameter.getCompatibleType())) {
                return false;
            }
            return this.valuesMatch(this.javaType, parameter.getJavaType());
        }
        return false;
    }

    public String getCompatibleType() {
        return this.compatibleType;
    }

    public String getJavaType() {
        return this.javaType;
    }

    @Override
    protected void process(ComplexDatabaseType type) {
        type.setTypeName(this.name);
        type.setCompatibleType(this.compatibleType);
        if (this.javaType != null) {
            type.setJavaType(this.getJavaClass(this.getMetadataClass(this.javaType)));
        }
    }

    public void setCompatibleType(String compatibleType) {
        this.compatibleType = compatibleType;
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    @Override
    public boolean isPLSQLComplexTypeMetadata() {
        return true;
    }

    public boolean isPLSQLRecordMetadata() {
        return false;
    }

    public boolean isPLSQLTableMetadata() {
        return false;
    }
}

