/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.weaving;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarEntry;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.weaving.AbstractStaticWeaveOutputHandler;

public class StaticWeaveDirectoryOutputHandler
extends AbstractStaticWeaveOutputHandler {
    private URL source = null;
    private URL target = null;

    public StaticWeaveDirectoryOutputHandler(URL source, URL target) {
        this.source = source;
        this.target = target;
    }

    @Override
    public void addDirEntry(String dirPath) throws IOException {
        File file = new File(String.valueOf(this.target.getPath()) + File.separator + dirPath).getAbsoluteFile();
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    @Override
    public void addEntry(JarEntry targetEntry, byte[] entryBytes) throws IOException {
        FileOutputStream fos = null;
        try {
            File target = new File(String.valueOf(this.target.getPath()) + targetEntry.getName()).getAbsoluteFile();
            if (!target.exists()) {
                target.createNewFile();
            }
            fos = new FileOutputStream(target);
            fos.write(entryBytes);
        }
        catch (Throwable throwable) {
            Helper.close(fos);
            throw throwable;
        }
        Helper.close(fos);
    }

    @Override
    public void addEntry(InputStream jis, JarEntry entry2) throws IOException, URISyntaxException {
        File target = new File(String.valueOf(this.target.getPath()) + entry2.getName()).getAbsoluteFile();
        if (!target.exists()) {
            target.createNewFile();
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            if (new File(Helper.toURI(this.source)).isDirectory()) {
                File sourceEntry = new File(String.valueOf(this.source.getPath()) + entry2.getName());
                fis = new FileInputStream(sourceEntry);
                byte[] classBytes = new byte[fis.available()];
                fis.read(classBytes);
                fos = new FileOutputStream(target);
                fos.write(classBytes);
            } else {
                this.readwriteStreams(jis, new FileOutputStream(target));
            }
        }
        finally {
            Helper.close(fis);
            Helper.close(fos);
        }
    }
}

