/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime.misc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class Stats {
    public static final String ANTLRWORKS_DIR = "antlrworks";

    public static double stddev(int[] X) {
        int m3 = X.length;
        if (m3 <= 1) {
            return 0.0;
        }
        double xbar = Stats.avg(X);
        double s2 = 0.0;
        int i = 0;
        while (i < m3) {
            s2 += ((double)X[i] - xbar) * ((double)X[i] - xbar);
            ++i;
        }
        return Math.sqrt(s2 /= (double)(m3 - 1));
    }

    public static double avg(int[] X) {
        double xbar = 0.0;
        int m3 = X.length;
        if (m3 == 0) {
            return 0.0;
        }
        int i = 0;
        while (i < m3) {
            xbar += (double)X[i];
            ++i;
        }
        if (xbar >= 0.0) {
            return xbar / (double)m3;
        }
        return 0.0;
    }

    public static int min(int[] X) {
        int min2 = Integer.MAX_VALUE;
        int m3 = X.length;
        if (m3 == 0) {
            return 0;
        }
        int i = 0;
        while (i < m3) {
            if (X[i] < min2) {
                min2 = X[i];
            }
            ++i;
        }
        return min2;
    }

    public static int max(int[] X) {
        int max2 = Integer.MIN_VALUE;
        int m3 = X.length;
        if (m3 == 0) {
            return 0;
        }
        int i = 0;
        while (i < m3) {
            if (X[i] > max2) {
                max2 = X[i];
            }
            ++i;
        }
        return max2;
    }

    public static int sum(int[] X) {
        int s2 = 0;
        int m3 = X.length;
        if (m3 == 0) {
            return 0;
        }
        int i = 0;
        while (i < m3) {
            s2 += X[i];
            ++i;
        }
        return s2;
    }

    public static void writeReport(String filename, String data) throws IOException {
        String absoluteFilename = Stats.getAbsoluteFileName(filename);
        File f = new File(absoluteFilename);
        File parent = f.getParentFile();
        parent.mkdirs();
        FileOutputStream fos = new FileOutputStream(f, true);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        PrintStream ps = new PrintStream(bos);
        ps.println(data);
        ps.close();
        bos.close();
        fos.close();
    }

    public static String getAbsoluteFileName(String filename) {
        return String.valueOf(System.getProperty("user.home")) + File.separator + ANTLRWORKS_DIR + File.separator + filename;
    }
}

