/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm;

public class ByteVector {
    byte[] data;
    int length;

    public ByteVector() {
        this.data = new byte[64];
    }

    public ByteVector(int n) {
        this.data = new byte[n];
    }

    public ByteVector putByte(int n) {
        int n2 = this.length;
        if (n2 + 1 > this.data.length) {
            this.enlarge(1);
        }
        this.data[n2++] = (byte)n;
        this.length = n2;
        return this;
    }

    ByteVector put11(int n, int n2) {
        int n3 = this.length;
        if (n3 + 2 > this.data.length) {
            this.enlarge(2);
        }
        byte[] byArray = this.data;
        byArray[n3++] = (byte)n;
        byArray[n3++] = (byte)n2;
        this.length = n3;
        return this;
    }

    public ByteVector putShort(int n) {
        int n2 = this.length;
        if (n2 + 2 > this.data.length) {
            this.enlarge(2);
        }
        byte[] byArray = this.data;
        byArray[n2++] = (byte)(n >>> 8);
        byArray[n2++] = (byte)n;
        this.length = n2;
        return this;
    }

    ByteVector put12(int n, int n2) {
        int n3 = this.length;
        if (n3 + 3 > this.data.length) {
            this.enlarge(3);
        }
        byte[] byArray = this.data;
        byArray[n3++] = (byte)n;
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)n2;
        this.length = n3;
        return this;
    }

    public ByteVector putInt(int n) {
        int n2 = this.length;
        if (n2 + 4 > this.data.length) {
            this.enlarge(4);
        }
        byte[] byArray = this.data;
        byArray[n2++] = (byte)(n >>> 24);
        byArray[n2++] = (byte)(n >>> 16);
        byArray[n2++] = (byte)(n >>> 8);
        byArray[n2++] = (byte)n;
        this.length = n2;
        return this;
    }

    public ByteVector putLong(long l) {
        int n = this.length;
        if (n + 8 > this.data.length) {
            this.enlarge(8);
        }
        byte[] byArray = this.data;
        int n2 = (int)(l >>> 32);
        byArray[n++] = (byte)(n2 >>> 24);
        byArray[n++] = (byte)(n2 >>> 16);
        byArray[n++] = (byte)(n2 >>> 8);
        byArray[n++] = (byte)n2;
        n2 = (int)l;
        byArray[n++] = (byte)(n2 >>> 24);
        byArray[n++] = (byte)(n2 >>> 16);
        byArray[n++] = (byte)(n2 >>> 8);
        byArray[n++] = (byte)n2;
        this.length = n;
        return this;
    }

    public ByteVector putUTF8(String string2) {
        int n = this.length;
        int n2 = string2.length();
        if (n + 2 + n2 > this.data.length) {
            this.enlarge(2 + n2);
        }
        byte[] byArray = this.data;
        byArray[n++] = (byte)(n2 >>> 8);
        byArray[n++] = (byte)n2;
        for (int i = 0; i < n2; ++i) {
            int n3;
            char c = string2.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n++] = (byte)c;
                continue;
            }
            int n4 = i;
            for (n3 = i; n3 < n2; ++n3) {
                c = string2.charAt(n3);
                if (c >= '\u0001' && c <= '\u007f') {
                    ++n4;
                    continue;
                }
                if (c > '\u07ff') {
                    n4 += 3;
                    continue;
                }
                n4 += 2;
            }
            byArray[this.length] = (byte)(n4 >>> 8);
            byArray[this.length + 1] = (byte)n4;
            if (this.length + 2 + n4 > byArray.length) {
                this.length = n;
                this.enlarge(2 + n4);
                byArray = this.data;
            }
            for (n3 = i; n3 < n2; ++n3) {
                c = string2.charAt(n3);
                if (c >= '\u0001' && c <= '\u007f') {
                    byArray[n++] = (byte)c;
                    continue;
                }
                if (c > '\u07ff') {
                    byArray[n++] = (byte)(0xE0 | c >> 12 & 0xF);
                    byArray[n++] = (byte)(0x80 | c >> 6 & 0x3F);
                    byArray[n++] = (byte)(0x80 | c & 0x3F);
                    continue;
                }
                byArray[n++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n++] = (byte)(0x80 | c & 0x3F);
            }
            break;
        }
        this.length = n;
        return this;
    }

    public ByteVector putByteArray(byte[] byArray, int n, int n2) {
        if (this.length + n2 > this.data.length) {
            this.enlarge(n2);
        }
        if (byArray != null) {
            System.arraycopy(byArray, n, this.data, this.length, n2);
        }
        this.length += n2;
        return this;
    }

    private void enlarge(int n) {
        int n2 = 2 * this.data.length;
        int n3 = this.length + n;
        byte[] byArray = new byte[n2 > n3 ? n2 : n3];
        System.arraycopy(this.data, 0, byArray, 0, this.length);
        this.data = byArray;
    }
}

