/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.FieldVisitor;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.tree.AnnotationNode;
import org.eclipse.persistence.internal.libraries.asm.tree.FieldNode;
import org.eclipse.persistence.internal.libraries.asm.tree.InnerClassNode;
import org.eclipse.persistence.internal.libraries.asm.tree.MemberNode;
import org.eclipse.persistence.internal.libraries.asm.tree.MethodNode;

public class ClassNode
extends MemberNode
implements ClassVisitor {
    public int version;
    public int access;
    public String name;
    public String signature;
    public String superName;
    public List interfaces = new ArrayList();
    public String sourceFile;
    public String sourceDebug;
    public String outerClass;
    public String outerMethod;
    public String outerMethodDesc;
    public List innerClasses = new ArrayList();
    public List fields = new ArrayList();
    public List methods = new ArrayList();

    public void visit(int n, int n2, String string2, String string3, String string4, String[] stringArray) {
        this.version = n;
        this.access = n2;
        this.name = string2;
        this.signature = string3;
        this.superName = string4;
        if (stringArray != null) {
            this.interfaces.addAll(Arrays.asList(stringArray));
        }
    }

    public void visitSource(String string2, String string3) {
        this.sourceFile = string2;
        this.sourceDebug = string3;
    }

    public void visitOuterClass(String string2, String string3, String string4) {
        this.outerClass = string2;
        this.outerMethod = string3;
        this.outerMethodDesc = string4;
    }

    public void visitInnerClass(String string2, String string3, String string4, int n) {
        InnerClassNode innerClassNode = new InnerClassNode(string2, string3, string4, n);
        this.innerClasses.add(innerClassNode);
    }

    public FieldVisitor visitField(int n, String string2, String string3, String string4, Object object) {
        FieldNode fieldNode = new FieldNode(n, string2, string3, string4, object);
        this.fields.add(fieldNode);
        return fieldNode;
    }

    public MethodVisitor visitMethod(int n, String string2, String string3, String string4, String[] stringArray) {
        MethodNode methodNode = new MethodNode(n, string2, string3, string4, stringArray);
        this.methods.add(methodNode);
        return methodNode;
    }

    public void accept(ClassVisitor classVisitor) {
        AnnotationNode annotationNode;
        int n;
        String[] stringArray = new String[this.interfaces.size()];
        this.interfaces.toArray(stringArray);
        classVisitor.visit(this.version, this.access, this.name, this.signature, this.superName, stringArray);
        if (this.sourceFile != null || this.sourceDebug != null) {
            classVisitor.visitSource(this.sourceFile, this.sourceDebug);
        }
        if (this.outerClass != null) {
            classVisitor.visitOuterClass(this.outerClass, this.outerMethod, this.outerMethodDesc);
        }
        int n2 = this.visibleAnnotations == null ? 0 : this.visibleAnnotations.size();
        for (n = 0; n < n2; ++n) {
            annotationNode = (AnnotationNode)this.visibleAnnotations.get(n);
            annotationNode.accept(classVisitor.visitAnnotation(annotationNode.desc, true));
        }
        n2 = this.invisibleAnnotations == null ? 0 : this.invisibleAnnotations.size();
        for (n = 0; n < n2; ++n) {
            annotationNode = (AnnotationNode)this.invisibleAnnotations.get(n);
            annotationNode.accept(classVisitor.visitAnnotation(annotationNode.desc, false));
        }
        n2 = this.attrs == null ? 0 : this.attrs.size();
        for (n = 0; n < n2; ++n) {
            classVisitor.visitAttribute((Attribute)this.attrs.get(n));
        }
        for (n = 0; n < this.innerClasses.size(); ++n) {
            ((InnerClassNode)this.innerClasses.get(n)).accept(classVisitor);
        }
        for (n = 0; n < this.fields.size(); ++n) {
            ((FieldNode)this.fields.get(n)).accept(classVisitor);
        }
        for (n = 0; n < this.methods.size(); ++n) {
            ((MethodNode)this.methods.get(n)).accept(classVisitor);
        }
        classVisitor.visitEnd();
    }
}

