/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.XMLTransformationRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;
import org.eclipse.persistence.oxm.XMLField;

public class FieldTransformerNodeValue
extends NodeValue {
    private FieldTransformer fieldTransformer;
    private Field xmlField;

    public FieldTransformer getFieldTransformer() {
        return this.fieldTransformer;
    }

    public void setFieldTransformer(FieldTransformer fieldTransformer) {
        this.fieldTransformer = fieldTransformer;
    }

    public Field getXMLField() {
        return this.xmlField;
    }

    public void setXMLField(Field xmlField) {
        this.xmlField = xmlField;
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver) {
        return this.marshal(xPathFragment, marshalRecord, object, session, namespaceResolver, ObjectMarshalContext.getInstance());
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        Object value2 = this.fieldTransformer.buildFieldValue(object, this.getXMLField().getXPath(), (AbstractSession)session);
        return this.marshalSingleValue(xPathFragment, marshalRecord, object, value2, session, namespaceResolver, marshalContext);
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value2, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (value2 == null) {
            return false;
        }
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        if (this.getXMLField().getLastXPathFragment().isAttribute()) {
            marshalRecord.add(this.getXMLField(), value2);
            marshalRecord.closeStartGroupingElements(groupingFragment);
        } else {
            marshalRecord.closeStartGroupingElements(groupingFragment);
            marshalRecord.add(this.getXMLField(), value2);
        }
        return true;
    }

    @Override
    public void attribute(UnmarshalRecord unmarshalRecord, String namespaceURI, String localName, String value2) {
        XMLConversionManager xmlConversionManager = (XMLConversionManager)((CoreAbstractSession)unmarshalRecord.getSession()).getDatasourcePlatform().getConversionManager();
        Object objectValue = unmarshalRecord.getXMLReader().convertValueBasedOnSchemaType(this.xmlField, value2, xmlConversionManager, unmarshalRecord);
        if (unmarshalRecord.getTransformationRecord() == null) {
            unmarshalRecord.setTransformationRecord(new XMLTransformationRecord("ROOT", unmarshalRecord));
        }
        unmarshalRecord.getTransformationRecord().put((Object)this.xmlField, objectValue);
    }

    @Override
    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        Object value2 = unmarshalRecord.getCharacters().toString();
        boolean isCDATA = unmarshalRecord.isBufferCDATA();
        unmarshalRecord.resetStringBuffer();
        Field toWrite = this.xmlField;
        if (this.xmlField.isCDATA() != isCDATA) {
            toWrite = new XMLField(this.xmlField.getName());
            toWrite.setNamespaceResolver(this.xmlField.getNamespaceResolver());
            toWrite.setIsCDATA(isCDATA);
        }
        XMLConversionManager xmlConversionManager = (XMLConversionManager)((CoreAbstractSession)unmarshalRecord.getSession()).getDatasourcePlatform().getConversionManager();
        if (unmarshalRecord.getTypeQName() != null) {
            Class typeClass = this.xmlField.getJavaClass(unmarshalRecord.getTypeQName());
            value2 = xmlConversionManager.convertObject(value2, typeClass, unmarshalRecord.getTypeQName());
        } else {
            value2 = unmarshalRecord.getXMLReader().convertValueBasedOnSchemaType(this.xmlField, value2, xmlConversionManager, unmarshalRecord);
        }
        if (unmarshalRecord.getTransformationRecord() == null) {
            unmarshalRecord.setTransformationRecord(new XMLTransformationRecord("ROOT", unmarshalRecord));
        }
        unmarshalRecord.getTransformationRecord().put((Object)toWrite, value2);
    }
}

