/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.Context;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.Marshaller;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.CollectionReferenceMapping;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.xml.sax.Attributes;

public class XMLCollectionReferenceMappingNodeValue
extends MappingNodeValue
implements ContainerValue {
    private CollectionReferenceMapping xmlCollectionReferenceMapping;
    private Field xmlField;
    private static final String SPACE = " ";
    private int index = -1;

    public XMLCollectionReferenceMappingNodeValue(CollectionReferenceMapping xmlCollectionReferenceMapping, Field xmlField) {
        this.xmlCollectionReferenceMapping = xmlCollectionReferenceMapping;
        this.xmlField = xmlField;
    }

    @Override
    public void attribute(UnmarshalRecord unmarshalRecord, String namespaceURI, String localName, String value2) {
        if (value2 != null) {
            Object realValue = unmarshalRecord.getXMLReader().convertValueBasedOnSchemaType(this.xmlField, value2, (XMLConversionManager)((CoreAbstractSession)unmarshalRecord.getSession()).getDatasourcePlatform().getConversionManager(), unmarshalRecord);
            Object container = unmarshalRecord.getContainerInstance(this);
            this.xmlCollectionReferenceMapping.buildReference(unmarshalRecord, this.xmlField, realValue, unmarshalRecord.getSession(), container);
        }
    }

    @Override
    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        if (!this.xmlField.getLastXPathFragment().nameIsText()) {
            return;
        }
        Object value2 = unmarshalRecord.getCharacters().toString();
        unmarshalRecord.resetStringBuffer();
        XMLConversionManager xmlConversionManager = (XMLConversionManager)((CoreAbstractSession)unmarshalRecord.getSession()).getDatasourcePlatform().getConversionManager();
        if (unmarshalRecord.getTypeQName() != null) {
            Class typeClass = this.xmlField.getJavaClass(unmarshalRecord.getTypeQName());
            value2 = xmlConversionManager.convertObject(value2, typeClass, unmarshalRecord.getTypeQName());
        } else {
            value2 = unmarshalRecord.getXMLReader().convertValueBasedOnSchemaType(this.xmlField, value2, xmlConversionManager, unmarshalRecord);
        }
        Object container = unmarshalRecord.getContainerInstance(this);
        this.xmlCollectionReferenceMapping.buildReference(unmarshalRecord, this.xmlField, value2, unmarshalRecord.getSession(), container);
    }

    @Override
    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Object container) {
        this.endElement(xPathFragment, unmarshalRecord);
    }

    @Override
    public boolean isOwningNode(XPathFragment xPathFragment) {
        if (this.isMarshalNodeValue()) {
            if (this.xmlCollectionReferenceMapping.usesSingleNode()) {
                return xPathFragment.nameIsText() || xPathFragment.isAttribute();
            }
            XPathFragment nextFragment = xPathFragment.getNextFragment();
            return nextFragment != null && (nextFragment.nameIsText() || nextFragment.isAttribute());
        }
        return super.isOwningNode(xPathFragment);
    }

    @Override
    public boolean isWrapperAllowedAsCollectionName() {
        return true;
    }

    @Override
    public boolean isContainerValue() {
        return true;
    }

    @Override
    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    @Override
    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlCollectionReferenceMapping.setAttributeValueInObject(object, containerInstance);
    }

    @Override
    public CoreContainerPolicy getContainerPolicy() {
        return this.xmlCollectionReferenceMapping.getContainerPolicy();
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver) {
        Object objectValue;
        if (this.xmlCollectionReferenceMapping.isReadOnly()) {
            return false;
        }
        Object cp = this.xmlCollectionReferenceMapping.getContainerPolicy();
        Object collection = this.xmlCollectionReferenceMapping.getAttributeAccessor().getAttributeValueFromObject(object);
        if (collection == null) {
            return false;
        }
        Object iterator2 = cp.iteratorFor(collection);
        if (!cp.hasNext(iterator2)) {
            return marshalRecord.emptyCollection(xPathFragment, namespaceResolver, false);
        }
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        marshalRecord.closeStartGroupingElements(groupingFragment);
        if (this.xmlCollectionReferenceMapping.usesSingleNode()) {
            StringBuilder stringValueStringBuilder = new StringBuilder();
            while (cp.hasNext(iterator2)) {
                QName schemaType;
                String newValue;
                objectValue = cp.next(iterator2, (CoreAbstractSession)session);
                Object fieldValue = this.xmlCollectionReferenceMapping.buildFieldValue(objectValue, this.xmlField, session);
                if (fieldValue == null) {
                    if (objectValue != null) {
                        Field fkField = (Field)this.xmlCollectionReferenceMapping.getSourceToTargetKeyFieldAssociations().get(this.xmlField);
                        fieldValue = ((Context)((Marshaller)marshalRecord.getMarshaller()).getContext()).getValueByXPath(objectValue, fkField.getXPath(), fkField.getNamespaceResolver(), Object.class);
                    }
                    if (fieldValue == null) break;
                }
                if ((newValue = marshalRecord.getValueToWrite(schemaType = this.xmlField.getSchemaTypeForValue(fieldValue, session), fieldValue, (XMLConversionManager)session.getDatasourcePlatform().getConversionManager())) == null) continue;
                stringValueStringBuilder.append(newValue);
                if (!cp.hasNext(iterator2)) continue;
                stringValueStringBuilder.append(SPACE);
            }
            this.marshalSingleValue(xPathFragment, marshalRecord, object, stringValueStringBuilder.toString(), session, namespaceResolver, ObjectMarshalContext.getInstance());
        } else {
            marshalRecord.startCollection();
            while (cp.hasNext(iterator2)) {
                objectValue = cp.next(iterator2, (CoreAbstractSession)session);
                this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
            }
            marshalRecord.endCollection();
        }
        return true;
    }

    @Override
    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        if (this.xmlField.getLastXPathFragment().isAttribute() && !this.xmlCollectionReferenceMapping.usesSingleNode()) {
            String namespaceURI = this.xmlField.getLastXPathFragment().getNamespaceURI();
            String value2 = namespaceURI == null ? atts.getValue(this.xmlField.getLastXPathFragment().getLocalName()) : atts.getValue(namespaceURI, this.xmlField.getLastXPathFragment().getLocalName());
            this.xmlCollectionReferenceMapping.buildReference(unmarshalRecord, this.xmlField, value2, unmarshalRecord.getSession(), unmarshalRecord.getContainerInstance(this));
            return true;
        }
        return true;
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value2, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (this.xmlCollectionReferenceMapping.usesSingleNode()) {
            XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
            if (xPathFragment.isAttribute()) {
                marshalRecord.attribute(xPathFragment, namespaceResolver, (Object)((String)value2), null);
                marshalRecord.closeStartGroupingElements(groupingFragment);
            } else {
                marshalRecord.closeStartGroupingElements(groupingFragment);
                marshalRecord.characters(null, (String)value2, null, false);
            }
        } else {
            Object fieldValue = this.xmlCollectionReferenceMapping.buildFieldValue(value2, this.xmlField, session);
            if (fieldValue == null) {
                return false;
            }
            QName schemaType = this.xmlField.getSchemaTypeForValue(fieldValue, session);
            marshalRecord.openStartElement(xPathFragment, namespaceResolver);
            XPathFragment nextFragment = xPathFragment.getNextFragment();
            if (nextFragment.isAttribute()) {
                marshalRecord.attribute(nextFragment, namespaceResolver, fieldValue, schemaType);
                marshalRecord.closeStartElement();
            } else {
                marshalRecord.predicateAttribute(xPathFragment, namespaceResolver);
                marshalRecord.closeStartElement();
                marshalRecord.characters(schemaType, fieldValue, null, false);
            }
            marshalRecord.endElement(xPathFragment, namespaceResolver);
        }
        return true;
    }

    @Override
    public CollectionReferenceMapping getMapping() {
        return this.xmlCollectionReferenceMapping;
    }

    @Override
    public boolean getReuseContainer() {
        return this.getMapping().getReuseContainer();
    }

    @Override
    public boolean isMarshalNodeValue() {
        return this.xmlCollectionReferenceMapping.getFields().size() == 1 || this.xmlCollectionReferenceMapping.usesSingleNode();
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isDefaultEmptyContainer() {
        return this.getMapping().isDefaultEmptyContainer();
    }
}

