/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.core.queries.CoreAttributeGroup;
import org.eclipse.persistence.core.queries.CoreAttributeItem;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.Context;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.ObjectBuilder;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.SAXFragmentBuilder;
import org.eclipse.persistence.internal.oxm.Unmarshaller;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLRelationshipMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.CompositeCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.mappings.InverseReferenceMapping;
import org.eclipse.persistence.internal.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.oxm.record.XMLRecord;
import org.eclipse.persistence.internal.oxm.record.deferred.CompositeCollectionMappingContentHandler;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLCompositeCollectionMappingNodeValue
extends XMLRelationshipMappingNodeValue
implements ContainerValue {
    private CompositeCollectionMapping xmlCompositeCollectionMapping;
    private int index = -1;
    private boolean isInverseReference;

    public XMLCompositeCollectionMappingNodeValue(CompositeCollectionMapping xmlCompositeCollectionMapping) {
        this.xmlCompositeCollectionMapping = xmlCompositeCollectionMapping;
    }

    public XMLCompositeCollectionMappingNodeValue(CompositeCollectionMapping xmlCompositeCollectionMapping, boolean isInverse) {
        this(xmlCompositeCollectionMapping);
        this.isInverseReference = isInverse;
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver) {
        Object iterator2;
        if (this.xmlCompositeCollectionMapping.isReadOnly()) {
            return false;
        }
        Object collection = this.xmlCompositeCollectionMapping.getAttributeAccessor().getAttributeValueFromObject(object);
        if (collection == null) {
            AbstractNullPolicy wrapperNP = this.xmlCompositeCollectionMapping.getWrapperNullPolicy();
            if (wrapperNP != null && wrapperNP.getMarshalNullRepresentation() == XMLNullRepresentationType.XSI_NIL) {
                marshalRecord.nilSimple(namespaceResolver);
                return true;
            }
            return false;
        }
        CoreContainerPolicy cp = this.getContainerPolicy();
        int size2 = marshalRecord.getCycleDetectionStack().size();
        if ((this.isInverseReference || this.xmlCompositeCollectionMapping.getInverseReferenceMapping() != null) && size2 >= 2) {
            Object owner = marshalRecord.getCycleDetectionStack().get(size2 - 2);
            try {
                if (cp.contains(owner, collection, session)) {
                    return false;
                }
            }
            catch (ClassCastException classCastException) {}
        }
        if ((iterator2 = cp.iteratorFor(collection)) == null || !cp.hasNext(iterator2)) {
            return marshalRecord.emptyCollection(xPathFragment, namespaceResolver, this.xmlCompositeCollectionMapping.getWrapperNullPolicy() != null);
        }
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        marshalRecord.closeStartGroupingElements(groupingFragment);
        marshalRecord.startCollection();
        iterator2 = cp.iteratorFor(collection);
        while (cp.hasNext(iterator2)) {
            Object objectValue = cp.next(iterator2, session);
            this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
        }
        marshalRecord.endCollection();
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        try {
            void var4_8;
            AbstractNullPolicy nullPolicy;
            Descriptor descriptor = (Descriptor)this.xmlCompositeCollectionMapping.getReferenceDescriptor();
            if (descriptor == null) {
                void var4_7;
                Object policy;
                Descriptor descriptor2 = this.findReferenceDescriptor(xPathFragment, unmarshalRecord, atts, this.xmlCompositeCollectionMapping, (UnmarshalKeepAsElementPolicy)this.xmlCompositeCollectionMapping.getKeepAsElementPolicy());
                if (descriptor2 == null) {
                    QName leafType;
                    if (unmarshalRecord.getXMLReader().isNullRepresentedByXsiNil(this.xmlCompositeCollectionMapping.getNullPolicy())) {
                        if (unmarshalRecord.isNil()) {
                            return true;
                        }
                    } else if (this.xmlCompositeCollectionMapping.getNullPolicy().valueIsNull(atts)) {
                        this.getContainerPolicy().addInto(null, unmarshalRecord.getContainerInstance(this), unmarshalRecord.getSession());
                        return true;
                    }
                    if (this.xmlCompositeCollectionMapping.getField() != null && (leafType = ((Field)this.xmlCompositeCollectionMapping.getField()).getLastXPathFragment().getLeafElementType()) != null) {
                        XPathFragment frag = new XPathFragment();
                        frag.setNamespaceAware(unmarshalRecord.isNamespaceAware());
                        String xpath = leafType.getLocalPart();
                        String uri = leafType.getNamespaceURI();
                        if (uri != null && uri.length() > 0) {
                            frag.setNamespaceURI(uri);
                            String prefix = ((NamespaceResolver)((Descriptor)this.xmlCompositeCollectionMapping.getDescriptor()).getNonNullNamespaceResolver()).resolveNamespaceURI(uri);
                            if (prefix != null && prefix.length() > 0) {
                                xpath = String.valueOf(prefix) + ':' + xpath;
                            }
                        }
                        frag.setXPath(xpath);
                        Object xmlContext = ((Unmarshaller)unmarshalRecord.getUnmarshaller()).getContext();
                        Object DESCRIPTOR = ((Context)xmlContext).getDescriptorByGlobalType(frag);
                    }
                }
                if ((policy = this.xmlCompositeCollectionMapping.getKeepAsElementPolicy()) != null && (var4_7 == null && policy.isKeepUnknownAsElement() || policy.isKeepAllAsElement())) {
                    if (unmarshalRecord.getTypeQName() == null) {
                        this.setupHandlerForKeepAsElementPolicy(unmarshalRecord, xPathFragment, atts);
                        return true;
                    }
                    XMLConversionManager cfr_ignored_0 = (XMLConversionManager)((CoreAbstractSession)unmarshalRecord.getSession()).getDatasourcePlatform().getConversionManager();
                    Class theClass = (Class)XMLConversionManager.getDefaultXMLTypes().get(unmarshalRecord.getTypeQName());
                    if (theClass == null) {
                        this.setupHandlerForKeepAsElementPolicy(unmarshalRecord, xPathFragment, atts);
                        return true;
                    }
                }
            }
            if ((nullPolicy = this.xmlCompositeCollectionMapping.getNullPolicy()).isNullRepresentedByEmptyNode()) {
                String qnameString = xPathFragment.getLocalName();
                if (xPathFragment.getPrefix() != null) {
                    qnameString = String.valueOf(xPathFragment.getPrefix()) + ':' + qnameString;
                }
                if (var4_8 == null) return true;
                CompositeCollectionMappingContentHandler aHandler = new CompositeCollectionMappingContentHandler(unmarshalRecord, this, this.xmlCompositeCollectionMapping, atts, xPathFragment, (Descriptor)var4_8);
                aHandler.startElement(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), qnameString, atts);
                XMLReader xmlReader = unmarshalRecord.getXMLReader();
                xmlReader.setContentHandler(aHandler);
                xmlReader.setLexicalHandler(aHandler);
                return true;
            }
            if (unmarshalRecord.getXMLReader().isNullRecord(nullPolicy, atts, unmarshalRecord)) return true;
            Field xmlFld = (Field)this.xmlCompositeCollectionMapping.getField();
            if (xmlFld.hasLastXPathFragment()) {
                unmarshalRecord.setLeafElementType(xmlFld.getLastXPathFragment().getLeafElementType());
            }
            this.processChild(xPathFragment, unmarshalRecord, atts, (Descriptor)var4_8, this.xmlCompositeCollectionMapping);
            return true;
        }
        catch (SAXException sAXException) {
            throw XMLMarshalException.unmarshalException(sAXException);
        }
    }

    @Override
    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        Object collection = unmarshalRecord.getContainerInstance(this);
        this.endElement(xPathFragment, unmarshalRecord, collection);
    }

    @Override
    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Object collection) {
        if (unmarshalRecord.isNil() && unmarshalRecord.getXMLReader().isNullRepresentedByXsiNil(this.xmlCompositeCollectionMapping.getNullPolicy()) && unmarshalRecord.getChildRecord() == null) {
            if (unmarshalRecord.getXMLReader().isInCollection()) {
                unmarshalRecord.addAttributeValue(this, null);
            } else {
                unmarshalRecord.setAttributeValueNull(this);
            }
            unmarshalRecord.resetStringBuffer();
            return;
        }
        if (unmarshalRecord.getChildRecord() == null) {
            SAXFragmentBuilder builder = unmarshalRecord.getFragmentBuilder();
            Object keepAsElementPolicy = this.xmlCompositeCollectionMapping.getKeepAsElementPolicy();
            if (keepAsElementPolicy != null && (keepAsElementPolicy.isKeepUnknownAsElement() || keepAsElementPolicy.isKeepAllAsElement()) && builder.getNodes().size() > 1) {
                if (unmarshalRecord.getTypeQName() != null) {
                    XMLConversionManager cfr_ignored_0 = (XMLConversionManager)((CoreAbstractSession)unmarshalRecord.getSession()).getDatasourcePlatform().getConversionManager();
                    Class theClass = (Class)XMLConversionManager.getDefaultXMLTypes().get(unmarshalRecord.getTypeQName());
                    if (theClass != null) {
                        this.endElementProcessText(unmarshalRecord, this.xmlCompositeCollectionMapping, xPathFragment, collection);
                        return;
                    }
                }
                if (builder.getNodes().size() > 1) {
                    this.setOrAddAttributeValueForKeepAsElement(builder, this.xmlCompositeCollectionMapping, this.xmlCompositeCollectionMapping, unmarshalRecord, true, collection);
                    return;
                }
            } else {
                this.endElementProcessText(unmarshalRecord, this.xmlCompositeCollectionMapping, xPathFragment, collection);
                return;
            }
            return;
        }
        Object objectValue = unmarshalRecord.getChildRecord().getCurrentObject();
        InverseReferenceMapping inverseReferenceMapping = this.xmlCompositeCollectionMapping.getInverseReferenceMapping();
        if (inverseReferenceMapping != null) {
            if (inverseReferenceMapping.getContainerPolicy() == null) {
                Object currentValue = inverseReferenceMapping.getAttributeAccessor().getAttributeValueFromObject(objectValue);
                if (!this.isInverseReference || currentValue == null && this.isInverseReference) {
                    inverseReferenceMapping.getAttributeAccessor().setAttributeValueInObject(objectValue, unmarshalRecord.getCurrentObject());
                }
            } else {
                Object backpointerContainer = inverseReferenceMapping.getAttributeAccessor().getAttributeValueFromObject(objectValue);
                if (backpointerContainer == null) {
                    backpointerContainer = inverseReferenceMapping.getContainerPolicy().containerInstance();
                    inverseReferenceMapping.getAttributeAccessor().setAttributeValueInObject(objectValue, backpointerContainer);
                }
                inverseReferenceMapping.getContainerPolicy().addInto(unmarshalRecord.getCurrentObject(), backpointerContainer, unmarshalRecord.getSession());
            }
        }
        objectValue = this.xmlCompositeCollectionMapping.convertDataValueToObjectValue(objectValue, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller());
        unmarshalRecord.addAttributeValue(this, objectValue, collection);
        unmarshalRecord.setChildRecord(null);
    }

    @Override
    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    @Override
    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlCompositeCollectionMapping.setAttributeValueInObject(object, containerInstance);
    }

    @Override
    public CoreContainerPolicy getContainerPolicy() {
        return this.xmlCompositeCollectionMapping.getContainerPolicy();
    }

    @Override
    public boolean isContainerValue() {
        return true;
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value2, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        Class<?> objectValueClass;
        Object marshaller = marshalRecord.getMarshaller();
        boolean isNil = false;
        if (value2 instanceof Root) {
            isNil = ((Root)value2).nil;
            value2 = ((Root)value2).getObject();
        }
        if ((value2 = this.xmlCompositeCollectionMapping.convertObjectValueToDataValue(value2, session, marshaller)) == null) {
            return this.xmlCompositeCollectionMapping.getNullPolicy().compositeObjectMarshal(xPathFragment, marshalRecord, object, session, namespaceResolver);
        }
        Descriptor descriptor = (Descriptor)this.xmlCompositeCollectionMapping.getReferenceDescriptor();
        if (descriptor == null) {
            descriptor = (Descriptor)session.getDescriptor(value2.getClass());
        } else if (descriptor.hasInheritance() && (objectValueClass = value2.getClass()) != descriptor.getJavaClass()) {
            descriptor = (Descriptor)session.getDescriptor(objectValueClass);
        }
        Object keepAsElementPolicy = this.xmlCompositeCollectionMapping.getKeepAsElementPolicy();
        if (keepAsElementPolicy != null && (keepAsElementPolicy.isKeepUnknownAsElement() || keepAsElementPolicy.isKeepAllAsElement()) && value2 instanceof Node) {
            marshalRecord.node((Node)value2, marshalRecord.getNamespaceResolver());
            return true;
        }
        if (descriptor != null) {
            marshalRecord.beforeContainmentMarshal(value2);
            ObjectBuilder objectBuilder = (ObjectBuilder)descriptor.getObjectBuilder();
            CoreAttributeGroup group = marshalRecord.getCurrentAttributeGroup();
            CoreAttributeGroup<Object> nestedGroup = XMLRecord.DEFAULT_ATTRIBUTE_GROUP;
            Object item = group.getItem(this.getMapping().getAttributeName());
            if (item != null) {
                if (((CoreAttributeItem)item).getGroups() != null) {
                    nestedGroup = ((CoreAttributeItem)item).getGroup(descriptor.getJavaClass());
                }
                if (nestedGroup == null) {
                    nestedGroup = ((CoreAttributeItem)item).getGroup() == null ? XMLRecord.DEFAULT_ATTRIBUTE_GROUP : ((CoreAttributeItem)item).getGroup();
                }
            }
            marshalRecord.pushAttributeGroup(nestedGroup);
            this.xPathNode.startElement(marshalRecord, xPathFragment, object, session, namespaceResolver, objectBuilder, value2);
            if (isNil) {
                marshalRecord.nilSimple(namespaceResolver);
            }
            List extraNamespaces = objectBuilder.addExtraNamespacesToNamespaceResolver(descriptor, marshalRecord, session, true, false);
            this.writeExtraNamespaces(extraNamespaces, marshalRecord, session);
            marshalRecord.addXsiTypeAndClassIndicatorIfRequired(descriptor, (Descriptor)this.xmlCompositeCollectionMapping.getReferenceDescriptor(), (Field)this.xmlCompositeCollectionMapping.getField(), false);
            objectBuilder.buildRow(marshalRecord, value2, session, marshaller, xPathFragment);
            marshalRecord.afterContainmentMarshal(object, value2);
            marshalRecord.popAttributeGroup();
            marshalRecord.endElement(xPathFragment, namespaceResolver);
            marshalRecord.removeExtraNamespacesFromNamespaceResolver(extraNamespaces, session);
        } else {
            if ("UNKNOWN_OR_TRANSIENT_CLASS".equals(this.xmlCompositeCollectionMapping.getReferenceClassName())) {
                throw XMLMarshalException.descriptorNotFoundInProject(value2.getClass().getName());
            }
            this.xPathNode.startElement(marshalRecord, xPathFragment, object, session, namespaceResolver, null, value2);
            QName schemaType = ((Field)this.xmlCompositeCollectionMapping.getField()).getSchemaTypeForValue(value2, session);
            this.updateNamespaces(schemaType, marshalRecord, (Field)this.xmlCompositeCollectionMapping.getField());
            marshalRecord.characters(schemaType, value2, null, false);
            marshalRecord.endElement(xPathFragment, namespaceResolver);
        }
        return true;
    }

    @Override
    public CompositeCollectionMapping getMapping() {
        return this.xmlCompositeCollectionMapping;
    }

    @Override
    protected void setOrAddAttributeValue(UnmarshalRecord unmarshalRecord, Object value2, XPathFragment xPathFragment, Object collection) {
        unmarshalRecord.addAttributeValue(this, value2, collection);
    }

    @Override
    public boolean getReuseContainer() {
        return this.xmlCompositeCollectionMapping.getReuseContainer();
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isDefaultEmptyContainer() {
        return this.xmlCompositeCollectionMapping.isDefaultEmptyContainer();
    }

    @Override
    public boolean isWrapperAllowedAsCollectionName() {
        return true;
    }
}

