/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.querykeys.QueryKey;

public abstract class InterfaceContainerPolicy
extends ContainerPolicy {
    protected Class containerClass;
    protected String containerClassName;
    protected transient Method cloneMethod;

    public InterfaceContainerPolicy() {
    }

    public InterfaceContainerPolicy(Class containerClass) {
        this.setContainerClass(containerClass);
    }

    public InterfaceContainerPolicy(String containerClassName) {
        this.setContainerClassName(containerClassName);
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.getContainerClass().equals(((InterfaceContainerPolicy)object).getContainerClass());
    }

    @Override
    public Object cloneFor(Object container) {
        if (container == null) {
            return null;
        }
        try {
            return this.invokeCloneMethodOn(this.getCloneMethod(), container);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.invokeCloneMethodOn(this.getCloneMethod(container.getClass()), container);
        }
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Class containerClass;
        block6: {
            super.convertClassNamesToClasses(classLoader);
            if (this.getContainerClassName() == null) {
                return;
            }
            containerClass = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        containerClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getContainerClassName(), true, classLoader));
                        break block6;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.getContainerClassName(), exception.getException());
                    }
                }
                containerClass = PrivilegedAccessHelper.getClassForName(this.getContainerClassName(), true, classLoader);
            }
            catch (ClassNotFoundException exception) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.getContainerClassName(), exception);
            }
        }
        this.setContainerClass(containerClass);
    }

    @Override
    public CollectionChangeEvent createChangeEvent(Object collectionOwner, String propertyName, Object collectionChanged, Object elementChanged, int changeType, Integer index, boolean isChangeApplied) {
        return new CollectionChangeEvent(collectionOwner, propertyName, collectionChanged, elementChanged, changeType, index, false, isChangeApplied);
    }

    public QueryKey createQueryKeyForMapKey() {
        return null;
    }

    public Method getCloneMethod() {
        if (this.cloneMethod == null) {
            this.setCloneMethod(this.getCloneMethod(this.getContainerClass()));
        }
        return this.cloneMethod;
    }

    protected Method getCloneMethod(Class javaClass) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedGetMethod(javaClass, "clone", null, false));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw QueryException.methodDoesNotExistInContainerClass("clone", javaClass);
                }
            }
            return PrivilegedAccessHelper.getMethod(javaClass, "clone", null, false);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw QueryException.methodDoesNotExistInContainerClass("clone", javaClass);
        }
    }

    @Override
    public Class getContainerClass() {
        return this.containerClass;
    }

    @Override
    public String getContainerClassName() {
        if (this.containerClassName == null && this.containerClass != null) {
            this.containerClassName = this.containerClass.getName();
        }
        return this.containerClassName;
    }

    public DatabaseField getDirectKeyField(CollectionMapping mapping) {
        return null;
    }

    public abstract Class getInterfaceType();

    @Override
    public boolean hasNext(Object iterator2) {
        return ((Iterator)iterator2).hasNext();
    }

    protected Object invokeCloneMethodOn(Method method, Object container) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedMethodInvoker(method, container, null));
                }
                catch (PrivilegedActionException exception) {
                    Exception throwableException = exception.getException();
                    if (throwableException instanceof IllegalAccessException) {
                        throw QueryException.cannotAccessMethodOnObject(method, container);
                    }
                    throw QueryException.methodInvocationFailed(method, container, throwableException);
                }
            }
            return PrivilegedAccessHelper.invokeMethod(method, container, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw QueryException.cannotAccessMethodOnObject(method, container);
        }
        catch (InvocationTargetException ex2) {
            throw QueryException.methodInvocationFailed(method, container, ex2);
        }
    }

    public boolean isMapKeyAttribute() {
        return false;
    }

    @Override
    public boolean isValidContainerType(Class containerType) {
        return Helper.classImplementsInterface(containerType, this.getInterfaceType());
    }

    @Override
    protected Object next(Object iterator2) {
        return ((Iterator)iterator2).next();
    }

    public void setCloneMethod(Method cloneMethod) {
        this.cloneMethod = cloneMethod;
    }

    @Override
    public void setContainerClass(Class containerClass) {
        this.containerClass = containerClass;
        this.initializeConstructor();
    }

    @Override
    public void setContainerClassName(String containerClassName) {
        this.containerClassName = containerClassName;
    }

    @Override
    public Object buildContainerFromVector(Vector vector, AbstractSession session) {
        if (this.containerClass == ClassConstants.Vector_class) {
            return vector;
        }
        return super.buildContainerFromVector(vector, session);
    }

    @Override
    protected Object toStringInfo() {
        return this.getContainerClass();
    }
}

