/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.persistence.FlushModeType;
import org.eclipse.persistence.annotations.IdValidation;
import org.eclipse.persistence.config.PersistenceUnitProperties;
import org.eclipse.persistence.config.ReferenceMode;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;

public class PropertiesHandler {
    public static String getPropertyValue(String name, Map m3) {
        return PropertiesHandler.getPropertyValue(name, m3, true);
    }

    public static String getPropertyValueLogDebug(String name, Map m3, AbstractSession session) {
        return PropertiesHandler.getPropertyValueLogDebug(name, m3, session, true);
    }

    public static String getPropertyValue(String name, Map m3, boolean useSystemAsDefault) {
        return Prop.getPropertyValueToApply(name, m3, null, useSystemAsDefault);
    }

    public static String getPropertyValueLogDebug(String name, Map m3, AbstractSession session, boolean useSystemAsDefault) {
        return Prop.getPropertyValueToApply(name, m3, session, useSystemAsDefault);
    }

    public static String getPropertyValue(String name, String value2) {
        return Prop.getPropertyValueToApply(name, value2, null);
    }

    public static String getPropertyValueLogDebug(String name, String value2, AbstractSession session) {
        return Prop.getPropertyValueToApply(name, value2, session);
    }

    public static String getPrefixedPropertyValue(String prefix, String suffix, Map m3) {
        return (String)PropertiesHandler.getPrefixValues(prefix, m3).get(suffix);
    }

    public static Map getPrefixValues(String prefix, Map m3) {
        return Prop.getPrefixValuesToApply(prefix, m3, null, true);
    }

    public static Map getPrefixValuesLogDebug(String prefix, Map m3, AbstractSession session) {
        return Prop.getPrefixValuesToApply(prefix, m3, session, true);
    }

    public static String getDefaultPropertyValue(String name) {
        return Prop.getDefaultPropertyValueToApply(name, null);
    }

    public static String getDefaultPropertyValueLogDebug(String name, AbstractSession session) {
        return Prop.getDefaultPropertyValueToApply(name, session);
    }

    protected static boolean shouldUseDefault(String value2) {
        return value2 != null && value2.length() == 0;
    }

    protected static class BatchWritingProp
    extends Prop {
        BatchWritingProp() {
            super("eclipselink.jdbc.batch-writing", "None");
            this.shouldReturnOriginalValueIfValueToApplyNotFound = true;
            this.valueArray = new Object[]{"None", "JDBC", "Buffered", "Oracle-JDBC"};
        }
    }

    protected static class BooleanProp
    extends Prop {
        BooleanProp(String name, String defaultValue) {
            super(name, defaultValue);
            this.valueArray = new Object[]{"true", "false"};
        }
    }

    protected static class CacheSizeProp
    extends Prop {
        CacheSizeProp() {
            super("eclipselink.cache.size.", Integer.toString(1000));
        }
    }

    protected static class CacheTypeProp
    extends Prop {
        CacheTypeProp() {
            super("eclipselink.cache.type.", "SoftWeak");
            String pcg = "org.eclipse.persistence.internal.identitymaps.";
            this.valueArray = new Object[][]{{"Weak", String.valueOf(pcg) + "WeakIdentityMap"}, {"Soft", String.valueOf(pcg) + "SoftIdentityMap"}, {"SoftWeak", String.valueOf(pcg) + "SoftCacheWeakIdentityMap"}, {"HardWeak", String.valueOf(pcg) + "HardCacheWeakIdentityMap"}, {"Full", String.valueOf(pcg) + "FullIdentityMap"}, {"NONE", String.valueOf(pcg) + "NoIdentityMap"}};
        }
    }

    protected static class ConnectionPoolProp
    extends Prop {
        ConnectionPoolProp() {
            super("eclipselink.connection-pool.");
        }
    }

    protected static class DescriptorCustomizerProp
    extends Prop {
        DescriptorCustomizerProp() {
            super("eclipselink.descriptor.customizer.");
        }
    }

    protected static class ExclusiveConnectionModeProp
    extends Prop {
        ExclusiveConnectionModeProp() {
            super("eclipselink.jdbc.exclusive-connection.mode", "Transactional");
            this.valueArray = new Object[]{"Transactional", "Isolated", "Always"};
        }
    }

    protected static class FlushClearCacheProp
    extends Prop {
        FlushClearCacheProp() {
            super("eclipselink.flush-clear.cache", "DropInvalidate");
            this.valueArray = new Object[]{"Merge", "Drop", "DropInvalidate"};
        }
    }

    protected static class FlushModeProp
    extends Prop {
        FlushModeProp() {
            super("eclipselink.persistence-context.flush-mode", FlushModeType.AUTO.toString());
            this.valueArray = new Object[]{FlushModeType.AUTO.toString(), FlushModeType.COMMIT.toString()};
        }
    }

    protected static class IdValidationProp
    extends Prop {
        IdValidationProp() {
            super("eclipselink.id-validation", IdValidation.ZERO.toString());
            this.valueArray = new Object[]{IdValidation.NULL.toString(), IdValidation.ZERO.toString(), IdValidation.NEGATIVE.toString(), IdValidation.NONE.toString()};
        }
    }

    protected static class LoggerTypeProp
    extends Prop {
        LoggerTypeProp() {
            super("eclipselink.logging.logger", "DefaultLogger");
            this.shouldReturnOriginalValueIfValueToApplyNotFound = true;
            String pcg = "org.eclipse.persistence.logging.";
            this.valueArray = new Object[][]{{"DefaultLogger", String.valueOf(pcg) + "DefaultSessionLog"}, {"JavaLogger", String.valueOf(pcg) + "JavaLog"}};
        }
    }

    protected static class LoggingLevelProp
    extends Prop {
        LoggingLevelProp(String name, String defaultValue) {
            super(name, defaultValue);
            this.valueArray = new Object[]{Level.OFF.getName(), Level.SEVERE.getName(), Level.OFF.getName(), Level.WARNING.getName(), Level.INFO.getName(), Level.CONFIG.getName(), Level.FINE.getName(), Level.FINER.getName(), Level.FINEST.getName(), Level.ALL.getName()};
        }
    }

    protected static abstract class Prop {
        static HashMap mainMap = new HashMap();
        Object[] valueArray;
        HashMap valueMap;
        String name;
        String defaultValue;
        String defaultValueToApply;
        boolean valueToApplyMayBeNull;
        boolean shouldReturnOriginalValueIfValueToApplyNotFound;

        static {
            Prop.addProp(new LoggerTypeProp());
            Prop.addProp(new LoggingLevelProp("eclipselink.logging.level", Level.INFO.getName()));
            Prop.addProp(new LoggingLevelProp("eclipselink.logging.level.", Level.INFO.getName()));
            Prop.addProp(new TargetDatabaseProp());
            Prop.addProp(new TargetServerProp());
            Prop.addProp(new CacheSizeProp());
            Prop.addProp(new CacheTypeProp());
            Prop.addProp(new BooleanProp("eclipselink.cache.shared.", "false"));
            Prop.addProp(new DescriptorCustomizerProp());
            Prop.addProp(new BatchWritingProp());
            Prop.addProp(new FlushClearCacheProp());
            Prop.addProp(new ReferenceModeProp());
            Prop.addProp(new FlushModeProp());
            Prop.addProp(new BooleanProp("eclipselink.persistence-context.close-on-commit", "false"));
            Prop.addProp(new BooleanProp("eclipselink.persistence-context.persist-on-commit", "true"));
            Prop.addProp(new BooleanProp("eclipselink.persistence-context.commit-without-persist-rules", "false"));
            Prop.addProp(new BooleanProp("eclipselink.validate-existence", "false"));
            Prop.addProp(new BooleanProp("eclipselink.order-updates", "false"));
            Prop.addProp(new BooleanProp("eclipselink.transaction.join-existing", "false"));
            Prop.addProp(new BooleanProp("eclipselink.composite-unit", "false"));
            Prop.addProp(new BooleanProp("eclipselink.composite-unit.member", "false"));
            Prop.addProp(new ExclusiveConnectionModeProp());
            Prop.addProp(new BooleanProp("eclipselink.jdbc.exclusive-connection.is-lazy", "true"));
            Prop.addProp(new IdValidationProp());
            Prop.addProp(new ConnectionPoolProp());
            Prop.addProp(new BooleanProp("eclipselink.jdbc.result-set-access-optimization", Boolean.toString(ObjectLevelReadQuery.isResultSetAccessOptimizedQueryDefault)));
        }

        Prop(String name) {
            this.name = name;
        }

        Prop(String name, String defaultValue) {
            this(name);
            this.defaultValue = defaultValue;
        }

        static String getPropertyValueFromMap(String name, Map m3, boolean useSystemAsDefault) {
            String value2 = (String)m3.get(name);
            return value2 == null && useSystemAsDefault ? System.getProperty(name) : value2;
        }

        static Map getPrefixValuesFromMap(String name, Map m3, boolean useSystemAsDefault) {
            HashMap mapOut = new HashMap();
            if (useSystemAsDefault) {
                Map.Entry[] entries;
                Map.Entry[] entryArray = entries = (Map.Entry[])AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return System.getProperties().entrySet().toArray(new Map.Entry[0]);
                    }
                });
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    Map.Entry entry2 = entryArray[n2];
                    String str = (String)entry2.getKey();
                    if (str.startsWith(name)) {
                        String entityName = str.substring(name.length(), str.length());
                        mapOut.put(entityName, entry2.getValue());
                    }
                    ++n2;
                }
            }
            for (Map.Entry entry3 : m3.entrySet()) {
                String str = (String)entry3.getKey();
                if (!str.startsWith(name)) continue;
                String entityName = str.substring(name.length(), str.length());
                mapOut.put(entityName, entry3.getValue());
            }
            return mapOut;
        }

        static String getPropertyValue(String name, boolean shouldUseDefault, Map m3, AbstractSession session, boolean useSystemAsDefault) {
            Prop prop = (Prop)mainMap.get(name);
            if (prop == null) {
                return null;
            }
            String value2 = Prop.getPropertyValueFromMap(name, m3, useSystemAsDefault);
            if (value2 == null) {
                return null;
            }
            return prop.getValueToApply(value2, shouldUseDefault, session);
        }

        static String getPropertyValueToApply(String name, Map m3, AbstractSession session, boolean useSystemAsDefault) {
            Prop prop = (Prop)mainMap.get(name);
            if (prop == null) {
                throw new IllegalArgumentException(name);
            }
            String value2 = Prop.getPropertyValueFromMap(name, m3, useSystemAsDefault);
            if (value2 == null) {
                return null;
            }
            return prop.getValueToApply(value2, PropertiesHandler.shouldUseDefault(value2), session);
        }

        static String getPropertyValueToApply(String name, String value2, AbstractSession session) {
            Prop prop = (Prop)mainMap.get(name);
            if (prop == null) {
                throw new IllegalArgumentException(name);
            }
            return prop.getValueToApply(value2, PropertiesHandler.shouldUseDefault(value2), session);
        }

        static Map<String, Object> getPrefixValuesToApply(String prefix, Map m3, AbstractSession session, boolean useSystemAsDefault) {
            Prop prop = (Prop)mainMap.get(prefix);
            Map mapIn = Prop.getPrefixValuesFromMap(prefix, m3, useSystemAsDefault);
            if (mapIn.isEmpty()) {
                return mapIn;
            }
            HashMap<String, Object> mapOut = new HashMap<String, Object>(mapIn.size());
            for (Map.Entry entry2 : mapIn.entrySet()) {
                String suffix = (String)entry2.getKey();
                Object value2 = entry2.getValue();
                if (prop != null && value2 instanceof String) {
                    value2 = prop.getValueToApply((String)value2, PropertiesHandler.shouldUseDefault((String)value2), suffix, session);
                }
                mapOut.put(suffix, value2);
            }
            return mapOut;
        }

        static String getDefaultPropertyValueToApply(String name, AbstractSession session) {
            Prop prop = (Prop)mainMap.get(name);
            if (prop == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-default-for-unknown-property", new Object[]{name}));
            }
            prop.logDefault(session);
            return prop.defaultValueToApply;
        }

        String getValueToApply(String value2, boolean shouldUseDefault, AbstractSession session) {
            return this.getValueToApply(value2, shouldUseDefault, null, session);
        }

        String getValueToApply(String value2, boolean shouldUseDefault, String suffix, AbstractSession session) {
            String logValue;
            String key;
            if (shouldUseDefault) {
                this.logDefault(session, suffix);
                return this.defaultValueToApply;
            }
            String valueToApply = value2;
            if (this.valueMap != null && (valueToApply = (String)this.valueMap.get(key = Prop.getUpperCaseString(value2))) == null) {
                boolean notFound = true;
                if (this.valueToApplyMayBeNull) {
                    boolean bl = notFound = !this.valueMap.containsKey(key);
                }
                if (notFound) {
                    if (this.shouldReturnOriginalValueIfValueToApplyNotFound) {
                        valueToApply = value2;
                    } else {
                        String propertyName = this.name;
                        if (suffix != null) {
                            propertyName = String.valueOf(propertyName) + suffix;
                        }
                        throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-illegal-property-value", new Object[]{propertyName, Prop.getPrintValue(value2)}));
                    }
                }
            }
            if ((logValue = PersistenceUnitProperties.getOverriddenLogStringForProperty(this.name)) != null) {
                this.log(session, logValue, logValue, suffix);
            } else {
                this.log(session, value2, valueToApply, suffix);
            }
            return valueToApply;
        }

        static String getUpperCaseString(String value2) {
            if (value2 != null) {
                return value2.toUpperCase();
            }
            return null;
        }

        static String getPrintValue(String value2) {
            if (value2 != null) {
                return value2;
            }
            return "null";
        }

        void initialize() {
            if (this.valueArray != null) {
                this.valueMap = new HashMap(this.valueArray.length);
                if (this.valueArray instanceof Object[][]) {
                    Object[][] valueArray2 = (Object[][])this.valueArray;
                    int i = 0;
                    while (i < valueArray2.length) {
                        this.valueMap.put(Prop.getUpperCaseString((String)valueArray2[i][0]), valueArray2[i][1]);
                        if (valueArray2[i][1] == null) {
                            this.valueToApplyMayBeNull = true;
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < this.valueArray.length) {
                        this.valueMap.put(Prop.getUpperCaseString((String)this.valueArray[i]), this.valueArray[i]);
                        if (this.valueArray[i] == null) {
                            this.valueToApplyMayBeNull = true;
                        }
                        ++i;
                    }
                }
                this.defaultValueToApply = (String)this.valueMap.get(Prop.getUpperCaseString(this.defaultValue));
            } else {
                this.defaultValueToApply = this.defaultValue;
            }
        }

        void logDefault(AbstractSession session) {
            this.logDefault(session, null);
        }

        void logDefault(AbstractSession session, String suffix) {
            if (session != null && session.shouldLog(1, "properties")) {
                String propertyName = this.name;
                if (suffix != null) {
                    propertyName = String.valueOf(propertyName) + suffix;
                }
                if (this.defaultValue != this.defaultValueToApply) {
                    session.log(1, "properties", "handler_property_value_default", new Object[]{propertyName, this.defaultValue, this.defaultValueToApply});
                } else {
                    session.log(1, "properties", "property_value_default", new Object[]{propertyName, this.defaultValue});
                }
            }
        }

        void log(AbstractSession session, String value2, String valueToApply, String suffix) {
            if (session != null && session.shouldLog(1, "properties")) {
                String propertyName = this.name;
                if (suffix != null) {
                    propertyName = String.valueOf(propertyName) + suffix;
                }
                if (value2 != valueToApply) {
                    session.log(1, "properties", "handler_property_value_specified", new Object[]{propertyName, value2, valueToApply});
                } else {
                    session.log(1, "properties", "property_value_specified", new Object[]{propertyName, value2});
                }
            }
        }

        static void addProp(Prop prop) {
            prop.initialize();
            mainMap.put(prop.name, prop);
        }
    }

    protected static class ReferenceModeProp
    extends Prop {
        ReferenceModeProp() {
            super("eclipselink.persistence-context.reference-mode", ReferenceMode.HARD.toString());
            this.valueArray = new Object[]{ReferenceMode.HARD.toString(), ReferenceMode.WEAK.toString(), ReferenceMode.FORCE_WEAK.toString()};
        }
    }

    protected static class TargetDatabaseProp
    extends Prop {
        TargetDatabaseProp() {
            super("eclipselink.target-database", "Auto");
            this.shouldReturnOriginalValueIfValueToApplyNotFound = true;
            String pcg = "org.eclipse.persistence.platform.database.";
            this.valueArray = new Object[][]{{"Auto", String.valueOf(pcg) + "DatabasePlatform"}, {"Oracle", String.valueOf(pcg) + "OraclePlatform"}, {"Oracle8i", String.valueOf(pcg) + "oracle.Oracle8Platform"}, {"Oracle9i", String.valueOf(pcg) + "oracle.Oracle9Platform"}, {"Oracle10g", String.valueOf(pcg) + "oracle.Oracle10Platform"}, {"Oracle11", String.valueOf(pcg) + "oracle.Oracle11Platform"}, {"Attunity", String.valueOf(pcg) + "AttunityPlatform"}, {"Cloudscape", String.valueOf(pcg) + "CloudscapePlatform"}, {"Database", String.valueOf(pcg) + "DatabasePlatform"}, {"DB2Mainframe", String.valueOf(pcg) + "DB2MainframePlatform"}, {"DB2", String.valueOf(pcg) + "DB2Platform"}, {"DBase", String.valueOf(pcg) + "DBasePlatform"}, {"Derby", String.valueOf(pcg) + "DerbyPlatform"}, {"HANA", String.valueOf(pcg) + "HANAPlatform"}, {"HSQL", String.valueOf(pcg) + "HSQLPlatform"}, {"Informix", String.valueOf(pcg) + "InformixPlatform"}, {"JavaDB", String.valueOf(pcg) + "JavaDBPlatform"}, {"MySQL", String.valueOf(pcg) + "MySQLPlatform"}, {"MaxDB", String.valueOf(pcg) + "MaxDBPlatform"}, {"MySQL4", String.valueOf(pcg) + "MySQLPlatform"}, {"PointBase", String.valueOf(pcg) + "PointBasePlatform"}, {"PostgreSQL", String.valueOf(pcg) + "PostgreSQLPlatform"}, {"SQLAnywhere", String.valueOf(pcg) + "SQLAnywherePlatform"}, {"SQLServer", String.valueOf(pcg) + "SQLServerPlatform"}, {"Sybase", String.valueOf(pcg) + "SybasePlatform"}, {"Symfoware", String.valueOf(pcg) + "SymfowarePlatform"}, {"TimesTen", String.valueOf(pcg) + "TimesTenPlatform"}};
        }
    }

    protected static class TargetServerProp
    extends Prop {
        TargetServerProp() {
            super("eclipselink.target-server", "None");
            this.shouldReturnOriginalValueIfValueToApplyNotFound = true;
            String pcg = "org.eclipse.persistence.platform.server.";
            this.valueArray = new Object[][]{{"None", String.valueOf(pcg) + "NoServerPlatform"}, {"OC4J", String.valueOf(pcg) + "oc4j.Oc4jPlatform"}, {"SunAS9", String.valueOf(pcg) + "sunas.SunAS9ServerPlatform"}, {"Glassfish", String.valueOf(pcg) + "glassfish.GlassfishPlatform"}, {"WebSphere", String.valueOf(pcg) + "was.WebSpherePlatform"}, {"WebSphere_6_1", String.valueOf(pcg) + "was.WebSphere_6_1_Platform"}, {"WebSphere_7", String.valueOf(pcg) + "was.WebSphere_7_Platform"}, {"WebSphere_Liberty", String.valueOf(pcg) + "was.WebSphere_Liberty_Platform"}, {"WebLogic", String.valueOf(pcg) + "wls.WebLogicPlatform"}, {"WebLogic_9", String.valueOf(pcg) + "wls.WebLogic_9_Platform"}, {"WebLogic_10", String.valueOf(pcg) + "wls.WebLogic_10_Platform"}, {"JBoss", String.valueOf(pcg) + "jboss.JBossPlatform"}, {"NetWeaver_7_1", String.valueOf(pcg) + "sap.SAPNetWeaver_7_1_Platform"}};
        }
    }
}

