/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.xjc;

import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.ConsoleErrorReporter;
import com.sun.tools.xjc.Driver;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.XJCListener;
import java.io.File;
import java.io.FileWriter;
import org.xml.sax.SAXParseException;

public class MOXyXJC {
    public static void main(String[] args) throws Throwable {
        Listener listener = new Listener();
        int compileSuccess = -1;
        try {
            for (int x = 0; x < args.length; ++x) {
                if (!"-empty_output".equals(args[x])) continue;
                String[] args2 = new String[args.length - 1];
                System.arraycopy(args, 0, args2, 0, x);
                System.arraycopy(args, x + 1, args2, x, args.length - x - 1);
                args = args2;
                break;
            }
            compileSuccess = Driver.run((String[])args, (XJCListener)listener);
        }
        catch (BadCommandLineException e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
                System.out.println();
            }
            Driver.usage((Options)e.getOptions(), (boolean)false);
            System.exit(1);
        }
        if (compileSuccess == 0) {
            String destDir = ".";
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].equals("-d")) continue;
                destDir = args[i + 1];
                break;
            }
            if (listener.getGeneratedPackagePath() != null) {
                File jaxbPropsFile = new File(destDir + File.separator + listener.getGeneratedPackagePath(), "jaxb.properties");
                FileWriter writer = new FileWriter(jaxbPropsFile);
                writer.write("javax.xml.bind.context.factory=org.eclipse.persistence.jaxb.JAXBContextFactory");
                listener.generatedFile(listener.getGeneratedPackagePath() + File.separator + "jaxb.properties", 0, 0);
                writer.close();
            }
        }
        System.exit(compileSuccess);
    }

    static class Listener
    extends XJCListener {
        private ConsoleErrorReporter cer = new ConsoleErrorReporter(System.err);
        private String generatedPackagePath = null;

        Listener() {
        }

        public void generatedFile(String fileName, int count2, int total) {
            this.message(fileName);
            if (this.generatedPackagePath == null) {
                this.generatedPackagePath = fileName.substring(0, fileName.lastIndexOf(File.separator));
            }
        }

        public String getGeneratedPackagePath() {
            return this.generatedPackagePath;
        }

        public void message(String msg) {
            System.out.println(msg);
        }

        public void error(SAXParseException exception) {
            this.cer.error(exception);
        }

        public void fatalError(SAXParseException exception) {
            this.cer.fatalError(exception);
        }

        public void warning(SAXParseException exception) {
            this.cer.warning(exception);
        }

        public void info(SAXParseException exception) {
            this.cer.info(exception);
        }
    }
}

