/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import org.eclipse.persistence.jpa.jpql.ExpressionTools;

public final class WordParser {
    private int cursor = 0;
    private final int length;
    private final CharSequence text;
    private WordType wordType;

    public WordParser(CharSequence text) {
        this.text = text;
        this.length = text.length();
        this.wordType = WordType.UNDEFINED;
    }

    public char character() {
        return this.character(this.cursor);
    }

    public char character(int position) {
        return position >= this.length ? (char)'\u0000' : this.text.charAt(position);
    }

    public boolean endsWith(int endPosition, String suffix) {
        return this.startsWith(suffix, endPosition - suffix.length());
    }

    public boolean endsWithIgnoreCase(int endPosition, String suffix) {
        return this.startsWithIgnoreCase(suffix, endPosition - suffix.length());
    }

    public String entireWord() {
        return this.entireWord(this.cursor);
    }

    public String entireWord(int position) {
        int startPosition = this.partialWordStartPosition(position);
        int endPosition = this.wordEndPosition(position);
        return this.substring(startPosition, endPosition);
    }

    public WordType getWordType() {
        return this.wordType;
    }

    public boolean isArithmeticSymbol(char character) {
        return character == '>' || character == '!' || character == '<' || character == '/' || character == '*' || character == '-' || character == '+' || character == '=' || character == '{';
    }

    public boolean isDelimiter(char character) {
        return character == '(' || character == ')' || character == ',';
    }

    public boolean isDigit(char character) {
        return character == '.' || Character.isDigit(character);
    }

    public boolean isTail() {
        return this.cursor >= this.length;
    }

    public boolean isWordSeparator(char character) {
        return Character.isWhitespace(character) || this.isDelimiter(character) || this.isArithmeticSymbol(character);
    }

    public int length() {
        return this.length;
    }

    public void moveBackward(CharSequence word) {
        this.cursor -= word.length();
    }

    public void moveBackward(int position) {
        this.cursor -= position;
    }

    public String moveForward(CharSequence word) {
        return this.moveForward(word.length());
    }

    public String moveForward(int position) {
        String word = this.substring(this.cursor, this.cursor + position);
        this.cursor += position;
        return word;
    }

    public String moveForwardIgnoreWhitespace(CharSequence word) {
        StringBuilder sb = new StringBuilder();
        int pc = word.length();
        int po = 0;
        while (--pc >= 0) {
            char c1 = this.text.charAt(this.cursor++);
            char c2 = word.charAt(po++);
            if (Character.isWhitespace(c1)) {
                if (Character.isWhitespace(c2)) {
                    sb.append(' ');
                    continue;
                }
                ++pc;
                --po;
                continue;
            }
            sb.append(c1);
        }
        return sb.toString();
    }

    public String numericLiteral() {
        return this.substring(this.cursor, this.scanNumericLiteral(this.cursor));
    }

    public String partialWord() {
        int startIndex = this.partialWordStartPosition(this.cursor);
        return this.substring(startIndex, this.cursor);
    }

    public String partialWord(int position) {
        int startIndex = this.partialWordStartPosition(position);
        return this.substring(startIndex, position);
    }

    public int partialWordStartPosition(int position) {
        int startIndex = position;
        int index = position;
        while (--index >= 0) {
            char character = this.text.charAt(index);
            if (Character.isWhitespace(character) || this.isDelimiter(character) || this.isArithmeticSymbol(character)) break;
            --startIndex;
        }
        return startIndex;
    }

    public int position() {
        return this.cursor;
    }

    private int scanNumericLiteral(int startPosition) {
        int endIndex = startPosition;
        boolean digitParsed = false;
        boolean dotParsed = false;
        block0: while (endIndex < this.length) {
            char character = this.text.charAt(endIndex);
            if (character >= '0' && character <= '9') {
                digitParsed = true;
            } else if (character == '+' || character == '-') {
                if (endIndex > startPosition) {
                    break;
                }
            } else if (character == '.') {
                if (dotParsed) {
                    endIndex = startPosition + 1;
                    this.wordType = WordType.WORD;
                    break;
                }
                dotParsed = true;
            } else {
                if (character == 'x') {
                    boolean powerParsed = false;
                    while (endIndex < this.length) {
                        character = this.text.charAt(endIndex);
                        if (character == 'p' || character == 'P') {
                            powerParsed = true;
                        } else if ((!powerParsed || character != '+' && character != '+') && this.isWordSeparator(character)) break block0;
                        ++endIndex;
                    }
                    break;
                }
                if (character == 'e' || character == 'E') {
                    if (!digitParsed) {
                        this.wordType = WordType.WORD;
                        break;
                    }
                    int index = ++endIndex;
                    while (index < this.length) {
                        character = this.text.charAt(index);
                        if (index == endIndex && (character == '-' || character == '+') || character >= '0' && character <= '9') {
                            ++endIndex;
                        } else {
                            if (character == '.') {
                                this.wordType = WordType.WORD;
                            }
                            if (this.isWordSeparator(character)) break block0;
                            ++endIndex;
                        }
                        ++index;
                    }
                    break;
                }
                if (character == 'f' || character == 'F' || character == 'd' || character == 'D' || character == 'l' || character == 'L') {
                    if (!digitParsed) {
                        this.wordType = WordType.WORD;
                        break;
                    }
                    if (++endIndex == this.length || this.isWordSeparator(character = this.text.charAt(endIndex))) {
                        break;
                    }
                } else {
                    if (!digitParsed && Character.isJavaIdentifierPart(character)) {
                        this.wordType = WordType.WORD;
                        break;
                    }
                    if (this.isWordSeparator(character)) break;
                }
            }
            ++endIndex;
        }
        return endIndex;
    }

    private int scanStringLiteral(int startPosition) {
        int endIndex = startPosition;
        char startQuote = this.text.charAt(endIndex);
        ++endIndex;
        while (endIndex < this.length) {
            char character = this.text.charAt(endIndex);
            if (character == startQuote) {
                char previousCharacter;
                char nextCharacter;
                ++endIndex;
                if (!(startQuote == '\'' && endIndex < this.length ? (nextCharacter = this.text.charAt(endIndex)) == '\'' : startQuote == '\"' && endIndex - 2 > startPosition && (previousCharacter = this.text.charAt(endIndex - 2)) == '\\')) break;
            }
            ++endIndex;
        }
        return endIndex;
    }

    public void setPosition(int position) {
        this.cursor = position < 0 ? 0 : position;
    }

    public int skipLeadingWhitespace() {
        int count2 = 0;
        while (this.cursor < this.length) {
            char character = this.text.charAt(this.cursor);
            if (!Character.isWhitespace(character)) break;
            ++this.cursor;
            ++count2;
        }
        return count2;
    }

    public boolean startsWith(char possibleCharacter) {
        return possibleCharacter == this.character();
    }

    public boolean startsWith(CharSequence prefix) {
        return this.startsWith(prefix, this.cursor);
    }

    public boolean startsWith(CharSequence prefix, int startIndex) {
        int prefixLength = prefix.length();
        if (startIndex < 0 || startIndex > this.length - prefixLength) {
            return false;
        }
        int prefixIndex = 0;
        while (--prefixLength >= 0) {
            if (this.text.charAt(startIndex++) == prefix.charAt(prefixIndex++)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWithArithmeticOperator() {
        char character = this.text.charAt(this.cursor);
        return character == '+' || character == '/' || character == '-' || character == '*';
    }

    public Boolean startsWithDigit() {
        char character = this.character();
        if (character == '-' || character == '+') {
            this.moveForward(1);
            int count2 = this.skipLeadingWhitespace();
            character = this.character(this.cursor);
            this.moveBackward(count2 + 1);
            if (this.isDigit(character)) {
                return Boolean.TRUE;
            }
            if (character == '-' || character == '+' || character == '+' || character == '/') {
                return null;
            }
            return Boolean.FALSE;
        }
        if (character == '.') {
            return this.isDigit(this.character(this.cursor + 1));
        }
        if (this.isDigit(character)) {
            return Boolean.TRUE;
        }
        return null;
    }

    public boolean startsWithIdentifier(CharSequence identifier) {
        return this.startsWithIdentifier(identifier, this.cursor);
    }

    public boolean startsWithIdentifier(CharSequence identifier, int position) {
        int pc = identifier.length();
        if (position < 0 || position > this.length - pc) {
            return false;
        }
        int po = 0;
        int to2 = position;
        while (--pc >= 0) {
            char u2;
            char c2;
            char c1;
            if ((c1 = this.text.charAt(to2++)) == (c2 = identifier.charAt(po++))) continue;
            if (Character.isWhitespace(c1)) {
                if (Character.isWhitespace(c2)) continue;
                if (to2 == this.length) {
                    return false;
                }
                ++pc;
                --po;
                continue;
            }
            char u1 = Character.toUpperCase(c1);
            if (u1 != (u2 = Character.toUpperCase(c2))) {
                return false;
            }
            if (Character.toLowerCase(u1) == Character.toLowerCase(u2)) continue;
            return false;
        }
        if (to2 == this.length) {
            return true;
        }
        char character = this.text.charAt(to2);
        return this.isWordSeparator(character);
    }

    public boolean startsWithIgnoreCase(char possibleCharacter) {
        char character = this.character();
        return possibleCharacter == character || possibleCharacter == Character.toUpperCase(character);
    }

    public boolean startsWithIgnoreCase(CharSequence prefix) {
        return this.startsWithIgnoreCase(prefix, this.cursor);
    }

    public boolean startsWithIgnoreCase(CharSequence prefix, int offset2) {
        int pc = prefix.length();
        if (offset2 < 0 || offset2 > this.length - pc) {
            return false;
        }
        int po = 0;
        int to2 = offset2;
        while (--pc >= 0) {
            char u2;
            char c2;
            char c1;
            if ((c1 = this.text.charAt(to2++)) == (c2 = prefix.charAt(po++))) continue;
            char u1 = Character.toUpperCase(c1);
            if (u1 != (u2 = Character.toUpperCase(c2))) {
                return false;
            }
            if (Character.toLowerCase(u1) == Character.toLowerCase(u2)) continue;
            return false;
        }
        return true;
    }

    public String substring() {
        return this.substring(this.cursor);
    }

    public String substring(int startIndex) {
        return this.substring(startIndex, this.length);
    }

    public String substring(int startIndex, int endIndex) {
        return this.text.subSequence(startIndex, endIndex).toString();
    }

    public String toString() {
        return this.isTail() ? "" : this.substring();
    }

    public int whitespaceCount() {
        return this.whitespaceCount(this.cursor);
    }

    public int whitespaceCount(int position) {
        int index = position;
        while (index < this.length) {
            char character = this.text.charAt(index);
            if (!Character.isWhitespace(character)) {
                return index - position;
            }
            ++index;
        }
        return 0;
    }

    public String word() {
        return this.substring(this.cursor, this.wordEndPosition());
    }

    public int wordEndPosition() {
        return this.wordEndPosition(this.cursor);
    }

    public int wordEndPosition(int position) {
        if (position >= this.length) {
            this.wordType = WordType.UNDEFINED;
            return position;
        }
        char character = this.text.charAt(position);
        int endIndex = position + 1;
        this.wordType = WordType.WORD;
        if (ExpressionTools.isQuote(character)) {
            this.wordType = WordType.STRING_LITERAL;
            if (position > 1 && ExpressionTools.isQuote(character = this.character(position - 1))) {
                return endIndex;
            }
            return this.scanStringLiteral(position);
        }
        if (ExpressionTools.isParameter(character)) {
            this.wordType = WordType.INPUT_PARAMETER;
            while (endIndex < this.length) {
                character = this.text.charAt(endIndex);
                if (character == '!' && endIndex + 1 < this.length) {
                    character = this.text.charAt(endIndex + 1);
                    if (character == '=') break;
                    ++endIndex;
                } else if (this.isWordSeparator(character)) break;
                ++endIndex;
            }
            return endIndex;
        }
        if (character == '/' || character == '*' || character == '+' || character == '-') {
            return endIndex;
        }
        if (character == '{') {
            return endIndex;
        }
        if (this.isDigit(character)) {
            this.wordType = WordType.NUMERIC_LITERAL;
            endIndex = this.scanNumericLiteral(position);
            if (this.wordType == WordType.NUMERIC_LITERAL) {
                return endIndex;
            }
        } else {
            if (character == '=') {
                return endIndex;
            }
            if (character == '<') {
                if (endIndex < this.length) {
                    character = this.text.charAt(endIndex);
                    if (character == '>' || character == '=') {
                        return endIndex + 1;
                    }
                    return endIndex;
                }
            } else if (character == '>' || character == '!') {
                if (endIndex == this.length) {
                    return endIndex;
                }
                char nextCharacter = this.text.charAt(endIndex);
                if (nextCharacter == '=') {
                    return ++endIndex;
                }
                if (character == '>') {
                    return endIndex;
                }
            } else if (this.isWordSeparator(character)) {
                return --endIndex;
            }
        }
        int index = endIndex;
        while (index < this.length) {
            character = this.text.charAt(index);
            if (character == '!' && endIndex + 1 < this.length) {
                character = this.text.charAt(index + 1);
                if (character == '=') {
                    return endIndex;
                }
                ++endIndex;
            } else {
                if (Character.isWhitespace(character) || this.isDelimiter(character) || character == '>' || character == '<' || character == '/' || character == '*' || character == '-' || character == '+' || character == '=') break;
                ++endIndex;
            }
            ++index;
        }
        return endIndex;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WordType {
        INPUT_PARAMETER,
        NUMERIC_LITERAL,
        STRING_LITERAL,
        UNDEFINED,
        WORD;

    }
}

