/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTripleEncapsulatedExpression
extends AbstractEncapsulatedExpression {
    private AbstractExpression firstExpression;
    private boolean hasFirstComma;
    private boolean hasSecondComma;
    private boolean hasSpaceAfterFirstComma;
    private boolean hasSpaceAfterSecondComma;
    protected int parameterIndex;
    private AbstractExpression secondExpression;
    private AbstractExpression thirdExpression;

    protected AbstractTripleEncapsulatedExpression(AbstractExpression parent, String identifier) {
        super(parent, identifier);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getFirstExpression().accept(visitor);
        this.getSecondExpression().accept(visitor);
        this.getThirdExpression().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getFirstExpression());
        children.add(this.getSecondExpression());
        children.add(this.getThirdExpression());
    }

    @Override
    protected void addOrderedEncapsulatedExpressionTo(List<Expression> children) {
        if (this.firstExpression != null) {
            children.add(this.firstExpression);
        }
        if (this.hasFirstComma) {
            children.add(this.buildStringExpression(','));
        }
        if (this.hasSpaceAfterFirstComma) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.secondExpression != null) {
            children.add(this.secondExpression);
        }
        if (this.hasSecondComma) {
            children.add(this.buildStringExpression(','));
        }
        if (this.hasSpaceAfterSecondComma) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.thirdExpression != null) {
            children.add(this.thirdExpression);
        }
    }

    public final CollectionExpression buildCollectionExpression() {
        ArrayList<AbstractExpression> children = new ArrayList<AbstractExpression>(3);
        children.add((AbstractExpression)this.getFirstExpression());
        children.add((AbstractExpression)this.getSecondExpression());
        children.add((AbstractExpression)this.getThirdExpression());
        ArrayList<Boolean> commas = new ArrayList<Boolean>(3);
        commas.add(this.hasFirstComma);
        commas.add(this.hasSecondComma);
        commas.add(Boolean.FALSE);
        ArrayList<Boolean> spaces2 = new ArrayList<Boolean>(3);
        spaces2.add(this.hasSpaceAfterFirstComma);
        spaces2.add(this.hasSpaceAfterSecondComma);
        spaces2.add(Boolean.FALSE);
        return new CollectionExpression(this, children, commas, spaces2, true);
    }

    @Override
    public JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.firstExpression != null && this.firstExpression.isAncestor(expression)) {
            return this.getQueryBNF(this.getParameterQueryBNFId(0));
        }
        if (this.secondExpression != null && this.secondExpression.isAncestor(expression)) {
            return this.getQueryBNF(this.getParameterQueryBNFId(1));
        }
        if (this.thirdExpression != null && this.thirdExpression.isAncestor(expression)) {
            return this.getQueryBNF(this.getParameterQueryBNFId(2));
        }
        return super.findQueryBNF(expression);
    }

    public final Expression getFirstExpression() {
        if (this.firstExpression == null) {
            this.firstExpression = this.buildNullExpression();
        }
        return this.firstExpression;
    }

    public abstract String getParameterQueryBNFId(int var1);

    public final Expression getSecondExpression() {
        if (this.secondExpression == null) {
            this.secondExpression = this.buildNullExpression();
        }
        return this.secondExpression;
    }

    public final Expression getThirdExpression() {
        if (this.thirdExpression == null) {
            this.thirdExpression = this.buildNullExpression();
        }
        return this.thirdExpression;
    }

    @Override
    public boolean hasEncapsulatedExpression() {
        return this.hasFirstExpression() || this.hasFirstComma || this.hasSecondExpression() || this.hasSecondComma || this.hasThirdExpression();
    }

    public final boolean hasFirstComma() {
        return this.hasFirstComma;
    }

    public final boolean hasFirstExpression() {
        return this.firstExpression != null && !this.firstExpression.isNull();
    }

    public final boolean hasSecondComma() {
        return this.hasSecondComma;
    }

    public final boolean hasSecondExpression() {
        return this.secondExpression != null && !this.secondExpression.isNull();
    }

    public final boolean hasSpaceAfterFirstComma() {
        return this.hasSpaceAfterFirstComma;
    }

    public final boolean hasSpaceAfterSecondComma() {
        return this.hasSpaceAfterSecondComma;
    }

    public final boolean hasThirdExpression() {
        return this.thirdExpression != null && !this.thirdExpression.isNull();
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        char character = wordParser.character();
        if (!(this.parameterIndex != 0 || character != '+' && character != '-' || this.hasLeftParenthesis())) {
            this.parameterIndex = -1;
            return true;
        }
        return super.isParsingComplete(wordParser, word, expression);
    }

    protected abstract boolean isThirdExpressionOptional();

    @Override
    protected void parseEncapsulatedExpression(WordParser wordParser, int whitespaceCount, boolean tolerant) {
        int count2 = 0;
        this.parameterIndex = 0;
        this.firstExpression = this.parse(wordParser, this.getParameterQueryBNFId(0), tolerant);
        if (this.firstExpression != null) {
            count2 = wordParser.skipLeadingWhitespace();
        } else if (this.parameterIndex == -1) {
            return;
        }
        this.hasFirstComma = wordParser.startsWith(',');
        if (this.hasFirstComma) {
            count2 = 0;
            wordParser.moveForward(1);
            this.hasSpaceAfterFirstComma = wordParser.skipLeadingWhitespace() > 0;
        }
        this.parameterIndex = 1;
        this.secondExpression = this.parse(wordParser, this.getParameterQueryBNFId(1), tolerant);
        if (!this.hasFirstComma) {
            this.hasSpaceAfterFirstComma = count2 > 0;
        }
        count2 = wordParser.skipLeadingWhitespace();
        this.hasSecondComma = wordParser.startsWith(',');
        if (this.hasSecondComma) {
            count2 = 0;
            wordParser.moveForward(1);
            this.hasSpaceAfterSecondComma = wordParser.skipLeadingWhitespace() > 0;
        }
        this.parameterIndex = 2;
        this.thirdExpression = this.parse(wordParser, this.getParameterQueryBNFId(2), tolerant);
        if (!(this.hasSecondComma || this.isThirdExpressionOptional() && this.thirdExpression == null)) {
            this.hasSpaceAfterSecondComma = count2 > 0;
        }
    }

    @Override
    protected void removeEncapsulatedExpression() {
        this.hasFirstComma = false;
        this.hasSecondComma = false;
        this.firstExpression = null;
        this.thirdExpression = null;
        this.secondExpression = null;
        this.hasSpaceAfterFirstComma = false;
        this.hasSpaceAfterSecondComma = false;
    }

    @Override
    protected final void toParsedTextEncapsulatedExpression(StringBuilder writer, boolean actual) {
        if (this.firstExpression != null) {
            this.firstExpression.toParsedText(writer, actual);
        }
        if (this.hasFirstComma) {
            writer.append(',');
        }
        if (this.hasSpaceAfterFirstComma) {
            writer.append(' ');
        }
        if (this.secondExpression != null) {
            this.secondExpression.toParsedText(writer, actual);
        }
        if (this.hasSecondComma) {
            writer.append(',');
        }
        if (this.hasSpaceAfterSecondComma) {
            writer.append(' ');
        }
        if (this.thirdExpression != null) {
            this.thirdExpression.toParsedText(writer, actual);
        }
    }
}

