/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.EmptyCollectionComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionFactory;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.NullComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.UnknownExpression;

public final class IsExpressionFactory
extends ExpressionFactory {
    public static final String ID = "IS";

    public IsExpressionFactory() {
        super(ID, ID, "IS EMPTY", "IS NOT EMPTY", "IS NOT NULL", "IS NULL");
    }

    protected AbstractExpression buildExpression(AbstractExpression parent, WordParser wordParser, String word, JPQLQueryBNF queryBNF, AbstractExpression expression, boolean tolerant) {
        int count2;
        int position = wordParser.position();
        int index = position + 2;
        if (wordParser.startsWithIdentifier("NOT", index += (count2 = wordParser.whitespaceCount(index)))) {
            index += 3;
            if (wordParser.startsWithIdentifier("EMPTY", index += (count2 = wordParser.whitespaceCount(index)))) {
                expression = new EmptyCollectionComparisonExpression(parent, "IS NOT EMPTY", expression);
            } else if (wordParser.startsWithIdentifier("NULL", index)) {
                expression = new NullComparisonExpression(parent, "IS NOT NULL", expression);
            } else {
                word = wordParser.substring(position, index - count2);
                expression = new UnknownExpression(parent, word);
            }
        } else if (wordParser.startsWithIdentifier("EMPTY", index)) {
            expression = new EmptyCollectionComparisonExpression(parent, "IS EMPTY", expression);
        } else if (wordParser.startsWithIdentifier("NULL", index)) {
            expression = new NullComparisonExpression(parent, "IS NULL", expression);
        } else {
            word = wordParser.substring(position, index - count2);
            expression = new UnknownExpression(parent, word);
        }
        expression.parse(wordParser, tolerant);
        return expression;
    }
}

