/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.resources.common;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Vector;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.resources.common.AbstractResource;
import org.eclipse.persistence.jpa.rs.util.IdHelper;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.StreamingOutputMarshaller;
import org.eclipse.persistence.jpa.rs.util.list.SimpleHomogeneousList;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;

public abstract class AbstractEntityResource
extends AbstractResource {
    protected Response findAttribute(String version, String persistenceUnit, String type, String key, String attribute, HttpHeaders hh, UriInfo ui, URI baseURI) {
        Object id;
        PersistenceContext app = this.getPersistenceContext(persistenceUnit, baseURI, version, null);
        if (app == null || app.getClass(type) == null) {
            if (app == null) {
                JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            } else {
                JPARSLogger.fine("jpars_could_not_find_class_in_persistence_unit", new Object[]{type, persistenceUnit});
            }
            return Response.status(Response.Status.NOT_FOUND).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        Map<String, String> discriminators = AbstractEntityResource.getMatrixParameters(ui, persistenceUnit);
        Object entity = app.findAttribute(discriminators, type, id = IdHelper.buildId(app, type, key), AbstractEntityResource.getQueryParameters(ui), attribute);
        if (entity == null) {
            JPARSLogger.fine("jpars_could_not_entity_for_attribute", new Object[]{type, key, attribute, persistenceUnit});
            return Response.status(Response.Status.NOT_FOUND).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        Boolean collectionContainsDomainObjects = this.collectionContainsDomainObjects(entity);
        if (collectionContainsDomainObjects != null) {
            if (collectionContainsDomainObjects.booleanValue()) {
                return Response.ok(new StreamingOutputMarshaller(app, entity, hh.getAcceptableMediaTypes())).build();
            }
            return Response.ok(new StreamingOutputMarshaller(app, (Object)this.populateSimpleHomogeneousList((Collection)entity, attribute), hh.getAcceptableMediaTypes())).build();
        }
        return Response.ok(new StreamingOutputMarshaller(app, entity, hh.getAcceptableMediaTypes())).build();
    }

    protected Response find(String version, String persistenceUnit, String type, String key, HttpHeaders hh, UriInfo ui, URI baseURI) {
        Object id;
        PersistenceContext app = this.getPersistenceContext(persistenceUnit, baseURI, version, null);
        if (app == null || app.getClass(type) == null) {
            if (app == null) {
                JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            } else {
                JPARSLogger.fine("jpars_could_not_find_class_in_persistence_unit", new Object[]{type, persistenceUnit});
            }
            return Response.status(Response.Status.NOT_FOUND).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        Map<String, String> discriminators = AbstractEntityResource.getMatrixParameters(ui, persistenceUnit);
        Object entity = app.find(discriminators, type, id = IdHelper.buildId(app, type, key), AbstractEntityResource.getQueryParameters(ui));
        if (entity == null) {
            JPARSLogger.fine("jpars_could_not_entity_for_key", new Object[]{type, key, persistenceUnit});
            return Response.status(Response.Status.NOT_FOUND).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        return Response.ok(new StreamingOutputMarshaller(app, entity, hh.getAcceptableMediaTypes())).build();
    }

    protected Response create(String version, String persistenceUnit, String type, HttpHeaders hh, UriInfo uriInfo, URI baseURI, InputStream in) throws JAXBException {
        Vector<DatabaseMapping> mappings;
        PersistenceContext app = this.getPersistenceContext(persistenceUnit, baseURI, version, null);
        if (app == null) {
            JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            return Response.status(Response.Status.NOT_FOUND).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        ClassDescriptor descriptor = app.getDescriptor(type);
        if (descriptor == null) {
            JPARSLogger.fine("jpars_could_not_find_class_in_persistence_unit", new Object[]{type, persistenceUnit});
            return Response.status(Response.Status.NOT_FOUND).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        Object entity = null;
        try {
            entity = app.unmarshalEntity(type, StreamingOutputMarshaller.mediaType(hh.getAcceptableMediaTypes()), in);
        }
        catch (JAXBException e) {
            JPARSLogger.fine("exception_while_unmarhalling_entity", new Object[]{type, persistenceUnit, e.toString()});
            return Response.status(Response.Status.BAD_REQUEST).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        AbstractDirectMapping sequenceMapping = descriptor.getObjectBuilder().getSequenceMapping();
        if (sequenceMapping != null) {
            Object value2 = sequenceMapping.getAttributeAccessor().getAttributeValueFromObject(entity);
            if (descriptor.getObjectBuilder().isPrimaryKeyComponentInvalid(value2, descriptor.getPrimaryKeyFields().indexOf(descriptor.getSequenceNumberField())) || descriptor.getSequence().shouldAlwaysOverrideExistingValue()) {
                JPARSLogger.fine("jpars_put_not_idempotent", new Object[]{type, persistenceUnit});
                return Response.status(Response.Status.BAD_REQUEST).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
            }
        }
        if ((mappings = descriptor.getMappings()) != null && !mappings.isEmpty()) {
            for (DatabaseMapping mapping : mappings) {
                Object value3;
                RelationalDescriptor relDesc;
                AbstractDirectMapping relSequenceMapping;
                ClassDescriptor referenceDescriptor;
                ForeignReferenceMapping fkMapping;
                if (!(mapping instanceof ForeignReferenceMapping) || !(fkMapping = (ForeignReferenceMapping)mapping).isCascadePersist() && !fkMapping.isCascadeMerge() || (referenceDescriptor = fkMapping.getReferenceDescriptor()) == null || !(referenceDescriptor instanceof RelationalDescriptor) || (relSequenceMapping = (relDesc = (RelationalDescriptor)referenceDescriptor).getObjectBuilder().getSequenceMapping()) == null || (value3 = mapping.getAttributeAccessor().getAttributeValueFromObject(entity)) == null) continue;
                if (value3 instanceof ValueHolder) {
                    Object obj;
                    ValueHolder holder = (ValueHolder)value3;
                    if (holder == null || (obj = holder.getValue()) == null) continue;
                    JPARSLogger.fine("jpars_put_not_idempotent", new Object[]{type, persistenceUnit});
                    return Response.status(Response.Status.BAD_REQUEST).build();
                }
                if (!(value3 instanceof Collection) || ((Collection)value3).isEmpty()) continue;
                JPARSLogger.fine("jpars_put_not_idempotent", new Object[]{type, persistenceUnit});
                return Response.status(Response.Status.BAD_REQUEST).build();
            }
        }
        app.create(AbstractEntityResource.getMatrixParameters(uriInfo, persistenceUnit), entity);
        Response.ResponseBuilder rb = Response.status(Response.Status.CREATED);
        rb.entity(new StreamingOutputMarshaller(app, entity, hh.getAcceptableMediaTypes()));
        return rb.build();
    }

    protected Response update(String version, String persistenceUnit, String type, HttpHeaders hh, UriInfo uriInfo, URI baseURI, InputStream in) {
        PersistenceContext app = this.getPersistenceContext(persistenceUnit, baseURI, version, null);
        if (app == null || app.getClass(type) == null) {
            if (app == null) {
                JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            } else {
                JPARSLogger.fine("jpars_could_not_find_class_in_persistence_unit", new Object[]{type, persistenceUnit});
            }
            return Response.status(Response.Status.NOT_FOUND).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        Object entity = null;
        try {
            entity = app.unmarshalEntity(type, StreamingOutputMarshaller.mediaType(hh.getAcceptableMediaTypes()), in);
        }
        catch (JAXBException e) {
            JPARSLogger.fine("exception_while_unmarhalling_entity", new Object[]{type, persistenceUnit, e.toString()});
            return Response.status(Response.Status.BAD_REQUEST).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        entity = app.merge(AbstractEntityResource.getMatrixParameters(uriInfo, persistenceUnit), entity);
        return Response.ok(new StreamingOutputMarshaller(app, entity, hh.getAcceptableMediaTypes())).build();
    }

    protected Response setOrAddAttribute(String version, String persistenceUnit, String type, String key, String attribute, HttpHeaders hh, UriInfo ui, URI baseURI, InputStream in) {
        PersistenceContext app = this.getPersistenceContext(persistenceUnit, baseURI, version, null);
        if (app == null || app.getClass(type) == null) {
            if (app == null) {
                JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            } else {
                JPARSLogger.fine("jpars_could_not_find_class_in_persistence_unit", new Object[]{type, persistenceUnit});
            }
            return Response.status(Response.Status.NOT_FOUND).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        Object id = IdHelper.buildId(app, type, key);
        Object entity = null;
        String partner = this.getRelationshipPartner(AbstractEntityResource.getMatrixParameters(ui, attribute), AbstractEntityResource.getQueryParameters(ui));
        try {
            ClassDescriptor descriptor = app.getDescriptor(type);
            DatabaseMapping mapping = descriptor.getMappingForAttributeName(attribute);
            if (!mapping.isForeignReferenceMapping()) {
                JPARSLogger.fine("jpars_could_find_appropriate_mapping_for_update", new Object[]{attribute, type, key, persistenceUnit});
                return Response.status(Response.Status.NOT_FOUND).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
            }
            entity = app.unmarshalEntity(((ForeignReferenceMapping)mapping).getReferenceDescriptor().getAlias(), StreamingOutputMarshaller.mediaType(hh.getAcceptableMediaTypes()), in);
        }
        catch (JAXBException e) {
            JPARSLogger.fine("exception_while_unmarhalling_entity", new Object[]{type, persistenceUnit, e.toString()});
            return Response.status(Response.Status.BAD_REQUEST).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        Object result2 = app.updateOrAddAttribute(AbstractEntityResource.getMatrixParameters(ui, persistenceUnit), type, id, AbstractEntityResource.getQueryParameters(ui), attribute, entity, partner);
        if (result2 == null) {
            JPARSLogger.fine("jpars_could_not_update_attribute", new Object[]{attribute, type, key, persistenceUnit});
            return Response.status(Response.Status.NOT_FOUND).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        return Response.ok(new StreamingOutputMarshaller(app, result2, hh.getAcceptableMediaTypes())).build();
    }

    protected Response removeAttributeInternal(String version, String persistenceUnit, String type, String key, String attribute, HttpHeaders hh, UriInfo ui) {
        String listItemId = null;
        Map<String, String> matrixParams = AbstractEntityResource.getMatrixParameters(ui, attribute);
        Map<String, Object> queryParams = AbstractEntityResource.getQueryParameters(ui);
        if (queryParams != null && !queryParams.isEmpty()) {
            listItemId = (String)queryParams.get("eclipselink.jpars.list.item-id");
        }
        String partner = this.getRelationshipPartner(matrixParams, queryParams);
        PersistenceContext app = this.getPersistenceContext(persistenceUnit, ui.getBaseUri(), version, null);
        if (app == null || app.getClass(type) == null) {
            if (app == null) {
                JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            } else {
                JPARSLogger.fine("jpars_could_not_find_class_in_persistence_unit", new Object[]{type, persistenceUnit});
            }
            return Response.status(Response.Status.BAD_REQUEST).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        if (attribute == null && listItemId == null) {
            return Response.status(Response.Status.BAD_REQUEST).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        Object id = IdHelper.buildId(app, type, key);
        ClassDescriptor descriptor = app.getDescriptor(type);
        DatabaseMapping mapping = descriptor.getMappingForAttributeName(attribute);
        if (!mapping.isForeignReferenceMapping()) {
            JPARSLogger.fine("jpars_could_find_appropriate_mapping_for_update", new Object[]{attribute, type, key, persistenceUnit});
            return Response.status(Response.Status.NOT_FOUND).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        Map<String, String> discriminators = AbstractEntityResource.getMatrixParameters(ui, persistenceUnit);
        Object entity = app.find(discriminators, type, id, AbstractEntityResource.getQueryParameters(ui));
        Object result2 = app.removeAttribute(AbstractEntityResource.getMatrixParameters(ui, persistenceUnit), type, id, attribute, listItemId, entity, partner);
        if (result2 == null) {
            JPARSLogger.fine("jpars_could_not_update_attribute", new Object[]{attribute, type, key, persistenceUnit});
            return Response.status(Response.Status.NOT_FOUND).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        return Response.ok(new StreamingOutputMarshaller(app, result2, hh.getAcceptableMediaTypes())).build();
    }

    protected Response delete(String version, String persistenceUnit, String type, String key, UriInfo ui, HttpHeaders hh, URI baseURI) {
        PersistenceContext app = this.getPersistenceContext(persistenceUnit, baseURI, version, null);
        if (app == null || app.getClass(type) == null) {
            if (app == null) {
                JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            } else {
                JPARSLogger.fine("jpars_could_not_find_class_in_persistence_unit", new Object[]{type, persistenceUnit});
            }
            return Response.status(Response.Status.NOT_FOUND).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        Map<String, String> discriminators = AbstractEntityResource.getMatrixParameters(ui, persistenceUnit);
        Object id = IdHelper.buildId(app, type, key);
        app.delete(discriminators, type, id);
        return Response.ok().build();
    }

    private Boolean collectionContainsDomainObjects(Object object) {
        if (!(object instanceof Collection)) {
            return null;
        }
        Collection collection = (Collection)object;
        for (Object collectionItem : collection) {
            if (!PersistenceWeavedRest.class.isAssignableFrom(collectionItem.getClass())) continue;
            return true;
        }
        return false;
    }

    private SimpleHomogeneousList populateSimpleHomogeneousList(Collection collection, String attributeName) {
        SimpleHomogeneousList simpleList = new SimpleHomogeneousList();
        ArrayList<JAXBElement> items = new ArrayList<JAXBElement>();
        for (Object collectionItem : collection) {
            if (PersistenceWeavedRest.class.isAssignableFrom(collectionItem.getClass())) continue;
            JAXBElement jaxbElement = new JAXBElement(new QName(attributeName), collectionItem.getClass(), collectionItem);
            items.add(jaxbElement);
        }
        simpleList.setItems(items);
        return simpleList;
    }
}

