/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.util.xmladapters;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.logging.LoggingLocalization;
import org.eclipse.persistence.jpa.rs.util.IdHelper;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.mappings.XMLInverseReferenceMapping;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;

public class ReferenceAdapter<T extends PersistenceWeavedRest>
extends XmlAdapter<Object, Object> {
    private String baseURI = null;
    private PersistenceContext context = null;

    public ReferenceAdapter() {
    }

    public ReferenceAdapter(String baseURI, PersistenceContext context) {
        this.baseURI = baseURI;
        this.context = context;
    }

    @Override
    public Link marshal(Object o) throws Exception {
        if (o == null) {
            return null;
        }
        ClassDescriptor descriptor = this.context.getJAXBDescriptorForClass(o.getClass());
        PersistenceWeavedRest t = (PersistenceWeavedRest)descriptor.getObjectBuilder().buildNewInstance();
        Link link = new Link();
        link.setMethod("GET");
        link.setRel("self");
        String id = IdHelper.stringifyId(o, descriptor.getAlias(), this.context);
        String version = this.context.getVersion();
        if (version != null) {
            link.setHref(String.valueOf(this.baseURI) + version + "/" + this.context.getName() + "/entity/" + descriptor.getAlias() + "/" + id);
        } else {
            link.setHref(String.valueOf(this.baseURI) + this.context.getName() + "/entity/" + descriptor.getAlias() + "/" + id);
        }
        descriptor.getMappingForAttributeName("_persistence_href").setAttributeValueInObject(t, link);
        return link;
    }

    @Override
    public T unmarshal(Object object) throws Exception {
        if (object == null) {
            return null;
        }
        PersistenceWeavedRest persistenceWeavedRest = null;
        Link link = null;
        if (object instanceof PersistenceWeavedRest) {
            persistenceWeavedRest = (PersistenceWeavedRest)object;
            link = persistenceWeavedRest._persistence_getHref();
        } else if (object instanceof Link) {
            link = (Link)object;
        } else {
            return null;
        }
        if ((link == null || link != null && link.getHref() == null) && persistenceWeavedRest != null) {
            ClassDescriptor descriptor = this.context.getJAXBDescriptorForClass(persistenceWeavedRest.getClass());
            if (persistenceWeavedRest instanceof FetchGroupTracker && JpaHelper.getDatabaseSession(this.context.getEmf()).doesObjectExist(persistenceWeavedRest) && this.context.doesExist(null, persistenceWeavedRest)) {
                FetchGroup fetchGroup = new FetchGroup();
                for (DatabaseMapping mapping : descriptor.getMappings()) {
                    if (mapping instanceof XMLInverseReferenceMapping) continue;
                    fetchGroup.addAttribute(mapping.getAttributeName());
                }
                new FetchGroupManager().setObjectFetchGroup(persistenceWeavedRest, fetchGroup, null);
            }
            return (T)persistenceWeavedRest;
        }
        if (link != null && link.getHref() != null) {
            String uri = link.getHref().replace("\\/", "/");
            String entityType = uri.substring(uri.indexOf("/entity/"), uri.lastIndexOf(47));
            entityType = entityType.substring(entityType.lastIndexOf("/") + 1);
            String entityId = uri.substring(uri.lastIndexOf("/") + 1);
            ClassDescriptor descriptor = this.context.getDescriptor(entityType);
            Object id = IdHelper.buildId(this.context, descriptor.getAlias(), entityId);
            PersistenceWeavedRest foundEntity = (PersistenceWeavedRest)this.getObjectById(entityType, id);
            return (T)foundEntity;
        }
        return null;
    }

    private Object getObjectById(String entityType, Object id) throws Exception {
        Object entity = this.context.find(null, entityType, id, null);
        if (entity != null) {
            return entity;
        }
        throw new JPARSException(LoggingLocalization.buildMessage("object_referred_by_link_does_not_exist", new Object[]{entityType, id}));
    }
}

