/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.logging.EclipseLinkLogRecord;

public class LogFormatter
extends SimpleFormatter {
    Date dat = new Date();
    private static final String format = "{0,date} {0,time}";
    private MessageFormat formatter;
    private Object[] args = new Object[1];
    private String lineSeparator = PrivilegedAccessHelper.getLineSeparator();

    @Override
    public synchronized String format(LogRecord record0) {
        if (!(record0 instanceof EclipseLinkLogRecord)) {
            return super.format(record0);
        }
        EclipseLinkLogRecord record2 = (EclipseLinkLogRecord)record0;
        StringBuffer sb = new StringBuffer();
        if (record2.shouldPrintDate()) {
            this.dat.setTime(record2.getMillis());
            this.args[0] = this.dat;
            StringBuffer text = new StringBuffer();
            if (this.formatter == null) {
                this.formatter = new MessageFormat(format);
            }
            this.formatter.format(this.args, text, (FieldPosition)null);
            sb.append(text);
            sb.append(" ");
        }
        if (record2.getSourceClassName() != null) {
            sb.append(record2.getSourceClassName());
        } else {
            sb.append(record2.getLoggerName());
        }
        if (record2.getSourceMethodName() != null) {
            sb.append(" ");
            sb.append(record2.getSourceMethodName());
        }
        if (record2.getSessionString() != null) {
            sb.append(" ");
            sb.append(record2.getSessionString());
        }
        if (record2.getConnection() != null) {
            sb.append(" ");
            sb.append("Connection(" + String.valueOf(System.identityHashCode(record2.getConnection())) + ")");
        }
        if (record2.shouldPrintThread()) {
            sb.append(" ");
            sb.append("Thread(" + String.valueOf(record2.getThreadID()) + ")");
        }
        sb.append(this.lineSeparator);
        String message = this.formatMessage(record2);
        sb.append(record2.getLevel().getLocalizedName());
        sb.append(": ");
        sb.append(message);
        sb.append(this.lineSeparator);
        if (record2.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                if (record2.getLevel().intValue() == Level.SEVERE.intValue()) {
                    record2.getThrown().printStackTrace(pw);
                } else if (record2.getLevel().intValue() <= Level.WARNING.intValue()) {
                    if (record2.shouldLogExceptionStackTrace()) {
                        record2.getThrown().printStackTrace(pw);
                    } else {
                        pw.write(record2.getThrown().toString());
                        pw.write(this.lineSeparator);
                    }
                }
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception exception) {}
        }
        return sb.toString();
    }
}

