/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.converters;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.persistence.AttributeConverter;
import javax.persistence.PersistenceException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.sessions.Session;

public class ConverterClass
implements Converter {
    protected boolean isForMapKey;
    protected boolean disableConversion;
    protected Class fieldClassification;
    protected String fieldClassificationName;
    protected String attributeConverterClassName;
    protected AttributeConverter attributeConverter;

    public ConverterClass(String attributeConverterClassName, boolean isForMapKey, String fieldClassificationName, boolean disableConversion) {
        this.isForMapKey = isForMapKey;
        this.disableConversion = disableConversion;
        this.fieldClassificationName = fieldClassificationName;
        this.attributeConverterClassName = attributeConverterClassName;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        block13: {
            block12: {
                Class attributeConverterClass = null;
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            attributeConverterClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.attributeConverterClassName, true, classLoader));
                            this.attributeConverter = (AttributeConverter)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(attributeConverterClass));
                            break block12;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.attributeConverterClassName, exception.getException());
                        }
                    }
                    attributeConverterClass = PrivilegedAccessHelper.getClassForName(this.attributeConverterClassName, true, classLoader);
                    this.attributeConverter = (AttributeConverter)PrivilegedAccessHelper.newInstanceFromClass(attributeConverterClass);
                }
                catch (ClassNotFoundException exception) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.attributeConverterClassName, exception);
                }
                catch (IllegalAccessException exception) {
                    throw ValidationException.errorInstantiatingClass(attributeConverterClass, exception);
                }
                catch (InstantiationException exception) {
                    throw ValidationException.errorInstantiatingClass(attributeConverterClass, exception);
                }
            }
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.fieldClassification = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.fieldClassificationName, true, classLoader));
                        break block13;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.fieldClassificationName, exception.getException());
                    }
                }
                this.fieldClassification = PrivilegedAccessHelper.getClassForName(this.fieldClassificationName, true, classLoader);
            }
            catch (ClassNotFoundException exception) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.attributeConverterClassName, exception);
            }
        }
    }

    @Override
    public Object convertDataValueToObjectValue(Object dataValue, Session session) {
        try {
            return this.attributeConverter.convertToEntityAttribute(dataValue);
        }
        catch (RuntimeException re) {
            throw new PersistenceException(ExceptionLocalization.buildMessage("wrap_convert_exception", new Object[]{"convertToEntityAttribute", this.attributeConverterClassName, dataValue}), re);
        }
    }

    @Override
    public Object convertObjectValueToDataValue(Object objectValue, Session session) {
        try {
            return this.attributeConverter.convertToDatabaseColumn(objectValue);
        }
        catch (RuntimeException re) {
            throw new PersistenceException(ExceptionLocalization.buildMessage("wrap_convert_exception", new Object[]{"convertToDatabaseColumn", this.attributeConverterClassName, objectValue}), re);
        }
    }

    @Override
    public void initialize(DatabaseMapping mapping, Session session) {
        if (mapping.isDirectToFieldMapping()) {
            DirectToFieldMapping m3 = (DirectToFieldMapping)mapping;
            if (this.disableConversion) {
                m3.setConverter(null);
            } else {
                m3.setConverter(this);
                m3.setFieldClassification(this.fieldClassification);
                m3.setFieldClassificationClassName(this.fieldClassificationName);
            }
        } else if (mapping.isDirectMapMapping() && this.isForMapKey) {
            DirectMapMapping m4 = (DirectMapMapping)mapping;
            if (this.disableConversion) {
                m4.setKeyConverter(null);
            } else {
                m4.setKeyConverter(this);
                m4.setDirectKeyFieldClassification(this.fieldClassification);
                m4.setDirectKeyFieldClassificationName(this.fieldClassificationName);
            }
        } else if (mapping.isDirectCollectionMapping()) {
            DirectCollectionMapping m5 = (DirectCollectionMapping)mapping;
            if (this.disableConversion) {
                m5.setValueConverter(null);
            } else {
                m5.setValueConverter(this);
                m5.setDirectFieldClassification(this.fieldClassification);
                m5.setDirectFieldClassificationName(this.fieldClassificationName);
            }
        }
    }

    @Override
    public boolean isMutable() {
        return false;
    }
}

