/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEventManager;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.oxm.Context;
import org.eclipse.persistence.internal.oxm.QNameInheritancePolicy;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.Unmarshaller;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathQName;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.XMLChoiceCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.queries.AttributeGroup;

public class XMLDescriptor
extends ClassDescriptor
implements Descriptor<AttributeAccessor, DatabaseMapping, DatabaseField, InheritancePolicy, InstantiationPolicy, NamespaceResolver, ObjectBuilder, UnmarshalRecord, XMLUnmarshaller> {
    private static final Vector EMPTY_VECTOR = NonSynchronizedVector.newInstance(1);
    private NamespaceResolver namespaceResolver;
    private XMLSchemaReference schemaReference;
    private boolean shouldPreserveDocument = false;
    private XMLField defaultRootElementField;
    private boolean sequencedObject = false;
    private boolean isWrapper = false;
    private boolean resultAlwaysXMLRoot = false;
    private boolean lazilyInitialized = false;
    private AttributeAccessor locationAccessor = null;
    private boolean hasReferenceMappings = false;

    public XMLDescriptor() {
        this.tables = NonSynchronizedVector.newInstance(3);
        this.mappings = NonSynchronizedVector.newInstance();
        this.primaryKeyFields = null;
        this.fields = NonSynchronizedVector.newInstance();
        this.allFields = NonSynchronizedVector.newInstance();
        this.constraintDependencies = EMPTY_VECTOR;
        this.multipleTableForeignKeys = Collections.EMPTY_MAP;
        this.queryKeys = Collections.EMPTY_MAP;
        this.initializationStage = 0;
        this.interfaceInitializationStage = 0;
        this.descriptorType = 0;
        this.shouldOrderMappings = true;
        this.shouldBeReadOnly = false;
        this.shouldAlwaysConformResultsInUnitOfWork = false;
        this.shouldAcquireCascadedLocks = false;
        this.hasSimplePrimaryKey = false;
        this.idValidation = null;
        this.derivesIdMappings = Collections.EMPTY_MAP;
        this.additionalWritableMapKeyFields = Collections.EMPTY_LIST;
        this.objectBuilder = new TreeObjectBuilder(this);
        this.shouldOrderMappings = false;
        this.descriptorIsAggregate();
    }

    @Override
    public String getDefaultRootElement() {
        if (this.getTables().isEmpty()) {
            return null;
        }
        return this.getTables().firstElement().getName();
    }

    @Override
    public boolean shouldPreserveDocument() {
        return this.shouldPreserveDocument;
    }

    public void setShouldPreserveDocument(boolean shouldPreserveDocument) {
        this.shouldPreserveDocument = shouldPreserveDocument;
    }

    @Override
    public void addRootElement(String rootElementName) {
        if (rootElementName != null && !this.getTableNames().contains(rootElementName)) {
            this.addTableName(rootElementName);
        }
    }

    @Override
    public void setDefaultRootElement(String newDefaultRootElement) {
        if (this.setDefaultRootElementField(newDefaultRootElement)) {
            int index = this.getTableNames().indexOf(newDefaultRootElement);
            if (index == 0) {
                return;
            }
            DatabaseTable databaseTable = new DatabaseTable();
            databaseTable.setUseDelimiters(false);
            databaseTable.setName(newDefaultRootElement);
            if (index >= 0) {
                this.getTables().remove(index);
                this.getTables().add(0, databaseTable);
            } else {
                this.getTables().add(0, databaseTable);
            }
        }
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    @Override
    public NamespaceResolver getNonNullNamespaceResolver() {
        if (this.namespaceResolver == null) {
            this.namespaceResolver = new NamespaceResolver();
        }
        return this.namespaceResolver;
    }

    @Override
    public InheritancePolicy getInheritancePolicy() {
        if (this.inheritancePolicy == null) {
            this.setInheritancePolicy(new QNameInheritancePolicy(this));
        }
        return (InheritancePolicy)this.inheritancePolicy;
    }

    @Override
    public void setNamespaceResolver(NamespaceResolver newNamespaceResolver) {
        this.namespaceResolver = newNamespaceResolver;
    }

    @Override
    public XMLSchemaReference getSchemaReference() {
        return this.schemaReference;
    }

    @Override
    public void setSchemaReference(XMLSchemaReference newSchemaReference) {
        this.schemaReference = newSchemaReference;
    }

    @Override
    public boolean isXMLDescriptor() {
        return true;
    }

    @Override
    public boolean isLazilyInitialized() {
        return this.lazilyInitialized;
    }

    public void setLazilyInitialized(boolean shouldLazyInitiailize) {
        this.lazilyInitialized = shouldLazyInitiailize;
    }

    @Override
    public Vector<String> getPrimaryKeyFieldNames() {
        if (this.primaryKeyFields == null) {
            return new Vector<String>(0);
        }
        return super.getPrimaryKeyFieldNames();
    }

    @Override
    protected void validateMappingType(DatabaseMapping mapping) {
        if (!mapping.isXMLMapping()) {
            throw DescriptorException.invalidMappingType(mapping);
        }
    }

    @Override
    public AbstractRecord buildNestedRowFromFieldValue(Object fieldValue) {
        if (fieldValue instanceof XMLRecord) {
            return (XMLRecord)fieldValue;
        }
        if (!(fieldValue instanceof Vector)) {
            return ((ObjectBuilder)this.getObjectBuilder()).createRecord((AbstractSession)null);
        }
        Vector nestedRows = (Vector)fieldValue;
        if (nestedRows.isEmpty()) {
            return ((ObjectBuilder)this.getObjectBuilder()).createRecord((AbstractSession)null);
        }
        if (!(nestedRows.firstElement() instanceof AbstractRecord)) {
            return ((ObjectBuilder)this.getObjectBuilder()).createRecord((AbstractSession)null);
        }
        return (XMLRecord)nestedRows.firstElement();
    }

    @Override
    public Vector buildNestedRowsFromFieldValue(Object fieldValue, AbstractSession session) {
        if (!(fieldValue instanceof Vector)) {
            return new Vector(0);
        }
        return (Vector)fieldValue;
    }

    @Override
    public AbstractDirectMapping newDirectMapping() {
        return new XMLDirectMapping();
    }

    @Override
    public AggregateMapping newAggregateMapping() {
        return new XMLCompositeObjectMapping();
    }

    @Override
    public DatabaseMapping newAggregateCollectionMapping() {
        return new XMLCompositeCollectionMapping();
    }

    @Override
    public DatabaseMapping newDirectCollectionMapping() {
        return new XMLCompositeDirectCollectionMapping();
    }

    @Override
    public DatabaseMapping addDirectMapping(String attributeName, String xpathString) {
        XMLDirectMapping mapping = new XMLDirectMapping();
        mapping.setAttributeName(attributeName);
        mapping.setXPath(xpathString);
        return this.addMapping(mapping);
    }

    @Override
    public DatabaseMapping addDirectMapping(String attributeName, String getMethodName, String setMethodName, String xpathString) {
        XMLDirectMapping mapping = new XMLDirectMapping();
        mapping.setAttributeName(attributeName);
        mapping.setSetMethodName(setMethodName);
        mapping.setGetMethodName(getMethodName);
        mapping.setXPath(xpathString);
        return this.addMapping(mapping);
    }

    @Override
    public void addPrimaryKeyFieldName(String fieldName) {
        this.addPrimaryKeyField(new XMLField(fieldName));
    }

    @Override
    public void addPrimaryKeyField(DatabaseField field2) {
        if (!(field2 instanceof XMLField)) {
            String fieldName = field2.getName();
            field2 = new XMLField(fieldName);
        }
        if (this.primaryKeyFields == null) {
            this.primaryKeyFields = new ArrayList(1);
        }
        super.addPrimaryKeyField(field2);
    }

    @Override
    public void setPrimaryKeyFields(List<DatabaseField> thePrimaryKeyFields) {
        if (thePrimaryKeyFields == null) {
            return;
        }
        ArrayList<DatabaseField> xmlFields = new ArrayList<DatabaseField>(thePrimaryKeyFields.size());
        for (DatabaseField field2 : thePrimaryKeyFields) {
            if (!(field2 instanceof XMLField)) {
                String fieldName = field2.getName();
                field2 = new XMLField(fieldName);
            }
            xmlFields.add(field2);
        }
        super.setPrimaryKeyFields((List<DatabaseField>)xmlFields);
    }

    @Override
    public Vector buildDirectValuesFromFieldValue(Object fieldValue) throws DatabaseException {
        if (!(fieldValue instanceof Vector)) {
            Vector<Object> fieldValues = new Vector<Object>(1);
            fieldValues.add(fieldValue);
            return fieldValues;
        }
        return (Vector)fieldValue;
    }

    @Override
    public Object buildFieldValueFromDirectValues(Vector directValues, String elementDataTypeName, AbstractSession session) throws DatabaseException {
        return directValues;
    }

    @Override
    public Object buildFieldValueFromNestedRows(Vector nestedRows, String structureName, AbstractSession session) throws DatabaseException {
        return nestedRows;
    }

    @Override
    public DatabaseField buildField(String fieldName) {
        XMLField xmlField = new XMLField(fieldName);
        xmlField.setNamespaceResolver(this.getNamespaceResolver());
        return xmlField;
    }

    @Override
    public DatabaseField buildField(DatabaseField field2) {
        try {
            XMLField xmlField = (XMLField)field2;
            xmlField.setNamespaceResolver(this.getNamespaceResolver());
            xmlField.initialize();
        }
        catch (ClassCastException classCastException) {}
        return super.buildField(field2);
    }

    @Override
    public void initializeAggregateInheritancePolicy(AbstractSession session) {
    }

    @Override
    public void setTableNames(Vector tableNames) {
        if (tableNames != null && tableNames.size() > 0) {
            this.setDefaultRootElementField((String)tableNames.get(0));
        }
        super.setTableNames(tableNames);
    }

    @Override
    public void setTables(Vector<DatabaseTable> theTables) {
        super.setTables(theTables);
    }

    @Override
    public void preInitialize(AbstractSession session) throws DescriptorException {
        if (this.isInitialized(1)) {
            return;
        }
        this.setInitializationStage(1);
        Enumeration<DatabaseMapping> mappingsEnum = this.getMappings().elements();
        while (mappingsEnum.hasMoreElements()) {
            try {
                DatabaseMapping mapping = mappingsEnum.nextElement();
                mapping.preInitialize(session);
            }
            catch (DescriptorException exception) {
                session.getIntegrityChecker().handleError(exception);
            }
        }
        this.getCachePolicy().useNoIdentityMap();
        this.getQueryManager().getDoesExistQuery().setExistencePolicy(4);
        this.validateBeforeInitialization(session);
        this.preInitializeInheritancePolicy(session);
        this.verifyTableQualifiers(session.getDatasourcePlatform());
        this.initializeProperties(session);
        if (this.hasInterfacePolicy()) {
            this.preInterfaceInitialization(session);
        }
        this.getCachePolicy().assignDefaultValues(session);
    }

    @Override
    protected void preInitializeInheritancePolicy(AbstractSession session) throws DescriptorException {
        super.preInitializeInheritancePolicy(session);
        if (this.hasInheritance()) {
            XMLDescriptor parentDescriptor;
            NamespaceResolver parentNamespaceResolver;
            if (this.isChildDescriptor() && (parentNamespaceResolver = (parentDescriptor = (XMLDescriptor)this.getInheritancePolicy().getParentDescriptor()).getNamespaceResolver()) != null && parentNamespaceResolver != this.namespaceResolver) {
                if (this.namespaceResolver == null) {
                    this.namespaceResolver = this.getNonNullNamespaceResolver();
                }
                if (parentNamespaceResolver.hasPrefixesToNamespaces()) {
                    for (Map.Entry<String, String> entry2 : parentNamespaceResolver.getPrefixesToNamespaces().entrySet()) {
                        String namespaceURI = this.namespaceResolver.resolveNamespacePrefix(entry2.getKey());
                        if (namespaceURI == null) {
                            this.namespaceResolver.put(entry2.getKey(), entry2.getValue());
                            continue;
                        }
                        if (namespaceURI.equals(entry2.getValue())) continue;
                        throw XMLMarshalException.subclassAttemptedToOverrideNamespaceDeclaration(entry2.getKey(), this.getJavaClassName(), namespaceURI, parentDescriptor.getJavaClassName(), entry2.getValue());
                    }
                }
            }
            this.getInheritancePolicy().preInitialize(session);
        } else {
            this.setInternalDefaultTable();
        }
    }

    @Override
    public void postInitialize(AbstractSession session) throws DescriptorException {
        if (this.isInitialized(3) || this.isInvalid()) {
            return;
        }
        this.setInitializationStage(3);
        if (this.hasInheritance()) {
            for (ClassDescriptor child : this.getInheritancePolicy().getChildDescriptors()) {
                child.postInitialize(session);
            }
        }
        for (DatabaseMapping mapping : this.getMappings()) {
            mapping.postInitialize(session);
        }
        if (this.hasInheritance()) {
            this.getInheritancePolicy().postInitialize(session);
        }
        if (this.primaryKeyFields != null) {
            int index = this.primaryKeyFields.size() - 1;
            while (index >= 0) {
                DatabaseField primaryKeyField = this.getPrimaryKeyFields().get(index);
                int fieldIndex = this.getFields().indexOf(primaryKeyField);
                if (fieldIndex != -1) {
                    primaryKeyField = this.getFields().get(fieldIndex);
                    this.getPrimaryKeyFields().set(index, primaryKeyField);
                }
                --index;
            }
        }
        int index = 0;
        while (index < this.getFields().size()) {
            DatabaseMapping mapping;
            DatabaseField field2 = this.getFields().elementAt(index);
            if (field2.getType() == null && (mapping = ((ObjectBuilder)this.getObjectBuilder()).getMappingForField(field2)) != null) {
                field2.setType(mapping.getFieldClassification(field2));
            }
            field2.setIndex(index);
            ++index;
        }
        this.validateAfterInitialization(session);
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        if (this.hasInheritance()) {
            ((QNameInheritancePolicy)this.getInheritancePolicy()).setNamespaceResolver(this.getNamespaceResolver());
        }
        if (this.defaultRootElementField != null) {
            this.defaultRootElementField.setNamespaceResolver(this.namespaceResolver);
            this.defaultRootElementField.initialize();
        }
        if (this.schemaReference != null && this.schemaReference.getSchemaContext() != null && (this.schemaReference.getType() == 1 || this.schemaReference.getType() == 2) && this.getDefaultRootElementType() == null) {
            if (this.hasInheritance() && this.isChildDescriptor()) {
                XMLField parentField = ((XMLDescriptor)this.getInheritancePolicy().getParentDescriptor()).getDefaultRootElementField();
                if (parentField == null || parentField != null && this.defaultRootElementField != null && !this.defaultRootElementField.getXPathFragment().equals(parentField.getXPathFragment())) {
                    this.setDefaultRootElementType(this.schemaReference.getSchemaContextAsQName(this.getNamespaceResolver()));
                }
            } else {
                this.setDefaultRootElementType(this.schemaReference.getSchemaContextAsQName(this.getNamespaceResolver()));
            }
        }
        if (this.primaryKeyFields != null) {
            int x = 0;
            int primaryKeyFieldsSize = this.primaryKeyFields.size();
            while (x < primaryKeyFieldsSize) {
                XMLField pkField = (XMLField)this.primaryKeyFields.get(x);
                pkField.setNamespaceResolver(this.namespaceResolver);
                pkField.initialize();
                ++x;
            }
        }
        if (this.shouldBeReadOnly() && !session.getDefaultReadOnlyClasses().contains(this.getJavaClass())) {
            session.getDefaultReadOnlyClasses().add(this.getJavaClass());
        }
        if (this.isInitialized(2) || this.isInvalid()) {
            return;
        }
        this.setInitializationStage(2);
        if (this.isChildDescriptor()) {
            ClassDescriptor parentDescriptor = this.getInheritancePolicy().getParentDescriptor();
            parentDescriptor.initialize(session);
            if (parentDescriptor.hasEventManager()) {
                this.getEventManager();
            }
        }
        Enumeration<DatabaseMapping> mappingsEnum = this.getMappings().elements();
        while (mappingsEnum.hasMoreElements()) {
            DatabaseMapping choiceMapping;
            DatabaseMapping mapping = mappingsEnum.nextElement();
            this.validateMappingType(mapping);
            mapping.initialize(session);
            if (mapping.isObjectReferenceMapping()) {
                this.hasReferenceMappings = true;
            }
            if (mapping instanceof XMLChoiceObjectMapping) {
                choiceMapping = (XMLChoiceObjectMapping)mapping;
                for (XMLMapping next2 : ((XMLChoiceObjectMapping)choiceMapping).getChoiceElementMappings().values()) {
                    if (!((DatabaseMapping)((Object)next2)).isObjectReferenceMapping()) continue;
                    this.hasReferenceMappings = true;
                }
            }
            if (mapping instanceof XMLChoiceCollectionMapping) {
                choiceMapping = (XMLChoiceCollectionMapping)mapping;
                for (XMLMapping next2 : ((XMLChoiceCollectionMapping)choiceMapping).getChoiceElementMappings().values()) {
                    if (!((DatabaseMapping)((Object)next2)).isObjectReferenceMapping()) continue;
                    this.hasReferenceMappings = true;
                }
            }
            Helper.addAllUniqueToVector(this.getFields(), mapping.getFields());
        }
        if (this.hasInheritance()) {
            this.getInheritancePolicy().initialize(session);
        }
        this.setAllFields((Vector)this.getFields().clone());
        ((ObjectBuilder)this.getObjectBuilder()).initialize(session);
        if (this.hasInterfacePolicy()) {
            this.interfaceInitialization(session);
        }
        if (this.hasReturningPolicy()) {
            this.getReturningPolicy().initialize(session);
        }
        if (this.eventManager != null) {
            ((DescriptorEventManager)this.eventManager).initialize(session);
        }
        if (this.copyPolicy != null) {
            this.copyPolicy.initialize(session);
        }
        ((InstantiationPolicy)this.getInstantiationPolicy()).initialize(session);
        if (this.getSchemaReference() != null) {
            this.getSchemaReference().initialize(session);
        }
        if (this.getInheritancePolicyOrNull() != null && this.getInheritancePolicy().getParentDescriptor() != null) {
            XMLDescriptor d = (XMLDescriptor)this.getInheritancePolicy().getParentDescriptor();
            this.locationAccessor = d.getLocationAccessor();
        }
        if (this.locationAccessor != null) {
            this.locationAccessor.initializeAttributes(this.getJavaClass());
        }
    }

    @Override
    public boolean requiresInitialization(AbstractSession session) {
        return !this.isDescriptorForInterface();
    }

    @Override
    protected DatabaseTable extractDefaultTable() {
        return new DatabaseTable();
    }

    @Override
    public Object wrapObjectInXMLRoot(UnmarshalRecord unmarshalRecord, boolean forceWrap) {
        String elementLocalName = unmarshalRecord.getLocalName();
        String elementNamespaceUri = unmarshalRecord.getRootElementNamespaceUri();
        if (forceWrap || this.shouldWrapObject(unmarshalRecord.getCurrentObject(), elementNamespaceUri, elementLocalName, null, unmarshalRecord.isNamespaceAware())) {
            XMLRoot xmlRoot = new XMLRoot();
            xmlRoot.setLocalName(elementLocalName);
            xmlRoot.setNamespaceURI(elementNamespaceUri);
            xmlRoot.setObject(unmarshalRecord.getCurrentObject());
            xmlRoot.setEncoding(unmarshalRecord.getEncoding());
            xmlRoot.setVersion(unmarshalRecord.getVersion());
            xmlRoot.setSchemaLocation(unmarshalRecord.getSchemaLocation());
            xmlRoot.setNoNamespaceSchemaLocation(unmarshalRecord.getNoNamespaceSchemaLocation());
            xmlRoot.setNil(unmarshalRecord.isNil());
            this.setDeclaredTypeOnXMLRoot(xmlRoot, elementNamespaceUri, elementLocalName, unmarshalRecord.isNamespaceAware(), (Unmarshaller)unmarshalRecord.getUnmarshaller());
            return xmlRoot;
        }
        return unmarshalRecord.getCurrentObject();
    }

    @Override
    public Object wrapObjectInXMLRoot(Object object, String elementNamespaceUri, String elementLocalName, String elementPrefix, boolean forceWrap, boolean isNamespaceAware, XMLUnmarshaller xmlUnmarshaller) {
        if (forceWrap || this.shouldWrapObject(object, elementNamespaceUri, elementLocalName, elementPrefix, isNamespaceAware)) {
            XMLRoot xmlRoot = new XMLRoot();
            xmlRoot.setLocalName(elementLocalName);
            xmlRoot.setNamespaceURI(elementNamespaceUri);
            xmlRoot.setObject(object);
            this.setDeclaredTypeOnXMLRoot(xmlRoot, elementNamespaceUri, elementLocalName, isNamespaceAware, xmlUnmarshaller);
            return xmlRoot;
        }
        return object;
    }

    @Override
    public Object wrapObjectInXMLRoot(Object object, String elementNamespaceUri, String elementLocalName, String elementPrefix, String encoding, String version, boolean forceWrap, boolean isNamespaceAware, XMLUnmarshaller unmarshaller) {
        if (forceWrap || this.shouldWrapObject(object, elementNamespaceUri, elementLocalName, elementPrefix, isNamespaceAware)) {
            XMLRoot xmlRoot = new XMLRoot();
            xmlRoot.setLocalName(elementLocalName);
            xmlRoot.setNamespaceURI(elementNamespaceUri);
            xmlRoot.setObject(object);
            xmlRoot.setEncoding(encoding);
            xmlRoot.setVersion(version);
            this.setDeclaredTypeOnXMLRoot(xmlRoot, elementNamespaceUri, elementLocalName, isNamespaceAware, unmarshaller);
            return xmlRoot;
        }
        return object;
    }

    private void setDeclaredTypeOnXMLRoot(Root xmlRoot, String elementNamespaceUri, String elementLocalName, boolean isNamespaceAware, Unmarshaller unmarshaller) {
        XPathQName xpathQName = new XPathQName(elementNamespaceUri, elementLocalName, isNamespaceAware);
        Object desc = ((Context)unmarshaller.getContext()).getDescriptor(xpathQName);
        if (desc != null) {
            xmlRoot.setDeclaredType(desc.getJavaClass());
        }
    }

    public boolean shouldWrapObject(Object object, String elementNamespaceUri, String elementLocalName, String elementPrefix, boolean isNamespaceAware) {
        if (this.resultAlwaysXMLRoot) {
            return true;
        }
        XMLField defaultRootField = this.getDefaultRootElementField();
        if (defaultRootField != null) {
            String defaultRootName = defaultRootField.getXPathFragment().getLocalName();
            String defaultRootNamespaceUri = defaultRootField.getXPathFragment().getNamespaceURI();
            if (isNamespaceAware ? (defaultRootNamespaceUri == null && elementNamespaceUri == null || defaultRootNamespaceUri == null && elementNamespaceUri.length() == 0 || elementNamespaceUri == null && defaultRootNamespaceUri.length() == 0 || defaultRootNamespaceUri != null && elementNamespaceUri != null && defaultRootNamespaceUri.equals(elementNamespaceUri)) && defaultRootName.equals(elementLocalName) : defaultRootName.equals(elementLocalName)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public XMLField getDefaultRootElementField() {
        return this.defaultRootElementField;
    }

    private boolean setDefaultRootElementField(String newDefaultRootElement) {
        if (newDefaultRootElement == null || newDefaultRootElement.length() == 0) {
            this.setDefaultRootElementField((XMLField)null);
            return false;
        }
        if (this.getDefaultRootElementField() != null && newDefaultRootElement.equals(this.getDefaultRootElementField().getName())) {
            return false;
        }
        this.setDefaultRootElementField(new XMLField(newDefaultRootElement));
        return true;
    }

    public void setDefaultRootElementField(XMLField xmlField) {
        this.defaultRootElementField = xmlField;
    }

    @Override
    public QName getDefaultRootElementType() {
        if (this.defaultRootElementField != null) {
            return this.defaultRootElementField.getLeafElementType();
        }
        return null;
    }

    public void setDefaultRootElementType(QName type) {
        if (this.defaultRootElementField != null) {
            this.defaultRootElementField.setLeafElementType(type);
        }
    }

    @Override
    public boolean isSequencedObject() {
        return this.sequencedObject;
    }

    public void setSequencedObject(boolean isSequenced) {
        this.sequencedObject = isSequenced;
    }

    @Override
    public boolean isWrapper() {
        return this.isWrapper;
    }

    public void setIsWrapper(boolean value2) {
        this.isWrapper = value2;
    }

    @Override
    public boolean isResultAlwaysXMLRoot() {
        return this.resultAlwaysXMLRoot;
    }

    @Override
    public void setResultAlwaysXMLRoot(boolean resultAlwaysXMLRoot) {
        this.resultAlwaysXMLRoot = resultAlwaysXMLRoot;
    }

    public boolean hasReferenceMappings() {
        return this.hasReferenceMappings;
    }

    @Override
    public DatabaseField getTypedField(DatabaseField field2) {
        DatabaseMapping selfMapping;
        XMLField foundField = (XMLField)super.getTypedField(field2);
        if (foundField != null) {
            return foundField;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(field2.getName(), "/");
        DatabaseField typedField = this.getTypedField(stringTokenizer);
        if (typedField == null && (selfMapping = ((ObjectBuilder)this.objectBuilder).getMappingForField(new XMLField("."))) != null) {
            return selfMapping.getReferenceDescriptor().getTypedField(field2);
        }
        return typedField;
    }

    @Override
    protected DatabaseField getTypedField(StringTokenizer stringTokenizer) {
        String xPath = "";
        XMLField xmlField = new XMLField();
        xmlField.setNamespaceResolver(this.namespaceResolver);
        while (stringTokenizer.hasMoreElements()) {
            String nextToken = stringTokenizer.nextToken();
            xmlField.setXPath(String.valueOf(xPath) + nextToken);
            xmlField.initialize();
            DatabaseMapping mapping = ((ObjectBuilder)this.objectBuilder).getMappingForField(xmlField);
            if (mapping == null) {
                XPathFragment xPathFragment = new XPathFragment(nextToken);
                if (xPathFragment.getIndexValue() > 0) {
                    xmlField.setXPath(String.valueOf(xPath) + nextToken.substring(0, nextToken.indexOf(91)));
                    xmlField.initialize();
                    mapping = ((ObjectBuilder)this.objectBuilder).getMappingForField(xmlField);
                    if (mapping != null && mapping.isCollectionMapping() && mapping.getContainerPolicy().isListPolicy()) {
                        if (stringTokenizer.hasMoreElements()) {
                            return ((XMLDescriptor)mapping.getReferenceDescriptor()).getTypedField(stringTokenizer);
                        }
                        return mapping.getField();
                    }
                }
            } else {
                if (stringTokenizer.hasMoreElements()) {
                    return ((XMLDescriptor)mapping.getReferenceDescriptor()).getTypedField(stringTokenizer);
                }
                return mapping.getField();
            }
            xPath = String.valueOf(xPath) + nextToken + "/";
        }
        return null;
    }

    @Override
    public AttributeAccessor getLocationAccessor() {
        return this.locationAccessor;
    }

    @Override
    public void setLocationAccessor(AttributeAccessor value2) {
        this.locationAccessor = value2;
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.attributeGroups != null) {
            for (AttributeGroup next2 : this.attributeGroups.values()) {
                next2.convertClassNamesToClasses(classLoader);
            }
        }
    }
}

