/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.XMLMarshaller;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.ExtendedContentHandler;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.CharacterEscapeHandler;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class OutputStreamRecord
extends MarshalRecord<XMLMarshaller> {
    protected static final byte[] OPEN_XML_PI_AND_VERSION_ATTRIBUTE = "<?xml version=\"".getBytes(Constants.DEFAULT_CHARSET);
    protected static final byte[] OPEN_ENCODING_ATTRIBUTE = " encoding=\"".getBytes(Constants.DEFAULT_CHARSET);
    protected static final byte[] CLOSE_PI = "?>".getBytes(Constants.DEFAULT_CHARSET);
    protected static final byte SPACE = 32;
    protected static final byte CLOSE_ATTRIBUTE_VALUE = 34;
    protected static final byte[] OPEN_CDATA = "<![CDATA[".getBytes(Constants.DEFAULT_CHARSET);
    protected static final byte[] CLOSE_CDATA = "]]>".getBytes(Constants.DEFAULT_CHARSET);
    protected static final byte[] OPEN_COMMENT = "<!--".getBytes(Constants.DEFAULT_CHARSET);
    protected static final byte[] CLOSE_COMMENT = "-->".getBytes(Constants.DEFAULT_CHARSET);
    protected static final byte OPEN_START_ELEMENT = 60;
    protected static final byte CLOSE_ELEMENT = 62;
    protected static final byte[] AMP = "&amp;".getBytes(Constants.DEFAULT_CHARSET);
    protected static final byte[] LT = "&lt;".getBytes(Constants.DEFAULT_CHARSET);
    protected static final byte[] QUOT = "&quot;".getBytes(Constants.DEFAULT_CHARSET);
    protected static final byte[] ENCODING = "UTF-8".getBytes(Constants.DEFAULT_CHARSET);
    protected static final byte[] SLASH_N = "&#xa;".getBytes(Constants.DEFAULT_CHARSET);
    protected static final byte[] SLASH_R = "&#xd;".getBytes(Constants.DEFAULT_CHARSET);
    protected OutputStream outputStream;
    protected boolean isStartElementOpen = false;
    protected boolean isProcessingCData = false;
    private static final int BUFFER_SIZE = 512;
    private byte[] buffer = new byte[512];
    private int bufferIndex = 0;

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
    }

    @Override
    public void startDocument(String encoding, String version) {
        try {
            this.outputStreamWrite(OPEN_XML_PI_AND_VERSION_ATTRIBUTE);
            this.outputStreamWrite(version.getBytes("UTF-8"));
            this.outputStreamWrite((byte)34);
            if (encoding != null) {
                this.outputStreamWrite(OPEN_ENCODING_ATTRIBUTE);
                this.outputStreamWrite(ENCODING);
                this.outputStreamWrite((byte)34);
            }
            this.outputStreamWrite(CLOSE_PI);
        }
        catch (UnsupportedEncodingException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void writeHeader() {
        this.outputStreamWrite(((XMLMarshaller)this.getMarshaller()).getXmlHeader().getBytes());
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        super.openStartElement(xPathFragment, namespaceResolver);
        if (this.isStartElementOpen) {
            this.outputStreamWrite((byte)62);
        }
        this.isStartElementOpen = true;
        this.outputStreamWrite((byte)60);
        byte[] prefixBytes = this.getPrefixBytes(xPathFragment);
        if (prefixBytes != null) {
            this.outputStreamWrite(prefixBytes);
            this.outputStreamWrite((byte)58);
        }
        this.outputStreamWrite(xPathFragment.getLocalNameBytes());
        if (xPathFragment.isGeneratedPrefix()) {
            this.namespaceDeclaration(xPathFragment.getPrefix(), xPathFragment.getNamespaceURI());
        }
    }

    @Override
    public void element(XPathFragment frag) {
        if (this.isStartElementOpen) {
            this.outputStreamWrite((byte)62);
            this.isStartElementOpen = false;
        }
        this.outputStreamWrite((byte)60);
        try {
            this.outputStreamWrite(this.getNameForFragment(frag).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        this.outputStreamWrite((byte)47);
        this.outputStreamWrite((byte)62);
    }

    @Override
    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String value2) {
        this.attribute(null, xPathFragment.getLocalName(), this.getNameForFragment(xPathFragment), value2);
    }

    @Override
    public void attribute(String namespaceURI, String localName, String qName, String value2) {
        try {
            this.outputStreamWrite((byte)32);
            this.outputStreamWrite(qName.getBytes("UTF-8"));
            this.outputStreamWrite((byte)61);
            this.outputStreamWrite((byte)34);
            this.writeValue(value2, true, true, this.outputStream);
            this.outputStreamWrite((byte)34);
        }
        catch (UnsupportedEncodingException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void closeStartElement() {
    }

    @Override
    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        if (this.isStartElementOpen) {
            this.outputStreamWrite((byte)47);
            this.outputStreamWrite((byte)62);
            this.isStartElementOpen = false;
        } else {
            this.outputStreamWrite((byte)60);
            this.outputStreamWrite((byte)47);
            byte[] prefixBytes = this.getPrefixBytes(xPathFragment);
            if (prefixBytes != null) {
                this.outputStreamWrite(prefixBytes);
                this.outputStreamWrite((byte)58);
            }
            this.outputStreamWrite(xPathFragment.getLocalNameBytes());
            this.outputStreamWrite((byte)62);
        }
        this.isStartElementOpen = false;
    }

    @Override
    public void characters(String value2) {
        if (this.isStartElementOpen) {
            this.isStartElementOpen = false;
            this.outputStreamWrite((byte)62);
        }
        this.writeValue(value2, true);
    }

    @Override
    public void cdata(String value2) {
        try {
            if (this.isStartElementOpen) {
                this.isStartElementOpen = false;
                this.outputStreamWrite((byte)62);
            }
            this.outputStreamWrite(OPEN_CDATA);
            this.outputStreamWrite(value2.getBytes("UTF-8"));
            this.outputStreamWrite(CLOSE_CDATA);
        }
        catch (UnsupportedEncodingException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    protected void writeValue(String value2, boolean escapeChars) {
        this.writeValue(value2, escapeChars, false, this.outputStream);
    }

    protected void writeValue(String value2, boolean escapeChars, boolean isAttribute, OutputStream os) {
        CharacterEscapeHandler escapeHandler;
        if (escapeChars && (escapeHandler = ((XMLMarshaller)this.marshaller).getCharacterEscapeHandler()) != null) {
            try {
                CharArrayWriter out = new CharArrayWriter();
                escapeHandler.escape(value2.toCharArray(), 0, value2.length(), isAttribute, out);
                byte[] bytes = out.toString().getBytes();
                this.outputStreamWrite(bytes);
                out.close();
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
            return;
        }
        int x = 0;
        int length = value2.length();
        while (x < length) {
            block17: {
                char character;
                block14: {
                    block18: {
                        block15: {
                            block16: {
                                character = value2.charAt(x);
                                if (character <= '\u007f') break block14;
                                if (character <= '\u07ff') break block15;
                                if (character < '\ud800' || character > '\udfff') break block16;
                                int uc = ((character & 0x3FF) << 10 | value2.charAt(++x) & 0x3FF) + 65536;
                                this.outputStreamWrite((byte)(0xF0 | uc >> 18), os);
                                this.outputStreamWrite((byte)(0x80 | uc >> 12 & 0x3F), os);
                                this.outputStreamWrite((byte)(0x80 | uc >> 6 & 0x3F), os);
                                this.outputStreamWrite((byte)(128 + (uc & 0x3F)), os);
                                break block17;
                            }
                            this.outputStreamWrite((byte)(224 + (character >> 12)), os);
                            this.outputStreamWrite((byte)(128 + (character >> 6 & 0x3F)), os);
                            break block18;
                        }
                        this.outputStreamWrite((byte)(192 + (character >> 6)), os);
                    }
                    this.outputStreamWrite((byte)(128 + (character & 0x3F)), os);
                    break block17;
                }
                if (escapeChars) {
                    switch (character) {
                        case '&': {
                            this.outputStreamWrite(AMP, os);
                            break;
                        }
                        case '<': {
                            this.outputStreamWrite(LT, os);
                            break;
                        }
                        case '\"': {
                            this.outputStreamWrite(QUOT, os);
                            break;
                        }
                        case '\n': {
                            if (isAttribute) {
                                this.outputStreamWrite(SLASH_N, os);
                                break;
                            }
                            this.outputStreamWrite((byte)character, os);
                            break;
                        }
                        case '\r': {
                            this.outputStreamWrite(SLASH_R, os);
                            break;
                        }
                        default: {
                            this.outputStreamWrite((byte)character, os);
                            break;
                        }
                    }
                } else {
                    this.outputStreamWrite((byte)character, os);
                }
            }
            ++x;
        }
    }

    @Override
    public void node(Node node, NamespaceResolver namespaceResolver, String uri, String localName) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String resolverPfx = null;
            if (this.getNamespaceResolver() != null) {
                resolverPfx = ((NamespaceResolver)this.getNamespaceResolver()).resolveNamespaceURI(attr.getNamespaceURI());
            }
            if (resolverPfx != null) {
                this.attribute(attr.getNamespaceURI(), "", String.valueOf(resolverPfx) + ':' + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.namespaceDeclaration(attr.getPrefix(), attr.getNamespaceURI());
                    ((NamespaceResolver)this.getNamespaceResolver()).put(attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else if (node.getNodeType() == 3) {
            this.characters(node.getNodeValue());
        } else {
            try {
                OutputStreamRecordContentHandler handler = new OutputStreamRecordContentHandler();
                XMLFragmentReader xfragReader = new XMLFragmentReader(namespaceResolver);
                xfragReader.setContentHandler(handler);
                xfragReader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
                xfragReader.parse(node, uri, localName);
            }
            catch (SAXException sex) {
                throw XMLMarshalException.marshalException(sex);
            }
        }
    }

    @Override
    public void flush() {
        try {
            this.outputStream.write(this.buffer, 0, this.bufferIndex);
            this.bufferIndex = 0;
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    protected void outputStreamWrite(byte[] bytes) {
        this.outputStreamWrite(bytes, this.outputStream);
    }

    protected void outputStreamWrite(byte[] bytes, OutputStream os) {
        if (os != this.outputStream) {
            try {
                os.write(bytes);
                return;
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }
        int bytesLength = bytes.length;
        if (this.bufferIndex + bytesLength >= 512) {
            try {
                os.write(this.buffer, 0, this.bufferIndex);
                this.bufferIndex = 0;
                if (bytesLength > 512) {
                    os.write(bytes);
                    return;
                }
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }
        System.arraycopy(bytes, 0, this.buffer, this.bufferIndex, bytes.length);
        this.bufferIndex += bytesLength;
    }

    protected void outputStreamWrite(byte aByte) {
        this.outputStreamWrite(aByte, this.outputStream);
    }

    protected void outputStreamWrite(byte aByte, OutputStream os) {
        if (os != this.outputStream) {
            try {
                os.write(aByte);
                return;
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }
        if (this.bufferIndex == 512) {
            try {
                os.write(this.buffer, 0, 512);
                this.bufferIndex = 0;
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }
        this.buffer[this.bufferIndex++] = aByte;
    }

    protected class OutputStreamRecordContentHandler
    implements ExtendedContentHandler,
    LexicalHandler {
        Map<String, String> prefixMappings = new HashMap<String, String>();

        OutputStreamRecordContentHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            try {
                if (OutputStreamRecord.this.isStartElementOpen) {
                    OutputStreamRecord.this.outputStreamWrite((byte)62);
                }
                OutputStreamRecord.this.outputStreamWrite((byte)60);
                OutputStreamRecord.this.outputStreamWrite(qName.getBytes("UTF-8"));
                OutputStreamRecord.this.isStartElementOpen = true;
                this.handleAttributes(atts);
                this.writePrefixMappings();
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            try {
                if (OutputStreamRecord.this.isStartElementOpen) {
                    OutputStreamRecord.this.outputStreamWrite((byte)47);
                    OutputStreamRecord.this.outputStreamWrite((byte)62);
                } else {
                    OutputStreamRecord.this.outputStreamWrite((byte)60);
                    OutputStreamRecord.this.outputStreamWrite((byte)47);
                    OutputStreamRecord.this.outputStreamWrite(qName.getBytes("UTF-8"));
                    OutputStreamRecord.this.outputStreamWrite((byte)62);
                }
                OutputStreamRecord.this.isStartElementOpen = false;
            }
            catch (UnsupportedEncodingException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            String namespaceUri = ((NamespaceResolver)OutputStreamRecord.this.getNamespaceResolver()).resolveNamespacePrefix(prefix);
            if (namespaceUri == null || !namespaceUri.equals(uri)) {
                this.prefixMappings.put(prefix, uri);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String characters = new String(ch, start, length);
            this.characters(characters);
        }

        @Override
        public void characters(CharSequence characters) throws SAXException {
            if (OutputStreamRecord.this.isProcessingCData) {
                OutputStreamRecord.this.cdata(characters.toString());
                return;
            }
            if (OutputStreamRecord.this.isStartElementOpen) {
                OutputStreamRecord.this.outputStreamWrite((byte)62);
                OutputStreamRecord.this.isStartElementOpen = false;
            }
            OutputStreamRecord.this.writeValue(characters.toString(), true);
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            if (OutputStreamRecord.this.isStartElementOpen) {
                OutputStreamRecord.this.outputStreamWrite((byte)62);
                OutputStreamRecord.this.isStartElementOpen = false;
            }
            this.writeComment(ch, start, length);
        }

        @Override
        public void startCDATA() throws SAXException {
            OutputStreamRecord.this.isProcessingCData = true;
        }

        @Override
        public void endCDATA() throws SAXException {
            OutputStreamRecord.this.isProcessingCData = false;
        }

        protected void writePrefixMappings() {
            try {
                if (!this.prefixMappings.isEmpty()) {
                    Set<Map.Entry<String, String>> entries = this.prefixMappings.entrySet();
                    for (Map.Entry<String, String> nextEntry : entries) {
                        String prefix = nextEntry.getKey();
                        OutputStreamRecord.this.outputStreamWrite((byte)32);
                        OutputStreamRecord.this.outputStreamWrite("xmlns".getBytes("UTF-8"));
                        if (prefix != null && prefix.length() > 0) {
                            OutputStreamRecord.this.outputStreamWrite((byte)58);
                            OutputStreamRecord.this.outputStreamWrite(prefix.getBytes("UTF-8"));
                        }
                        OutputStreamRecord.this.outputStreamWrite((byte)61);
                        OutputStreamRecord.this.outputStreamWrite((byte)34);
                        String uri = nextEntry.getValue();
                        if (uri != null) {
                            OutputStreamRecord.this.outputStreamWrite(uri.getBytes("UTF-8"));
                        }
                        OutputStreamRecord.this.outputStreamWrite((byte)34);
                    }
                    this.prefixMappings.clear();
                }
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        protected void handleAttributes(Attributes atts) {
            int i = 0;
            int attsLength = atts.getLength();
            while (i < attsLength) {
                String qName = atts.getQName(i);
                if (qName == null || !qName.startsWith("xmlns:") && !qName.equals("xmlns")) {
                    OutputStreamRecord.this.attribute(atts.getURI(i), atts.getLocalName(i), qName, atts.getValue(i));
                }
                ++i;
            }
        }

        protected void writeComment(char[] chars, int start, int length) {
            OutputStreamRecord.this.outputStreamWrite(OPEN_COMMENT);
            OutputStreamRecord.this.writeValue(new String(chars, start, length), false);
            OutputStreamRecord.this.outputStreamWrite(CLOSE_COMMENT);
        }

        protected void writeCharacters(char[] chars, int start, int length) {
            OutputStreamRecord.this.writeValue(new String(chars, start, length), true);
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void setNil(boolean isNil) {
        }
    }
}

