/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;

public class DBasePlatform
extends DatabasePlatform {
    @Override
    protected Hashtable buildFieldTypes() {
        Hashtable<Class<Timestamp>, FieldTypeDefinition> fieldTypeMapping = new Hashtable<Class<Timestamp>, FieldTypeDefinition>();
        fieldTypeMapping.put(Boolean.class, new FieldTypeDefinition("NUMBER", 1));
        fieldTypeMapping.put(Integer.class, new FieldTypeDefinition("NUMBER", 11));
        fieldTypeMapping.put(Long.class, new FieldTypeDefinition("NUMBER", 19));
        fieldTypeMapping.put(Float.class, new FieldTypeDefinition("NUMBER", 12, 5).setLimits(19, 0, 19));
        fieldTypeMapping.put(Double.class, new FieldTypeDefinition("NUMBER", 10, 5).setLimits(19, 0, 19));
        fieldTypeMapping.put(Short.class, new FieldTypeDefinition("NUMBER", 6));
        fieldTypeMapping.put(Byte.class, new FieldTypeDefinition("NUMBER", 4));
        fieldTypeMapping.put(BigInteger.class, new FieldTypeDefinition("NUMBER", 19));
        fieldTypeMapping.put(BigDecimal.class, new FieldTypeDefinition("NUMBER", 19).setLimits(19, 0, 9));
        fieldTypeMapping.put(Number.class, new FieldTypeDefinition("NUMBER", 19).setLimits(19, 0, 9));
        fieldTypeMapping.put(String.class, new FieldTypeDefinition("CHAR", 255));
        fieldTypeMapping.put(Character.class, new FieldTypeDefinition("CHAR", 1));
        fieldTypeMapping.put(Byte[].class, new FieldTypeDefinition("BINARY"));
        fieldTypeMapping.put(Character[].class, new FieldTypeDefinition("MEMO"));
        fieldTypeMapping.put(byte[].class, new FieldTypeDefinition("BINARY"));
        fieldTypeMapping.put(char[].class, new FieldTypeDefinition("MEMO"));
        fieldTypeMapping.put(Blob.class, new FieldTypeDefinition("BINARY"));
        fieldTypeMapping.put(Clob.class, new FieldTypeDefinition("MEMO"));
        fieldTypeMapping.put(Date.class, new FieldTypeDefinition("DATE", false));
        fieldTypeMapping.put(Time.class, new FieldTypeDefinition("CHAR", 15));
        fieldTypeMapping.put(Timestamp.class, new FieldTypeDefinition("CHAR", 25));
        return fieldTypeMapping;
    }

    @Override
    public Object convertToDatabaseType(Object value2) {
        Object databaseValue = super.convertToDatabaseType(value2);
        if (databaseValue instanceof Time || databaseValue instanceof Timestamp) {
            databaseValue = databaseValue.toString();
        }
        return databaseValue;
    }

    @Override
    public void setParameterValueInDatabaseCall(Object parameter, PreparedStatement statement, int index, AbstractSession session) throws SQLException {
        Object databaseValue = super.convertToDatabaseType(parameter);
        if (databaseValue instanceof Time || databaseValue instanceof Timestamp) {
            databaseValue = databaseValue.toString();
        }
        super.setParameterValueInDatabaseCall(databaseValue, statement, index, session);
    }

    @Override
    public int getMaxFieldNameSize() {
        return 10;
    }

    @Override
    public String getSelectForUpdateString() {
        return " FOR UPDATE OF *";
    }

    @Override
    public boolean isDBase() {
        return true;
    }

    @Override
    public Hashtable maximumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, Integer.MAX_VALUE);
        values.put(Long.class, Long.valueOf("922337203685478000"));
        values.put(Double.class, Double.valueOf("99999999.999999999"));
        values.put(Short.class, (short)Short.MIN_VALUE);
        values.put(Byte.class, (byte)-128);
        values.put(Float.class, Float.valueOf("99999999.999999999"));
        values.put(BigInteger.class, new BigInteger("922337203685478000"));
        values.put(BigDecimal.class, new BigDecimal("999999.999999999"));
        return values;
    }

    @Override
    public Hashtable minimumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, Integer.MIN_VALUE);
        values.put(Long.class, Long.valueOf("-922337203685478000"));
        values.put(Double.class, Double.valueOf("-99999999.999999999"));
        values.put(Short.class, (short)Short.MIN_VALUE);
        values.put(Byte.class, (byte)-128);
        values.put(Float.class, Float.valueOf("-99999999.999999999"));
        values.put(BigInteger.class, new BigInteger("-922337203685478000"));
        values.put(BigDecimal.class, new BigDecimal("-999999.999999999"));
        return values;
    }

    @Override
    public void printFieldNotNullClause(Writer writer) {
    }

    @Override
    public boolean shouldUseJDBCOuterJoinSyntax() {
        return false;
    }

    @Override
    public boolean supportsForeignKeyConstraints() {
        return false;
    }

    @Override
    public boolean supportsPrimaryKeyConstraint() {
        return false;
    }
}

