/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.OraclePreparedStatement;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.oracle.Oracle9Platform;

public class Oracle10Platform
extends Oracle9Platform {
    @Override
    protected String buildFirstRowsHint(int max2) {
        return "";
    }

    @Override
    public int executeBatch(Statement statement, boolean isStatementPrepared) throws SQLException {
        if (this.usesNativeBatchWriting() && isStatementPrepared) {
            int rowCount = 0;
            try {
                rowCount = ((OraclePreparedStatement)statement).sendBatch();
            }
            finally {
                ((OraclePreparedStatement)statement).setExecuteBatch(1);
            }
            return rowCount;
        }
        statement.executeBatch();
        return statement.getUpdateCount();
    }

    @Override
    public boolean isNativeConnectionRequiredForLobLocator() {
        return false;
    }

    @Override
    public void writeLOB(DatabaseField field2, Object value2, ResultSet resultSet, AbstractSession session) throws SQLException {
        if (this.isBlob(field2.getType())) {
            Blob blob = (Blob)resultSet.getObject(field2.getName());
            blob.setBytes(1L, (byte[])value2);
            session.log(1, "sql", "write_BLOB", blob.length(), field2.getName());
        } else if (this.isClob(field2.getType())) {
            Clob clob = (Clob)resultSet.getObject(field2.getName());
            clob.setString(1L, (String)value2);
            session.log(1, "sql", "write_CLOB", clob.length(), field2.getName());
        }
    }

    @Override
    public boolean canBatchWriteWithOptimisticLocking(DatabaseCall call) {
        return true;
    }
}

