/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.oxm.StrBuffer;
import org.eclipse.persistence.internal.oxm.record.ExtendedContentHandler;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAXDocumentBuilder
implements ExtendedContentHandler {
    protected Document document;
    protected List<Node> nodes = new ArrayList<Node>();
    protected XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
    protected Map namespaceDeclarations;
    protected StrBuffer stringBuffer = new StrBuffer();
    protected Locator locator;

    public SAXDocumentBuilder() {
        this.namespaceDeclarations = new HashMap();
    }

    public Document getDocument() {
        return this.document;
    }

    public Document getInitializedDocument() throws SAXException {
        if (this.document == null) {
            try {
                this.document = this.xmlPlatform.createDocument();
                this.nodes.add(this.document);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        return this.document;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.document = this.xmlPlatform.createDocument();
            this.nodes.add(this.document);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.nodes.remove(this.nodes.size() - 1);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (prefix == null) {
            prefix = "";
        }
        if (uri == null) {
            uri = "";
        }
        if (this.namespaceDeclarations == null) {
            this.namespaceDeclarations = new HashMap();
        }
        this.namespaceDeclarations.put(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (namespaceURI != null && namespaceURI.length() == 0) {
            namespaceURI = null;
        }
        Element element = this.getInitializedDocument().createElementNS(namespaceURI, qName);
        Node parentNode = this.nodes.get(this.nodes.size() - 1);
        if (this.stringBuffer.length() > 0 && this.nodes.size() != 1) {
            Text text = this.getInitializedDocument().createTextNode(this.stringBuffer.toString());
            parentNode.appendChild(text);
            this.stringBuffer.reset();
        }
        this.appendChildNode(parentNode, element);
        this.nodes.add(element);
        if (this.namespaceDeclarations != null) {
            for (Map.Entry nextEntry : this.namespaceDeclarations.entrySet()) {
                boolean isRootElement;
                String prefix = (String)nextEntry.getKey();
                String uri = (String)nextEntry.getValue();
                boolean prefixEmpty = prefix.length() == 0;
                String elemNamespaceURI = element.getNamespaceURI();
                boolean elementNamespaceNull = elemNamespaceURI == null;
                boolean elementNamespaceEmpty = elemNamespaceURI != null && elemNamespaceURI.length() == 0;
                boolean bl = isRootElement = element.getParentNode().getNodeType() == 9;
                if (prefixEmpty && isRootElement && (elementNamespaceEmpty || elementNamespaceNull)) continue;
                this.addNamespaceDeclaration(element, prefix, uri);
            }
            this.namespaceDeclarations = null;
        }
        int numberOfAttributes = atts.getLength();
        int x = 0;
        while (x < numberOfAttributes) {
            String attributeNamespaceURI = atts.getURI(x);
            if (attributeNamespaceURI != null && attributeNamespaceURI.length() == 0) {
                attributeNamespaceURI = null;
            }
            if (attributeNamespaceURI == null && (atts.getQName(x).startsWith("xmlns:") || atts.getQName(x).equals("xmlns"))) {
                attributeNamespaceURI = "http://www.w3.org/2000/xmlns/";
            }
            String value2 = atts.getValue(x);
            element.setAttributeNS(attributeNamespaceURI, atts.getQName(x), value2);
            ++x;
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        Element endedElement = (Element)this.nodes.remove(this.nodes.size() - 1);
        if (this.stringBuffer.length() > 0) {
            Text text = this.getInitializedDocument().createTextNode(this.stringBuffer.toString());
            endedElement.appendChild(text);
            this.stringBuffer.reset();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.stringBuffer.append(ch, start, length);
    }

    @Override
    public void characters(CharSequence characters) {
        this.stringBuffer.append(characters.toString());
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        ProcessingInstruction pi = this.getInitializedDocument().createProcessingInstruction(target, data);
        Node parentNode = this.nodes.get(this.nodes.size() - 1);
        parentNode.appendChild(pi);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    protected void addNamespaceDeclaration(Element parentElement, String prefix, String uri) {
        if (prefix.length() == 0 || "xmlns".equals(prefix)) {
            parentElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", uri);
        } else {
            parentElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
        }
    }

    public void appendChildNode(Node parentNode, Node childNode) {
        parentNode.appendChild(childNode);
    }

    @Override
    public void setNil(boolean isNil) {
    }
}

