/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.Type;
import commonj.sdo.helper.DataHelper;
import commonj.sdo.helper.HelperContext;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.sequenced.SequencedObject;
import org.eclipse.persistence.oxm.sequenced.Setting;
import org.eclipse.persistence.sdo.DefaultValueStore;
import org.eclipse.persistence.sdo.SDOChangeSummary;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDOExternalizableDelegator;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOSequence;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.ValueStore;
import org.eclipse.persistence.sdo.helper.ListWrapper;
import org.eclipse.persistence.sdo.helper.SDODataHelper;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.XPathEngine;

public class SDODataObject
implements DataObject,
SequencedObject {
    private SDOType type;
    private SDODataObject container;
    private ValueStore currentValueStore;
    private List openContentProperties;
    private List openContentPropertiesAttributes;
    private Map openContentAliasNames;
    private String containmentPropertyName;
    private SDOChangeSummary changeSummary;
    private List<SDOProperty> instanceProperties;
    private String sdoRef;
    private SDOSequence sequence;
    private DataGraph dataGraph;
    private HelperContext aHelperContext;
    private String text;

    public SDODataObject() {
        this._setCurrentValueStore(new DefaultValueStore());
    }

    public void _setHelperContext(HelperContext aContext) {
        this.aHelperContext = aContext;
        if (this.changeSummary != null) {
            this.changeSummary.setHelperContext(this.aHelperContext);
        }
    }

    @Override
    public Object get(String path) {
        try {
            return XPathEngine.getInstance().get(path, this);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void set(String path, Object value2) throws ClassCastException, UnsupportedOperationException, IllegalArgumentException {
        XPathEngine.getInstance().set(path, value2, this, false);
    }

    @Override
    public boolean isSet(String path) {
        return XPathEngine.getInstance().isSet(path, (DataObject)this);
    }

    @Override
    public void unset(String path) {
        XPathEngine.getInstance().unset(path, this);
    }

    @Override
    public boolean getBoolean(String path) throws ClassCastException {
        Boolean value2;
        block3: {
            try {
                value2 = (Boolean)XPathEngine.getInstance().convertObjectToValueByPath(path, Boolean.class, this);
                if (value2 != null) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return value2;
    }

    @Override
    public byte getByte(String path) {
        Byte value2;
        block3: {
            try {
                value2 = (Byte)XPathEngine.getInstance().convertObjectToValueByPath(path, Byte.class, this);
                if (value2 != null) break block3;
                return 0;
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return value2;
    }

    @Override
    public char getChar(String path) {
        Character value2;
        block3: {
            try {
                value2 = (Character)XPathEngine.getInstance().convertObjectToValueByPath(path, Character.class, this);
                if (value2 != null) break block3;
                return '\u0000';
            }
            catch (Exception exception) {
                return '\u0000';
            }
        }
        return value2.charValue();
    }

    @Override
    public double getDouble(String path) {
        Double value2;
        block3: {
            try {
                value2 = (Double)XPathEngine.getInstance().convertObjectToValueByPath(path, Double.class, this);
                if (value2 != null) break block3;
                return 0.0;
            }
            catch (Exception exception) {
                return 0.0;
            }
        }
        return value2;
    }

    @Override
    public float getFloat(String path) {
        Float value2;
        block3: {
            try {
                value2 = (Float)XPathEngine.getInstance().convertObjectToValueByPath(path, Float.class, this);
                if (value2 != null) break block3;
                return 0.0f;
            }
            catch (Exception exception) {
                return 0.0f;
            }
        }
        return value2.floatValue();
    }

    @Override
    public int getInt(String path) {
        Integer value2;
        block3: {
            try {
                value2 = (Integer)XPathEngine.getInstance().convertObjectToValueByPath(path, Integer.class, this);
                if (value2 != null) break block3;
                return 0;
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return value2;
    }

    @Override
    public long getLong(String path) {
        Long value2;
        block3: {
            try {
                value2 = (Long)XPathEngine.getInstance().convertObjectToValueByPath(path, Long.class, this);
                if (value2 != null) break block3;
                return 0L;
            }
            catch (Exception exception) {
                return 0L;
            }
        }
        return value2;
    }

    @Override
    public short getShort(String path) {
        Short value2;
        block3: {
            try {
                value2 = (Short)XPathEngine.getInstance().convertObjectToValueByPath(path, Short.class, this);
                if (value2 != null) break block3;
                return 0;
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return value2;
    }

    @Override
    public byte[] getBytes(String path) {
        try {
            byte[] value2 = (byte[])XPathEngine.getInstance().convertObjectToValueByPath(path, byte[].class, this);
            return value2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String path) {
        try {
            BigDecimal value2 = (BigDecimal)XPathEngine.getInstance().convertObjectToValueByPath(path, BigDecimal.class, this);
            return value2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public BigInteger getBigInteger(String path) {
        try {
            BigInteger value2 = (BigInteger)XPathEngine.getInstance().convertObjectToValueByPath(path, BigInteger.class, this);
            return value2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public SDODataObject getDataObject(String path) throws ClassCastException {
        Object value2 = this.get(path);
        if (value2 instanceof ListWrapper) {
            return (SDODataObject)((ListWrapper)value2).get(0);
        }
        return (SDODataObject)value2;
    }

    @Override
    public Date getDate(String path) {
        try {
            Date value2 = (Date)XPathEngine.getInstance().convertObjectToValueByPath(path, Date.class, this);
            return value2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getString(String path) {
        try {
            String value2 = (String)XPathEngine.getInstance().convertObjectToValueByPath(path, String.class, this);
            return value2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public List getList(String path) {
        try {
            return (List)XPathEngine.getInstance().convertObjectToValueByPath(path, List.class, this);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void setBoolean(String path, boolean value2) {
        this.convertValueAndSet(path, (Object)value2);
    }

    @Override
    public void setByte(String path, byte value2) {
        this.convertValueAndSet(path, (Object)value2);
    }

    @Override
    public void setChar(String path, char value2) {
        this.convertValueAndSet(path, (Object)Character.valueOf(value2));
    }

    @Override
    public void setDouble(String path, double value2) {
        this.convertValueAndSet(path, (Object)value2);
    }

    @Override
    public void setFloat(String path, float value2) {
        this.convertValueAndSet(path, (Object)Float.valueOf(value2));
    }

    @Override
    public void setInt(String path, int value2) {
        this.convertValueAndSet(path, (Object)value2);
    }

    @Override
    public void setLong(String path, long value2) {
        this.convertValueAndSet(path, (Object)value2);
    }

    @Override
    public void setShort(String path, short value2) {
        this.convertValueAndSet(path, (Object)value2);
    }

    @Override
    public void setBytes(String path, byte[] value2) {
        this.convertValueAndSet(path, (Object)value2);
    }

    @Override
    public void setBigDecimal(String path, BigDecimal value2) {
        this.convertValueAndSet(path, (Object)value2);
    }

    @Override
    public void setBigInteger(String path, BigInteger value2) {
        this.convertValueAndSet(path, (Object)value2);
    }

    @Override
    public void setDataObject(String path, DataObject value2) {
        this.set(path, (Object)value2);
    }

    @Override
    public void setDate(String path, Date value2) {
        this.convertValueAndSet(path, (Object)value2);
    }

    @Override
    public void setString(String path, String value2) {
        this.convertValueAndSet(path, (Object)value2);
    }

    @Override
    public void setList(String path, List value2) {
        this.convertValueAndSet(path, (Object)value2);
    }

    @Override
    public Object get(int propertyIndex) throws IllegalArgumentException {
        SDOProperty p = this.getInstanceProperty(propertyIndex);
        return this.get(p);
    }

    @Override
    public void set(int propertyIndex, Object value2) {
        try {
            SDOProperty p = this.getInstanceProperty(propertyIndex);
            this.set(p, value2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("PropertyIndex invalid.");
        }
    }

    @Override
    public boolean isSet(int propertyIndex) {
        SDOProperty p = this.getInstanceProperty(propertyIndex);
        return this.isSet(p);
    }

    @Override
    public void unset(int propertyIndex) {
        SDOProperty p = this.getInstanceProperty(propertyIndex);
        this.unset(p);
    }

    @Override
    public boolean getBoolean(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getBoolean(property);
    }

    @Override
    public byte getByte(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getByte(property);
    }

    @Override
    public char getChar(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getChar(property);
    }

    @Override
    public double getDouble(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getDouble(property);
    }

    @Override
    public float getFloat(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getFloat(property);
    }

    @Override
    public int getInt(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getInt(property);
    }

    @Override
    public long getLong(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getLong(property);
    }

    @Override
    public short getShort(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getShort(property);
    }

    @Override
    public byte[] getBytes(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getBytes(property);
    }

    @Override
    public BigDecimal getBigDecimal(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getBigDecimal(property);
    }

    @Override
    public BigInteger getBigInteger(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getBigInteger(property);
    }

    @Override
    public SDODataObject getDataObject(int propertyIndex) {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getDataObject(property);
    }

    @Override
    public Date getDate(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getDate(property);
    }

    @Override
    public String getString(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getString(property);
    }

    @Override
    public List getList(int propertyIndex) {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getList(property);
    }

    @Override
    public Sequence getSequence(String path) {
        Object anObject = this.get(path);
        if (anObject == null || !(anObject instanceof DataObject)) {
            throw SDOException.sequenceNotFoundForPath(path);
        }
        return ((DataObject)anObject).getSequence();
    }

    @Override
    public Sequence getSequence(int propertyIndex) {
        SDOProperty aProperty = this.getInstanceProperty(propertyIndex);
        return this.getSequencePrivate(aProperty);
    }

    @Override
    public Sequence getSequence(Property property) {
        return this.getSequencePrivate(property);
    }

    private Sequence getSequencePrivate(Property aProperty) {
        if (aProperty != null && ((SDOProperty)aProperty).getType().isSequenced() && this.isSet(aProperty) && !((SDOProperty)aProperty).getType().isDataType() && !aProperty.isMany()) {
            return ((DataObject)this.get(aProperty)).getSequence();
        }
        throw SDOException.sequenceNotSupportedForProperty(aProperty.getName());
    }

    @Override
    public SDOSequence getSequence() {
        return this.sequence;
    }

    @Override
    public void setBoolean(int propertyIndex, boolean value2) {
        this.convertValueAndSet(propertyIndex, (Object)value2);
    }

    @Override
    public void setByte(int propertyIndex, byte value2) {
        this.convertValueAndSet(propertyIndex, (Object)value2);
    }

    @Override
    public void setChar(int propertyIndex, char value2) {
        this.convertValueAndSet(propertyIndex, (Object)Character.valueOf(value2));
    }

    @Override
    public void setDouble(int propertyIndex, double value2) {
        this.convertValueAndSet(propertyIndex, (Object)value2);
    }

    @Override
    public void setFloat(int propertyIndex, float value2) {
        this.convertValueAndSet(propertyIndex, (Object)Float.valueOf(value2));
    }

    @Override
    public void setInt(int propertyIndex, int value2) {
        this.convertValueAndSet(propertyIndex, (Object)value2);
    }

    @Override
    public void setLong(int propertyIndex, long value2) {
        this.convertValueAndSet(propertyIndex, (Object)value2);
    }

    @Override
    public void setShort(int propertyIndex, short value2) {
        this.convertValueAndSet(propertyIndex, (Object)value2);
    }

    @Override
    public void setBytes(int propertyIndex, byte[] value2) {
        this.convertValueAndSet(propertyIndex, (Object)value2);
    }

    @Override
    public void setBigDecimal(int propertyIndex, BigDecimal value2) {
        this.convertValueAndSet(propertyIndex, (Object)value2);
    }

    @Override
    public void setBigInteger(int propertyIndex, BigInteger value2) {
        this.convertValueAndSet(propertyIndex, (Object)value2);
    }

    @Override
    public void setDataObject(int propertyIndex, DataObject value2) {
        this.set(propertyIndex, (Object)value2);
    }

    @Override
    public void setDate(int propertyIndex, Date value2) {
        this.convertValueAndSet(propertyIndex, (Object)value2);
    }

    @Override
    public void setString(int propertyIndex, String value2) {
        this.convertValueAndSet(propertyIndex, (Object)value2);
    }

    @Override
    public void setList(int propertyIndex, List value2) {
        this.convertValueAndSet(propertyIndex, (Object)value2);
    }

    @Override
    public Object get(Property property) throws IllegalArgumentException {
        if (property == null) {
            throw new IllegalArgumentException("Argument not Supported.");
        }
        if (this.type != null && !this.type.isOpen() && property.isOpenContent()) {
            throw new IllegalArgumentException("Argument not Supported.");
        }
        if (property.isMany()) {
            return this.getList(property);
        }
        if (this.isSet(property)) {
            return this.getPropertyInternal(property);
        }
        return property.getDefault();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Property defineOpenContentProperty(String name, Object value2) throws UnsupportedOperationException, IllegalArgumentException {
        if (value2 == null) {
            return null;
        }
        DataObject propertyDO = this.aHelperContext.getDataFactory().create("commonj.sdo", "Property");
        propertyDO.set("name", (Object)name);
        Type sdotype = null;
        boolean isMany = false;
        boolean isContainment = false;
        Class<?> valueClass = value2.getClass();
        if (value2 instanceof Collection) {
            if (((Collection)value2).size() <= 0) return null;
            Object firstObject = ((Collection)value2).iterator().next();
            if (firstObject == null) return null;
            valueClass = firstObject.getClass();
            if (firstObject instanceof DataObject) {
                if (((DataObject)firstObject).getContainer() == null) {
                    isContainment = true;
                }
                sdotype = ((DataObject)firstObject).getType();
            } else {
                sdotype = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getTypeForSimpleJavaType(valueClass);
            }
            isMany = true;
        } else if (value2 instanceof DataObject) {
            if (((DataObject)value2).getContainer() == null) {
                isContainment = true;
            }
            sdotype = ((DataObject)value2).getType();
        } else {
            Property xmlElementProperty = this.aHelperContext.getTypeHelper().getOpenContentProperty("commonj.sdo/xml", "xmlElement");
            propertyDO.set(xmlElementProperty, (Object)Boolean.TRUE);
            sdotype = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getTypeForSimpleJavaType(valueClass);
        }
        propertyDO.set("type", (Object)sdotype);
        propertyDO.set("many", (Object)isMany);
        propertyDO.set("containment", (Object)isContainment);
        return this.aHelperContext.getTypeHelper().defineOpenContentProperty(null, propertyDO);
    }

    public Property defineOpenContentProperty(String name, Object value2, Type sdotype) throws UnsupportedOperationException, IllegalArgumentException {
        if (value2 == null) {
            return null;
        }
        if (sdotype == null) {
            return this.defineOpenContentProperty(name, value2);
        }
        DataObject propertyDO = this.aHelperContext.getDataFactory().create("commonj.sdo", "Property");
        propertyDO.set("name", (Object)name);
        boolean isMany = false;
        boolean isContainment = false;
        Class<?> valueClass = value2.getClass();
        if (value2 instanceof Collection) {
            Object firstObject;
            if (((Collection)value2).size() > 0 && (firstObject = ((Collection)value2).iterator().next()) != null) {
                valueClass = firstObject.getClass();
                if (firstObject instanceof DataObject) {
                    if (((DataObject)firstObject).getContainer() == null) {
                        isContainment = true;
                    }
                    sdotype = ((DataObject)firstObject).getType();
                } else {
                    sdotype = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getTypeForSimpleJavaType(valueClass);
                }
            }
            isMany = true;
        } else if (value2 instanceof DataObject) {
            if (((DataObject)value2).getContainer() == null) {
                isContainment = true;
            }
            sdotype = ((DataObject)value2).getType();
        } else {
            sdotype = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getTypeForSimpleJavaType(valueClass);
        }
        propertyDO.set("type", (Object)sdotype);
        propertyDO.set("many", (Object)isMany);
        propertyDO.set("containment", (Object)isContainment);
        return this.aHelperContext.getTypeHelper().defineOpenContentProperty(null, propertyDO);
    }

    @Override
    public void set(Property property, Object value2) throws UnsupportedOperationException, IllegalArgumentException {
        this.set((SDOProperty)property, value2, true);
    }

    public void setInternal(SDOProperty property, Object value2, boolean updateSequence) throws UnsupportedOperationException, IllegalArgumentException {
        if (this.getType() == null) {
            throw new UnsupportedOperationException("Type is null");
        }
        if (property.isOpenContent() && !this.getType().isOpen()) {
            throw new IllegalArgumentException("DataObject " + this + " is not Open for property " + property.getName());
        }
        Object oldValue = this.get(property);
        boolean wasSet = this.isSet(property);
        if (wasSet && oldValue == value2) {
            return;
        }
        this._setModified(true);
        if (property.isMany()) {
            List listValue;
            if (value2 == null) {
                listValue = new ListWrapper(this, property);
            } else {
                try {
                    listValue = (List)value2;
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalArgumentException("Properties with isMany = true can only be set on list values.");
                }
            }
            if (property.isContainment() || this.isContainedByDataGraph(property)) {
                for (Object next2 : listValue) {
                    if (!(next2 instanceof SDODataObject) || !this.parentContains(next2)) continue;
                    throw new IllegalArgumentException("Circular reference.");
                }
            }
            ListWrapper oldValueListWrapper = (ListWrapper)oldValue;
            oldValueListWrapper.clear(updateSequence);
            oldValueListWrapper.addAll((Collection)value2, updateSequence);
        } else {
            if (property.isContainment() || this.isContainedByDataGraph(property)) {
                SDODataObject dataObjectValue;
                if (this.parentContains(value2)) {
                    throw new IllegalArgumentException("Circular reference.");
                }
                if (oldValue != null) {
                    this.detach(property, oldValue);
                }
                if ((dataObjectValue = (SDODataObject)value2) != null) {
                    this.updateContainment((Property)property, dataObjectValue);
                }
            }
            this.setPropertyInternal(property, value2, updateSequence);
        }
        if (this.getType().isOpen() && property.isOpenContent()) {
            this.addOpenContentProperty(property);
        }
    }

    public void set(SDOProperty property, Object value2, boolean updateSequence) throws UnsupportedOperationException, IllegalArgumentException {
        if (property == null) {
            throw new IllegalArgumentException("Illegal Argument.");
        }
        if (property.isReadOnly()) {
            throw new UnsupportedOperationException("Property is Readonly." + property.getName() + "  " + this.getType().getName());
        }
        if (value2 == null && !property.isNullable()) {
            this.unset(property, false, updateSequence);
        } else {
            this.setInternal(property, value2, updateSequence);
        }
    }

    @Override
    public boolean isSet(Property property) {
        if (property == null) {
            throw SDOException.cannotPerformOperationOnNullArgument("isSet");
        }
        if (property.isMany()) {
            List value2 = this.getList(property);
            return !value2.isEmpty();
        }
        return this.isSetInternal(property);
    }

    @Override
    public void unset(Property property) {
        if (property == null) {
            throw SDOException.cannotPerformOperationOnNullArgument("unset");
        }
        this.unset(property, false);
    }

    private void unset(Property property, boolean fromDelete) {
        this.unset(property, fromDelete, true);
    }

    public void unset(Property property, boolean fromDelete, boolean updateSequence) {
        Object oldValue;
        if (property == null) {
            throw SDOException.cannotPerformOperationOnNullArgument("unset");
        }
        if (((SDOProperty)property).isReadOnly()) {
            throw new UnsupportedOperationException("Property is Readonly." + property.getName() + "  " + this.getType().getName());
        }
        boolean wasSet = this.isSet(property);
        if (wasSet) {
            if (!fromDelete) {
                this._setModified(true);
            }
        } else {
            return;
        }
        if ((property.isContainment() || this.isContainedByDataGraph(property)) && (oldValue = this.get(property)) != null) {
            if (property.isMany()) {
                int itemIndex = 0;
                int size2 = ((List)oldValue).size();
                while (itemIndex < size2) {
                    SDODataObject manyItem = (SDODataObject)((List)oldValue).get(itemIndex);
                    if (manyItem != null) {
                        manyItem.detachOrDelete(fromDelete);
                    }
                    ++itemIndex;
                }
            } else {
                ((SDODataObject)oldValue).detachOrDelete(fromDelete);
            }
        }
        if (wasSet) {
            this.unsetInternal(property, updateSequence);
        }
    }

    @Override
    public boolean getBoolean(Property property) throws IllegalArgumentException, ClassCastException {
        Boolean propertyBooleanValue = (Boolean)this.convertObjectToValue(property, Boolean.class);
        if (propertyBooleanValue == null) {
            return false;
        }
        return propertyBooleanValue;
    }

    @Override
    public byte getByte(Property property) throws IllegalArgumentException, ClassCastException {
        Byte propertyByteValue = (Byte)this.convertObjectToValue(property, Byte.class);
        if (propertyByteValue == null) {
            return 0;
        }
        return propertyByteValue;
    }

    @Override
    public char getChar(Property property) throws IllegalArgumentException {
        Character propertyCharValue = (Character)this.convertObjectToValue(property, Character.class);
        if (propertyCharValue == null) {
            return '\u0000';
        }
        return propertyCharValue.charValue();
    }

    @Override
    public double getDouble(Property property) throws IllegalArgumentException {
        Double propertyDoubleValue = (Double)this.convertObjectToValue(property, Double.class);
        if (propertyDoubleValue == null) {
            return 0.0;
        }
        return propertyDoubleValue;
    }

    @Override
    public float getFloat(Property property) throws IllegalArgumentException {
        Float propertyFloatValue = (Float)this.convertObjectToValue(property, Float.class);
        if (propertyFloatValue == null) {
            return 0.0f;
        }
        return propertyFloatValue.floatValue();
    }

    @Override
    public int getInt(Property property) throws IllegalArgumentException {
        Integer propertyIntegerValue = (Integer)this.convertObjectToValue(property, Integer.class);
        if (propertyIntegerValue == null) {
            return 0;
        }
        return propertyIntegerValue;
    }

    @Override
    public long getLong(Property property) throws IllegalArgumentException {
        Long propertyLongValue = (Long)this.convertObjectToValue(property, Long.class);
        if (propertyLongValue == null) {
            return 0L;
        }
        return propertyLongValue;
    }

    @Override
    public short getShort(Property property) throws IllegalArgumentException {
        Short propertyShortValue = (Short)this.convertObjectToValue(property, Short.class);
        if (propertyShortValue == null) {
            return 0;
        }
        return propertyShortValue;
    }

    @Override
    public byte[] getBytes(Property property) throws IllegalArgumentException {
        byte[] propertyByteValue = (byte[])this.convertObjectToValue(property, byte[].class);
        return propertyByteValue;
    }

    @Override
    public BigDecimal getBigDecimal(Property property) throws IllegalArgumentException {
        BigDecimal propertyDecimalValue = (BigDecimal)this.convertObjectToValue(property, BigDecimal.class);
        return propertyDecimalValue;
    }

    @Override
    public BigInteger getBigInteger(Property property) throws IllegalArgumentException {
        BigInteger propertyBigIntegerValue = (BigInteger)this.convertObjectToValue(property, BigInteger.class);
        return propertyBigIntegerValue;
    }

    @Override
    public SDODataObject getDataObject(Property property) throws IllegalArgumentException, ClassCastException {
        if (property != null && property.isMany()) {
            List value2 = (List)this.get(property);
            if (value2.size() > 0) {
                return (SDODataObject)value2.get(0);
            }
            return null;
        }
        return (SDODataObject)this.get(property);
    }

    @Override
    public Date getDate(Property property) {
        if (property == null) {
            throw SDOException.cannotPerformOperationOnNullArgument("getDate");
        }
        if (property.getType().equals(SDOConstants.SDO_STRING)) {
            DataHelper dHelper = this.aHelperContext.getDataHelper();
            String dateString = (String)this.get(property);
            return dHelper.toDate(dateString);
        }
        Date propertyDateValue = (Date)this.convertObjectToValue(property, Date.class);
        return propertyDateValue;
    }

    @Override
    public String getString(Property property) {
        String propertyStringValue = (String)this.convertObjectToValue(property, String.class);
        return propertyStringValue;
    }

    @Override
    public List getList(Property property) {
        if (property == null) {
            throw SDOException.cannotPerformOperationOnNullArgument("getList");
        }
        if (this.type != null && !this.type.isOpen() && property.isOpenContent()) {
            throw new IllegalArgumentException("Argument not Supported.");
        }
        if (!property.isMany()) {
            throw new ClassCastException("can not call getList for a property that has isMany false.");
        }
        Object value2 = this.getPropertyInternal(property);
        if (value2 != null && value2 instanceof List) {
            return (List)value2;
        }
        ListWrapper theList = new ListWrapper(this, property);
        if (this.getType().isOpen() && property.isOpenContent()) {
            this.addOpenContentProperty(property);
        }
        this.setPropertyInternal((SDOProperty)property, theList, false);
        return theList;
    }

    @Override
    public void setBoolean(Property property, boolean value2) {
        this.convertValueAndSet(property, (Object)value2);
    }

    @Override
    public void setByte(Property property, byte value2) {
        this.convertValueAndSet(property, (Object)value2);
    }

    @Override
    public void setChar(Property property, char value2) {
        this.convertValueAndSet(property, (Object)Character.valueOf(value2));
    }

    @Override
    public void setDouble(Property property, double value2) {
        this.convertValueAndSet(property, (Object)value2);
    }

    @Override
    public void setFloat(Property property, float value2) {
        this.convertValueAndSet(property, (Object)Float.valueOf(value2));
    }

    @Override
    public void setInt(Property property, int value2) {
        this.convertValueAndSet(property, (Object)value2);
    }

    @Override
    public void setLong(Property property, long value2) {
        this.convertValueAndSet(property, (Object)value2);
    }

    @Override
    public void setShort(Property property, short value2) {
        this.convertValueAndSet(property, (Object)value2);
    }

    @Override
    public void setBytes(Property property, byte[] value2) {
        this.convertValueAndSet(property, (Object)value2);
    }

    @Override
    public void setBigDecimal(Property property, BigDecimal value2) {
        this.convertValueAndSet(property, (Object)value2);
    }

    @Override
    public void setBigInteger(Property property, BigInteger value2) {
        this.convertValueAndSet(property, (Object)value2);
    }

    @Override
    public void setDataObject(Property property, DataObject value2) {
        this.set(property, (Object)value2);
    }

    @Override
    public void setDate(Property property, Date value2) {
        this.convertValueAndSet(property, (Object)value2);
    }

    @Override
    public void setString(Property property, String value2) {
        this.convertValueAndSet(property, (Object)value2);
    }

    @Override
    public void setList(Property property, List value2) {
        this.convertValueAndSet(property, (Object)value2);
    }

    @Override
    public DataObject createDataObject(String propertyName) {
        SDOProperty aProperty = this.getInstanceProperty(propertyName);
        return this.createDataObject(aProperty);
    }

    @Override
    public SDODataObject createDataObject(int propertyIndex) {
        SDOProperty aProperty = this.getInstanceProperty(propertyIndex);
        return this.createDataObject(aProperty);
    }

    @Override
    public SDODataObject createDataObject(Property aProperty) {
        Type aType;
        if (aProperty.isContainment() && (aType = aProperty.getType()) != null) {
            return this.createDataObject(aProperty, aType);
        }
        return null;
    }

    @Override
    public SDODataObject createDataObject(String propertyName, String namespaceURI, String typeName) {
        SDOProperty aProperty = this.getInstanceProperty(propertyName);
        Type aType = this.aHelperContext.getTypeHelper().getType(namespaceURI, typeName);
        return this.createDataObject(aProperty, aType);
    }

    @Override
    public SDODataObject createDataObject(int propertyIndex, String namespaceURI, String typeName) {
        SDOProperty aProperty = this.getInstanceProperty(propertyIndex);
        Type aType = this.aHelperContext.getTypeHelper().getType(namespaceURI, typeName);
        return this.createDataObject(aProperty, aType);
    }

    @Override
    public SDODataObject createDataObject(Property property, Type aType) {
        SDODataObject created = (SDODataObject)this.aHelperContext.getDataFactory().create(aType);
        if (property.isMany()) {
            ((ListWrapper)this.getList(property)).add(created, true);
        } else {
            this.set(property, (Object)created);
        }
        this._setModified(true);
        created._setCreated(true);
        return created;
    }

    private void detach(Property property, Object oldValue) {
        if (property.isMany()) {
            List oldListValue = (List)oldValue;
            int i = 0;
            int size2 = oldListValue.size();
            while (i < size2) {
                Object nextValue = oldListValue.get(i);
                if (nextValue != null && nextValue instanceof SDODataObject) {
                    ((SDODataObject)nextValue).detachOrDelete(false);
                }
                ++i;
            }
        } else if (oldValue != null && oldValue instanceof SDODataObject) {
            ((SDODataObject)oldValue).detachOrDelete(false);
        }
    }

    public void detachOrDelete(boolean fromDelete) {
        boolean isCSRoot;
        if (this.container == null && !fromDelete) {
            return;
        }
        boolean bl = isCSRoot = this.changeSummary != null && this.changeSummary.getRootObject() == this;
        if (!fromDelete && isCSRoot) {
            return;
        }
        this.detachDeleteRecursivePrivate(fromDelete, !isCSRoot, true);
    }

    private void detachDeleteRecursivePrivate(boolean fromDelete, boolean clearCS, boolean isRootOfRecursiveLoop) {
        boolean subTreeRootHasCStoClear = clearCS;
        if (this.getContainer() == null) {
            clearCS = false;
        }
        if ((isRootOfRecursiveLoop || fromDelete) && this.getContainer() != null) {
            this.getContainer()._setModified(true);
            this._setContainer(null);
            this._setContainmentPropertyName(null);
        }
        this._setDeleted(true);
        DataGraph previousDataGraph = this.getDataGraph();
        this.setDataGraph(null);
        List instancePropertiesList = this.getInstanceProperties();
        int i = 0;
        int psize = instancePropertiesList.size();
        while (i < psize) {
            SDOProperty nextProperty = (SDOProperty)instancePropertiesList.get(i);
            Object oldValue = this.get(nextProperty);
            if (!nextProperty.getType().isChangeSummaryType()) {
                if (nextProperty.isContainment() || this.isContainedByDataGraph(previousDataGraph, nextProperty)) {
                    if (nextProperty.isMany()) {
                        int j = 0;
                        int lsize = ((List)oldValue).size();
                        while (j < lsize) {
                            Object manyItem = ((List)oldValue).get(j);
                            this.detachDeleteRecursivePrivateHelper((SDODataObject)manyItem, fromDelete, clearCS);
                            ++j;
                        }
                    } else {
                        this.detachDeleteRecursivePrivateHelper((SDODataObject)oldValue, fromDelete, clearCS);
                    }
                }
                if (fromDelete && !nextProperty.isReadOnly()) {
                    this.unset(nextProperty, fromDelete);
                }
            }
            ++i;
        }
        if (clearCS || subTreeRootHasCStoClear) {
            this._setChangeSummary(null);
        }
    }

    private void detachDeleteRecursivePrivateHelper(SDODataObject aDataObject, boolean fromDelete, boolean clearCS) {
        if (aDataObject != null) {
            SDOChangeSummary containerCS;
            boolean isCSRoot;
            boolean bl = isCSRoot = aDataObject.getChangeSummary() != null && aDataObject.getChangeSummary().getRootObject() == aDataObject;
            if (isCSRoot) {
                clearCS = false;
            } else if (aDataObject.getContainer() != null && (containerCS = aDataObject.getContainer().getChangeSummary()) == null) {
                clearCS = true;
            }
            aDataObject.detachDeleteRecursivePrivate(fromDelete, clearCS, false);
        }
    }

    @Override
    public void detach() {
        this.detachWithSequenceUpdate();
    }

    private void detachWithSequenceUpdate() {
        this.detach(false, true);
    }

    private void deleteWithSequenceUpdate() {
        this.detach(true, true);
    }

    private void detach(boolean fromDelete, boolean updateSequence) {
        SDOProperty containmentProperty = this.getContainmentProperty();
        if (containmentProperty != null && containmentProperty.isReadOnly()) {
            throw new UnsupportedOperationException("Property is Readonly." + containmentProperty.getName() + "  " + this.getType().getName());
        }
        if (containmentProperty != null) {
            if (this.getContainmentProperty().isMany()) {
                List oldList = this.getContainer().getList(containmentProperty);
                ((ListWrapper)oldList).remove(this, fromDelete, updateSequence);
            } else {
                this.getContainer().unset(containmentProperty, fromDelete, updateSequence);
            }
        } else {
            this._setDeleted(true);
            this.detachOrDelete(fromDelete);
        }
    }

    @Override
    public void delete() {
        this.deleteWithSequenceUpdate();
    }

    @Override
    public SDODataObject getContainer() {
        return this.container;
    }

    @Override
    public SDOProperty getContainmentProperty() {
        if (this.container != null && this.containmentPropertyName != null) {
            return this.container.getInstanceProperty(this.containmentPropertyName);
        }
        return null;
    }

    @Override
    public DataGraph getDataGraph() {
        return this.dataGraph;
    }

    public void setDataGraph(DataGraph dataGraph) {
        this.dataGraph = dataGraph;
    }

    @Override
    public SDOType getType() {
        return this.type;
    }

    @Override
    public List getInstanceProperties() {
        if (this.instanceProperties == null) {
            this.instanceProperties = new ArrayList<SDOProperty>();
        }
        return this.instanceProperties;
    }

    @Override
    public SDOProperty getProperty(String propertyName) {
        return this.getInstanceProperty(propertyName);
    }

    @Override
    public SDOProperty getInstanceProperty(String propertyName) {
        if (this.getType() == null) {
            throw new UnsupportedOperationException("Type is null");
        }
        SDOProperty property = this.getType().getProperty(propertyName);
        if (property == null && (property = (SDOProperty)this._getOpenContentAliasNamesMap().get(propertyName)) == null) {
            SDOProperty nextProp;
            int i = 0;
            while (i < this._getOpenContentProperties().size()) {
                nextProp = (SDOProperty)this._getOpenContentProperties().get(i);
                if (nextProp.getName().equals(propertyName)) {
                    return nextProp;
                }
                ++i;
            }
            if (property == null) {
                i = 0;
                while (i < this._getOpenContentPropertiesAttributes().size()) {
                    nextProp = (SDOProperty)this._getOpenContentPropertiesAttributes().get(i);
                    if (nextProp.getName().equals(propertyName)) {
                        return nextProp;
                    }
                    ++i;
                }
            }
        }
        return property;
    }

    SDOProperty getInstanceProperty(String propertyName, Object value2) {
        SDOProperty sdoProperty = this.getInstanceProperty(propertyName);
        if (sdoProperty == null) {
            sdoProperty = (SDOProperty)this.defineOpenContentProperty(propertyName, value2);
        }
        return sdoProperty;
    }

    public SDOProperty getInstanceProperty(int propertyIndex) throws IllegalArgumentException {
        try {
            SDOProperty property = this.getInstancePropertiesArray()[propertyIndex];
            return property;
        }
        catch (IndexOutOfBoundsException e) {
            throw SDOException.propertyNotFoundAtIndex(e, propertyIndex);
        }
    }

    @Override
    public SDODataObject getRootObject() {
        if (this.getContainer() != null) {
            return this.getContainer().getRootObject();
        }
        return this;
    }

    @Override
    public SDOChangeSummary getChangeSummary() {
        return this.changeSummary;
    }

    public void _setCreated(boolean created) {
        if (this.changeSummary != null) {
            this.changeSummary.setCreated(this, created);
        }
    }

    public void _setModified(boolean modified) {
        if (this.changeSummary != null && this.isLogging()) {
            this.updateChangeSummaryWithOriginalValues();
        }
    }

    private void _setDeleted(boolean deleted) {
        boolean wasDeleted;
        if (this.changeSummary != null && (wasDeleted = this.changeSummary.setDeleted(this, deleted)) && this.isLogging()) {
            this.updateChangeSummaryWithOriginalValues();
        }
    }

    private void setChangeSummaryNonRecursive(ChangeSummary csm) {
        SDOProperty changeSummaryProperty;
        this.changeSummary = (SDOChangeSummary)csm;
        if (this.getType() != null && (changeSummaryProperty = this.getType().getChangeSummaryProperty()) != null) {
            this.setChangeSummaryProperty(changeSummaryProperty, csm);
        }
    }

    public void _setChangeSummary(SDOChangeSummary aChangeSummary) {
        this.updateChangeSummaryAndDataGraph(aChangeSummary, this.getDataGraph());
    }

    private void updateChangeSummaryAndDataGraph(ChangeSummary aChangeSummary, DataGraph aDataGraph) {
        Iterator iterProperties = this.getInstanceProperties().iterator();
        this.setDataGraph(aDataGraph);
        while (iterProperties.hasNext()) {
            Property property = (Property)iterProperties.next();
            if (!property.isContainment() && !this.isContainedByDataGraph(property)) continue;
            Object object = this.get(property);
            if (object instanceof SDODataObject) {
                ((SDODataObject)object).updateChangeSummaryAndDataGraph(aChangeSummary, aDataGraph);
            }
            if (!(object instanceof ListWrapper)) continue;
            for (Object listContainedObject : (ListWrapper)object) {
                if (!(listContainedObject instanceof SDODataObject)) continue;
                ((SDODataObject)listContainedObject).updateChangeSummaryAndDataGraph(aChangeSummary, aDataGraph);
            }
        }
        this.setChangeSummaryNonRecursive(aChangeSummary);
    }

    private void updateDataGraph(DataGraph aDataGraph) {
        Iterator iterProperties = this.getInstanceProperties().iterator();
        this.setDataGraph(aDataGraph);
        while (iterProperties.hasNext()) {
            Property property = (Property)iterProperties.next();
            if (!property.isContainment() && !this.isContainedByDataGraph(property)) continue;
            Object object = this.get(property);
            if (object instanceof SDODataObject) {
                ((SDODataObject)object).updateDataGraph(aDataGraph);
            }
            if (!(object instanceof ListWrapper)) continue;
            for (Object listContainedObject : (ListWrapper)object) {
                if (!(listContainedObject instanceof SDODataObject)) continue;
                ((SDODataObject)listContainedObject).updateDataGraph(aDataGraph);
            }
        }
    }

    private void setChangeSummaryProperty(SDOProperty property, ChangeSummary value2) {
        if (property.isOpenContent()) {
            throw new IllegalArgumentException("ChangeSummary can not be on an open content property.");
        }
        if (property.isMany()) {
            throw new IllegalArgumentException("ChangeSummary can not be on a property with many set to true.");
        }
        if (this.isLogging()) {
            this._setModified(true);
        }
        this.setPropertyInternal(property, value2, true);
    }

    public void undoChanges(boolean isCSRoot, ChangeSummary cs, SDODataObject origContainer, String origContainmentPropName) {
        if (cs == null) {
            return;
        }
        if (((SDOChangeSummary)cs).isDirty(this)) {
            if (!isCSRoot) {
                if (this.changeSummary == null) {
                    this.changeSummary = (SDOChangeSummary)cs;
                }
                if (this.container == null) {
                    this._setContainer(origContainer);
                }
                if (this.containmentPropertyName == null) {
                    this._setContainmentPropertyName(origContainmentPropName);
                }
            }
            this._setCurrentValueStore((ValueStore)((SDOChangeSummary)cs).getOriginalValueStores().get(this));
            ((SDOChangeSummary)cs).getOriginalValueStores().remove(this);
        }
        if (this.getType().isSequenced() && ((SDOChangeSummary)cs).isDirty(this.sequence)) {
            SDOSequence currentSequence = this.sequence;
            SDOSequence originalSequence = (SDOSequence)((SDOChangeSummary)cs).getOriginalSequences().get(this);
            if (originalSequence == null && currentSequence != null) {
                throw SDOException.oldSequenceNotFound();
            }
            this.sequence = originalSequence;
            ((SDOChangeSummary)cs).getOldSequences().remove(this);
            ((SDOChangeSummary)cs).getOriginalSequences().remove(this);
        }
        List oldUnsetOCList = ((SDOChangeSummary)cs).getUnsetOCProperties(this);
        int i = 0;
        int size2 = oldUnsetOCList.size();
        while (i < size2) {
            this.addOpenContentProperty((Property)oldUnsetOCList.get(0));
            ++i;
        }
        for (SDOProperty property : this.getInstanceProperties()) {
            Object value2;
            if (property.getType().isChangeSummaryType() || (value2 = this.get(property)) == null && this.getChangeSummary() != null) continue;
            if (property.isMany()) {
                if (value2 == null) continue;
                ((ListWrapper)value2).undoChanges(this.getChangeSummary());
                if (property.getType().isDataType()) continue;
                for (Object valueMany : (List)value2) {
                    if (valueMany == null) continue;
                    ((SDODataObject)valueMany).undoChanges(false, this.changeSummary, this, property.getName());
                }
                continue;
            }
            if (property.getType().isDataType() || value2 == null) continue;
            ((SDODataObject)value2).undoChanges(false, this.changeSummary, this, property.getName());
        }
    }

    private void updateChangeSummaryWithOriginalValues() {
        if (this.isLogging() && !this.getChangeSummary().isDirty(this) && !this.getChangeSummary().isCreated(this)) {
            this.getChangeSummary().getOriginalValueStores().put(this, this._getCurrentValueStore());
            this.currentValueStore = this._getCurrentValueStore().copy();
            if (this.getType().isSequenced()) {
                SDOSequence copySequence = this.getSequence().copy();
                this.getChangeSummary().getOriginalSequences().put(this, copySequence);
            }
        }
    }

    public void resetChanges() {
        if (this.container != null && this.containmentPropertyName != null && this.changeSummary != null) {
            this.changeSummary.setOldContainer(this, this.container);
            this.changeSummary.setOldContainmentProperty(this, this.container.getInstanceProperty(this.containmentPropertyName));
        }
        int x = 0;
        int instancePropertiesSize = this.instanceProperties.size();
        while (x < instancePropertiesSize) {
            SDOProperty property = this.instanceProperties.get(x);
            Object value2 = this.get(property);
            if ((property.isContainment() || this.isContainedByDataGraph(property)) && !property.isMany() && value2 != null && !property.getType().isChangeSummaryType()) {
                ((SDODataObject)value2).resetChanges();
            } else if (property.isMany() && value2 != null) {
                List listValue = (List)value2;
                int y = 0;
                int listValueSize = listValue.size();
                while (y < listValueSize) {
                    Object valueMany = listValue.get(y);
                    if ((property.isContainment() || this.isContainedByDataGraph(property)) && valueMany != null && !property.getType().isChangeSummaryType()) {
                        ((SDODataObject)valueMany).resetChanges();
                    }
                    ++y;
                }
            }
            ++x;
        }
    }

    public void _setType(Type aType) {
        this.type = (SDOType)aType;
        if (this.getInstanceProperties().isEmpty()) {
            if (this.type != null) {
                this.getInstanceProperties().addAll(this.type.getProperties());
            }
            this.getInstanceProperties().addAll(this._getOpenContentProperties());
        }
        if (this.type != null) {
            SDOProperty csmProperty;
            this._getCurrentValueStore().initialize(this);
            if (this.type.isSequenced()) {
                this.sequence = new SDOSequence(this);
            }
            if ((csmProperty = this.type.getChangeSummaryProperty()) != null) {
                SDOChangeSummary aChangeSummary = new SDOChangeSummary(this, this.aHelperContext);
                aChangeSummary.endLogging();
                this._setChangeSummary(aChangeSummary);
            }
        }
    }

    public void _setCurrentValueStore(ValueStore aValueStore) {
        this.currentValueStore = aValueStore;
    }

    public ValueStore _getCurrentValueStore() {
        return this.currentValueStore;
    }

    public void _setContainer(DataObject aContainer) {
        this.container = (SDODataObject)aContainer;
    }

    public Map _getOpenContentPropertiesAttributesMap() {
        HashMap<QName, Object> openContentPropertiesAttrs = new HashMap<QName, Object>();
        int i = 0;
        int size2 = this._getOpenContentPropertiesAttributes().size();
        while (i < size2) {
            Property next2 = (Property)this._getOpenContentPropertiesAttributes().get(i);
            QName qname = new QName(((SDOProperty)next2).getUri(), next2.getName());
            openContentPropertiesAttrs.put(qname, this.get(next2));
            ++i;
        }
        return openContentPropertiesAttrs;
    }

    public void _setOpenContentPropertiesAttributesMap(Map openAttributeProperties) {
        for (QName nextKey : openAttributeProperties.keySet()) {
            if (nextKey.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/") || nextKey.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema-instance") && nextKey.getLocalPart().equals("type")) continue;
            Object value2 = openAttributeProperties.get(nextKey);
            SDOProperty prop = (SDOProperty)this.aHelperContext.getXSDHelper().getGlobalProperty(nextKey.getNamespaceURI(), nextKey.getLocalPart(), false);
            if (prop == null) {
                DataObject propDo = this.aHelperContext.getDataFactory().create("commonj.sdo", "Property");
                propDo.set("name", (Object)nextKey.getLocalPart());
                propDo.set("type", (Object)SDOConstants.SDO_STRING);
                propDo.set("many", (Object)false);
                prop = (SDOProperty)this.aHelperContext.getTypeHelper().defineOpenContentProperty(null, propDo);
                prop.setInstanceProperty(SDOConstants.XMLELEMENT_PROPERTY, Boolean.FALSE);
                prop.setUri(nextKey.getNamespaceURI());
                this.set(prop, value2);
                continue;
            }
            this.set(prop, value2);
        }
    }

    public void _setOpenContentPropertiesWithXMLRoots(List openContentPropertiesWithXMLRoots) {
        int i = 0;
        int size2 = openContentPropertiesWithXMLRoots.size();
        while (i < size2) {
            Object next2 = openContentPropertiesWithXMLRoots.get(i);
            String propertyName = null;
            String propertyUri = null;
            Object value2 = null;
            Type theType = null;
            if (next2 instanceof XMLRoot) {
                XMLRoot nextXMLRoot = (XMLRoot)next2;
                value2 = nextXMLRoot.getObject();
                propertyName = nextXMLRoot.getLocalName();
                propertyUri = nextXMLRoot.getNamespaceURI();
                theType = value2 instanceof DataObject ? ((DataObject)value2).getType() : ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getTypeForSimpleJavaType(value2.getClass());
            } else if (next2 instanceof DataObject) {
                value2 = next2;
                String qualifiedName = ((SDOType)((DataObject)next2).getType()).getXmlDescriptor().getDefaultRootElement();
                int colonIndex = qualifiedName.indexOf(":");
                if (colonIndex > -1) {
                    String prefix = qualifiedName.substring(0, colonIndex);
                    if (prefix != null && !prefix.equals("")) {
                        propertyUri = ((SDOType)((DataObject)next2).getType()).getXmlDescriptor().getNonNullNamespaceResolver().resolveNamespacePrefix(prefix);
                    }
                    propertyName = qualifiedName.substring(colonIndex + 1, qualifiedName.length());
                } else {
                    propertyName = qualifiedName;
                }
                theType = ((DataObject)next2).getType();
            } else {
                theType = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getTypeForSimpleJavaType(value2.getClass());
            }
            if (propertyName != null) {
                SDOProperty prop = (SDOProperty)this.aHelperContext.getXSDHelper().getGlobalProperty(propertyUri, propertyName, true);
                if (prop == null) {
                    prop = this.getInstanceProperty(propertyName);
                    if (prop != null) {
                        if (prop.getUri() == null && propertyUri != null) {
                            prop = this.createNewProperty(propertyName, propertyUri, theType);
                        } else if (prop.getUri() != null) {
                            if (propertyUri == null) {
                                prop = this.createNewProperty(propertyName, propertyUri, theType);
                            } else if (!prop.getUri().equals(propertyUri)) {
                                prop = this.createNewProperty(propertyName, propertyUri, theType);
                            }
                        }
                    } else {
                        prop = this.createNewProperty(propertyName, propertyUri, theType);
                    }
                }
                if (prop.isMany()) {
                    ((ListWrapper)this.getList(prop)).add(value2, false);
                } else {
                    this.set(prop, value2, false);
                }
            }
            ++i;
        }
    }

    private SDOProperty createNewProperty(String propertyName, String propertyUri, Type theType) {
        DataObject propDo = this.aHelperContext.getDataFactory().create("commonj.sdo", "Property");
        propDo.set("name", (Object)propertyName);
        propDo.set("type", (Object)theType);
        propDo.set("many", (Object)true);
        SDOProperty prop = (SDOProperty)this.aHelperContext.getTypeHelper().defineOpenContentProperty(null, propDo);
        prop.setUri(propertyUri);
        return prop;
    }

    public List _getOpenContentPropertiesWithXMLRoots() {
        ArrayList<XMLRoot> returnList = new ArrayList<XMLRoot>();
        int i = 0;
        int size2 = this.openContentProperties.size();
        while (i < size2) {
            SDOProperty next2 = (SDOProperty)this.openContentProperties.get(i);
            XMLRoot root = new XMLRoot();
            String localName = next2.getXPath();
            if (next2.getType() != null) {
                String uri;
                if (!next2.getType().isDataType()) {
                    uri = next2.getUri();
                    root.setNamespaceURI(uri);
                } else {
                    uri = next2.getUri();
                    root.setNamespaceURI(uri);
                }
            }
            root.setLocalName(localName);
            Object value2 = this.get(next2);
            if (next2.isMany()) {
                int j = 0;
                int sizel = ((List)value2).size();
                while (j < sizel) {
                    XMLRoot nextRoot = new XMLRoot();
                    nextRoot.setNamespaceURI(root.getNamespaceURI());
                    nextRoot.setLocalName(root.getLocalName());
                    Object nextItem = ((List)value2).get(j);
                    if (next2.getType() != null && next2.getType().getXmlDescriptor() == null) {
                        nextItem = XMLConversionManager.getDefaultXMLManager().convertObject(nextItem, String.class);
                    }
                    nextRoot.setObject(nextItem);
                    returnList.add(nextRoot);
                    ++j;
                }
            } else {
                if (next2.getType() != null && next2.getType().getXmlDescriptor() == null) {
                    value2 = XMLConversionManager.getDefaultXMLManager().convertObject(value2, String.class);
                }
                root.setObject(value2);
                returnList.add(root);
            }
            ++i;
        }
        return returnList;
    }

    public List _getOpenContentProperties() {
        if (this.openContentProperties == null) {
            this.openContentProperties = new ArrayList();
        }
        return this.openContentProperties;
    }

    private Map<String, Property> _getOpenContentAliasNamesMap() {
        if (this.openContentAliasNames == null) {
            this.openContentAliasNames = new HashMap();
        }
        return this.openContentAliasNames;
    }

    private void convertValueAndSet(Property property, Object originalValue) {
        Object convertedValue;
        if (property.isMany()) {
            if (originalValue == null) {
                convertedValue = new ArrayList();
            } else if (originalValue instanceof List) {
                convertedValue = this.aHelperContext.getDataHelper().convert(property, originalValue);
            } else {
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(originalValue);
                convertedValue = this.aHelperContext.getDataHelper().convert(property, l);
            }
        } else {
            convertedValue = this.aHelperContext.getDataHelper().convert(property, originalValue);
        }
        this.set(property, convertedValue);
    }

    private void convertValueAndSet(int propertyIndex, Object originalValue) {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        Object convertedValue = this.aHelperContext.getDataHelper().convert(property, originalValue);
        this.set(property, convertedValue);
    }

    private void convertValueAndSet(String path, Object originalValue) {
        XPathEngine.getInstance().set(path, originalValue, this, true);
    }

    public Object convertObjectToValue(Property property, Class cls) throws ClassCastException, IllegalArgumentException {
        if (property == null) {
            throw new IllegalArgumentException(SDOException.cannotPerformOperationOnNullArgument("convertObjectToValue"));
        }
        Object obj = this.unwrapListValue(property, this.get(property));
        try {
            return ((SDODataHelper)this.aHelperContext.getDataHelper()).convertValueToClass(property, obj, cls);
        }
        catch (Exception exception) {
            throw new ClassCastException("An error occurred during converison or an unsupported conversion was attempted.");
        }
    }

    public Object convertObjectToValue(Property property, int position, Class cls) throws ClassCastException, IllegalArgumentException {
        if (property == null) {
            throw new IllegalArgumentException(SDOException.cannotPerformOperationOnNullArgument("convertObjectToValue"));
        }
        if (cls == ClassConstants.List_Class && !property.isMany()) {
            throw new ClassCastException("can not call getList for a property that has isMany false.");
        }
        Object obj = position == -1 ? (cls == ClassConstants.List_Class ? this.get(property) : this.unwrapListValue(property, this.get(property))) : this.getList(property).get(position);
        try {
            return ((SDODataHelper)this.aHelperContext.getDataHelper()).convertValueToClass(property, obj, cls);
        }
        catch (Exception exception) {
            throw new ClassCastException("An error occurred during conversion or an unsupported conversion was attempted.");
        }
    }

    public void _setContainmentPropertyName(String aContainmentPropertyName) {
        this.containmentPropertyName = aContainmentPropertyName;
    }

    public String _getContainmentPropertyName() {
        return this.containmentPropertyName;
    }

    public boolean parentContains(Object value2) {
        if (value2 == null || !(value2 instanceof DataObject)) {
            return false;
        }
        if (this.getContainer() != null && this.getContainmentProperty() != null) {
            if (value2.equals(this.getContainer())) {
                return true;
            }
            return this.getContainer().parentContains(value2);
        }
        return false;
    }

    private boolean isContainedByDataGraph(Property aProperty) {
        return this.isContainedByDataGraph(this.getDataGraph(), (SDOProperty)aProperty);
    }

    private boolean isContainedByDataGraph(DataGraph aDataGraph, SDOProperty aProperty) {
        return aDataGraph != null && aProperty.getType() != null && !aProperty.getType().isDataType();
    }

    public void updateContainment(Property property, Collection values, boolean updateSequence) {
        if (property.isContainment() || this.isContainedByDataGraph(property)) {
            Object[] valuesArray = values.toArray();
            int i = 0;
            while (i < valuesArray.length) {
                Object next2 = valuesArray[i];
                if (next2 instanceof SDODataObject) {
                    this.updateContainment(property, (SDODataObject)next2, updateSequence);
                }
                ++i;
            }
        }
    }

    public void updateContainment(Property property, Collection values) {
        this.updateContainment(property, values, true);
    }

    public void updateContainment(Property property, SDODataObject aDataObject, boolean updateSequence) {
        if (property.isContainment() || this.isContainedByDataGraph(property)) {
            boolean wasInNewCS;
            boolean bl = wasInNewCS = this.getChangeSummary() != null && aDataObject.getChangeSummary() != null && this.getChangeSummary().equals(aDataObject.getChangeSummary());
            if (aDataObject.getContainer() != null) {
                aDataObject.detach(false, updateSequence);
            }
            boolean isDeleted = false;
            if (this.getChangeSummary() != null) {
                isDeleted = this.getChangeSummary().isDeleted(aDataObject);
            }
            if (this.getChangeSummary() != null && aDataObject.getType() != null && aDataObject.getType().getChangeSummaryProperty() == null) {
                aDataObject.updateChangeSummaryAndDataGraph(this.getChangeSummary(), this.getDataGraph());
            } else if (aDataObject.getDataGraph() != this.getDataGraph()) {
                aDataObject.updateDataGraph(this.getDataGraph());
            }
            aDataObject._setContainer(this);
            aDataObject._setContainmentPropertyName(property.getName());
            if (!wasInNewCS && this.getChangeSummary() != null && !this.getChangeSummary().isDeleted(aDataObject)) {
                aDataObject._setCreated(true);
            }
            if (this.getChangeSummary() != null && this.getChangeSummary().isDeleted(aDataObject)) {
                aDataObject._setDeleted(false);
            }
            this._setModified(true);
            if (isDeleted) {
                ValueStore originalParentVS;
                SDODataObject oldParentDO;
                Map originalValueStores = this.getChangeSummary().getOriginalValueStores();
                ValueStore originalVS = (ValueStore)originalValueStores.get(aDataObject);
                if (originalVS.equals(aDataObject._getCurrentValueStore())) {
                    originalValueStores.remove(aDataObject);
                }
                if ((oldParentDO = this.getChangeSummary().getOldContainer(aDataObject)) == this && (originalParentVS = (ValueStore)originalValueStores.get(oldParentDO)).equals(this._getCurrentValueStore())) {
                    Map originalElements = this.getChangeSummary().getOriginalElements();
                    List oldParentProps = oldParentDO.getInstanceProperties();
                    int i = 0;
                    while (i < oldParentProps.size()) {
                        Object prop = originalParentVS.getDeclaredProperty(i);
                        Object oldList = originalElements.get(prop);
                        if (oldList != null) {
                            List oldElements = (List)oldList;
                            List currentElements = ((ListWrapper)prop).getCurrentElements();
                            if (oldElements.size() != currentElements.size()) {
                                return;
                            }
                            Iterator elementIt = currentElements.iterator();
                            Iterator oldelementIt = oldElements.iterator();
                            while (elementIt.hasNext()) {
                                if (elementIt.next() == oldelementIt.next()) continue;
                                return;
                            }
                        }
                        ++i;
                    }
                    originalValueStores.remove(oldParentDO);
                }
            }
        }
    }

    public void updateContainment(Property property, SDODataObject value2) {
        this.updateContainment(property, value2, true);
    }

    private boolean isLogging() {
        return this.changeSummary != null && this.changeSummary.isLogging();
    }

    public Object writeReplace() {
        return new SDOExternalizableDelegator(this, this.aHelperContext);
    }

    private String getPathPrivate(String currentPath, SDODataObject targetObject, String aSeparator) {
        SDODataObject aParent = targetObject.getContainer();
        if (aParent == null) {
            return currentPath;
        }
        String aContainmentPropertyName = targetObject._getContainmentPropertyName();
        SDOProperty aChild = aParent.getInstanceProperty(aContainmentPropertyName);
        if (aChild.isMany()) {
            int index = aParent.getList(aChild).indexOf(targetObject);
            return this.getPathPrivate(String.valueOf(aContainmentPropertyName) + "[" + (1 + index) + "]" + aSeparator + currentPath, aParent, "/");
        }
        return this.getPathPrivate(String.valueOf(aContainmentPropertyName) + aSeparator + currentPath, aParent, "/");
    }

    public String _getPath() {
        if (this.getContainer() == null) {
            return "/";
        }
        return this.getPathPrivate("", this, "");
    }

    private SDOProperty[] getInstancePropertiesArray() {
        if (this.openContentProperties == null || this.openContentProperties.isEmpty()) {
            return this.getType().getPropertiesArray();
        }
        SDOProperty[] props = this.getType().getPropertiesArray();
        SDOProperty[] ret = new SDOProperty[this.openContentProperties.size() + props.length];
        int i = 0;
        while (i < props.length) {
            ret[i] = props[i];
            ++i;
        }
        i = props.length;
        while (i < ret.length) {
            ret[i] = (SDOProperty)this.openContentProperties.get(i - props.length);
            ++i;
        }
        return ret;
    }

    public Object getPropertyInternal(Property property) {
        int index = ((SDOProperty)property).getIndexInType();
        if (index == -1) {
            return this._getCurrentValueStore().getOpenContentProperty(property);
        }
        return this._getCurrentValueStore().getDeclaredProperty(index);
    }

    public void setPropertyInternal(SDOProperty property, Object value2, boolean updateSequence) {
        int index;
        Object origValue = this.getPropertyInternal(property);
        if (this.type.isSequenced() && updateSequence && !property.getType().isChangeSummaryType() && !this.aHelperContext.getXSDHelper().isAttribute(property)) {
            if (property.isMany()) {
                this.getSequence().addSettingWithoutModifyingDataObject(property, value2);
            } else if (this.isSet(property)) {
                this.getSequence().updateSettingWithoutModifyingDataObject(property, this.get(property), value2);
            } else {
                this.getSequence().addSettingWithoutModifyingDataObject(property, value2);
            }
        }
        if ((index = property.getIndexInType()) == -1) {
            this._getCurrentValueStore().setOpenContentProperty(property, value2);
        } else {
            this._getCurrentValueStore().setDeclaredProperty(index, value2);
            SDOProperty oppositeProperty = property.getOpposite();
            if (oppositeProperty != null) {
                List oppositeList;
                if (value2 != null) {
                    if (property.isMany()) {
                        List valueList = (List)value2;
                        for (SDODataObject valueDO : valueList) {
                            if (this == valueDO.get(oppositeProperty)) continue;
                            valueDO.setInternal(oppositeProperty, this, true);
                        }
                    } else {
                        SDODataObject valueDO = (SDODataObject)value2;
                        if (oppositeProperty.isMany()) {
                            oppositeList = valueDO.getList(oppositeProperty);
                            if (!oppositeList.contains(this)) {
                                oppositeList.add(this);
                            }
                        } else if (this != valueDO.get(oppositeProperty)) {
                            valueDO.setInternal(oppositeProperty, this, true);
                        }
                    }
                }
                if (origValue != null) {
                    if (property.isMany()) {
                        List origValueList = (List)origValue;
                        for (SDODataObject origValueDO : origValueList) {
                            if (origValueDO.get(oppositeProperty) == null) continue;
                            origValueDO.set(oppositeProperty, null);
                        }
                    } else {
                        DataObject origValueDO = (DataObject)origValue;
                        if (oppositeProperty.isMany()) {
                            oppositeList = origValueDO.getList(oppositeProperty);
                            if (oppositeList.contains(this)) {
                                oppositeList.remove(this);
                            }
                        } else if (origValueDO.get(oppositeProperty) != null) {
                            origValueDO.set(oppositeProperty, null);
                        }
                    }
                }
            }
        }
    }

    public void addOpenContentProperty(Property property) {
        List theList = null;
        theList = this.aHelperContext.getXSDHelper().isAttribute(property) ? this._getOpenContentPropertiesAttributes() : this._getOpenContentProperties();
        if (!theList.contains(property)) {
            if (this.isLogging()) {
                this.getChangeSummary().removeUnsetOCProperty(this, property);
            }
            theList.add(property);
            this.getInstanceProperties().add(property);
            if (((SDOProperty)property).hasAliasNames()) {
                int i = 0;
                int size2 = ((SDOProperty)property).getAliasNames().size();
                while (i < size2) {
                    this._getOpenContentAliasNamesMap().put((String)((SDOProperty)property).getAliasNames().get(i), property);
                    ++i;
                }
            }
        }
    }

    public void removeOpenContentProperty(Property property) {
        if (this.isLogging()) {
            this.getChangeSummary().setUnsetOCProperty(this, property);
        }
        this._getOpenContentProperties().remove(property);
        this._getOpenContentPropertiesAttributes().remove(property);
        this.getInstanceProperties().remove(property);
        if (((SDOProperty)property).hasAliasNames()) {
            int i = 0;
            int size2 = ((SDOProperty)property).getAliasNames().size();
            while (i < size2) {
                this._getOpenContentAliasNamesMap().remove(((SDOProperty)property).getAliasNames().get(i));
                ++i;
            }
        }
    }

    public boolean isSetInternal(Property property) {
        int index = ((SDOProperty)property).getIndexInType();
        if (index == -1) {
            return this._getCurrentValueStore().isSetOpenContentProperty(property);
        }
        return this._getCurrentValueStore().isSetDeclaredProperty(index);
    }

    private void unsetInternal(Property property, boolean updateSequence) {
        if (property.isMany()) {
            this.getList(property).clear();
            if (property.isOpenContent()) {
                this.removeOpenContentProperty(property);
            } else {
                this._getCurrentValueStore().unsetDeclaredProperty(((SDOProperty)property).getIndexInType());
            }
        } else if (property.isOpenContent()) {
            this._getCurrentValueStore().unsetOpenContentProperty(property);
            this.removeOpenContentProperty(property);
        } else {
            this._getCurrentValueStore().unsetDeclaredProperty(((SDOProperty)property).getIndexInType());
        }
        if (this.type.isSequenced() && this.sequence != null && updateSequence && this.aHelperContext.getXSDHelper().isElement(property)) {
            this.sequence.removeSettingWithoutModifyingDataObject(property);
        }
    }

    public String _getSdoRef() {
        return this.sdoRef;
    }

    public void _setOpenContentPropertiesAttributes(List openContentPropertiesAttributes) {
        this.openContentPropertiesAttributes = openContentPropertiesAttributes;
    }

    public List _getOpenContentPropertiesAttributes() {
        if (this.openContentPropertiesAttributes == null) {
            this.openContentPropertiesAttributes = new ArrayList();
        }
        return this.openContentPropertiesAttributes;
    }

    @Override
    public List<Setting> getSettings() {
        if (this.sequence != null) {
            return this.getSequence().getSettings();
        }
        return null;
    }

    public void _setSdoRef(String newRef) {
        this.sdoRef = newRef;
    }

    private Object unwrapListValue(Property prop, Object val) {
        if (prop == null || val == null) {
            return null;
        }
        if (!prop.isMany() || !(val instanceof ListWrapper)) {
            return val;
        }
        ListWrapper l = (ListWrapper)val;
        if (l.size() == 0) {
            return null;
        }
        return l.get(0);
    }
}

