/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.types;

import commonj.sdo.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLTransformationMapping;
import org.eclipse.persistence.oxm.schema.XMLSchemaURLReference;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOClassLoader;
import org.eclipse.persistence.sdo.helper.SDOMethodAttributeAccessor;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.extension.SDOUtil;
import org.eclipse.persistence.sdo.helper.metadata.NamespaceURITransformer;
import org.eclipse.persistence.sdo.helper.metadata.QNameTransformer;
import org.eclipse.persistence.sessions.Project;

public class SDOWrapperType
extends SDOType
implements Type {
    private static final String PACKAGE_NAME = "org.eclipse.persistence.sdo.dataobjects.";
    private static final String ATTRIBUTE_NAME = "value";
    private static final String XPATH = "text()";
    private String typeName;
    private Map<QName, XMLDescriptor> descriptorsMap;

    public SDOWrapperType(Type aPropertyType, String aTypeName, SDOTypeHelper aSDOTypeHelper) {
        this(aPropertyType, aTypeName, aSDOTypeHelper, (QName)null, (Class<? extends SDODataObject>)null);
    }

    public SDOWrapperType(Type aPropertyType, String aTypeName, SDOTypeHelper aSDOTypeHelper, QName aSchemaType) {
        this(aPropertyType, aTypeName, aSDOTypeHelper, new QName[]{aSchemaType}, null);
    }

    public SDOWrapperType(Type aPropertyType, String aTypeName, SDOTypeHelper aSDOTypeHelper, QName aSchemaType, Class<? extends SDODataObject> implClass) {
        this(aPropertyType, aTypeName, aSDOTypeHelper, new QName[]{aSchemaType}, new Class[]{implClass});
    }

    public SDOWrapperType(Type aPropertyType, String aTypeName, SDOTypeHelper aSDOTypeHelper, QName[] schemaTypes) {
        this(aPropertyType, aTypeName, aSDOTypeHelper, schemaTypes, null);
    }

    public SDOWrapperType(Type aPropertyType, String aTypeName, SDOTypeHelper aSDOTypeHelper, QName[] schemaTypes, Class<? extends SDODataObject>[] implClasses) {
        super("org.eclipse.persistence.sdo", aTypeName, aSDOTypeHelper);
        this.typeName = aTypeName;
        SDOProperty valueProperty = new SDOProperty(this.aHelperContext);
        valueProperty.setName(ATTRIBUTE_NAME);
        valueProperty.setType(aPropertyType);
        valueProperty.setXsdType(schemaTypes[0]);
        this.addDeclaredProperty(valueProperty);
        String normalizedTypeName = SDOUtil.className(aTypeName, true, true, false);
        if (implClasses == null || implClasses[0] == null) {
            String implClassName = PACKAGE_NAME + normalizedTypeName + "WrapperImpl";
            this.setImplClassName(implClassName);
            this.getImplClass();
        } else {
            this.javaImplClass = implClasses[0];
            this.xmlDescriptor.setJavaClass(this.javaImplClass);
        }
        this.initializeDescriptor(this.xmlDescriptor, schemaTypes[0], aPropertyType, valueProperty);
        this.descriptorsMap = new HashMap<QName, XMLDescriptor>();
        this.descriptorsMap.put(schemaTypes[0], this.xmlDescriptor);
        this.setSchemaContext(this.xmlDescriptor, schemaTypes[0]);
        if (schemaTypes.length > 1) {
            int i = 1;
            while (i < schemaTypes.length) {
                XMLDescriptor d = new XMLDescriptor();
                QName schemaType = schemaTypes[i];
                String className = PACKAGE_NAME + normalizedTypeName + "_" + schemaType.getLocalPart() + "Wrapper";
                try {
                    if (implClasses == null || implClasses[i] == null) {
                        SDOClassLoader loader = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getLoader();
                        d.setJavaClass(loader.loadClass(String.valueOf(className) + "Impl", this));
                    } else {
                        d.setJavaClass(implClasses[i]);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw SDOException.classNotFound(e, this.getURI(), this.getName());
                }
                catch (SecurityException e) {
                    throw SDOException.classNotFound(e, this.getURI(), this.getName());
                }
                this.initializeDescriptor(d, schemaType, aPropertyType, valueProperty);
                this.descriptorsMap.put(schemaTypes[i], d);
                this.setSchemaContext(d, schemaTypes[i]);
                ++i;
            }
        }
    }

    private void setSchemaContext(XMLDescriptor desc, QName schemaType) {
        if (schemaType == null || desc == null) {
            return;
        }
        XMLSchemaURLReference urlRef = new XMLSchemaURLReference();
        urlRef.setSchemaContextAsQName(schemaType);
        desc.setSchemaReference(urlRef);
    }

    private void initializeDescriptor(XMLDescriptor aDescriptor, QName aQName, Type aPropertyType, SDOProperty aValueProperty) {
        aDescriptor.setNamespaceResolver((NamespaceResolver)null);
        SDOMethodAttributeAccessor accessor = null;
        accessor = new SDOMethodAttributeAccessor(aValueProperty);
        if (XMLConstants.QNAME_QNAME.equals(aQName)) {
            XMLTransformationMapping mapping = new XMLTransformationMapping();
            mapping.setAttributeName(ATTRIBUTE_NAME);
            QNameTransformer transformer = new QNameTransformer(XPATH);
            mapping.setAttributeTransformer(transformer);
            mapping.addFieldTransformer(XPATH, (FieldTransformer)transformer);
            NamespaceResolver nsr = new NamespaceResolver();
            nsr.setDefaultNamespaceURI("http://www.w3.org/2000/xmlns/");
            XMLField field2 = new XMLField();
            field2.setNamespaceResolver(nsr);
            field2.setXPath("@xmlns");
            mapping.addFieldTransformer(field2, (FieldTransformer)new NamespaceURITransformer());
            mapping.setAttributeAccessor(accessor);
            aDescriptor.addMapping(mapping);
        } else {
            XMLDirectMapping mapping = new XMLDirectMapping();
            mapping.setAttributeName(ATTRIBUTE_NAME);
            mapping.setXPath(XPATH);
            mapping.setAttributeClassification(aPropertyType.getInstanceClass());
            ((XMLField)mapping.getField()).setSchemaType(aQName);
            mapping.setAttributeAccessor(accessor);
            aDescriptor.addMapping(mapping);
        }
        aDescriptor.setIsWrapper(true);
    }

    public XMLDescriptor getXmlDescriptor(QName aQName) {
        XMLDescriptor d = this.descriptorsMap.get(aQName);
        if (d == null) {
            return this.xmlDescriptor;
        }
        return d;
    }

    public Map getDescriptorsMap() {
        return this.descriptorsMap;
    }

    public void addDescriptorToProject(Project project) {
        Iterator<XMLDescriptor> it = this.descriptorsMap.values().iterator();
        while (it.hasNext()) {
            project.addDescriptor(it.next());
        }
    }

    @Override
    public List getAliasNames() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getBaseTypes() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public String getName() {
        return this.typeName;
    }

    @Override
    public String getURI() {
        return "org.eclipse.persistence.sdo";
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isDataType() {
        return false;
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public boolean isSequenced() {
        return false;
    }

    @Override
    public boolean isFinalized() {
        return true;
    }

    @Override
    public boolean isWrapperType() {
        return true;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append(String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(this.hashCode()));
        str.append("{uri=");
        str.append(this.getURI());
        str.append(" name=");
        str.append(this.getName());
        str.append("}");
        return str.toString();
    }

    public static class BooleanObjectWrapperImpl
    extends SDODataObject {
    }

    public static class BooleanWrapperImpl
    extends SDODataObject {
    }

    public static class ByteObjectWrapperImpl
    extends SDODataObject {
    }

    public static class ByteWrapperImpl
    extends SDODataObject {
    }

    public static class BytesWrapperImpl
    extends SDODataObject {
    }

    public static class Bytes_hexBunaryWrapperImpl
    extends SDODataObject {
    }

    public static class CharacterObjectWrapperImpl
    extends SDODataObject {
    }

    public static class CharacterWrapperImpl
    extends SDODataObject {
    }

    public static class DateTimeWrapperImpl
    extends SDODataObject {
    }

    public static class DateWrapperImpl
    extends SDODataObject {
    }

    public static class DayWrapperImpl
    extends SDODataObject {
    }

    public static class DecimalWrapperImpl
    extends SDODataObject {
    }

    public static class DoubleObjectWrapperImpl
    extends SDODataObject {
    }

    public static class DoubleWrapperImpl
    extends SDODataObject {
    }

    public static class DurationWrapperImpl
    extends SDODataObject {
    }

    public static class FloatObjectWrapperImpl
    extends SDODataObject {
    }

    public static class FloatWrapperImpl
    extends SDODataObject {
    }

    public static class IntObjectWrapperImpl
    extends SDODataObject {
    }

    public static class IntWrapperImpl
    extends SDODataObject {
    }

    public static class IntegerWrapperImpl
    extends SDODataObject {
    }

    public static class LongObjectWrapperImpl
    extends SDODataObject {
    }

    public static class LongWrapperImpl
    extends SDODataObject {
    }

    public static class MonthDayWrapperImpl
    extends SDODataObject {
    }

    public static class MonthWrapperImpl
    extends SDODataObject {
    }

    public static class ObjectWrapperImpl
    extends SDODataObject {
    }

    public static class ShortObjectWrapperImpl
    extends SDODataObject {
    }

    public static class ShortWrapperImpl
    extends SDODataObject {
    }

    public static class StringWrapperImpl
    extends SDODataObject {
    }

    public static class StringsWrapperImpl
    extends SDODataObject {
    }

    public static class TimeWrapperImpl
    extends SDODataObject {
    }

    public static class URIWrapperImpl
    extends SDODataObject {
    }

    public static class URI_QNameWrapperImpl
    extends SDODataObject {
    }

    public static class YearMonthDayWrapperImpl
    extends SDODataObject {
    }

    public static class YearMonthWrapperImpl
    extends SDODataObject {
    }

    public static class YearWrapperImpl
    extends SDODataObject {
    }
}

